<?php
class Transaction_model extends CI_Model {

	
	function verify($username, $password, $partyCode){
	
		$this->db->where('cu.api_customer_username', $username);
		$this->db->where('lower(cu.api_customer_password)', strtolower($this->prep_password($password)));
		$this->db->where('cu.api_customer_partycode', $partyCode);
		$query = $this->db->get('api_party_customers cu');
		
		$count = $query->num_rows();
		if($count > 0)
		{
			//get current date and time
			$currentDateTime = $this->getCurrentDateTime();
			
			$accessCode = $this->generateAccesscode($partyCode, $username, $currentDateTime);
			$customer_id = $query->row()->api_customer_id;
			
			$fields = array(
				'api_customer_id' => $customer_id,
				'api_partycode' => $partyCode,
				'api_accesscode' => $accessCode,
				'api_duration'	=> 	$this->config->item("accessCode_expiry"),
				'api_session_browser' =>  $this->agent->browser().' '.$this->agent->version(),
				'api_party_ip' =>  $this->input->ip_address(),
			);
			
			// insert to db
			$this->db->set($fields);
			$this->db->insert('api_sessions');
			
			return array($accessCode,$currentDateTime, $this->config->item("accessCode_expiry"));
		}
		else
		{
			return 'Invalid';
		}
	
	}
	
	
	function validateAccessCode($accessCode = false){
		
		$this->db->where('api_accesscode', $accessCode);
		$this->db->order_by('api_session_id', "asc"); 
		$query = $this->db->get('api_sessions');
	
		$count = $query->num_rows();
		if($count > 0)
		{
			$result = $query->row();
			
			//get current date and time
			$currentDateTime = $this->getCurrentDateTime();
			
			$expiryTime = $result->api_duration;
			date_default_timezone_set("Asia/Manila");
			$endtime = new DateTime($result->api_time_issued);
			$endtime->modify("+" .$expiryTime ." minutes");
			$endtime = $endtime->format('Y-m-d-H:i:s');
			//check if expired 
			
			if($endtime < $currentDateTime){
				//deactivate previous access credentials
				$this->deactivateSession($accessCode, 0);
				return 'expired';
			
			}
			else{
			
				if($result->api_active == 0)
				{
					return 'inactive';
				}
				else{
				
					//deactivate previous access credentials
					$this->deactivateSession($accessCode, 0);
					
					$token = $this->generateToken($accessCode, $currentDateTime);
					
					$partyCode = $this->get_party_code($accessCode);
					$customer_id = $this->get_customer_id($accessCode);
					
					$fields = array(
						'api_customer_id' => $customer_id,
						'api_partycode' => $partyCode,
						'api_accesscode' => $accessCode,
						'api_dynatoken' => $token,
						'api_duration'	=> 	$this->config->item("token_expiry"),
						'api_session_browser' =>  $this->agent->browser().' '.$this->agent->version(),
						'api_party_ip' =>  $this->input->ip_address(),
					);
					
					// insert to db
					$this->db->set($fields);
					$this->db->insert('api_sessions');
					
					return array($token,$currentDateTime, $this->config->item("token_expiry"));
				}
			}
			
		
		}
		else
		{
		return 'invalid';
		}
	
	}
	

	function renewToken($accessCode, $token){
	
		$this->db->where('api_accesscode', $accessCode);
		$this->db->where('api_dynatoken', $token);
		$query = $this->db->get('api_sessions');
	
		$count = $query->num_rows();
		if($count > 0)
		{
			$result = $query->row();
			
			//get current date and time
			$currentDateTime = $this->getCurrentDateTime();
			
			$expiryTime = $result->api_duration;
			date_default_timezone_set("Asia/Manila");
			$endtime = new DateTime($result->api_time_issued);
			$endtime->modify("+" .$expiryTime ." minutes");
			$endtime = $endtime->format('Y-m-d-H:i:s');
			//check if expired 
			if($endtime < $currentDateTime){
				//deactivate previous access credentials
				$this->deactivateSession($accessCode, $token);
				return 'expired';
			}else{
				if($result->api_active == 0)
				{
					return 'inactive';
				}
				else{
				
					//deactivate previous access credentials
					$this->deactivateSession($accessCode, $token);
					
					$token = $this->generateToken($accessCode, $currentDateTime);
					$partyCode = $this->get_party_code($accessCode);
					$customer_id = $this->get_customer_id($accessCode);
					
					$fields = array(
						'api_customer_id' => $customer_id,
						'api_partycode' => $partyCode,
						'api_accesscode' => $accessCode,
						'api_dynatoken' => $token,
						'api_duration'	=> 	$this->config->item("token_expiry"),
						'api_session_browser' =>  $this->agent->browser().' '.$this->agent->version(),
						'api_party_ip' =>  $this->input->ip_address(),
					);
					
					// insert to db
					$this->db->set($fields);
					$this->db->insert('api_sessions');
					
					return array($token,$currentDateTime, $this->config->item("token_expiry"));
				}
			}
			
		}else{
			return 'invalid';
		}
	
	}
	
	function deactivateSession($accessCode, $token){
	
		$this->db->where('api_accesscode',$accessCode);
		$this->db->where('api_dynatoken',$token);
		$this->db->set('api_active', 0);
		$this->db->update('api_sessions');
		return true;
	}
	
	function getCurrentDateTime(){
		$date = new DateTime(null, new DateTimeZone('Asia/Manila'));
		return $date->format('Y-m-d-H:i:s');	
		
	}
	
	function generateToken($accessCode, $time){
		return sha1($this->config->item('encryption_key'). $accessCode . $time);
	}
		
	function generateAccesscode($partyCode = false, $username=false, $time=false){
		return sha1($this->config->item('encryption_key'). $partyCode . $username . $time);
		
	}												
		
	function prep_password($password)
	{

		return sha1($this->config->item('encryption_key').$password);
	}
	
	function add_ticket_details(){
	
		$fields = array(
			'ticket_date_entered'		=> date('Y-m-d H:i:s'),
			'ticket_session_id'			=> $this->session->userdata('csi'),
			'ticket_event_id'			=> $event_id,
			'ticket_section_id'			=> $section->section_id,
			'ticket_price_id'			=> $price_id,
			'ticket_seat'				=> $section->section_type,
			'ticket_type_id'			=> 1,
			'ticket_status'				=> 'selected'
		);
		
	}
	
	function get_party_code($accessCode){
	
		$this->db->select('api_partycode');
		$this->db->where('api_accesscode',$accessCode);
		$this->db->order_by('api_session_id', "asc"); 
		return $this->db->get('api_sessions')->row()->api_partycode;
	
	}
	
	function verify_access_token($accessCode, $token){
	
	
		$this->db->where('api_accesscode', $accessCode);
		$this->db->where('api_dynatoken', $token);
		$query = $this->db->get('api_sessions');
	
		$count = $query->num_rows();
		if($count > 0)
		{
			$result = $query->row();
			
			//get current date and time
			$currentDateTime = $this->getCurrentDateTime();
			
			$expiryTime = $result->api_duration;
			date_default_timezone_set('Asia/Manila');
			$endtime = new DateTime($result->api_time_issued);
			$endtime->modify("+" .$expiryTime ." minutes");
			$endtime = $endtime->format('Y-m-d-H:i:s');
			//check if expired 
			
			if($endtime < $currentDateTime){
				//deactivate previous access credentials
				$this->deactivateSession($accessCode, $token);
				return 'expired';
			
			}else{
				
				if($result->api_active == 0)
				{
					return 'inactive';
				}
				else{
				
					return 'valid';
					
				}
			}
			
		}else{
		
			return 'invalid';
		
		}
	
	
	
	}
	
	function verify_app_token($appCode, $token){
	
	
		$this->db->where('api_apppcode', $appCode);
		$this->db->where('api_livetoken', $token);
		$query = $this->db->get('api_sessions');
	
		$count = $query->num_rows();
		if($count > 0)
		{
			$result = $query->row();
			
			//get current date and time
			$currentDateTime = $this->getCurrentDateTime();
			
			$expiryTime = $result->api_duration;
			date_default_timezone_set('Asia/Manila');
			$endtime = new DateTime($result->api_time_issued);
			$endtime->modify("+" .$expiryTime ." minutes");
			$endtime = $endtime->format('Y-m-d-H:i:s');
			//check if expired 
			
			if($endtime < $currentDateTime){
				//deactivate previous access credentials
 				return 'expired';
			
			}else{
				
				if($result->api_gen_active == 0)
				{
					return 'inactive';
				}
				else{
				
					return 'valid';
					
				}
			}
			
		}else{
		
			return 'invalid';
		
		}
	
	
	
	}
	
	function buy_ticket($ticketDetails, $accessCode){
	
	// print_r($ticketDetails);
 	$customer_id = $this->get_customer_id($accessCode);
	
	
	//prepare trans details
	$trans_details = array(
		'transaction_date'				=> date("Y-m-d H:i:s"),
		'transaction_user_id'			=> 1617,
		'transaction_receipt_number'	=> 1,
		'transaction_customer_id'		=> $customer_id,
		'transaction_branch_id'			=> 90,
		'transaction_terminal_id'		=> 1,
		'transaction_status'			=> 'selected',
	);	
	
	//insert to transactions table
	$this->db->set($trans_details);
	$this->db->insert('transactions');
	
	$transaction_id = $this->db->insert_id();
	
	foreach($ticketDetails as $tixDetails):
		// print_r($tixDetails);
		//prepare ticket details	
		 $tix_details = array(
			'ticket_transaction_id'		=> $transaction_id,
			'ticket_date_entered'		=> date('Y-m-d H:i:s'),
			'ticket_session_id'			=> $accessCode,
			'ticket_event_id'			=> $tixDetails[0],
			'ticket_section_id'			=> $tixDetails[1],
			'ticket_price_id'			=> $tixDetails[2],
			'ticket_type_id'			=> $tixDetails[3],
			'ticket_row'				=> $tixDetails[4],
			'ticket_seat'				=> $tixDetails[5],
			'ticket_system_row'			=> $tixDetails[6],
			'ticket_system_col'			=> $tixDetails[7],
			'ticket_status'				=> 'selected',
			'ticket_user_id'			=> 1617,
			'ticket_branch_id'			=> 90,
			'ticket_terminal_id'		=> 1
			
		);
		//insert to tickets table
		$this->db->set($tix_details);
		$this->db->insert('tickets');
		// echo $this->db->last_query();

		endforeach;
		
		return array('success', $transaction_id, date('Y-m-d H:i:s'), $this->config->item("token_expiry"));
	
	}

	function get_customer_id($accessCode){
	
		$this->db->select('api_customer_id');
		$this->db->where('api_accesscode', $accessCode);
		return $this->db->get('api_sessions')->row()->api_customer_id;
	}
	
	function paid_online($transaction_id)
	{
	    
		// update the transactions table
		$this->db->where('transaction_id', $transaction_id);
		$this->db->update('transactions', array('transaction_status' => 'paid_online'));

		// update the status of the tickets
		$this->db->where('ticket_status', 'selected');
		$this->db->where('ticket_transaction_id', $transaction_id);
		$this->db->update('tickets', array('ticket_status' => 'paid_online'));
		
		return true;
	}
	
	function get($transaction_id)
	{
		$this->db->join('terminals te', 't.transaction_terminal_id = te.terminal_id');
		$this->db->join('branches b', 't.transaction_branch_id = b.branch_id');
		$this->db->join('users u', 't.transaction_user_id = u.user_id');
		$this->db->join('customers c', 't.transaction_customer_id = c.customer_id');
		$this->db->where('transaction_id', $transaction_id);
		$query = $this->db->get('transactions t');
	
		return $query->row();		
	}
	
	function get_or($transaction_id){
	
		$this->db->select('transaction_receipt_number');
		$this->db->where('transaction_id', $transaction_id);
		$query = $this->db->get('transactions');
		return $query->row()->transaction_receipt_number;
	
	}
	
	function get_for_bcode($transaction_id)
	{
		$this->db->join('terminals te', 't.transaction_terminal_id = te.terminal_id');
		$this->db->join('branches b', 't.transaction_branch_id = b.branch_id');
		$this->db->join('users u', 't.transaction_user_id = u.user_id');
		$this->db->join('api_party_customers c', 't.transaction_customer_id = c.api_customer_id');
		$this->db->where('transaction_id', $transaction_id);
		$query = $this->db->get('transactions t');
	
		return $query->row();		
	}
	
	function add_barcode($transaction_id, $barcode)
	{
		// update the tickets table
		$this->db->where('transaction_id', $transaction_id);
		$this->db->update('transactions', array('transaction_barcode' => $barcode));
		
		return true;
	}
  
	function update_receipt_number($transaction_id, $receipt_number)
	{
		// update the transactions table
		$this->db->where('transaction_id', $transaction_id);
		$this->db->update('transactions', array('transaction_receipt_number' => $receipt_number));
		
		return true;
	}
	 
	function check_ticket_details($ticketDetails, $totalAmount){
 
 		$event_ids = array();
 		$section_ids = array();
  		$price_ids = array();
 		$unique_event_ids = array();
 		$unique_section_ids = array();
 		$used_seats = array();
 		//0-eventid 1-sectionid 2-priceid 3-tickettypeid 4-systemrow 5-systemcol 6-ticketrow 7-ticketseat  8-actualprice 9-convenience
		foreach($ticketDetails as $tix){
 		
			if(count($tix) != 9)
			//check if correct datamessage format
			foreach($tix as $key => $value) {
 				if($value == "") { return 0; }
				
				// compile event_ids
				if ($key == 0 ) {
					$event_ids[] = $value;
				}
				if ($key == 1 ) {
					$section_ids[] = $value;
				} 
				
				//force ticket_type_id condition 1
				if ($key == 3 ) { 
					if($value != 1){ return 0;} 
				}
				 
			}
 		}
			

		// identify unique elements needed for data gathering
		$unique_event_ids = array_unique($event_ids);
		$unique_section_ids = array_unique($section_ids);
		
		
		// build data using ticket details (including unique elements for ticket check) 
		//check event_id
		list($events_info,$prices_event_info, $events_ticket_type_info) = $this->get_selected_events($unique_event_ids);
		$sections_info = $this->get_selected_sections($unique_section_ids);
		$used_seats = $this->get_selected_used_section_seats($unique_section_ids);
			
	 
 		//0-eventid 1-sectionid 2-priceid 3-tickettypeid 4-systemrow 5-systemcol 6-ticketrow 7-ticketseat  8-actualprice 9-convenience
		$amount_total = 0;
		foreach($ticketDetails as $tix){ 
			$event_id = $tix[0];
			$section_id = $tix[1];
			$price_id = $tix[2];
			$ticket_type_id = $tix[3];
			$system_row = $tix[4];
			$system_col = $tix[5];
			$ticket_row = $tix[6];
			$ticket_seat = $tix[7]; 
			$actual_price = $tix[8];
			$convenience = $tix[9];
			
			// $event_id = $row->event_id;
			// $event_info[$event_id]['online_fee'] =  $row->event_internet_sales_charge;
			// $event_info[$event_id]['ek'] =  $row->events_config_ekbarcode_active;
			// $event_info[$event_id]['active'] =  $row->event_active;
		
			//check if event is valid 
 			if(isset( $events_info[$event_id]['online_active'])){ 
				if(!$events_info[$event_id]['online_active']){ return 0; }
				if($events_info[$event_id]['online_fee'] != $convenience ){ return 0; }
			}else{ return 0;}
			
 			
 			// $events_price_info[$event_id][$price_id][$section_id] = $price_amount ;
			//if ticket type id is 1
			if($ticket_type_id != 1){ return 0;} 
			
 			
			//check eventid, priceid , sectionid and amount validity	
			if(isset($prices_event_info[$event_id][$price_id][$section_id] )){ 
				$ticket_price = $prices_event_info[$event_id][$price_id][$section_id];
				//  $ticket_price = number_format($ticket_price, 2, '', '');
				if($ticket_price != $actual_price){ return 0;} 
				
				$amount_total = $amount_total + $ticket_price + $convenience;
				
			}else{ return 0;}
		
 		
			//check existence of seat in a section
			$section_type =	$sections_info[$section_id]['section_type'];
			$section_seat_config =	$sections_info[$section_id]['section_seat_config'];
			
			
			if($section_type != 'Reserved'){ 
 				if($system_row != 0 || $system_col != 0 || $ticket_row != 0 || $ticket_seat != 0){ return 0;} 
			}else{ 
 				//check seat validity and used seats
				if(!$this->validate_seat($section_type, $section_seat_config, $system_row, $system_col, $ticket_row, $ticket_seat)){ return 0;} 
				if(isset($used_seats[$system_row][$system_col][$ticket_row][$ticket_seat])){ return 0 ;}
				
			}
		  
		} 
		
		$amount_total = number_format($amount_total, 2, '', '');
		// $totalAmount = number_format($totalAmount, 2, '', '');
		// echo $amount_total . '/' . $totalAmount;
		if($amount_total != $totalAmount){ return 2;}
		
		return 1;
 
	
	}
 
	public function validate_seat($section_type, $section_config, $system_row, $system_col, $ticket_row, $ticket_col) {
		$valid = false; 
		
		if ($section_type == "Reserved") {
			$check_row = "R$system_row";
			$check_col = "C$system_col";
			$ticket_seat = "$check_row|$check_col|$ticket_row|$ticket_col";
			$tmp_seat_config = unserialize($section_config);
			if(isset($tmp_seat_config[$check_row][$check_col])) {
				$tmp_seat = $tmp_seat_config[$check_row][$check_col];
				if ($tmp_seat == $ticket_seat) {
					$valid =1;
				}
			}
		}
		return $valid;
	}
	
	function get_selected_events($eventids){
		$event_info = array();
		$event_price_info = array();
		$event_ticket_type_info = array();
		$this->db->select('event_id, event_ticket_types, event_internet_sales_charge, ec.events_config_ekbarcode_active, event_active');
		$this->db->join('events_config ec', 'ec.events_config_eventid = event_id');
		$this->db->where_in('event_id' , $eventids);
		$query = $this->db->get('events');
 		
	 
		$result = $query->result();
		
		
		foreach($result as $row){
		
			$event_id = $row->event_id;
			$event_info[$event_id]['online_fee'] =  $row->event_internet_sales_charge;
			$event_info[$event_id]['ek'] =  $row->events_config_ekbarcode_active;
			$event_info[$event_id]['active'] =  $row->event_active;
			$event_info[$event_id]['online_active'] = false;
			
			$ticket_types =  unserialize($row->event_ticket_types);
			
			if($event_info[$event_id]['online_fee'] != '' && $event_info[$event_id]['ek'] == 0 && $event_info[$event_id]['active'] == 1 ){
				$event_info[$event_id]['online_active'] =  true;
				foreach($ticket_types as $ticket_type){
				
				$event_ticket_type_info[$event_id][$ticket_type] = true;
				
				}
			}
		}
		
		 
  		$this->db->where_in('price_event_id' , $eventids);
		$query = $this->db->get('prices');
 		
	 
		$result = $query->result();
		
		
		foreach($result as $row){
		
			$event_id = $row->price_event_id;
			$price_id = $row->price_id;
			$price_amount = $row->price_price;
			$price_section_config = unserialize($row->price_sections);
			foreach($price_section_config as $section_id) {
				$event_price_info[$event_id][$price_id][$section_id] = $price_amount ;
			}
		}
		
		return array($event_info, $event_price_info, $event_ticket_type_info);
	}
	
	function get_selected_sections($sectionids){
	
		$section_info = array();
		$this->db->where_in('section_id' , $sectionids);
		$query = $this->db->get('sections');
		
		foreach($query->result() as $row){
		
		$section_id = $row->section_id;
		$section_info[$section_id]['section_type'] = $row->section_type;
		$section_info[$section_id]['section_seat_config'] = $row->section_seat_config; 
		}
		
		return $section_info;
	
	}
	
	function get_selected_used_section_seats($unique_section_ids){
		$used_seats = array();
		//'done','paid','paid_online','selected','reserved','expired','cancelled','voided','reservation_cancelled','unselected'
		$ticket_status = array('done','paid','paid_online','reserved','selected');
		
		$this->db->select('ticket_system_row, ticket_system_col, ticket_row, ticket_seat, ticket_status');
		$this->db->where_in('ticket_section_id', $unique_section_ids);  
		$this->db->where_in('ticket_status', $ticket_status);   
		$query = $this->db->get('tickets');
	 
		foreach($query->result() as $row){ 
		$used_seats[$row->ticket_system_row][$row->ticket_system_col][$row->ticket_row][$row->ticket_seat] = $row->ticket_status; 
		} 
		
		return $used_seats; 
	}
	
 
}

