<?php

class Sections_model extends CI_Model {

	var $seatplans = 'seatplans s';
	var $venues = 'venues v';
	var $sections = 'sections se';
	var $prices = 'prices pc';
	var $tickets = 'tickets ti';

    function __construct()
    {
        // Call the Model constructor
        parent::__construct();
    }
    
	function get($section_id)
	{
		$this->db->where('section_id', $section_id);
		$query = $this->db->get($this->sections);
		//echo $this->db->last_query();
		
		if($query->num_rows() > 0){
			return $query->row();
		}else{
			return false;
		}
	}
	
	function get_section_ids_array($seatplan_id)
	{
		$this->db->select('section_id'); 
		$this->db->where('section_seatplan_id', $seatplan_id);
		//$this->db->order_by('pc.price_price', 'desc'); 
		$this->db->order_by("section_name", "asc");
		$query = $this->db->get($this->sections)->result();
		$arr_sid = array();
		foreach($query as $section) {
			$arr_sid[] = $section->section_id;
		}
		// return $query->result_array();
		return $arr_sid;
	}
	

	
	function getSectionsWithEventID()
	{
	$this->db->select('  e.event_id
						,s.section_id
						,s.section_name
						,s.section_type
						,s.section_seat_config
						,s.section_capacity
						,s.section_row_from
						,s.section_row_to
						,s.section_row_increment
						,s.section_col_from
						,s.section_col_to
						,s.section_col_increment
						
						
					');
					
	
	$this->db->join('events e', 'e.event_seatplan_id = s.section_seatplan_id');
	$this->db->where('e.event_active', 1);
	$query = $this->db->get('sections s');

	// echo $this->db->last_query();
	$result = $query->result();
	return $result;
	}
	
	
	
	
	function get_ticket_availability_sections($sections, $seatplan_id = false, $unserialize = false)
	{
		if ($unserialize) {
			$arr_sections = unserialize($sections);
		} else {
			$arr_sections = array($sections);
		}
		
		if (empty($arr_sections)) { return array(); }
		
		foreach($arr_sections as $section_id) {
			$price_section_info['used'][$section_id] = 0;
			$price_section_info['capacity'][$section_id] = 0;
			$price_section_info['available'][$section_id] = 0;
			$price_section_info['available_db'][$section_id] = 0;
			$price_section_info['reserved'][$section_id] = 0;
			$price_section_info['type'][$section_id] = "";
		}
		
		// get capacity and default availability
		$this->db->select('section_id, section_capacity, section_type, section_available');
		$this->db->where_in('section_id', $arr_sections);
		$this->db->where('section_seatplan_id', $seatplan_id);
		
		$query = $this->db->get($this->sections);

		// filter out non-existingg section_id
		$arr_sections = array();
		foreach($query->result() as $row) {
			$section_id = $row->section_id;
			$arr_sections[] = $section_id;
			$capacity = $row->section_capacity;
			$price_section_info['capacity'][$section_id] = $capacity;
			
			// default value - if no seat is taken yet
			$price_section_info['available'][$section_id] = $capacity; 
			$price_section_info['type'][$section_id] = $row->section_type; 
			$price_section_info['available_db'][$section_id] = $row->section_available;
		}
		
		if (!empty($arr_sections)) {
			// get taken value
			$this->db->select('ticket_section_id, count(ticket_id) as taken');
			$this->db->where_in('ticket_section_id', $arr_sections);
			$this->db->where_in('ticket_status', array('reserved','done','selected','paid','paid_online'));
			$this->db->group_by('ticket_section_id');
			$query = $this->db->get($this->tickets);
			
			foreach($query->result() as $row) {
				$section_id = $row->ticket_section_id;
				$count_used = $row->taken;
				$price_section_info['used'][$section_id] = $count_used;
				$total_capacity = $price_section_info['capacity'][$section_id];
				$price_section_info['available'][$section_id] = $total_capacity - $count_used;
			}

			// get ticket count of reserved seats
			$this->db->select('ticket_section_id, count(ticket_id) as reserved');
			$this->db->where_in('ticket_section_id', $arr_sections);
			$this->db->where_in('ticket_status', array('reserved'));
			$this->db->group_by('ticket_section_id');
			$query = $this->db->get($this->tickets);
			
			foreach($query->result() as $row) {
				$section_id = $row->ticket_section_id;
				$count_reserved = $row->reserved;
				$price_section_info['reserved'][$section_id] = $count_reserved;
			}
			return $price_section_info;
		} else {
			return array();
		}

	}
	
	function get_sections($seatplan_id)
	{
		$this->db->where('section_seatplan_id', $seatplan_id);
		//$this->db->order_by('pc.price_price', 'desc'); 
		$this->db->order_by("section_name", "asc");
		$query = $this->db->get($this->sections);
		if($query->num_rows() > 0){
		return $query->result();
		}else{
		return false;
		}
		
		
	}
	
	
	function get_all_sections()
	{
		//$this->db->order_by('pc.price_price', 'desc'); 
		$this->db->order_by("section_name", "asc");
		$query = $this->db->get($this->sections);
		if($query->num_rows() > 0){
		return $query->result();
		}else{
		return false;
		}
		
		
	}
	

	function get_selected_section_names($seatplan_id, $sections)
	{	
		$array = array();
		
		if (!$sections)
		{
			return false;
		}
		
		$this->db->where('section_seatplan_id', $seatplan_id);
		$query = $this->db->get($this->sections);
			
		$result = $query->result();

		if ($result)
		{
			// transform result to csv
			$sections = unserialize($sections);

			if ($sections) 
			{
				foreach($result as $r)
				{
					if (in_array($r->section_id, $sections))
						$array[$r->section_id] = $r->section_name;
				}
				
				return $array;
			}
			else
				return false;
		}
		else
			return false;
	}
	
		
		
	function get_selected_section($seatplan_id, $sections)
	{	
		$array = array();
		
		if (!$sections)
		{
			return false;
		}
		
		$this->db->where('section_seatplan_id', $seatplan_id);
		$query = $this->db->get($this->sections);
			
		$result = $query->result();


		if ($result)
		{
			// transform result to csv
			$sections = unserialize($sections);

			if ($sections) 
			{
			
				foreach($result as $r)
				{
					if (in_array($r->section_id, $sections)){
						$array[$r->section_id] = $r->section_name;
					}
				}
		
				return $array;
			}
			else
				return false;
		}
		else
			return false;
	}
	

	function get_section_info($sectionID){
		$this->db->select('section_name, section_type');
		$this->db->where('section_id', $sectionID);
		$query = $this->db->get($this->sections);
		return $query->row();

	}
	
	function get_ticket_availability($sections, $seatplan_id = false, $unserialize = false, $breakdown = false) {
		$ret = $this->get_ticket_availability_sections($sections, $seatplan_id, $unserialize);
		
		if (empty($ret)) { 
			return array(
					'total_capacity' => 0
					, 'total_used' => 0
					, 'total_reserved' => 0
					, 'total_available' => 0
					, 'total_available_db' => 0
					, 'type' => 'N/A'
				); 
		}

		$type = current($ret['type']);

		if ($breakdown) {
			$section_info = $ret;
		}
		
		$section_info['total_capacity'] = array_sum($ret['capacity']);
		$section_info['total_used'] = array_sum($ret['used']);
		// $section_info['total_reserved'] = array_sum($ret['reserved']);
		$section_info['total_available'] = array_sum($ret['available']);
		$section_info['total_available_db'] = array_sum($ret['available_db']);
		$section_info['type'] = $type; 

		return $section_info;
	}
	
	
	function section_max_col_row($section_type, $section_col_from, $section_col_to, $section_col_increment ,$section_row_from, $section_row_to, $section_row_increment) 
	{
		$max_col = 0;
		$max_row = 0;

		if ($section_type == "Reserved") {
			$seatcolumns = range($section_col_from, $section_col_to, $section_col_increment);
			$seatrows = range($section_row_from, $section_row_to, $section_row_increment);
			$max_col = count($seatcolumns);
			$max_row = count($seatrows);
		}

		return array($max_col,$max_row);
	}
	
	
	function section_used_seats(){
		$ticket_status  = array('paid', 'done', 'paid_online', 'selected', 'reserved');
		
		
		$this->db->select('tix.ticket_section_id, tix.ticket_system_row, tix.ticket_system_col, tix.ticket_row, tix.ticket_seat, tix.ticket_id');
		$this->db->join('events ev', 'tix.ticket_event_id = ev.event_id');
		$this->db->where_in('tix.ticket_status', $ticket_status);
		$this->db->where('ev.event_active = 1');
		$query = $this->db->get('tickets tix');
		
		// return $query->result();
		foreach($query->result() as $row) {
			$section_id = $row->ticket_section_id;
			$sys_col = $row->ticket_system_col;
			$sys_row = $row->ticket_system_row;
			$tix_row = $row->ticket_row;
			$tix_seat = $row->ticket_seat;
			$tix_id = $row->ticket_id;
			
			// generate list of used seats -- to be mainly used for sections with reserved seats
			$seat_type = array("Free Seating", "Standing");
			if(!in_array($tix_seat, $seat_type)) {
				// if(isset($sections_used_seats[$section_id][$sys_row][$sys_col])) {
					$sections_used_seats[$section_id][]="R$sys_row|C$sys_col|$tix_row|$tix_seat";
				// }
			}
			
			// generate count list of used seats -- includes reserved, free seating and guaranted seats
			// can be used to generate number of available tickets by using formula (CAPACITY - USED_COUNT)
			if(!isset($tmp_section_used_count[$section_id])) {
				$tmp_section_used_count[$section_id] = array();
			}
			$tmp_section_used_count[$section_id][] = $tix_id;
		}
		
		foreach($tmp_section_used_count as $section_id => $tix_list) {
			$sections_used_count[$section_id] = count($tix_list);
		}
		
		return array($sections_used_seats, $sections_used_count);
	}
	
	function generate_section_seats($section_type, $section_seat_config) {
		$seat_config = array();
		if ($section_type == "Reserved") {
			$tmp_seat_config = unserialize($section_seat_config);
			foreach($tmp_seat_config as $row => $col) {
				foreach($col as $seat) {
					$seat_config[] = $seat;
				}
			}
		}
		
		return $seat_config;
		}


	
	
	
	
	
}

