<?php

class api_tickets_model extends CI_Model {

	var $events = 'events e';
	var $users = 'users u';
	var $tickets = 'tickets ti';
	var $sections = 'sections s';
	var $prices = 'prices p';
	var $ticket_types = 'ticket_types tt';
	var $venues = 'venues v';
	var $transactions = 'transactions tr';
	var $terminals = 'terminals te';
	var $ticket_layouts = 'ticket_layouts tl';
	var $logos = 'logos l';
	var $ticket_logos = 'ticket_logos tk';

	
	public function __construct()
	{
		parent::__construct();
	
		// $this->load->database('default',true);
	}	
	

	function get_sold_seats($event_id, $section_id)
	{
		$this->db->select('ticket_system_row,ticket_system_col,ticket_row,ticket_seat');
		$this->db->where('ticket_event_id', $event_id);
		$this->db->where('ticket_section_id', $section_id);
		$this->db->where_in('ticket_status', array('done', 'paid', 'paid_online'));
		$query = $this->db->get($this->tickets);
		//echo $this->db->last_query();

		if($query->num_rows() > 0){
		return $query->result();
		}else{
		return false;
		}
		
	}


	function get_sold_count($event_id, $section_id)
	{
		$this->db->select('ticket_system_row,ticket_system_col,ticket_row,ticket_seat');
		$this->db->where('ticket_event_id', $event_id);
		$this->db->where('ticket_section_id', $section_id);
		$this->db->where_in('ticket_status', array('done', 'paid', 'paid_online'));
		$query = $this->db->get($this->tickets);
		
		return $query->num_rows();
	
	}
	
	function get_selected_seats($event_id, $section_id)
	{
		$this->db->select('ticket_system_row,ticket_system_col,ticket_row,ticket_seat');
		$this->db->where('ticket_event_id', $event_id);
		$this->db->where('ticket_section_id', $section_id);
		$this->db->where_in('ticket_status', array('selected'));
		$query = $this->db->get($this->tickets);
		//echo $this->db->last_query();

		if($query->num_rows() > 0){
		return $query->result();
		}else{
		return false;
		}
		
	}


	function get_selected_count($event_id, $section_id)
	{
		$this->db->select('ticket_system_row,ticket_system_col,ticket_row,ticket_seat');
		$this->db->where('ticket_event_id', $event_id);
		$this->db->where('ticket_section_id', $section_id);
		$this->db->where_in('ticket_status', array('selected'));
		$query = $this->db->get($this->tickets);
		
		return $query->num_rows();
	
	}
	
	
	function get_reserved_seats($event_id, $section_id)
	{
		$this->db->select('ticket_system_row,ticket_system_col,ticket_row,ticket_seat');
		$this->db->where('ticket_event_id', $event_id);
		$this->db->where('ticket_section_id', $section_id);
		$this->db->where_in('ticket_status', array('reserved'));
		$query = $this->db->get($this->tickets);
		//echo $this->db->last_query();

		if($query->num_rows() > 0){
		return $query->result();
		}else{
		return false;
		}
		
	}

	function get_reserved_count($event_id, $section_id)
	{
		$this->db->select('ticket_system_row,ticket_system_col,ticket_row,ticket_seat');
		$this->db->where('ticket_event_id', $event_id);
		$this->db->where('ticket_section_id', $section_id);
		$this->db->where_in('ticket_status', array('reserved'));
		$query = $this->db->get($this->tickets);
		
		return $query->num_rows();
	
	}
	

	function is_seat_taken($row, $col, $seats_taken)
	{
		foreach ($seats_taken as $seat)
		{
			if ($seat->ticket_system_row == $row and $seat->ticket_system_col == $col)
			{
				return true;
			}
		}
		
		return false;
	}
	
	function get_selected_tickets($transaction_id)
	{
		$this->db->select('ti.*, tr.*, p.*, tt.ticket_type_discount_type, tt.ticket_type_discount, tt.ticket_type_name, tt.ticket_type_code, s.section_id, s.section_name, s.section_type, s.section_code');
		$this->db->where('ti.ticket_transaction_id', $transaction_id);	
		$this->db->where('ti.ticket_status', 'selected');	
		$this->db->join($this->sections, 's.section_id = ti.ticket_section_id', 'left');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id', 'left');
		$this->db->join($this->prices, 'p.price_id = ti.ticket_price_id', 'left');
		$this->db->join($this->transactions, 'tr.transaction_id = ti.ticket_transaction_id', 'left');
		$this->db->order_by('ti.ticket_row', 'asc');
		$this->db->order_by('ti.ticket_seat + 0', 'asc');
		$query = $this->db->get($this->tickets);
		//echo $this->db->last_query();
		
		return $query->result();
	}
	
	function update_acknowledgment_receipt($ticket_id, $receipt_number)
	{
		// update the tickets table
		$this->db->where('ticket_id', $ticket_id);
		$this->db->update($this->tickets, array('ticket_acknowledgment_receipt' => $receipt_number));
		
		return true;
	}
	
	function get_paid_online_tickets($transaction_id)
	{
		$this->db->select('ti.*, tr.*, p.*, tt.ticket_type_discount_type, tt.ticket_type_discount, tt.ticket_type_name, tt.ticket_type_code, s.section_id, s.section_name, s.section_type, s.section_code');
		$this->db->where('ti.ticket_transaction_id', $transaction_id);	
		$this->db->where('ti.ticket_status', 'paid_online');		
		$this->db->join('sections s', 's.section_id = ti.ticket_section_id', 'left');
		$this->db->join('ticket_types tt', 'tt.ticket_type_id = ti.ticket_type_id', 'left');
		$this->db->join('prices p', 'p.price_id = ti.ticket_price_id', 'left');
		$this->db->join('transactions tr', 'tr.transaction_id = ti.ticket_transaction_id', 'left');
		$this->db->order_by('ti.ticket_row', 'asc');
		$this->db->order_by('ti.ticket_seat + 0', 'asc');
		$query = $this->db->get('tickets ti');
		//echo $this->db->last_query();
		
		return $query->result();
	}
	

	
	
	/* function select_ticket($event_id, $section_id, $system_row, $system_col, $row, $seat)
	{

		// check first if seat is still available
		if (!$this->is_seat_available($section_id, $system_row, $system_col))
		{
			$fields = array(
				'ticket_date_entered'		=> date('Y-m-d H:i:s'),
				// 'ticket_session_id'			=> $this->session->userdata('customer_session_id'),
				'ticket_event_id'			=> $event_id,
				'ticket_section_id'			=> $section_id,
				// 'ticket_price_id'			=> $this->session->userdata('cpi'),
				'ticket_system_row'			=> $system_row,
				'ticket_system_col'			=> $system_col,
				'ticket_row'				=> $row,
				'ticket_seat'				=> $seat,
				'ticket_status'				=> 'selected',
				// 'ticket_user_id'			=> $this->session->userdata('user_id'),
				// 'ticket_branch_id'			=> $this->session->userdata('user_branch_id'),
				// 'ticket_terminal_id'		=> $this->session->userdata('user_terminal_id'),
			);
			
			// insert to db
			$this->db->set($fields);
			$this->db->insert('tickets');
			$ticket_count = $this->db->affected_rows();
			
			// update available tickets
			if ($ticket_count > 0) {
				$this->update_available($section_id, 'decrease', $ticket_count);
				echo '<root><result>success</result></root>';
			}
		}
		else
		{
			echo '<root><result>failed</result></root> ';
		}
	} */
	
	
		
		
		
		
		
	
	function unselect_ticket($event_id, $section_id, $system_row, $system_col)
	{
		// log this
		// $this->logs_model->add("unselect_ticket($event_id, $section_id, $system_row, $seat)");

		// list($system_col, $row, $seat) = explode('|', $seat);
		// $system_col = str_replace('C', '', $system_col);
		

		// update db
		$this->db->where('ticket_event_id', $event_id);
		$this->db->where('ticket_section_id', $section_id);
		$this->db->where('ticket_system_row', $system_row);
		$this->db->where('ticket_system_col', $system_col);
		$this->db->where('ticket_status', 'selected');
		$this->db->update($this->tickets, array('ticket_status' => 'unselected'));
		$ticket_count = $this->db->affected_rows();

		// update available tickets
		if ($ticket_count > 0) {
			$this->update_available($section_id, 'increase', $ticket_count);
			echo '<root><result>success</result></root>';
		}else{
		echo '<root><result>no seat unselected</result></root>';
		}
			
	}
	

	function is_seat_available($section_id, $row, $col)
	{
	
	
	
		$this->db->where('ticket_section_id', $section_id);
		$this->db->where('ticket_system_row', $row);
		$this->db->where('ticket_system_col', $col);
		$this->db->where_in('ticket_status', array('done', 'paid', 'paid_online', 'reserved', 'selected'));
		$query = $this->db->get($this->tickets);
		
		// echo $this->db->last_query();
		// die();
		
		return  $query->num_rows();
	}
	
	
	function update_available($section_id, $type, $count)
	{
		// get last available tickets
		$this->db->select('section_available');
		$this->db->where('section_id', $section_id);
		$query = $this->db->get($this->sections);
		$row = $query->row();
		
		$new_available = ($type == 'increase') ? $row->section_available += $count : $row->section_available -= $count;
		
		// update last available tickets
		$this->db->where('section_id', $section_id);
		$this->db->update($this->sections, array('section_available' => $new_available));
		
		return true;
	}
	
	
	function get_unselected_tickets($transaction_id){
	$this->db->select('ti.*, tr.*, p.*, tt.ticket_type_discount_type, tt.ticket_type_discount, tt.ticket_type_name, tt.ticket_type_code, s.section_id, s.section_name, s.section_type, s.section_code');
	$this->db->where('ti.ticket_transaction_id', $transaction_id);	
	$this->db->where('ti.ticket_status','unselected');	
	$this->db->join($this->sections, 's.section_id = ti.ticket_section_id', 'left');
	$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id', 'left');
	$this->db->join($this->prices, 'p.price_id = ti.ticket_price_id', 'left');
	$this->db->join($this->transactions, 'tr.transaction_id = ti.ticket_transaction_id', 'left');
	$this->db->order_by('ti.ticket_row', 'asc');
	$this->db->order_by('ti.ticket_seat + 0', 'asc');
	$query = $this->db->get($this->tickets);
	//echo $this->db->last_query();
	
	return $query->result();
	}
		

	function get_tickets($transaction_id){
	$this->db->select('ti.*, tr.*, p.*, tt.ticket_type_discount_type, tt.ticket_type_discount, tt.ticket_type_name, tt.ticket_type_code, s.section_id, s.section_name, s.section_type, s.section_code');
	$this->db->where('ti.ticket_transaction_id', $transaction_id);	
		

	$this->db->where_in('ticket_status', array('done', 'paid_online'));
	$this->db->join('sections s', 's.section_id = ti.ticket_section_id', 'left');
	$this->db->join('ticket_types tt', 'tt.ticket_type_id = ti.ticket_type_id', 'left');
	$this->db->join('prices p', 'p.price_id = ti.ticket_price_id', 'left');
	$this->db->join('transactions tr', 'tr.transaction_id = ti.ticket_transaction_id', 'left');
	$this->db->order_by('ti.ticket_row', 'asc');
	$this->db->order_by('ti.ticket_seat + 0', 'asc');
	$query = $this->db->get('tickets ti');
	//echo $this->db->last_query();
	return $query->result();
	}


	function getVoucherInfo($transaction_id)
	{
		$this->db->select('ti.*, tr.*, p.*, tt.ticket_type_discount_type, tt.ticket_type_discount, tt.ticket_type_name, tt.ticket_type_code, s.section_id, s.section_name, s.section_type, s.section_code, pt.payment_type_name,e.event_internet_sales_charge,e.event_title,e.event_date_time,v.venue_name,c.customer_firstname,c.customer_lastname,c.customer_address1,c.customer_email,c.customer_mobile,u.username,cn.*');
		$this->db->where('ti.ticket_transaction_id', $transaction_id);	
		$this->db->where('ti.ticket_status', 'paid_online');		
		$this->db->join('sections s', 's.section_id = ti.ticket_section_id', 'left');
		$this->db->join('ticket_types tt', 'tt.ticket_type_id = ti.ticket_type_id', 'left');
		$this->db->join('prices p', 'p.price_id = ti.ticket_price_id', 'left');
		$this->db->join('transactions tr', 'tr.transaction_id = ti.ticket_transaction_id', 'left');
	
		$this->db->join('payments pm', 'pm.payment_transaction_id = ti.ticket_transaction_id','left');
		$this->db->join('payment_types pt', 'pm.payment_payment_type_id = pt.payment_type_id','left');	
		$this->db->join('events e', 'e.event_id = ti.ticket_event_id','left');	
		$this->db->join('venues v', 'e.event_venue_id = v.venue_id', 'left');
		$this->db->join('customers c', 'tr.transaction_customer_id = c.customer_id', 'left');
		$this->db->join('users u', 'tr.transaction_user_id = u.user_id', 'left');
		$this->db->join('card_numbers cn', 'tr.transaction_id = cn.card_number_transaction_id', 'left');
		
	
		$this->db->order_by('ti.ticket_row', 'asc');
		$this->db->order_by('ti.ticket_seat + 0', 'asc');
		$query = $this->db->get('tickets ti');
		// echo $this->db->last_query();
		
		return $query->result();
	}
	
	
	
	
	
		
	function nt_select_ticket($event_id, $section_id, $system_row, $system_col, $row, $seat,$ticket_price_id,$accessCode){

	
	// echo "event_id $event_id <br>"; 
	// echo "section_id $section_id <br>"; 
	// echo "system_row $system_row <br>"; 
	// echo "system_col $system_col <br>"; 
	// echo "row $row <br>"; 
	// echo "seat $seat <br>"; 
	// echo "ticket_price_id $ticket_price_id <br>"; 
	// echo "accessCode $accessCode <br>"; 
	// die();
	
				// check first if seat is still available
				if (!$this->is_seat_available($section_id, $system_row, $system_col) || $seat == "FreeSeating"){

			
					$fields = array(
						'ticket_date_entered'		=> date('Y-m-d H:i:s'),
						'ticket_session_id'			=> $accessCode,
						'ticket_event_id'			=> $event_id,
						'ticket_section_id'			=> $section_id,
						'ticket_system_row'			=> $system_row,
						'ticket_system_col'			=> $system_col,
						'ticket_row'				=> $row,
						'ticket_seat'				=> $seat,
						'ticket_status'				=> 'selected',
						'ticket_price_id'			=> $ticket_price_id,
					);
					
					// insert to db
					$this->db->set($fields);
					$this->db->insert('tickets');
					$ticket_id = $this->db->insert_id();
					
					
					
					// update available tickets
					if ($ticket_id > 0) {
						$this->update_available($section_id, 'decrease', 1);
						echo '<root><result>' . $ticket_id . '</result></root>';
					}
				}
				else
					
				{
						// echo $this->db->last_query();
				// die();
					echo '<root><result>failed</result></root> ';
				}
			
	}
	
		
	function nt_unselect_ticket($ticketid,$section_id){

		// update db
		$this->db->where('ticket_id', $ticketid);
		$this->db->where('ticket_section_id', $section_id);
		$this->db->where('ticket_status', 'selected');
		$this->db->update($this->tickets, array('ticket_status' => 'unselected'));
		$ticket_count = $this->db->affected_rows();

		// update available tickets
		if ($ticket_count > 0) {
			$this->update_available($section_id, 'increase', $ticket_count);
			echo '<root><result>success</result></root>';
		}else{
		echo '<root><result>no seat unselected</result></root>';
		}
			
	}

	
	
	
	function nt_get_selected_seats_by_session($session_id){
		
	$this->db->where('t.ticket_session_id',$session_id);
	$this->db->where('t.ticket_status', "selected");
	$this->db->join('sections s', 's.section_id = t.ticket_section_id','left');
	$this->db->join('prices p', 'p.price_id = t.ticket_price_id', 'left');
	$selected_seats = $this->db->get('tickets t')->result();
		 	
	return $selected_seats;
	}

	
	function nt_replace_session_for_selected_seats($old_session,$new_session){
	
	$data = array(
               'ticket_session_id' => $new_session
            );

	$this->db->where('ticket_session_id', $old_session);
	$this->db->update('tickets', $data);
	}
	
	function nt_unsellect_all_by_session($session,$section_id=false){
	
	
	$data = array(
               'ticket_status' => "unselected"
            );

	if($section_id){
	$this->db->where('ticket_section_id', trim($section_id));
		
	}
	
	$this->db->where('ticket_session_id', $session);
	$this->db->where('ticket_status', "selected");
	$this->db->update('tickets', $data);
	}

}
	



