<?php

class api_mobilenum_model extends CI_Model {

	var $seatplans = 'seatplans s';
	var $venues = 'venues v';
	var $prices = 'prices pc';
	var $events = 'events e';	

    function __construct()
    {
        // Call the Model constructor
        parent::__construct();
    }
	
	function validate_phonenumbers($number = false) {
		// can specify any format indicated below		
		$formats = array(
						// 13 to 14 char +63917-000-0000
						'+############', 
						'+#############', 
						'+##############', 
						// from 11-digit to 15-digit number
						'###########',
						'############',
						'#############',
						'##############',
						'###############',
					);
	
		/*
		Add following format when possible:
			+639200000000
			+63 920 000 0000
			+63 920 0000000
			639200000000
			63 920 000 0000
			63 920 0000000
			09200000000
			0920 0000000		
		*/

		$format = trim(preg_replace("/[0-9]/", "#", $number));
		return (in_array($format, $formats)) ? true : false;
	}
	
	
	function lookup($mobilenum = "") {
		$__bValid = empty($mobilenum);
		$objMobile = array(
				"isValid" => (!$__bValid),
				"isLocal" => false,
				"CountryCode" => "63",
				"NetworkCode" => "",
				"MobileNum" => $mobilenum,
				"Carrier" => "",
				"bCODE" => "",
			);
		
		if ($__bValid) {
			return $objMobile;
			exit;
		}
		
		if ($this->validate_phonenumbers($mobilenum)) {
			$__strMobileNum = str_replace("+","", $mobilenum);
			$__iPrefix = 0;
			$__iParsedMobileNum = 0;
			$__strlenMobile = strlen($__strMobileNum);
			
			// 12-digit for 639XX prefix for validation and reformat to 09XX format
			if ($__strlenMobile == 12)
			{
				$__iPrefix = intval(substr($__strMobileNum,0, 4));
				if ((6389 < $__iPrefix) && ($__iPrefix < 6400))
				{
					$__strMobileNum = "0" . substr($__strMobileNum, 2, 10);
				}
			}

			// 11-digit for 09XX prefix
			$__strlenMobile = strlen($__strMobileNum);
			if ($__strlenMobile == 11)
			{
				$__iPrefix = intval(substr($__strMobileNum,0, 4));

				if ((900 < $__iPrefix) && ($__iPrefix < 1000))
				{
					$__iPrefix %= 900;
					$__bValid = true;
					$__strMobileNum = substr($__strMobileNum, 1, 10);
				}
			}
			
			if ($__bValid) {
				$TelCo = $this->IdentifyTelco($__iPrefix);
				$objMobile["isLocal"] = true;
				$objMobile["CountryCode"] = "63";
				$objMobile["NetworkCode"] = ($__iPrefix+900);
				$objMobile["MobileNum"] = $__strMobileNum;
				$objMobile["Carrier"] = $TelCo;
				$objMobile["bCODE"] = $this->getBCODEcarrier($TelCo);
			}
		}
		return $objMobile;
	}
	
	
    function IdentifyTelco($prefix)
    {
        $strTelco = "";
        
		if ($this->IsAGlobeNum($prefix))
		{
			$strTelco = "GLOBE";
		}
		else if ($this->IsASmartNum($prefix))
		{
			$strTelco = "SMART";
		}
		else if ($this->IsASunNum($prefix))
		{
			$strTelco = "SUN";
		}
		
        return $strTelco;
    }

    function IsAGlobeNum($code)
    {
        $IsValid = false;
        $iGlobePrefixes = array( 05, 06, 15, 16, 17, 25, 26, 27, 35, 36, 37, 96, 97 );

		if (in_array($code,$iGlobePrefixes))
		{
			$IsValid = true;
		}
        
        return $IsValid;
    }

    function IsASmartNum($code)
    {
        $IsValid = false;
        $iSmartPrefixes = array( 07, 08, 09, 10, 12, 18, 19, 20, 21, 28, 29, 30, 38, 39, 89, 99, 48, 49 );

		if (in_array($code,$iSmartPrefixes))
		{
			$IsValid = true;
		}
        
        return $IsValid;
    }

    function IsASunNum($code)
    {
        $IsValid = false;
        $iSunPrefixes = array( 22, 23, 32, 33 );

		if (in_array($code,$iSunPrefixes))
		{
			$IsValid = true;
		}
        
        return $IsValid;

    }
	
	function getBCODEcarrier($carrier)
	{
		if ($carrier == "GLOBE")
		{
			$result = "ecom";
		}
		elseif ($carrier == "SMART")
		{
			$result = "cinema";
		}
		elseif ($carrier == "SUN")
		{
			$result = "cinema";
		}
		else
		{
			$result = "DEFAULT";
		}
		return $result;
	}
	
}


