<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

include('accesstemplate.php');
class GenericAccess extends	AccessTemplate{


	var $acceptedEvents = array(
			"katy" => "004900122122000",
			"bep" => "004151025112000",
			"miley" => "002330617112000",
			"justin" => "001520510112000",
			"test" => "PBA01042012",
		);

	function verify_partyid(){
		
		//initialize parameters
		$partycode = $this->input->get_post('partycode');
		$usecode = $this->input->get_post('usecode');
		$appcodeduration = $this->config->item("token_expiry");

		//Check if parameters are empty
		if(!$partycode||!$usecode){
		echo "Directory access is forbidden";
		}
		
		$dbAccess = $this->load->database('default',true);
		
					//Check existence of partycode &&  usecode..Returns true if exists
					if ($this->verifyparty($partycode,$usecode))
					{
							//Other Checkpoints 
								//Check if browser .. get browser used
								if ($this->agent->is_browser()){
								$agent = $this->agent->browser().' '.$this->agent->version();
								}//if robot..
								elseif ($this->agent->is_robot()){
								$agent = $this->agent->robot();
								}//if mobile..
								elseif ($this->agent->is_mobile()){
								$agent = $this->agent->mobile();
								}
								
								else
								{
								$agent = '"Directory access is forbidden';
								
								$data['content'] = $agent;
								}

								//if valid user agent...
								if($agent != 'Unidentified User Agent')
								{
								
								//Get partyCredentials
								$partycredentials = array(
								'platform' =>  $this->agent->platform(),
								'browser' =>  $this->agent->browser().' '.$this->agent->version(),
								'ipaddress' =>  $this->input->ip_address(),
								'referrer:' => $this->agent->referrer()
								);

								//Check Referrers from DB based on submitted credentials
							
	// // $dbAccess->select("API_HTTP_REFERER");
								// // $dbAccess->where("api_partycode", $partycode);
								// // $dbAccess->where("API_HTTP_REFERER",  $this->agent->referrer());
								// // $query = $dbAccess->get('api_gateways');
										
										// // if ($query->num_rows() < 1)
											// // { echo "Directory Access is forbidden";}
											// // else{
											
											//EXECUTE!
											//Issue an AppCode
											$appcode = $this->generateAppCode($partycode,$usecode,$this->getcurrentdatetime());

											//Save Appcode into api_sessions
											$data = array(
										   'api_partycode' => $partycode,
										   'api_apppcode' => $appcode,
										   'api_livetoken' => 0,
										   'api_duration' => $appcodeduration,
										   'api_gen_active' => 1,
										   'api_time_issued' => $this->getcurrentdatetime(),
										   'api_session_browser' => $partycredentials['browser'],
										   'api_party_ip' => $partycredentials['ipaddress']
											);
											$this->db->insert('api_sessions', $data); 

											
											$data['content'] = $appcode;
											

											// }											
						
							}	
					}
						
					else
					{
					$data['content'] = 'Invalid Party Code or Use Code';
					}
							
$this->load->view("appcode_xml", $data);
	}

	function initialize_partyline(){
	$dbAccess = $this->load->database('default',true);
	$appcode = $this->input->get_post('appcode');
	$livetoken = false;

			//Check if appcode exist
			if (!$this->checkappcode($appcode))
			{
			$data['content'] = 'Appcode does not exist';
			}
			else
			{
				
			//Check if there is a LiveToken already issued
				$dbAccess->select("api_livetoken");
				$dbAccess->where("api_apppcode", $appcode);
				$query = $dbAccess->get('api_sessions');

			if ($query->num_rows() == 1)
			{

						//Check if appcode/livetoken is still valid..if valid..
						if (!$this->checksessionexpiration($appcode,0))
						{
							//issue LiveToken
							$livetoken = $this->generatelivetoken($appcode);

							//Get partyCredentials
							$partycredentials = $this->getpartycredentials();
							
								$this->session_deactivate($appcode,0);
							
							//Save LiveToken into api_sessions
								$data = array(
							   'api_partycode' => $this->getpartycodebyappcode($appcode),
							   'api_apppcode' => $appcode,
							   'api_livetoken' => $livetoken,
							   'api_duration' => $this->config->item("token_expiry"),
							   'api_gen_active' => 1,
							   'api_time_issued' => $this->getcurrentdatetime(),
							   'api_session_browser' => $partycredentials['browser'],
							   'api_party_ip' => $partycredentials['ipaddress']
								);
								$this->db->insert('api_sessions', $data); 	
								
									$data['content'] =  $livetoken;
						}
						else
						{
						$data['content'] = 'Session Expired';
						}
			}
				else
				{
				$data['content'] = 'Invalid Live Token';
				}
			}
			
				$this->load->view("livetoken_xml", $data);	
	}

	function refresh_party(){
	$livetoken = false;
	$appcode = false;

	//Checks the existence of $appcode && $livetoken
	if ($this->validatesession($this->input->get_post('appcode'),$this->input->get_post('livetoken')))
	{

		$appcode = $this->input->get_post('appcode');
		$livetoken = $this->input->get_post('livetoken');


					//Check if Expired..if not yet expired..
						if(!$this->checksessionexpiration($appcode,$livetoken))
						{
							//Deactivate an $appcode/$livetoken
							$this->session_deactivate($appcode,$livetoken);
								
							//issue LiveToken
							$livetoken = $this->generatelivetoken($appcode);

							//Get partyCredentials
							$partycredentials = $this->getpartycredentials();

							//Save LiveToken into api_sessions
								$data = array(
							   'api_partycode' => $this->getpartycodebyappcode($appcode),
							   'api_apppcode' => $appcode,
							   'api_livetoken' => $livetoken,
							   'api_duration' => $this->config->item("token_expiry"),
							   'api_gen_active' => 1,
							   'api_time_issued' => $this->getcurrentdatetime(),
							   'api_session_browser' => $partycredentials['browser'],
							   'api_party_ip' => $partycredentials['ipaddress']
								);
								$this->db->insert('api_sessions', $data); 	
							
										$data['content'] = $livetoken;
						}

					else
					{
					$data['content'] =  'Access Expired';
					}
		}
		else
		{
		$data['content'] =  'LiveToken does not exist';
		}
	$this->load->view("livetoken_xml", $data);	
	}
		
	function register_party_user(){

		$this->load->helper('email');
		$livetoken = false;
		$appcode = false;
		$appcode = $this->input->get_post('appcode');
		$livetoken = $this->input->get_post('livetoken');
		
		////Checks the existence of $appcode && $livetoken
		if (!$this->validatesession($appcode,$livetoken))
		{		$data['content'] = 'Invalid  Appcode/Livetoken';}
		
		//Check if Expired..if not yet expired..if not...
		elseif($this->checksessionexpiration($appcode,$livetoken))
			{ $data['content'] = 'Appcode/LiveToken Expired';}
			else{

			$customer_partycode = $this->getpartycodebyappcode($appcode);

			$appcode = $this->input->post('appcode');
			$customer_firstname = $this->input->post('fname');
			$customer_middlename = $this->input->post('mname');
			$customer_lastname = $this->input->post('lname');
			$customer_birthdate = $this->input->post('bdate');
			$customer_mobile = $this->input->post('mobile');
			$customer_email = $this->input->post('email');
			$customer_password = $this->input->post('pass');
			
			//HARDCODE for the meantime-----------------------------------------------------
				echo $appcode; 
				$appcode = $this->input->post('appcode');
				$customer_firstname = 'Saul';
				$customer_middlename = 'David';
				$customer_lastname = 'Solomon';
				$customer_birthdate = '2013-02-15';
				$customer_mobile = 925434532687;
				$customer_email = 'abc@abc.com';
				$customer_password = '1234';
			//-------------------------------------------------------------------------------
				//Check Password
				if(!$customer_password)
					{ $customer_password = 'ERROR: No Password Provided';}
					else{$customer_password = $this->prep_password($customer_password);}
				
				//Check FirstName
				if(!$customer_firstname)
					{ $customer_firstname = 'ERROR: No First Name Provided';}
					
					//Check LastName
				if(!$customer_lastname)
					{ $customer_lastname = 'ERROR: No Last Name Provided';}	
					
					
				//Check Date..Date should be in YYYY-MM-DD
				if (!$customer_birthdate)
						{$customer_birthdate = 'ERROR: No Birth Date Provided';}
						
				//Returns TRUE if date format = YYYY-MM-DD
				if(!$this->isValidDate($customer_birthdate))
					{$customer_birthdate = 'ERROR: Invalid date format';}
					
					
				if($this->check_dbcolumn($customer_mobile))
				{ $customer_mobile = 'ERROR: Mobile number already existed';}
					
				//Check mobile
				if( !$customer_mobile)
				{ $customer_mobile = 'ERROR: No Mobile Number Provided';}

				
				//Check if email Adress string is valid
				if(!$customer_email)
						{ $customer_email = 'ERROR: No Email Provided';}
					
						//Check if email Adress string is valid
				if(!valid_email($customer_email))
						{ $customer_email = 'ERROR: Invalid Email Format';}	
					
				//Check duplicate email
				if($this->check_dbcolumn($customer_email))
				{ $customer_email = 'ERROR: Email Already Used';}			

				
					$data = array(
				   'api_customer_firstname' => $customer_firstname,
				   'api_customer_middlename' => $customer_middlename,
				   'api_customer_lastname' => $customer_lastname,
				   'api_customer_birthdate' => $customer_birthdate,
				   'api_customer_mobile' => $customer_mobile,
				   'api_customer_email' => $customer_email,
				   'api_customer_username' => $customer_email,
				   'api_customer_password' => $customer_password,
				   'api_customer_partycode' => $customer_partycode
					);
						
				//Check if there is an error
				$xml = '<root>';
				$xml = $xml . '<result>Registration Failed</result>';
				foreach ($data as $key=>$value) 
				{	if (strpos($value,'ERROR:') !== false) {
					$xml = $xml . '<' .  substr($key, 13)  .'>' . $value . '</' . substr($key, 13). '>';
					}
				}	
					$xml = $xml . '</root>';
			
			
									//If no error..
									if (strpos($xml,'ERROR:') == false)
												{
									// I N S E R T		T O		D A T A B A S E
									$this->db->insert('api_party_customers', $data); 	
									
												
												$xml = '<root>';
												$xml = $xml . '<result>Registration Succesful</result>';
												foreach ($data as $key=>$value) 
												{
													if(substr($key, 13) !== 'password')
													{
														$xml = $xml . '<' .  substr($key, 13)  .'>' . $value . '</' . substr($key, 13). '>';
													}
												}	
													$xml = $xml . '</root>';
												$data['content'] = $xml;
										}
				else
				{
				$data['content'] = $xml;

				}
			
				}
			$this->load->view("register_party_user_xml", $data);
	}
				
	
	/*=======  GENERIC FUNCTIONS ======= */
	function GetActiveEventsToday(){
	
	$date = new DateTime(null, new DateTimeZone('Asia/Manila'));
	$today = $date->format('Y-m-d');
	
	
	//$today = '2013-01-25';
	
	$appcode = $this->input->get_post('appcode');
		$livetoken = $this->input->get_post('livetoken');
		
		// Checks the existence of $appcode && $livetoken
		if (!$this->validatesession($appcode,$livetoken))
		{echo '$appcode/$livetoken does not exist';}
		
		// Check if Expired..if not yet expired..if not...
		elseif($this->checksessionexpiration($appcode,$livetoken))
			{ echo '$Appcode/$liveToken expired';}
			else{	
			

		$dbAccess = $this->load->database('default',true);
		
		$dbAccess->select("
				evt.event_id
				,evt.event_code
				, evt.event_long_title
				, evt.event_date_time
			");

			
		
					
		$dbAccess->like('evt.event_date_time', $today, 'after');
		$dbAccess->where("evt.event_active", 1);
		$query = $dbAccess->get('events evt');
	

		$this->load->dbutil();
		
		$config = array (
			  'root'    => 'root',
			  'element' => 'eventinfo', 
			  'newline' => "\n", 
			  'tab'    => "\t"
			);

			
		$xmloutput = $this->dbutil->xml_from_result($query, $config);
		echo $xmloutput;
	}

	}
	
	function GetActiveEventByID() {
		
		$appcode = $this->input->get_post('appcode');
		$livetoken = $this->input->get_post('livetoken');
		
		//Checks the existence of $appcode && $livetoken
		if (!$this->validatesession($appcode,$livetoken))
		{echo '$appcode/$livetoken does not exist';}
		
		//Check if Expired..if not yet expired..if not...
		elseif($this->checksessionexpiration($appcode,$livetoken))
			{ echo '$Appcode/$liveToken expired';}
			else{	
			
	
		
		
		$dbAccess = $this->load->database('default',true);
		
		$eventid = $this->input->get_post('eventid');

		
		$dbAccess->select("
				evt.event_id
				,evt.event_code
				, evt.event_long_title
				, evt.event_date_time
			");
			
		$dbAccess->where("evt.event_active", 1);
		$dbAccess->where("evt.event_id", $eventid);
		$query = $dbAccess->get('events evt');
	
	
		$this->load->dbutil();
		
		$config = array (
			  'root'    => 'root',
			  'element' => 'eventinfo', 
			  'newline' => "\n", 
			  'tab'    => "\t"
			);
			
		$xmloutput = $this->dbutil->xml_from_result($query, $config);
		echo $xmloutput;
				}
				
			
	}
	
	function GetActiveEvents(){
	
		$appcode = $this->input->get_post('appcode');
		$livetoken = $this->input->get_post('livetoken');
		
		// Checks the existence of $appcode && $livetoken
		if (!$this->validatesession($appcode,$livetoken))
		{echo '$appcode/$livetoken does not exist';}
		
		// Check if Expired..if not yet expired..if not...
		elseif($this->checksessionexpiration($appcode,$livetoken))
			{ echo '$Appcode/$liveToken expired';}
			else{	

		$dbAccess = $this->load->database('default',true);

		$dbAccess->select("
				evt.event_id
				,evt.event_code
				, evt.event_title
				, evt.event_long_title
				, evt.event_date_time
			");
			
		$dbAccess->where("evt.event_active", 1);
		$query = $dbAccess->get('events evt');
	
		$this->load->dbutil();
		
		$config = array (
			  'root'    => 'root',
			  'element' => 'eventinfo', 
			  'newline' => "\n", 
			  'tab'    => "\t"
			);
			
		$xmloutput = $this->dbutil->xml_from_result($query, $config);
		echo $xmloutput;

	}
	}
	
	function eventdetails() {
		
		// $appcode = $this->input->get_post('appcode');
		// $livetoken = $this->input->get_post('livetoken');
		
		//Checks the existence of $appcode && $livetoken
		// if (!$this->validatesession($appcode,$livetoken))
		// {echo '$appcode/$livetoken does not exist';}
		
		//Check if Expired..if not yet expired..if not...
		// elseif($this->checksessionexpiration($appcode,$livetoken))
			// { echo '$Appcode/$liveToken expired';}
			// else{	
			
		
		
		
		
		$dbAccess = $this->load->database('default',true);
		
		$eventid = $this->input->get_post('eventid');

		
		$dbAccess->select("
				evt.event_id
				,evt.event_code
				, evt.event_long_title
				, evt.event_date_time
				, evt.event_description
				, evt.event_image
			");
			
		$dbAccess->where("evt.event_active", 1);
		$dbAccess->where("evt.event_id", $eventid);
		$query = $dbAccess->get('events evt');
	
	
		$this->load->dbutil();
		
		$config = array (
			  'root'    => 'root',
			  'element' => 'eventinfo', 
			  'newline' => "\n", 
			  'tab'    => "\t"
			);
			
		$xmloutput = $this->dbutil->xml_from_result($query, $config);
		echo $xmloutput;
				// }
				
			
	}
	
	function seat_layout_image() {
		
		$appcode = $this->input->get_post('appcode');
		$livetoken = $this->input->get_post('livetoken');
		
		// Checks the existence of $appcode && $livetoken
		if (!$this->validatesession($appcode,$livetoken))
		{echo '$appcode/$livetoken does not exist';}
		
		// Check if Expired..if not yet expired..if not...
		elseif($this->checksessionexpiration($appcode,$livetoken))
			{ echo '$Appcode/$liveToken expired';}
			else{	
			
		
		
		
		
		$dbAccess = $this->load->database('default',true);
		
		$seatplanid = $this->input->get_post('seatplanid');

		
		$dbAccess->select("
				seatplans.seatplan_image,
				seatplans.seatplan_name,
				venues.venue_name
			");
			
		$dbAccess->where("seatplans.seatplan_id", $seatplanid);
		$dbAccess->join('venues', 'venues.venue_id = seatplans.seatplan_venue_id');
		$query = $dbAccess->get('seatplans');

		$this->load->dbutil();
		
		$config = array (
			  'root'    => 'root',
			  'element' => 'eventinfo', 
			  'newline' => "\n", 
			  'tab'    => "\t"
			);
			
		$xmloutput = $this->dbutil->xml_from_result($query, $config);
		echo $xmloutput;
				}
				
			
	}
	

	/*======= OTHER FUNCTIONS ======= */
	
			//Checks the existence of partycode and its corresponding usecode..Returns true if exists
			function verifyparty($partycode=false,$usecode=false){
				$isvalid = false;
				
				$dbAccess = $this->load->database('default',true);
				$dbAccess->select("api_user_id");
				$dbAccess->where("partycode", $partycode);
				$dbAccess->where("usecode",  $usecode);
				$query = $dbAccess->get('api_party');

					if ($query->num_rows() > 0)
					{
					$isvalid = True;
					}
					
				return $isvalid;
			}
				
			//Checks the existence of $appcode && $livetoken ..Returns TRUE if exists
			function validatesession($appcode=false,$livetoken=false){
				$exists = false;
				
				$dbAccess = $this->load->database('default',true);
				$dbAccess->select("api_session_id");
				$dbAccess->where("api_apppcode", $appcode);
				$dbAccess->where("api_livetoken",  $livetoken);
				$query = $dbAccess->get('api_sessions');

					if ($query->num_rows() > 0)
					{
					$exists = True;
					}
					
				return $exists;
			}
			
			//Returns TRUE if the $appcode or $livetoken is already INACTIVE or EXPIRED
			function checksessionexpiration($appcode=false,$livetoken=false){
		
			$isExpired = false;

					//Get the latest appcode row
					$dbAccess = $this->load->database('default',true);
					$dbAccess->select('api_time_issued,api_duration,api_gen_active,api_livetoken');
					$dbAccess->where("api_apppcode", $appcode);
					$dbAccess->where("api_livetoken", $livetoken);
					$dbAccess->order_by('api_time_issued','desc');
					$dbAccess->limit(1);
					$query = $dbAccess->get('api_sessions');
					$row = $query->row_array();	
					
					if($row)
					{
					$livetoken = $row['api_livetoken'];
					$duration = $row['api_duration'];// in minutes; 
					$issuetime =  $row['api_time_issued'];//time when appcode was issued
					$active = $row['api_gen_active'];
					
					
							//Check if still active
							if($active == 1)
								{
								//Declare 
								$endtime = new DateTime($row['api_time_issued']);
								$endtime->modify("+" .$duration ." minutes");
								
								$endtime = $endtime->format('Y-m-d H:i:sP');

											
								
										//Compare $endtime to Current date
										if ($endtime < $this->getcurrentdatetime())
										{
											//expired
											$isExpired = True;
											
											//Deactivate
											$isdeactivated = false;
											$isdeactivated = $this->session_deactivate($appcode,$livetoken);
										
											if (!$isdeactivated){
											echo 'Unable to deactivate an appcode/livetoken';
											}
										}
										else
										{
										$isExpired = False;
										}
								}
								elseif($active == 0)
								{
									$isExpired = True;						
								}
						else
						{
						echo 'Unable to retrieve expiration data';
						}
	
					}			
					else
					{
					echo 'Appcode does not exist';
					}
		
	return 	$isExpired;												
	}
	
			//Deactivates an $appcode/$livetoken
			function session_deactivate($appcode=false,$livetoken=false){
				$success = false;
				$dbAccess = $this->load->database('default',true);
				
				//Validate existence of appcode and livetoken...
						$dbAccess->select("api_session_id");
						$dbAccess->where('api_apppcode',$appcode);
						$dbAccess->where('api_livetoken',$livetoken);
						$query = $dbAccess->get('api_sessions');
						
						$row = $query->row_array();
						

							if ($query->num_rows() > 0)
							{
							// update api_gen_active from 1 to 0
							$data = array('api_gen_active' => 0);
							$dbAccess->where('api_apppcode',$appcode);
							$dbAccess->update('api_sessions', $data); 	
							$success = true;
							}
				return $success;
			}

			//NOTE..$partycode,$usecode and $time are mixed together to  generate an $appcode
			function generateAppCode($partycode = false, $usecode=false, $time=false){
			$appcode = $this->encrypt->sha1($partycode.'MGI'.$usecode.'MGI'.$time );
			return $appcode;
			}
			
			//NOTE..$appcode and $time are mixed together to  generate a $livetoken
			function generatelivetoken($appcode=false){
			$livetoken = $this->encrypt->sha1($appcode.'MGI'.$this->getcurrentdatetime().'MGI');
			return $livetoken;
			}
			
			//Returns an array of party platform,browser, ipAdress and referrer
			function getpartycredentials(){
			$partycredentials = false;
			
			$partycredentials = array(
			'platform' =>  $this->agent->platform(),
			'browser' =>  $this->agent->browser().' '.$this->agent->version(),
			'ipaddress' =>  $this->input->ip_address(),
			'referrer:' => $this->agent->referrer()
			);
			return $partycredentials;
			}
			
			//Get $partycode from sessions by appcode/liveToken
			function getpartycodebyappcode($appcode){
			$partycode = false;

				$dbAccess = $this->load->database('default',true);
				$dbAccess->select("api_partycode");
				$dbAccess->where("api_apppcode", $appcode);
				$dbAccess->limit(1);
				$query = $dbAccess->get('api_sessions');

					if ($query->num_rows() > 0){
					$row = $query->row();	
					$partycode = $row->api_partycode;
					}
					else
					{
					echo 'Unable to retrieve partycode from the database'; 
					}

			return $partycode;

			}

			//Check  api_customer_email ,api_customer_email  column if a certain record already exist..
			function check_dbcolumn($value=false){
			$exist = false;
				$dbAccess = $this->load->database('default',true);
				$dbAccess->where("api_customer_mobile", $value);
				$dbAccess->or_where('api_customer_email', $value);
				$query = $dbAccess->get('api_party_customers');
					
										if ($query->num_rows() > 0)
											{
											$exist = true;
											}

			return $exist;
			}
			
			//Current Time
			function getcurrentdatetime(){
			//Set Current Date
			$date = new DateTime(null, new DateTimeZone('Asia/Manila'));
			return $date = $date->format('Y-m-d H:i:sP');
		}
			
			//Returns TRUE if date format = YYYY-MM-DD
			//sample..	2011-02-14
			function isValidDate($date){
				if(preg_match("/^(\d{4})-(\d{2})-(\d{2})$/", $date, $matches))
				{
					if(checkdate($matches[2], $matches[3], $matches[1]))
					{
						return true;
					}
				}
			}
			
			function prep_password($password){
				return sha1($this->config->item('encryption_key').$password);
			}

			//Checks the existence of $appcode ..Returns TRUE if exists
			function checkappcode($appcode){
			$exist = false;
			$dbAccess = $this->load->database('default',true);
				$dbAccess->select("api_apppcode");
				$dbAccess->where("api_apppcode", $appcode);
				$query = $dbAccess->get('api_sessions');
				
				if ($query->num_rows() > 0)
				{
				$exist = true;
				}
				return $exist;
			}
			
	}
	
	