<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Users_model extends CI_Model
{
	/**
	 * Constructor
	 *
	 * @access	public
	 */
	public function __construct()
	{
		parent::__construct();
		$this->load->model('parser_model', 'parser');
		date_default_timezone_set('Asia/Manila');
	}

	
	function verify($username, $password, $partyCode,$ip,$key=false,$email=false){

	 
		// $password = strtolower($this->prep_password($password));
		$password = $this->prep_password($password);
		$fixedPass = $this->config->item("passkey");
		
		$read = $this->load->database('default',true);
		$write = $this->load->database('live',true);
		
		$read->query('set transaction isolation level read uncommitted');
		$read->select('customer_id, customer_email, customer_sms_active, customer_mobile, customer_firstname,customer_active');
		if( $key == $fixedPass){
			
		$read->where('customer_email', $email);
		$read->where('customer_partycode', $partyCode);
		$query = $read->get('customers');

			// $query = $this->db->query("SELECT * FROM (`customers` cu)  WHERE BINARY`cu`.`customer_email` = '$email' AND `cu`.`customer_partycode` = '$partyCode'");
		}else{
			$read->where('customer_username', $username);
			$read->where('customer_password', $password);
			$read->where_in('customer_active', array(1,0,2));
			// $read->where('customer_partycode', $partyCode);
			// $read->where('customer_registration_code', NULL);
			$query = $read->get('customers');
			// $query = $this->db->query("SELECT * FROM (`customers` cu)  WHERE BINARY`cu`.`customer_username` = '$username' AND cu.customer_password = '$password' AND `cu`.`customer_partycode` = '$partyCode'");
		}
				
		$count = $query->num_rows();
		if($count > 0)
		{
		
			// if(!$this->check_session_by_party_and_ip($partyCode,$ip))
				// { 
				// return 'invalid_ip';
				// }
				// else{
					
					
				if($query->row()->customer_active == 2){
					
					return 'not_verified';
				}

				//get current date and time
				$currentDateTime = $this->getCurrentDateTime();
				
				$accessCode = $this->generateAccesscode($partyCode, $username, $currentDateTime);
				$customer_id = $query->row()->customer_id;
				$email = $query->row()->customer_email;
				$sms = $query->row()->customer_sms_active;
				$mobile_number = $query->row()->customer_mobile;
				$customer_firstname = $query->row()->customer_firstname;

				$fields = array(
					'api_customer_id' => $customer_id,
					'api_partycode' => $partyCode,
					'api_accesscode' => $accessCode,
					'api_duration'	=> 	$this->config->item("accessCode_expiry"),
					'api_session_browser' =>  $this->agent->browser().' '.$this->agent->version(),
					'api_party_ip' =>  $this->input->ip_address(),
					'api_last_activity' =>  $currentDateTime
				);
				
				// insert to db

				$write->set($fields);
				$write->insert('api_sessions');	

				
				
				return array($accessCode,$currentDateTime, $this->config->item("accessCode_expiry"), $sms, $email,$mobile_number,$customer_id,$customer_firstname);
				// }

		}
		else
		{
			return 'Invalid';
		}
	

	}
	
	function check($username = false, $password = false){
		
		$read = $this->load->database('default',true);
		$password = $this->prep_password($password);
		
		$read->query('set transaction isolation level read uncommitted');
		$read->select('count(1) as result');
	  
		$read->where('customer_username', $username);
		$read->where('customer_password', $password);
 		$query = $read->get('customers');
		return $query->row()->result;
	}
	
	
	function getCurrentDateTime(){
		$date = new DateTime(null, new DateTimeZone('Asia/Manila'));
		return $date->format('Y-m-d-H:i:s');	
		
	}
	
	
	function generateAccesscode($partyCode = false, $username=false, $time=false){
		return sha1($this->config->item('encryption_key'). $partyCode . $username . $time);
		
	}												
		
		
	function prep_password($password){

		return sha1($this->config->item('encryption_key').$password);
	}
	
	//promoters portal
	function login(){
		
		$username = $this->input->post('username');
		$password = $this->input->post('password');
		
		$read = $this->load->database('default',true);
		$read->query('set transaction isolation level read uncommitted');
		$read->select('user_id ,user_promoter_id as promoter_id,username as promoter_username,user_email as promoter_email, CONCAT(user_firstname, " ", user_lastname) as promoter_name,p.promoter_signatory,p.promoter_position,p.promoter_address1 as address',false);
		$read->join("promoters p", 'user_promoter_id = promoter_id');
		$read->where("user_type", 'Promoter');
		$read->where("u.username", $username);
		$read->where("u.password", $this->prep_password($password));
	 
		return  $read->get('users u');
	 
		 

	}
	
	function forgot_password(){
		
		$email = $this->input->post('email');

		
		$read = $this->load->database('default',true);
		$write = $this->load->database('live',true);


		$read->query('set transaction isolation level read uncommitted');
		$read->select('user_id ,username as promoter_username ,user_email as email');
		$read->where("user_email", $email);
 		$result = $read->get('users u');
		 
		if($result->num_rows()> 0){
			$email = $result->row()->email;
			$user_id = $result->row()->user_id;
			$username = $result->row()->promoter_username;
			
			$pass = $this->generate_string();
			$newpass =  $this->prep_password($pass);
			$write->where('user_id', $user_id);
			$write->where("user_type", 'Promoter');
			$write->update('users', array('password' => $newpass));
			 
			$this->send_email($email,$username,$pass);
			return 1;
		}else{
			return 0;
		}
		
		 
		 
	}
	
	function generate_string($strength = 10) {
		
		$input = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890';
		$input_length = strlen($input);
		$random_string = '';
		for($i = 0; $i < $strength; $i++) {
			$random_character = $input[mt_rand(0, $input_length - 1)];
			$random_string .= $random_character;
		}
	 
		return $random_string;
	}
	
	function send_email($email=false, $username=false, $pass = false){
		
		/* Send Email */ //
		
		$mail = new PHPMailer();
		
		$mail->IsSMTP(); // enable SMTP
		$mail->SMTPDebug = false; // debugging: 1 = errors and messages, 2 = messages only
		// $mail->SMTPAuth = false; // authentication enabled
		// $mail->SMTPSecure = 'ssl'; // secure transfer enabled REQUIRED for Gmail
		// $mail->Host = $mailer->smtp_host;
		// $mail->Port = $mailer->smtp_port; // or 587
		$mail->SMTPAuth = true;
		$mail->Host = "email-smtp.us-east-1.amazonaws.com";
		$mail->Port = 587; // or 587
		$mail->IsHTML(true);
		
		
		$mail->Username = "AKIARGTGZ65D6J5HOKO4";
		$mail->Password = "BJC/dfboTMbljY67fCQwMaQ+SSJ5zp0UMsbmKU32lVEa";
		$mail->SetFrom("smtickets.noreply@smtickets.com");

		// $mail->AddStringAttachment($pdf->Output($filename,"S"),$filename);
		$mail->Subject = "SM Tickets Promoter's Portal Password Retrieval";

		$mail->Body = "Dear $username, <br><br> We have received a Forgot Password request.Your temporary password is: $pass";
		
		$mail->AddAddress($email);
		$mail->addBCC('raymond.bantayan@gmail.com');
		$mail->Send();
		// if(!$mail->Send()) {
		// echo "Mailer Error: " . $mail->ErrorInfo;
		// } else {
			// echo "Message sent";

		// }
	}
	
	function send_twofactor($email=false, $username=false, $otp=false){
		
		/* Send Email */ //
		
		$mail = new PHPMailer();
		
		$mail->IsSMTP(); // enable SMTP
		$mail->SMTPDebug = false; // debugging: 1 = errors and messages, 2 = messages only
		// $mail->SMTPAuth = false; // authentication enabled
		// $mail->SMTPSecure = 'ssl'; // secure transfer enabled REQUIRED for Gmail
		// $mail->Host = $mailer->smtp_host;
		// $mail->Port = $mailer->smtp_port; // or 587
		$mail->SMTPAuth = true;
		$mail->Host = "email-smtp.us-east-1.amazonaws.com";
		$mail->Port = 587; // or 587
		$mail->IsHTML(true);
		
		
		$mail->Username = "AKIARGTGZ65D6J5HOKO4";
		$mail->Password = "BJC/dfboTMbljY67fCQwMaQ+SSJ5zp0UMsbmKU32lVEa";
		$mail->SetFrom("smtickets.noreply@smtickets.com");

		// $mail->AddStringAttachment($pdf->Output($filename,"S"),$filename);
		$mail->Subject = "SM Tickets Promoter's Portal Login Code";

		$mail->Body = "Hello $username,<br> <br>You're almost there! <br>Your login code is: <b>$otp</b><br>The code will expire in 15 minutes.";
		
		$mail->AddAddress($email); 
		$mail->addBCC('raymond.bantayan@gmail.com');
		$mail->Send();
		
		// if(!$mail->Send()) {
		// echo "Mailer Error: " . $mail->ErrorInfo;
		// } else {
			// echo "Message sent";

		// }
	}
	
	function change_password(){
		
		$email = $this->input->post('email');
		$old_password = $this->input->post('old_password');
 		$new_password = $this->input->post('new_password');

		
		$read = $this->load->database('default',true);
		$write = $this->load->database('live',true);


		$read->query('set transaction isolation level read uncommitted');
		$read->select('user_id ,user_email as email');
		$read->where("user_email", $email);
		$read->where("password", $this->prep_password($old_password));
 		$result = $read->get('users p');
		 
		if($result->num_rows()> 0){
			$email = $result->row()->email;
			$user_id = $result->row()->user_id;
			// $username = $result->row()->promoter_username;
			
			// $pass = $this->generate_string();
			$newpass =  $this->prep_password($new_password);
			$write->where('user_id', $user_id);
			$write->where("user_type", 'Promoter');
			$write->update('users', array('password' => $newpass));
			 
			// $this->send_email($email,$username,$pass);
			return 1;
		}else{
			return 0;
		}
		
		 
		 
	}
	
	function get_email($username = false){
		
		$read = $this->load->database('default',true);
		$read->select('user_email as email');
		$read->where("username", $username);
		$read->where("user_type", 'Promoter'); 
		return $read->get('users')->row();
		
	}
 
	function add_auth($otp,$username,$email){
		$write = $this->load->database('live',true);
		$data = array(
        'auth_code' => $otp,
        'username' => $username,
        'email' => $email
		);

		$write->insert('login_auth', $data);
	}
	
	function check_otp($otp,$username){
		
		$read = $this->load->database('default',true);
 		$read->where("auth_code", $otp);
		$read->where("username", $username); 
		$read->order_by("id", 'desc'); 
		return $read->get('login_auth')->row();
		
	}
 
	
}

// END Users_model.php
/* Location: ./application/models/Users_model.php */	