<?php
class transactions_model extends CI_Model {

var $transactions = 'transactions tr';
var $sections = 'sections s';
var $tickets = 'tickets ti';
var $events = 'events e';
var $ticket_types = 'ticket_types tt';
var $prices = 'prices p';

	public function __construct()
	{
		parent::__construct();
	
		$this->load->database('default',true);
	}	
 
	function get($transaction_id)
	{
		 
		$this->db->query('set transaction isolation level read uncommitted');
		$sql = "SELECT *
				FROM (`transactions` t)
				JOIN `terminals` te ON `t`.`transaction_terminal_id` = `te`.`terminal_id`
				JOIN `branches` b ON `t`.`transaction_branch_id` = `b`.`branch_id`
				JOIN `users` u ON `t`.`transaction_user_id` = `u`.`user_id`
				LEFT JOIN `card_numbers` cn ON `t`.`transaction_id` = `cn`.`card_number_transaction_id`
				LEFT JOIN `customers` c ON `t`.`transaction_customer_id` = `c`.`customer_id` 
				
				WHERE `transaction_id` = '$transaction_id'";
		
		$query = $this->db->query($sql);
	
		return $query->row();		
	}
	

	function get_customer_transactions($customer_id, $offset = false, $limit = 20)
	{
		$status = ['done','paid_online'];
		$this->db->select('t.transaction_id, t.transaction_receipt_number,t.transaction_date, e.event_id,event_date_time,event_active, e.event_title, b.branch_name, t.transaction_status, c.card_number_card_type, c.card_number_value,event_online_concert,online_code, event_eticket'); //add select 05142019
		$this->db->group_by('t.transaction_id');
		// $this->db->where_in('lower(transaction_status)', array('done', 'paid_online'));
		$this->db->where('transaction_customer_id', $customer_id);
		$this->db->join('branches b', 'b.branch_id = t.transaction_branch_id', 'left');
		$this->db->join('tickets ti', 'ti.ticket_transaction_id = t.transaction_id', 'left');
		$this->db->join('events e', 'e.event_id = ti.ticket_event_id', 'left');
		$this->db->join('events_config ec', 'e.event_id = ec.events_config_eventid', 'left');
		$this->db->join('card_numbers c', 'c.card_number_transaction_id = t.transaction_id', 'left');
		$this->db->join('online_codes', 'online_code_ticket_id = ticket_id', 'left');
		$this->db->order_by('transaction_id', 'desc');
		if ($limit) $this->db->limit($limit);
		if ($offset) $this->db->offset($offset);
		$this->db->where_in('transaction_status',$status);
		$query = $this->db->get('transactions t');
		
		return $query->result();
	}

	
	function get_selected_seats_by_session($session_id = false, $event_id = false){
	
	$this->db->query('set transaction isolation level read uncommitted');
	$this->db->select('count(1) as tix_count, ticket_price_id as price_id');
	$this->db->where('t.ticket_session_id',$session_id);
	$this->db->where('t.ticket_event_id',$event_id);
	$this->db->where('t.ticket_status', "selected");
	$this->db->where('t.ticket_transaction_id' , "0"); 
	$result = $this->db->get('tickets t')->row();
	
	return array($result->tix_count, $result->price_id);
	}
 
	function add_barcode($transaction_id, $barcode)
	{
		$read = $this->load->database('default',true);
		$write = $this->load->database('live',true);
		
		// update the tickets table
		$write->where('transaction_id', $transaction_id);
		$write->update('transactions', array('transaction_barcode' => $barcode));
		
		return true;
	}
  
		
	function select_seat($event_id, $section_id, $price_id, $ticket_type , $accessCode, $section_type, $qty){

		$read = $this->load->database('default',true);
		$write = $this->load->database('live',true);
		
		for ($x = 1; $x <= $qty; $x++) {
 		
			$fields = array(
				'ticket_date_entered'		=> date('Y-m-d H:i:s'),
				'ticket_session_id'			=> $accessCode,
				'ticket_event_id'			=> $event_id,
				'ticket_section_id'			=> $section_id,
				'ticket_type_id'			=> $ticket_type,
				'ticket_price_id'			=> $price_id,
				'ticket_system_row'			=> 0,
				'ticket_system_col'			=> 0,
				'ticket_row'				=> '0',
				'ticket_seat'				=> $section_type,
				'ticket_status'				=> 'selected',
			);
			
			// insert to db
			$write->set($fields);
			$write->insert('tickets');
			// $ticket_id = $write->insert_id();
			 
			// update available tickets
			$this->update_available($section_id, 'decrease', 1);
			 
		} 
			
	}
	
		
	function add_seat($event_id, $section_id, $price_id, $ticket_type , $accessCode, $system_row,$system_col,$ticket_row,$ticket_seat){

 
		
		$read = $this->load->database('default',true);
		$write = $this->load->database('live',true);
		
  		
			$fields = array(
				'ticket_date_entered'		=> date('Y-m-d H:i:s'),
				'ticket_session_id'			=> $accessCode,
				'ticket_event_id'			=> $event_id,
				'ticket_section_id'			=> $section_id,
				'ticket_type_id'			=> $ticket_type,
				'ticket_price_id'			=> $price_id,
				'ticket_system_row'			=> $system_row,
				'ticket_system_col'			=> $system_col,
				'ticket_row'				=> $ticket_row,
				'ticket_seat'				=> $ticket_seat,
				'ticket_status'				=> 'selected',
			);
			
			// insert to db
			$write->set($fields);
			$write->insert('tickets');
			// $ticket_id = $write->insert_id();
			 
			// update available tickets
			$this->update_available($section_id, 'decrease', 1);
			 
		  
			
	}
	 
	 
	function get_selected_seats_per_event($session_id = false, $event_id = false){
	
	$this->db->query('set transaction isolation level read uncommitted');
	$this->db->select('event_internet_sales_charge,ticket_event_id,section_id, price_id,ticket_id, t.ticket_type_id, section_name,section_type, section_capacity, price_name, ticket_system_row, ticket_system_col, ticket_row, ticket_seat, price_price,ticket_type_discount_type,ticket_type_discount');
	$this->db->where('t.ticket_session_id',$session_id);
	$this->db->where('t.ticket_event_id',$event_id);
	$this->db->where('t.ticket_status', "selected");
	$this->db->where('t.ticket_transaction_id' , "0"); 
	$this->db->join('sections s', 's.section_id = t.ticket_section_id', 'left');
	$this->db->join('prices p', 'p.price_id = t.ticket_price_id', 'left');
	$this->db->join('events e', 'e.event_id = t.ticket_event_id', 'left');
	$this->db->join('ticket_types tt', 'tt.ticket_type_id = t.ticket_type_id', 'left');
 
	$selected_seats = $this->db->get('tickets t')->result();
			 
	return $selected_seats;
	}
	
	
	function get_ticket_types($ticket_type_id){
		
		if( !empty($ticket_type_id)){
			$this->db->query('set transaction isolation level read uncommitted');
			$this->db->where_in('ticket_type_id', $ticket_type_id);
			$ticket_types = $this->db->get('ticket_types')->result();
		
			return $ticket_types;
		}
			
		
	}
	
		
	function unselect_ticket($ticketid,$section_id){
		
		$read = $this->load->database('default',true);
		$write = $this->load->database('live',true);

		// update db
		$write->where('ticket_id', $ticketid);
		$write->where('ticket_section_id', $section_id);
		$write->where('ticket_transaction_id', 0);
		$write->where('ticket_status', 'selected');
		$write->update($this->tickets, array('ticket_status' => 'unselected'));
		$ticket_count = $write->affected_rows();

		// update available tickets
		if ($ticket_count > 0) {
			$this->update_available($section_id, 'increase', $ticket_count);
			echo '<root><result>Success</result></root>';
		}else{
			echo '<root><result>No seat unselected</result></root>';
		}
			
	}
 		
	function unselect_ticket_all($session_id,$section_id,$event_id){
		
		$read = $this->load->database('default',true);
		$write = $this->load->database('live',true);

		// update db
		$write->where('ticket_session_id', $session_id);
		$write->where('ticket_event_id', $event_id);
		$write->where('ticket_section_id', $section_id);
		$write->where('ticket_transaction_id', 0);
		$write->where('ticket_status', 'selected');
		$write->update($this->tickets, array('ticket_status' => 'unselected'));
		$ticket_count = $write->affected_rows();

		// update available tickets
		if ($ticket_count > 0) {
			$this->update_available($section_id, 'increase', $ticket_count);
			echo '<root><result>Success</result></root>';
		}else{
			echo '<root><result>No seat unselected</result></root>';
		}
			
	}
 

	function update_available($section_id, $type, $count)
	{
		$read = $this->load->database('default',true);
		$write = $this->load->database('live',true);
		// get last available tickets
		$write->select('section_available');
		$write->where('section_id', $section_id);
		$query = $write->get($this->sections);
		$row = $query->row();
		
		$new_available = ($type == 'increase') ? $row->section_available += $count : $row->section_available -= $count;
		
		// update last available tickets
		$write->where('section_id', $section_id);
		$write->update($this->sections, array('section_available' => $new_available));
		
		return true;
	}
		
	 	
	function get_taken_seats_per_section($sections){
	
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->select('ticket_section_id, count(1) as seats_taken');
 		$this->db->where_in('t.ticket_section_id',$sections);
		$this->db->where_in('t.ticket_status', array('done','paid','paid_online','selected','reserved')); 
		$this->db->group_by('t.ticket_section_id'); 
		$taken_seats = $this->db->get('tickets t')->result();
				 
		return $taken_seats;
	}
	
	function get_capacity_per_section($section){
	
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->select('section_capacity');
 		$this->db->where('section_id',$section);
		$capacity = $this->db->get('sections s')->row();
				 
		return $capacity;
	}
	
	
	function buy_ticket($ticketDetails, $session_id){
		// print_r($ticketDetails);
		$customer_id = $this->get_customer_id($session_id);
		$read = $this->load->database('default',true);
		$write = $this->load->database('live',true);
		
	
		
		//prepare trans details
		$trans_details = array(
			'transaction_date'				=> date("Y-m-d H:i:s"),
			'transaction_user_id'			=> 1,
			'transaction_receipt_number'	=> 1,
			'transaction_customer_id'		=> $customer_id,
			'transaction_branch_id'			=> 90,
			'transaction_terminal_id'		=> 1,
			'transaction_status'			=> 'selected',
		);	
		
		//insert to transactions table
		$write->set($trans_details);
		$write->insert('transactions');
		
		$transaction_id = $write->insert_id();
		
		foreach($ticketDetails as $x){
		
			 	 
 
			//prepare ticket details	
			 $tix_details = array(
				'ticket_transaction_id'		=> $transaction_id,
				'ticket_date_entered'		=> date('Y-m-d H:i:s'),
				'ticket_session_id'			=> '', 
 				'ticket_user_id'			=> 1,
				'ticket_branch_id'			=> 90,
				'ticket_terminal_id'		=> 1	
			);
 
	  
			//update tickets table
			$write->set($tix_details); 
			$write->where('ticket_id',$x->ticket_id);
			
			$write->update('tickets');
		 
		
		 
			
		}
			
		return array('success', $transaction_id, date('Y-m-d H:i:s'), $this->config->item("token_expiry"));
		
	}
	
	
	function is_seat_available($section_id, $row, $col)
	{
	 
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->select('ticket_id');
		$this->db->where('ticket_section_id', $section_id);
		$this->db->where('ticket_system_row', $row);
		$this->db->where('ticket_system_col', $col);
		$this->db->where_in('ticket_status', array('done', 'paid', 'paid_online', 'reserved', 'selected'));
		$this->db->limit(2); 
		$query = $this->db->get($this->tickets);
		 
		
		return  $query->num_rows();
	}
	
	
	function get_customer_id($accessCode){
	
		$read = $this->load->database('default',true);
		$write = $this->load->database('live',true);
		
		$read->select('api_customer_id');
		$read->where('api_accesscode', $accessCode);
		$query =  $read->get('api_sessions');
		if($query->num_rows > 0){
			return $query->row()->api_customer_id;
		}else{
			return false;
		}
	}
	
	
	function get_ticket_status($transaction_id){
		$write = $this->load->database('live',true);
		$read = $this->load->database('default',true);
		// $read->query('set transaction isolation level read uncommitted');
		$write->select('transaction_status');
		$write->where('transaction_id', $transaction_id);
		$query = $write->get('transactions');
		$data = $query->row();
		
		return $data->transaction_status;
		
	}
	
	function get_reserved_tickets($transaction_id,$status= false)
	{
		if(!$status){	
			$status = array('reserved');
		}
		
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->select('ti.*, tr.*, p.*, tt.ticket_type_discount_type, tt.ticket_type_discount, tt.ticket_type_name, tt.ticket_type_code, s.section_id, s.section_name, s.section_type, s.section_code,e.event_internet_sales_charge');
		$this->db->where('ti.ticket_transaction_id', $transaction_id);		
		$this->db->where_in('ti.ticket_status', $status );
		$this->db->join($this->sections, 's.section_id = ti.ticket_section_id', 'left');
		$this->db->join($this->events, 'e.event_id = ti.ticket_event_id', 'left');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id', 'left');
		$this->db->join($this->prices, 'p.price_id = ti.ticket_price_id', 'left');
		$this->db->join($this->transactions, 'tr.transaction_id = ti.ticket_transaction_id', 'left');
		$this->db->order_by('ti.ticket_row', 'asc');
		// $this->db->order_by('ti.ticket_seat + 0', 'asc');
		$query = $this->db->get($this->tickets);
		//echo $this->db->last_query();
		
		return $query->result();
	}
	
		
	function get_selected_tickets($transaction_id,$status= false)
	{
		if(!$status){	
			$status = array('selected');
		}
		$write = $this->load->database('live',true);
		// $write->query('set transaction isolation level read uncommitted');
		$write->select('ti.*, tr.*, p.*, tt.ticket_type_discount_type, tt.ticket_type_discount, tt.ticket_type_name, tt.ticket_type_code, s.section_id, s.section_name, s.section_type, s.section_code,e.event_internet_sales_charge');
		$write->where('ti.ticket_transaction_id', $transaction_id);		
		$write->where_in('ti.ticket_status', $status );
		$write->join($this->sections, 's.section_id = ti.ticket_section_id', 'left');
		$write->join($this->events, 'e.event_id = ti.ticket_event_id', 'left');
		$write->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id', 'left');
		$write->join($this->prices, 'p.price_id = ti.ticket_price_id', 'left');
		$write->join($this->transactions, 'tr.transaction_id = ti.ticket_transaction_id', 'left');
		$write->order_by('ti.ticket_row', 'asc');
		$write->order_by('ti.ticket_seat + 0', 'asc');
		$query = $write->get($this->tickets);
		//echo $this->db->last_query();
		
		return $query->result();
	}
	
	function paid_online2($transaction_id, $status = false )
	{
	    
		if(!$status){
			$status = array('selected');
		}
		$read = $this->load->database('default',true);
		$write = $this->load->database('live',true);
		
		// update the transactions table
		$write->where('transaction_id', $transaction_id);
		$write->update('transactions', array('transaction_status' => 'paid_online'));

		// update the status of the tickets
		//$write->where_in('ticket_status',  $status );
		$write->where('ticket_transaction_id', $transaction_id);
		$write->update('tickets', array('ticket_status' => 'paid_online'));
		
		return true;
	}
	
 
	
	function get_for_bcode($transaction_id)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->join('terminals te', 't.transaction_terminal_id = te.terminal_id');
		$this->db->join('branches b', 't.transaction_branch_id = b.branch_id');
		$this->db->join('users u', 't.transaction_user_id = u.user_id');
		$this->db->join('customers c', 't.transaction_customer_id = c.customer_id');
		$this->db->where('transaction_id', $transaction_id);
		$query = $this->db->get('transactions t');
	
		return $query->row();		
	}
	
	function update_receipt_number($transaction_id, $receipt_number)
	{
		$read = $this->load->database('default',true); 
		$write = $this->load->database('live',true); // update the transactions table
		$write->where('transaction_id', $transaction_id);
		$write->update('transactions', array('transaction_receipt_number' => $receipt_number));
		
		return true;
	}
	
	
	function get_or($transaction_id){
	
		$this->db->select('transaction_receipt_number');
		$this->db->where('transaction_id', $transaction_id);
		$query = $this->db->get('transactions');
		return $query->row()->transaction_receipt_number;
	
	}
	
	 
	function validate_qr($qr_code = false , $event_id =false){
		 
		$status = array('done','paid','paid_online','reserved','selected');
		$dbAccess = $this->load->database('live',true);
		$this->db->select('qr_type,t.transaction_id, t.transaction_status');
		$dbAccess->where('qr_event_id',$event_id);
		$dbAccess->where('qr_qrcode',$qr_code);
		$dbAccess->join('transactions t', 't.transaction_id = qr.qr_transaction_id', 'left' );

		$query = $dbAccess->get('qrcode qr');
		 
		
			$valid = false;
			if($query->num_rows() > 0){ 
				$result = $query->row();
			
				if($result->qr_type == 1){
					if($result->transaction_id){
					
						// die('test');
						if(in_array($result->transaction_status, $status)){
							$valid = true;
						}
					
					}
				}
				 
			}else{
				
				$valid = true;
			}
		return $valid;
	}

	
	function tag_qr($qr_code , $transaction_id, $event_id){
		
		$read = $this->load->database('default',true);
		$write = $this->load->database('live',true);
		
		// update the tickets table
		// $write->where('qr_transaction_id', 0);
		$write->where('qr_qrcode', $qr_code);
		if(!in_array( $event_id, [11706,11712])){ //enhypen
			$write->where('qr_event_id', $event_id);

		}
		$write->where('qr_type', 1);
		$write->update('qrcode', array('qr_transaction_id' => $transaction_id));
		
		
		
	}
	
	 
	function get_reserved_seats($transaction_id = false){
	
	$this->db->query('set transaction isolation level read uncommitted');
	$this->db->select('event_internet_sales_charge,ticket_event_id,section_id, price_id,ticket_id, t.ticket_type_id, section_name,section_type, section_capacity, price_name, ticket_system_row, ticket_system_col, ticket_row, ticket_seat, price_price');
	$this->db->where('t.ticket_transaction_id',$transaction_id);
	$this->db->where('t.ticket_status', "reserved");
	$this->db->join('sections s', 's.section_id = t.ticket_section_id', 'left');
	$this->db->join('prices p', 'p.price_id = t.ticket_price_id', 'left');
	$this->db->join('events e', 'e.event_id = t.ticket_event_id', 'left');
 
	$selected_seats = $this->db->get('tickets t')->result();
			 
	return $selected_seats;
	}
	
	
	//for reserved tickets
	function get_reserved_seats_per_event($session_id = false, $event_id = false){
	
	$this->db->query('set transaction isolation level read uncommitted');
	$this->db->select('ticket_transaction_id ,ticket_event_id,section_id, price_id,ticket_id, t.ticket_type_id, section_name,section_type, section_capacity, price_name, ticket_system_row, ticket_system_col, ticket_row, ticket_seat, price_price');
	$this->db->where('t.ticket_session_id',$session_id);
	$this->db->where('t.ticket_event_id',$event_id);
	$this->db->where('t.ticket_status', "reserved");
	// $this->db->where('t.ticket_transaction_id' , "0"); 
	$this->db->join('sections s', 's.section_id = t.ticket_section_id', 'left');
	$this->db->join('prices p', 'p.price_id = t.ticket_price_id', 'left');
 
	$selected_seats = $this->db->get('tickets t')->result();
			 
	return $selected_seats;
	}
	
	
	function buy_ticket_v2($ticketDetails, $session_id, $transaction_id){
		
		if(!$transaction_id) die();
		
		// print_r($ticketDetails);
		$customer_id = $this->get_customer_id($session_id);
		$read = $this->load->database('default',true);
		$write = $this->load->database('live',true);
		
	
		
		//prepare trans details
		$trans_details = array(
			'transaction_date'				=> date("Y-m-d H:i:s"),
			'transaction_user_id'			=> 1,
			'transaction_receipt_number'	=> 1,
			'transaction_customer_id'		=> $customer_id,
			'transaction_branch_id'			=> 90,
			'transaction_terminal_id'		=> 1,
			// 'transaction_status'			=> 'selected',
		);	
		
		//insert to transactions table
		$write->set($trans_details);
		$write->where("transaction_id",$transaction_id);
		$write->update('transactions');
		$success =  $write->affected_rows(); 

		// $transaction_id = $write->insert_id();
		
		foreach($ticketDetails as $x){
		
			 	 
 
			//prepare ticket details	
			 $tix_details = array(
				// 'ticket_transaction_id'		=> $transaction_id,
				// 'ticket_date_entered'		=> date('Y-m-d H:i:s'),
				// 'ticket_session_id'			=> '', 
 				'ticket_user_id'			=> 1,
				'ticket_branch_id'			=> 90,
				'ticket_terminal_id'		=> 1	
			);
 
	  
			//update tickets table
			$write->set($tix_details); 
			$write->where('ticket_id',$x->ticket_id);
			$write->where('ticket_status','reserved');

			$write->update('tickets');
		 
		
		}
			
		return array($success, $transaction_id, date('Y-m-d H:i:s'), $this->config->item("token_expiry"));
		
	}
	
	
	
	//for seagames
	function tag_customer_transaction($transaction_id = false)
	{
		$write = $this->load->database('live',true);
		if(!$transaction_id) die();
		
		$firstname = $this->input->get_post("firstname");
		$lastname = $this->input->get_post("lastname");
		$mobile = $this->input->get_post("mobile");
		$email = $this->input->get_post("email");
		
		$fields = array(
			'customer_transaction_id'	=> $transaction_id,
			'customer_firstname'		=> $firstname,
			'customer_lastname'			=> $lastname,
			'customer_mobile'			=> $mobile,
			'customer_email'			=> $email,
			 
		);
			
		// insert to db
		$write->set($fields);
		if($firstname)
		$write->insert('customers_seagames');
		
		
		
	}

	function get_reservations($reservation_code){
		
		
		// CORRECT FORMAT sha1( branch_id-transaction_id-transaction_month_date)
		
		$this->db->group_by('t.transaction_id');
		$this->db->where_in('lower(transaction_status)', array('done', 'paid_online','reserved'));
		$this->db->where('transaction_code', sha1($reservation_code));
		$this->db->where('transaction_status', 'reserved' );
		// $this->db->where_in('ti.ticket_event_id', array(6180,6018,6846,7127,6769,7366,7657));
		$this->db->join('branches b', 'b.branch_id = t.transaction_branch_id', 'left');
		$this->db->join('tickets ti', 'ti.ticket_transaction_id = t.transaction_id', 'left');
		$this->db->join('events e', 'e.event_id = ti.ticket_event_id', 'left');
		$this->db->join('card_numbers cn', 'cn.card_number_transaction_id = t.transaction_id', 'left');
		$this->db->order_by('transaction_id', 'desc');
		
		$query = $this->db->get('transactions t');
		
		return $query->result();
	}

	function update_ticket_type(){
		$read = $this->load->database('default',true);
		$write = $this->load->database('live',true);
		
		$session_id = $this->input->post("session_id");
		$event_id = $this->input->post("event_id");
		$ticket_type = $this->input->post("ticket_type");
		
		// update the tickets table
		$write->where('ticket_session_id', $session_id);
		$write->where('ticket_event_id', $event_id);
		$write->where('ticket_status', 'selected');
		$write->update('tickets', array('ticket_type_id' => $ticket_type));
		
		
	}
	
	// for etickets
	function transaction_done($transaction_id = false)
	{
	    $read = $this->load->database('default',true); 
		$write = $this->load->database('live',true); // update the transactions table
		
		if($transaction_id != ''){
			// update the transactions table
			$write->where('transaction_id', $transaction_id);
			$write->where('transaction_status','paid_online');
			$write->update($this->transactions, array('transaction_status' =>'done'));
			
			// update the tickets table		
			$changes = array(
				'ticket_user_id '		=> 1,
				'ticket_branch_id '		=> 1,
				'ticket_terminal_id '	=> 1,
				'ticket_status'			=> 'done',
				'ticket_date_printed'	=> date('Y-m-d H:i:s'),
			);
			
			// update the status of the tickets
			$write->where('ticket_status','paid_online');
			$write->where('ticket_transaction_id', $transaction_id);
			$write->update($this->tickets, $changes);
			
			return true;
		}
	}
	
	//for promoters portal
	function reservation_cancel($transaction_id = false)
	{
		
		if($transaction_id != ''){ 
			// update the status of the tickets
			$changes = array(  
				'ticket_status '	=> 'reservation_cancelled',
				'ticket_date_cancelled'	=> date('Y-m-d H:i:s'),
			);
			$this->db->where('ticket_transaction_id', $transaction_id);
			$this->db->where('ticket_status', 'reserved');
			$this->db->update($this->tickets, $changes);
			
			//update transaction
			$this->db->where('transaction_id', $transaction_id);
			$this->db->where('transaction_status', 'reserved');
			$this->db->update($this->transactions, array('transaction_status' => 'reservation_cancelled'));
			
			
 			 // echo $this->db->last_query();
			 // die();
		}
		return $this->db->affected_rows();
	}
	
	function customer_quick_add()
	{
		$i =& $this->input;
		
		// check first if customer is existing
		$customer = $this->get_by_mobile($this->input->post('mobile'));
	
		// if existing customer, just update firstname and lastname
		if (!empty($customer))
		{			
			if ($i->post('firstname')) $fields['customer_firstname'] = $i->post('firstname');
			if ($i->post('lastname')) $fields['customer_lastname'] = $i->post('lastname'); 
			if ($i->post('email')) $fields['customer_email'] = $i->post('email');
			if ($i->post('notes')) $fields['customer_notes'] = $i->post('notes');
			
			// update db
			$fields['customer_mobile'] = $i->post('mobile');
			$this->db->where('customer_mobile', $i->post('mobile'));
			$this->db->update('customers', $fields);
			// echo $this->db->last_query();
			// die();
			return $customer->customer_id;
		}
		
		// if new customer, insert to db
		else
		{
			$fields = array(
				'customer_mobile'			=> $i->post('mobile'),
				'customer_username'			=> '', 
				'customer_password'			=> '', 
				'customer_firstname'		=> $i->post('firstname'),
				'customer_lastname'			=> $i->post('lastname'), 
				'customer_email'			=> $i->post('email'), 
				'customer_notes'			=> $i->post('notes'),				
			);
			
			// insert to db
			$this->db->set($fields);
			$this->db->insert('customers');
			
			
			return $this->db->insert_id();
		}
	}
	
	function reservation_expiry($event_id)
	{
		$this->db->select('event_reservation_expire');
		$this->db->where('event_id', $event_id);
		$query = $this->db->get($this->events);
		
		return $query->row()->event_reservation_expire;
		
	}	
	
	function customer_info($customer_id)
	{
		
		$user_id = $_POST['user_id']; 
		$branch_id = 1; 
		$terminal_id = 1; 
		
		// add to transactions table
		$fields = array(
			'transaction_date'					=> date("Y-m-d H:i:s"),
 			'transaction_receipt_number '		=> 0,
 			'transaction_user_id '				=> $user_id,
			'transaction_customer_id '			=> $customer_id,
			'transaction_branch_id '			=> $branch_id,
			'transaction_terminal_id '			=> $terminal_id,
			'transaction_comment '				=> $this->input->post('notes'),		
			'transaction_status'				=> 'reserved',
			'transaction_pin'					=> $this->randomKey(4),				
		);			
	
		// insert to db
		$this->db->set($fields);
		$this->db->insert('transactions');
		
		// echo $this->db->last_query();
		// die();
		// get transaction id
		$transaction_id = $this->db->insert_id();
		
		// update selected seats in tickets table, include the transaction id
		$this->db->where('ticket_session_id', $this->input->post('session_id'));
		$this->db->where('ticket_status', 'selected');
		$this->db->update($this->tickets, array('ticket_transaction_id' => $transaction_id));		

		$transaction_code =	sha1( $branch_id . "-" . $transaction_id . "-"  . date("md"));
		$this->db->where('transaction_id',	$transaction_id );
		$this->db->update($this->transactions, array('transaction_code' => $transaction_code));	
		
		
		$reservation_expire = $this->reservation_expiry($this->input->post('event_id'));
		$extend_date = date("Y-m-d", strtotime("+$reservation_expire days"));
		
		$fields = array(
			'ticket_reservation_expiry'	=> $extend_date,
			'ticket_status'				=> 'reserved',
			'ticket_user_id'			=> $user_id,
			'ticket_branch_id'			=> $branch_id,
			'ticket_terminal_id'		=> $terminal_id
		);
			
					
		//update selected seats in tickets table with ticket_reservation_expiry and reserved status
		$this->db->where('ticket_transaction_id',$transaction_id);
		$this->db->where('ticket_status', 'selected');
		$this->db->update($this->tickets,$fields);
		
		
		$fields = array(
			'action_reference'			=> $transaction_id,
			'action_reftype'			=> 'transaction',
			'action_user_id'			=> $user_id,
			'action_type'				=> 'reserve',
			'action_source'				=> 'normal',
			'action_datetime'			=> date("Y-m-d H:i:s"),
			'action_remarks'			=> '',
		);
		
		$this->db->set($fields);
		$this->db->insert('action_log');
			
		return $this->db->affected_rows();
		
	}	
	
	function _check_tix_stat($session_id = false, $event_id = false)
	{
		$this->db->query('set transaction isolation level read uncommitted');

		$this->db->select("ti.ticket_status");
		$this->db->where('ti.ticket_session_id', $session_id);
		$this->db->where('ti.ticket_event_id', $event_id);
		$this->db->where('ti.ticket_status', 'selected');
		$get_tix_stat = $this->db->get('tickets ti');
	 
		
		if ($get_tix_stat->num_rows() > 0)
		{
			return true;
		}
		else 
		{
			 
			return false;
		}
	}
	 
	function get_by_mobile($mobile)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->where('customer_mobile', $mobile);
		$query = $this->db->get('customers');
		//echo $this->db->last_query();
		
		return $query->row();
	}
	
	function extend_reservation($transaction_id)
	{	
		$no_of_days = $this->input->post('days');
		$extend_date = date("Y-m-d", strtotime("+$no_of_days days")); 
		
		// update tickets table
		$this->db->where('ticket_transaction_id', $transaction_id);
		$this->db->update($this->tickets, array('ticket_reservation_expiry' => $extend_date));
			
		return $this->db->affected_rows();

	}
	
	function randomKey($length) {
		$characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
		$charactersLength = strlen($characters);
		$randomString = '';
		for ($i = 0; $i < $length; $i++) {
			$randomString .= $characters[rand(0, $charactersLength - 1)];
		}
		return $randomString;
	}

	function count_taken_seats($session_id, $event_id){
		$status = ['done','paid_online'];
		$customer_id = $this->get_customer_id($session_id); 

		$this->db->select('count(1) as count'); 
		$this->db->where('ticket_event_id', $event_id);
		$this->db->where('transaction_customer_id', $customer_id);
		$this->db->where_in('ticket_status',$status);
		$this->db->join('transactions t', 'ti.ticket_transaction_id = t.transaction_id', 'left');
		$this->db->limit(1); 
		$query = $this->db->get('tickets ti');
		return $query->row()->count;
		
	}
	
	function get_transaction_info($transaction_id){ //forupload
		
		$read = $this->load->database('default',true);
		$read->select('	p.payment_datetime,
							t.transaction_id,
							t.transaction_receipt_number,
							c.charge_ticket_count,
							c.charge_amount,
							cu.customer_email	');
		$read->where('c.charge_transaction_id',$transaction_id);
		$read->join('transactions t', 't.transaction_id = c.charge_transaction_id');
		$read->join('customers cu', 'cu.customer_id = t.transaction_customer_id');
		$read->join('payments p', 'p.payment_transaction_id = t.transaction_id');
		$q = $read->get('charges c');
		 
		$r = $q->row();

		return $r;		
	}
	
}
