<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Ticktickets_model extends CI_Model
{
	var $events = 'events e';
	var $users = 'users u';
	var $tickets = 'tickets ti';
	var $sections = 'sections s';
	var $prices = 'prices p';
	var $ticket_types = 'ticket_types tt';
	var $venues = 'venues v';
	var $transactions = 'transactions tr';
	var $terminals = 'terminals te';
	var $ticket_layouts = 'ticket_layouts tl';
	var $logos = 'logos l';
	var $ticket_logos = 'ticket_logos tk';
	var $branch = 'branches br';
	
	var $arrVoidListStat = array('done','paid'); // status filter for voiding
	var $shuttle_url = 'http://192.168.0.54:8989/shuttleapi/index.php/shuttle/create_transaction';
	/**
	 * Constructor
	 *
	 * @access	public
	 */
	public function __construct()
	{
		parent::__construct();
		$this->load->model('ekbarcode_model', 'ekbarcode');
		$this->load->model('users_model', 'users');
		$this->load->model('sections_model', 'sections_model');
		$this->load->model('transactions_model', 'transactions_model');
		$this->load->model('events_model', 'events_model');
		$this->load->model('ticket_layouts_model', 'ticket_layouts_model');
		$this->load->model('branches_model', 'branches_model');
		$this->load->model('payments_model', 'payments_model');
		$this->load->model('configurations_model', 'configurations_model');
		$this->load->model('prices_model', 'prices_model');
		$this->load->model('logs_model', 'logs_model');
		$this->load->model('logs_online_model', 'olog');
		$this->load->model('eplus_model', 'eplus');
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get
	 *
	 * @access	public
	 */
	function get($ticket_id)
	{
		$this->db->select('ti.*, tr.*, p.*, tt.ticket_type_discount_type, tt.ticket_type_discount, tt.ticket_type_name, tt.ticket_type_code, s.section_id, s.section_name, s.section_type, s.section_code');
		$this->db->where('ti.ticket_id', $ticket_id);	
		$this->db->join($this->sections, 's.section_id = ti.ticket_section_id', 'left');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id', 'left');
		$this->db->join($this->prices, 'p.price_id = ti.ticket_price_id', 'left');
		$this->db->join($this->transactions, 'tr.transaction_id = ti.ticket_transaction_id', 'left');
		//$this->db->join($this->events, 'ti.ticket_event_id = e.event_id', 'left');
		$query = $this->db->get($this->tickets);
		
		return $query->row();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_all_tickets
	 *
	 * @access	public
	 */
	function get_all_tickets($offset = false, $limit = false, $searchItems=false)
	{
		$this->db->select('ti.*, e.event_title, s.section_code, tt.ticket_type_code, u.*');
		$this->db->join($this->sections, 's.section_id = ti.ticket_section_id', 'left');
		$this->db->join($this->events, 'e.event_id = ti.ticket_event_id', 'left');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id', 'left');
		$this->db->join($this->users, 'u.user_id = ti.ticket_user_id', 'left');
				
		if (is_array($searchItems) && !empty($searchItems) )
		{
			foreach ($searchItems as $skey => $sval)
			{
				switch ($skey)
				{
					case 'ticket_id':
					case 'ticket_acknowledgment_receipt':
					case 'ticket_transaction_id':
						$this->db->where($skey, $sval);
						break;
					case 'ticket_date_entered':
						$this->db->like('ticket_date_entered', input_date($sval) );
						break;
					default:
					  $this->db->like($skey, $sval);
					  break;										
				}				
			}
		}		
		
		if ($limit) $this->db->limit($limit);
		if ($offset) $this->db->offset($offset);
		$this->db->order_by('ticket_id', 'desc');
		$query = $this->db->get($this->tickets);		
		return $query->result();		
	}	
	
	// --------------------------------------------------------------------
	
	/**
	 * get_ticket_count
	 *
	 * @access	public
	 */
	function get_ticket_count()
	{
		$this->db->select('count(*) as ticket_count');
		$query = $this->db->get($this->tickets);
		$count = $query->row();
		
		return $count->ticket_count;
	}
	
	// --------------------------------------------------------------------
	
	//*
	//	 * get_tickets
	//	 *
	//	 * @access	public
	//	 
	function get_tickets($type, $id = false, $cpi = false)
	{
		if ($type == 'session')
		{
			$this->db->where('ticket_session_id', $id);
		}
		else if ($type == 'transaction')
		{
			$this->db->where('ticket_transaction_id', $id);
		}
		
		$this->db->where('p.price_id', $cpi);
		
		$this->db->join($this->sections, 's.section_id = ti.ticket_section_id', 'left');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id', 'left');
		$this->db->join($this->events, 'e.event_id = ti.ticket_event_id', 'left');
		$this->db->join($this->ticket_layouts, 'tl.ticket_layout_event_id = e.event_id', 'left');
		$this->db->join($this->prices, 'p.price_event_id = e.event_id', 'left');
		$this->db->join($this->venues, 'v.venue_id = e.event_venue_id', 'left');
		$this->db->join($this->transactions, 'tr.transaction_id = ti.ticket_transaction_id', 'left');
		$this->db->join($this->terminals, 'te.terminal_id = tr.transaction_terminal_id', 'left');
		$this->db->orderby('ti.ticket_row', 'asc');
		$this->db->orderby('ti.ticket_seat + 0', 'asc');
		$query = $this->db->get($this->tickets);
		//echo $this->db->last_query();
		
		return $query->result();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_tickets_by_transaction
	 *
	 * @access	public
	 */
	function get_tickets_by_transaction($transaction_id, $cpi = false, $type = false)
	{
		$this->db->select('ti.*, tr.*, p.*, tt.ticket_type_discount_type, tt.ticket_type_discount, tt.ticket_type_name, tt.ticket_type_code, s.section_id, s.section_name, s.section_type, s.section_code, ekb.ek_barcode, ekb.ek_days_valid, u.username, e.event_code, ec.*');
		$this->db->where('ti.ticket_transaction_id', $transaction_id);
		if ($type) { 
			$this->db->where('ti.ticket_status', $type);
			$this->db->where('tr.transaction_status', $type);
		}
		$this->db->join('ek_barcode ekb', 'ekb.ek_ticket_id = ti.ticket_id', 'left');
		$this->db->join($this->sections, 's.section_id = ti.ticket_section_id', 'left');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id', 'left');
		$this->db->join($this->prices, 'p.price_id = ti.ticket_price_id', 'left');
		$this->db->join($this->users, 'u.user_id = ti.ticket_user_id', 'left');
		$this->db->join($this->events, 'e.event_id = ti.ticket_event_id', 'LEFT');
		$this->db->join('events_config ec', 'e.event_id = ec.events_config_eventid', 'LEFT');
		$this->db->join($this->transactions, 'tr.transaction_id = ti.ticket_transaction_id', 'left');
		$this->db->orderby('ti.ticket_row', 'asc');
		$this->db->orderby('ti.ticket_seat + 0', 'asc');
		$query = $this->db->get($this->tickets);
		//echo $this->db->last_query();
		
		return $query->result();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_tickets_v2
	 *
	 * @access	public
	 */
	function get_tickets_v2($transaction_id, $status)
	{
		$this->db->select('ti.*, tr.*, p.*, tt.ticket_type_discount_type, tt.ticket_type_discount, tt.ticket_type_name, tt.ticket_type_code, s.section_id, s.section_name, s.section_type, s.section_code');
		$this->db->where('ti.ticket_transaction_id', $transaction_id);	
		$this->db->where('ti.ticket_status', $status);		
		$this->db->join($this->sections, 's.section_id = ti.ticket_section_id', 'left');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id', 'left');
		$this->db->join($this->prices, 'p.price_id = ti.ticket_price_id', 'left');
		$this->db->join($this->transactions, 'tr.transaction_id = ti.ticket_transaction_id', 'left');
		$this->db->orderby('ti.ticket_row', 'asc');
		$this->db->orderby('ti.ticket_seat + 0', 'asc');
		$query = $this->db->get($this->tickets);
		//echo $this->db->last_query();
		
		return $query->result();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_tickets_by_transaction
	 *
	 * @access	public
	 */
	function get_paid_tickets($transaction_id)
	{
		$this->db->select('ti.*, tr.*, p.*, e.event_reservation_fee, tt.ticket_type_discount_type, tt.ticket_type_discount, tt.ticket_type_name, tt.ticket_type_code, s.section_id, s.section_name, s.section_type, s.section_code');
		$this->db->where('ti.ticket_transaction_id', $transaction_id);	
		$this->db->where('ti.ticket_status', 'paid');		
		$this->db->join($this->sections, 's.section_id = ti.ticket_section_id', 'left');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id', 'left');
		$this->db->join($this->prices, 'p.price_id = ti.ticket_price_id', 'left');
		$this->db->join($this->transactions, 'tr.transaction_id = ti.ticket_transaction_id', 'left');
		$this->db->join($this->events, 'ti.ticket_event_id = e.event_id', 'left');
		$this->db->orderby('ti.ticket_row', 'asc');
		$this->db->orderby('ti.ticket_seat + 0', 'asc');
		$query = $this->db->get($this->tickets);
		//echo $this->db->last_query();
		
		return $query->result();
	}
	
	function get_paid_online_tickets($transaction_id)
	{
		$this->db->select('ti.*, tr.*, p.*, e.event_reservation_fee, tt.ticket_type_discount_type, tt.ticket_type_discount, tt.ticket_type_name, tt.ticket_type_code, s.section_id, s.section_name, s.section_type, s.section_code');
		$this->db->where('ti.ticket_transaction_id', $transaction_id);	
		$this->db->where('ti.ticket_status', 'paid_online');
		$this->db->join($this->sections, 's.section_id = ti.ticket_section_id', 'left');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id', 'left');
		$this->db->join($this->prices, 'p.price_id = ti.ticket_price_id', 'left');
		$this->db->join($this->transactions, 'tr.transaction_id = ti.ticket_transaction_id', 'left');
		$this->db->join($this->events, 'ti.ticket_event_id = e.event_id', 'left');
		$this->db->orderby('ti.ticket_row', 'asc');
		$this->db->orderby('ti.ticket_seat + 0', 'asc');
		$query = $this->db->get($this->tickets);
		//echo $this->db->last_query();
		
		return $query->result();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_by_barcode
	 *
	 * @access	public
	 */
	function get_by_barcode($barcode)
	{
		$this->db->where('ticket_barcode', $barcode);
		$this->db->where('ticket_status', 'paid_online');	
		$query = $this->db->get($this->tickets);

		return $query->result();
	}
	
	function get_by_barcode_details($barcode)
	{
		$this->db->where('ticket_barcode', $barcode);
		$query = $this->db->get($this->tickets);

		return $query->result();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_done_tickets
	 *
	 * @access	public
	 */
	function get_ticket_count_for_void($transaction_id) {
		$this->db->select('ti.ticket_id');
		$this->db->where('ti.ticket_transaction_id', $transaction_id);	
		$this->db->where_in('ti.ticket_status', $this->arrVoidListStat);
		$query = $this->db->get($this->tickets);
		return $query->num_rows();
	}
	 
	function get_tickets_to_void($transaction_id)
	{
		$this->db->select('ti.*, tr.*, p.*, tt.ticket_type_discount_type, tt.ticket_type_discount, tt.ticket_type_name, tt.ticket_type_code, s.section_id, s.section_name, s.section_type, s.section_code');
		$this->db->where('ti.ticket_transaction_id', $transaction_id);	
		$this->db->where_in('ti.ticket_status', array('reserved','done','selected','paid','paid_online'));
		$this->db->join($this->sections, 's.section_id = ti.ticket_section_id', 'left');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id', 'left');
		$this->db->join($this->prices, 'p.price_id = ti.ticket_price_id', 'left');
		$this->db->join($this->transactions, 'tr.transaction_id = ti.ticket_transaction_id', 'left');
		$this->db->orderby('ti.ticket_row', 'asc');
		$this->db->orderby('ti.ticket_seat + 0', 'asc');
		$query = $this->db->get($this->tickets);
		
		return $query->result();
	}	
	
	function get_done_tickets($transaction_id)
	{
		$this->db->select('ti.*, tr.*, p.*, tt.ticket_type_discount_type, tt.ticket_type_discount, tt.ticket_type_name, tt.ticket_type_code, s.section_id, s.section_name, s.section_type, s.section_code');
		$this->db->where('ti.ticket_transaction_id', $transaction_id);	
		$this->db->where('ti.ticket_status', 'done');	
		$this->db->join($this->sections, 's.section_id = ti.ticket_section_id', 'left');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id', 'left');
		$this->db->join($this->prices, 'p.price_id = ti.ticket_price_id', 'left');
		$this->db->join($this->transactions, 'tr.transaction_id = ti.ticket_transaction_id', 'left');
		$this->db->orderby('ti.ticket_row', 'asc');
		$this->db->orderby('ti.ticket_seat + 0', 'asc');
		$query = $this->db->get($this->tickets);
		//echo $this->db->last_query();
		
		return $query->result();
	}	
	
	// --------------------------------------------------------------------
	
	/**
	 * get_reserved_tickets
	 *
	 * @access	public
	 */
	function get_reserved_tickets($transaction_id)
	{
		$this->db->select('ti.*, tr.*, p.*, tt.ticket_type_discount_type, tt.ticket_type_discount, tt.ticket_type_name, tt.ticket_type_code, s.section_id, s.section_name, s.section_type, s.section_code');
		$this->db->where('ti.ticket_transaction_id', $transaction_id);	
		$this->db->where('ti.ticket_status', 'reserved');	
		$this->db->join($this->sections, 's.section_id = ti.ticket_section_id', 'left');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id', 'left');
		$this->db->join($this->prices, 'p.price_id = ti.ticket_price_id', 'left');
		$this->db->join($this->transactions, 'tr.transaction_id = ti.ticket_transaction_id', 'left');
		$this->db->orderby('ti.ticket_row', 'asc');
		$this->db->orderby('ti.ticket_seat + 0', 'asc');
		$query = $this->db->get($this->tickets);
		//echo $this->db->last_query();
		
		return $query->result();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_selected_tickets
	 *
	 * @access	public
	 */
	function get_selected_tickets($transaction_id)
	{
		$this->db->select('ti.*, tr.*, p.*, tt.ticket_type_discount_type, tt.ticket_type_discount, tt.ticket_type_name, tt.ticket_type_code, s.section_id, s.section_name, s.section_type, s.section_code');
		$this->db->where('ti.ticket_transaction_id', $transaction_id);	
		$this->db->where('ti.ticket_status', 'selected');	
		$this->db->join($this->sections, 's.section_id = ti.ticket_section_id', 'left');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id', 'left');
		$this->db->join($this->prices, 'p.price_id = ti.ticket_price_id', 'left');
		$this->db->join($this->transactions, 'tr.transaction_id = ti.ticket_transaction_id', 'left');
		$this->db->orderby('ti.ticket_row', 'asc');
		$this->db->orderby('ti.ticket_seat + 0', 'asc');
		$query = $this->db->get($this->tickets);
		//echo $this->db->last_query();
		
		return $query->result();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_reserved_tickets
	 *
	 * @access	public
	 */
	function get_reserved_tickets_by_event($event_id)
	{
		$this->db->select('count( * ) AS cnt, tr.* ,c.*');
		$this->db->where('ticket_event_id', $event_id);
		$this->db->where('ticket_status', 'reserved');
		$this->db->join( $this->tickets, 'ticket_transaction_id = transaction_id','left');
		$this->db->join( 'customers c', 'transaction_customer_id=customer_id','left');
		$this->db->group_by('transaction_id');
		
		$query = $this->db->get( $this->transactions );
		return $query->result();
	}
	

// --------------------------------------------------------------------
	
	/**
	 * get_tickets_by_session
	 *
	 * @access	public
	 */
	function get_tickets_by_session($session_id)
	{
		$this->db->select('ti.*, tr.*, p.*, e.event_reservation_fee , tt.ticket_type_discount_type, tt.ticket_type_discount, tt.ticket_type_name, tt.ticket_type_code, s.section_id, s.section_name, s.section_type, s.section_code');
		$this->db->where('ticket_session_id', $session_id);	
		$this->db->where_in('ti.ticket_status', array('selected', 'reserved'));
		$this->db->join($this->sections, 's.section_id = ti.ticket_section_id', 'left');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id', 'left');
		$this->db->join($this->prices, 'p.price_id = ti.ticket_price_id', 'left');
		$this->db->join($this->transactions, 'tr.transaction_id = ti.ticket_transaction_id', 'left');
		$this->db->join($this->events, 'ti.ticket_event_id = e.event_id', 'left');
		$this->db->orderby('ti.ticket_row', 'asc');
		$this->db->orderby('ti.ticket_seat + 0', 'asc');
		$query = $this->db->get($this->tickets);
		//echo $this->db->last_query();
		
		$this->add_shuttle_transaction_reserve($query->result());
		
		return $query->result();
	}	
	
	//---------------------------------------------------------------------
	
	function get_ticket_logos($event_id)
	{
		$this->db->where('event_id', $event_id);
		$this->db->join($this->logos, 'l.logo_id = tk.ticket_logo_logo_id', 'left');
		$query = $this->db->get($this->ticket_logos);
		//echo $this->db->last_query();
		
		return $query->result();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_tickets
	 *
	 * @access	public
	 */
	function get_taken_seats($event_id, $section_id)
	{
		$this->db->where('ticket_event_id', $event_id);
		$this->db->where('ticket_section_id', $section_id);
		$this->db->where_in('ticket_status', array('done', 'paid', 'paid_online', 'reserved', 'selected'));
		$query = $this->db->get($this->tickets);
		//echo $this->db->last_query();
		
		return $query->result();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * is_seat_taken
	 *
	 * @access	public
	 */
	function is_seat_taken($row, $col, $seats_taken)
	{
		foreach ($seats_taken as $seat)
		{
			if ($seat->ticket_system_row == $row and $seat->ticket_system_col == $col and $seat->ticket_status != "reserved")
			{
				return true;
			}
		}
		
		return false;
	}
	function is_seat_taken_reserved($row, $col, $seats_taken)
	{
		foreach ($seats_taken as $seat)
		{
			if ($seat->ticket_system_row == $row and $seat->ticket_system_col == $col and $seat->ticket_status == "reserved")
			{
				return true;
			}
		}
		
		return false;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * is_seat_available
	 *
	 * @access	public
	 */
	function is_seat_available($section_id, $row, $col)
	{
		$this->db->where('ticket_section_id', $section_id);
		$this->db->where('ticket_system_row', $row);
		$this->db->where('ticket_system_col', $col);
		$this->db->where_in('ticket_status', array('done', 'paid', 'paid_online', 'reserved', 'selected'));
		$query = $this->db->get($this->tickets);
		//print_array($query->row());
		//echo $this->db->last_query();
		return ($query->num_rows() > 0) ? false : true;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * select_ticket
	 *
	 * @access	public
	 */
	function select_ticket_old($event_id, $section_id, $system_row, $seat)
	{
	
		list($system_col, $row, $seat) = explode('|', $seat);
		$system_col = str_replace('C', '', $system_col);
		
		// check first if seat is still available
		if ($this->is_seat_available($section_id, $system_row, $system_col))
		{
			$fields = array(
				'ticket_date_entered'		=> date('Y-m-d H:i:s'),
				'ticket_session_id'			=> $this->session->userdata('customer_session_id'),
				'ticket_event_id'			=> $event_id,
				'ticket_section_id'			=> $section_id,
				'ticket_price_id'			=> $this->session->userdata('cpi'),
				'ticket_system_row'			=> $system_row,
				'ticket_system_col'			=> $system_col,
				'ticket_row'				=> $row,
				'ticket_seat'				=> $seat,
				'ticket_status'				=> 'selected',
				'ticket_user_id'			=> $this->session->userdata('user_id'),
				'ticket_branch_id'			=> $this->session->userdata('user_branch_id'),
				'ticket_terminal_id'		=> $this->session->userdata('user_terminal_id'),
			);
			
			//print_array($fields);
			
			// insert to db
			$this->db->set($fields);
			$this->db->insert('tickets');
			
			// update available tickets
			$this->sections_model->update_available($section_id, 'decrease', 1);
				
			echo 'success';
		}
		else
		{
			echo 'failed';
		}
	}
	
	
	// --------------------------------------------------------------------
	
	/**
	 * unselect_ticket
	 *
	 * @access	public
	 */
	function unselect_ticket_old($event_id, $section_id, $system_row, $seat)
	{
		// log this
		$this->logs_model->add("unselect_ticket($event_id, $section_id, $system_row, $seat)");

		list($system_col, $row, $seat) = explode('|', $seat);
		$system_col = str_replace('C', '', $system_col);
		

		// update db
		$this->db->where('ticket_event_id', $event_id);
		$this->db->where('ticket_section_id', $section_id);
		$this->db->where('ticket_system_row', $system_row);
		$this->db->where('ticket_system_col', $system_col);
		$this->db->where('ticket_status', 'selected');
		$this->db->update($this->tickets, array('ticket_status' => 'unselected'));
		
		// update available tickets
		$this->sections_model->update_available($section_id, 'increase', 1);
			
		echo 'success';
	}

	function select_ticket($event_id, $section_id, $system_row, $seat)
	{
		list($system_col, $row, $seat) = explode('|', $seat);
		$system_col = str_replace('C', '', $system_col);
	
		// check first if seat is still available
		if ($this->is_seat_available($section_id, $system_row, $system_col))
		{
			$fields = array(
				'ticket_date_entered'		=> date('Y-m-d H:i:s'),
				'ticket_session_id'			=> $this->session->userdata('customer_session_id'),
				'ticket_event_id'			=> $event_id,
				'ticket_section_id'			=> $section_id,
				'ticket_price_id'			=> $this->session->userdata('cpi'),
				'ticket_system_row'			=> $system_row,
				'ticket_system_col'			=> $system_col,
				'ticket_row'				=> $row,
				'ticket_seat'				=> $seat,
				'ticket_status'				=> 'selected',
				'ticket_user_id'			=> $this->session->userdata('user_id'),
				'ticket_branch_id'			=> $this->session->userdata('user_branch_id'),
				'ticket_terminal_id'		=> $this->session->userdata('user_terminal_id'),
			);
			
			// insert to db
			$this->db->set($fields);
			$this->db->insert('tickets');
			

			$ticket_count = $this->db->affected_rows();
			
			// update available tickets
			if ($ticket_count > 0) {
				$this->sections_model->update_available($section_id, 'decrease', $ticket_count);
				echo 'success';
			}
		}
		else
		{
			echo 'failed';
		}
	}

	function unselect_ticket($event_id, $section_id, $system_row, $seat)
	{
		// log this
		$this->logs_model->add("unselect_ticket($event_id, $section_id, $system_row, $seat)");

		list($system_col, $row, $seat) = explode('|', $seat);
		$system_col = str_replace('C', '', $system_col);
		

		// update db
		$this->db->where('ticket_event_id', $event_id);
		$this->db->where('ticket_section_id', $section_id);
		$this->db->where('ticket_system_row', $system_row);
		$this->db->where('ticket_system_col', $system_col);
		$this->db->where('ticket_status', 'selected');
		$this->db->update($this->tickets, array('ticket_status' => 'unselected'));
		$ticket_count = $this->db->affected_rows();

		// update available tickets
		if ($ticket_count > 0) {
			$this->sections_model->update_available($section_id, 'increase', $ticket_count);
			echo 'success';
		}
			
	}
		
	// --------------------------------------------------------------------
	
	/**
	 * add
	 *
	 * @access	public
	 */
	function add($event_id, $section)
	{
		$ticket_count = 0;
		$tickets = array();
	
		// for free-seating and standing
		if ($this->input->post('ticket_quantity'))
		{
			foreach (range(1, $this->input->post('ticket_quantity')) as $count)
			{
				$fields = array(
					'ticket_date_entered'		=> date('Y-m-d H:i:s'),
					'ticket_session_id'			=> $this->session->userdata('customer_session_id'),
					'ticket_event_id'			=> $event_id,
					'ticket_section_id'			=> $section->section_id,
					'ticket_price_id'			=> $this->session->userdata('cpi'),
					'ticket_seat'				=> $section->section_type,
					'ticket_user_id'			=> $this->session->userdata('user_id'),
					'ticket_branch_id'			=> $this->session->userdata('user_branch_id'),
					'ticket_terminal_id'		=> $this->session->userdata('user_terminal_id'),
					'ticket_status'				=> 'selected'
				);
				
				//print_array($fields);
				
				// insert to db
				$this->db->set($fields);
				$this->db->insert('tickets');
				$tickets[] = $this->db->insert_id();
				$ticket_count++;
			}
			if ($ticket_count > 1) {
				$this->sections_model->update_available($section->section_id, 'decrease', $ticket_count);
			}
		}
		
		// for reserved seats
		else
		{
			foreach ($this->input->post('seat') as $seat_row => $seat_cols)
			{
				foreach ($seat_cols as $seat_col => $seat)
				{
		
					list($system_col, $row, $seat) = explode('|', $seat);
								
					$fields = array(
						'ticket_date_entered'		=> date('Y-m-d H:i:s'),
						'ticket_session_id'			=> $this->session->userdata('customer_session_id'),
						'ticket_event_id'			=> $event_id,
						'ticket_section_id'			=> $section->section_id,
						'ticket_price_id'			=> $this->session->userdata('cpi'),
						'ticket_system_row'			=> str_replace('R', '', $seat_row),
						'ticket_system_col'			=> str_replace('C', '', $system_col),
						'ticket_row'				=> $row,
						'ticket_seat'				=> $seat,
						'ticket_status'				=> 'selected'
					);
					
					//print_array($fields);
					
					// insert to db
					$this->db->set($fields);
					$this->db->insert('tickets');
					$tickets[] = $this->db->insert_id();
					$ticket_count++;
			
				}
			}
		}	

		if($this->session->userdata('shuttle_qty') > 0){
		
			$this->add_shuttle_transaction($tickets);
		}

		
		return $ticket_count;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * edit_ticket_type
	 *
	 */
	function edit_ticket_type()
	{
		$ticket = $this->input->post('ticket');
		$ticket_type = $this->input->post('ticket_type');
		$count = count($ticket);
		//$senior = $this->input->post('senior');
		
		
		for ($i = 0; $i < $count; $i++)
		{
 			$fields['ticket_type_id'] = $ticket_type[$i];
			
			// update db
			$this->db->where('ticket_id', $ticket[$i]);
			$this->db->update($this->tickets, $fields);
			
			
		 
		}
	
	 
		//$this->session->set_userdata('senior', $this->input->post('senior'));
		//$this->session->set_userdata('tix_count', $count);
		//$this->session->set_userdata('ticket_senior', $ticket);
		
	
		return true;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * update_acknowledgment_receipt
	 *
	 */
	function update_acknowledgment_receipt($ticket_id, $receipt_number)
	{
		// update the transactions table
		$this->db->where('ticket_id', $ticket_id);
		$this->db->update($this->tickets, array('ticket_acknowledgment_receipt' => $receipt_number));
		
		return true;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * clear_tickets
	 *
	 */
	function clear_tickets_old($session_id)
	{
		// $this->logs_model->add("clear_tickets($session_id)");
		// get seats previously selected by user but are not still done upon selection of new event(avoid parallel transactions by user)
		$this->db->where('ticket_session_id', $session_id);
		$this->db->where_in('ticket_status', array('selected', 'paid'));
		$query = $this->db->get($this->tickets);
		$tickets = $query->result();
		if (count($tickets) > 0)
		{
			foreach ($tickets as $ticket)
			{
				// $this->logs_model->add("clear_tickets / ".$ticket->ticket_id);
				
				$this->db->where('ticket_id', $ticket->ticket_id);
				$this->db->where('ticket_status', 'selected');
				$this->db->update($this->tickets, array('ticket_status' => 'unselected'));
						
				$this->sections_model->update_available($ticket->ticket_section_id, 'increase', 1);	
			}
		}
		
		$this->ekbarcode->free_stagnant_barcodes();
		
		
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * clear_selected_seats
	 *
	 */
	function clear_selected_seats_old()
	{
		// $this->logs_model->add("clear_selected_seats - due to expire time");

		// expire time
		$minutes = 15;
		$expire_time = date("Y-m-d H:i:s", strtotime(date("Y-m-d H:i:s"))-($minutes*60));
		
		// get selected seats that are due for clearing
		$this->db->where('ticket_date_entered <=', $expire_time);
		// $this->db->where_in('ticket_status', array('selected', 'paid'));
		$this->db->where('ticket_status', 'selected');

		$query = $this->db->getwhere($this->tickets);
		$tickets = $query->result();
		//echo $this->db->last_query();
		//print_array($tickets);
		
		if (count($tickets) > 0)
		{
			foreach ($tickets as $ticket)
			{
				$this->logs_model->add("unselected ".$ticket->ticket_id);

				$this->db->where('ticket_id', $ticket->ticket_id);
				$this->db->where('ticket_status', 'selected');
				$this->db->update($this->tickets, array('ticket_status' => 'unselected'));
						
				$this->sections_model->update_available($ticket->ticket_section_id, 'increase', 1);	
			}
		}
		$this->ekbarcode->free_stagnant_barcodes();
	}
	
	function clear_tickets_nosqlstr($session_id)
	{
		$uid = ($this->session->userdata('user_id')) ? $this->session->userdata('user_id') : 0;
		if ($uid > 0) {
			// get seats previously selected by user but are not still done upon selection of new event(avoid parallel transactions by user)
			$this->db->select('ticket_transaction_id, ticket_id, ticket_status, ticket_section_id');
			$this->db->where('ticket_session_id', $session_id);
			$this->db->where_in('ticket_status', array('selected'));
			$query = $this->db->get($this->tickets);
			$tickets = $query->result();
	
			if (count($tickets) > 0)
			{
				$tickets_for_reset["t"] = "reset";
				$tickets_for_reset["q"] = $tickets;
				foreach ($tickets as $ticket)
				{
					if (isset($processed[$ticket->ticket_section_id])) {
						$processed[$ticket->ticket_section_id]["detected"]++;
					} else {
						
						$this->db->where('ticket_session_id', $session_id);
						$this->db->where('ticket_id', $ticket->ticket_id);
						$this->db->where('ticket_status', 'selected');
						$this->db->update($this->tickets, array('ticket_status' => 'unselected'));
						$ticket_count = $this->db->affected_rows();

						if ($ticket_count > 0) {
							$this->sections_model->update_available($ticket->ticket_section_id, 'increase', $ticket_count);	

							$processed[$ticket->ticket_section_id]["detected"] = 1;
							$processed[$ticket->ticket_section_id]["sess"] = $session_id;
							$processed[$ticket->ticket_section_id]["affected"] = $ticket_count;
						}
					}
				}
				$tickets_for_reset["p"] = $processed;
				$this->olog->add_arrayinfo_to_review($tickets_for_reset);
			}
			$this->ekbarcode->free_stagnant_barcodes();
		}
	}
	

	function clear_tickets($session_id)
	{
		$slen = strlen($session_id);
		$uid = ($this->session->userdata('user_id')) ? $this->session->userdata('user_id') : 0;
		if (($uid > 0) && ($slen > 1)) {
			// get seats previously selected by user but are not still done upon selection of new event(avoid parallel transactions by user)
			$this->db->select('ticket_transaction_id, ticket_id, ticket_status, ticket_section_id, ticket_event_id');
			$this->db->where('ticket_session_id', "$session_id");
			$this->db->where_in('ticket_status', array('selected'));
			$query = $this->db->get($this->tickets);
			$tickets = $query->result();



			// use this as identifier there is an existing ekbarcode
			$existing_used_ekbc = false;
			
			if (count($tickets) > 0)
			{
				$sql = $this->db->last_query();
				$tickets_for_reset["t"] = "reset";
				$tickets_for_reset["uid"] = $uid;
				$tickets_for_reset["sql"] = $sql;
				$tickets_for_reset["count"] = count($tickets);




				
				// identify list of EK Events
				$ek_events = $this->ekbarcode->listing_active_array();
				
				// $tickets_for_reset["q"] = $tickets;
				foreach ($tickets as $ticket)
				{				





					// count tickets to identify if there is one that has ek_barcode
					if (isset($ek_events[$ticket->ticket_event_id])) {
						$ek_events[$ticket->ticket_event_id]++;
					}
					
					$this->db->where('ticket_session_id', "$session_id");
					$this->db->where('ticket_id', $ticket->ticket_id);
					$this->db->where('ticket_status', 'selected');
					$this->db->update($this->tickets, array('ticket_status' => 'unselected'));
					$ticket_count = $this->db->affected_rows();

					if ($ticket_count > 0) {
						$this->sections_model->update_available($ticket->ticket_section_id, 'increase', $ticket_count);	

						$processed[$ticket->ticket_transaction_id][$ticket->ticket_section_id][$session_id][$ticket->ticket_status][] = $ticket->ticket_id;
					}
				}



				
				$existing_used_ekbc = (array_sum($ek_events) > 0) ? true : $existing_used_ekbc ;
			
				$tickets_for_reset["proc"] = $processed;
				$this->olog->add_arrayinfo_to_review($tickets_for_reset);
			}





			
			if ($existing_used_ekbc) {
				$this->ekbarcode->free_stagnant_barcodes();
			}
		}
		
		$fields['qr_user_id'] = null;
		$user_id = $this->session->userdata('user_id');
		$this->db->where('qr_user_id', $user_id);
		$this->db->where('qr_transaction_id IS NULL');
		$this->db->update('qrcode', $fields);
		
	}
	

	function clear_selected_seats()
	{
		// expire time
		$minutes = 15;
		$minutes = 45;
		$expire_time = date("Y-m-d H:i:s", strtotime(date("Y-m-d H:i:s"))-($minutes*60));
		
		$date = date('Y-m-d', strtotime($expire_time));
		$newdate = strtotime('-1 day' , strtotime($expire_time));
		$newdate = date ( 'Y-m-d H:i:s' , $newdate );
		
		// get selected seats that are due for clearing
		$this->db->where('ticket_date_entered <=', $expire_time);
		$this->db->where('ticket_date_entered >=', $newdate);
		$this->db->where('ticket_status', 'selected');

		$query = $this->db->getwhere($this->tickets);
		$tickets = $query->result();
		
		$info = array();


		// use this as identifier there is an existing ekbarcode
		$existing_used_ekbc = false;
		if (count($tickets) > 0)
		{


			// identify list of EK Events
			$ek_events = $this->ekbarcode->listing_active_array();

			$info["expire"] = $expire_time;
			foreach ($tickets as $ticket)
			{

 
				// count tickets to identify if there is one that has ek_barcode
				if (isset($ek_events[$ticket->ticket_event_id])) {
					$ek_events[$ticket->ticket_event_id]++;
				}
				$this->db->where('ticket_id', $ticket->ticket_id);
				$this->db->where('ticket_status', 'selected');
				$this->db->update($this->tickets, array('ticket_status' => 'unselected'));
				$ticket_count = $this->db->affected_rows();
						
				$this->sections_model->update_available($ticket->ticket_section_id, 'increase', $ticket_count);
				$info["tixid"][$ticket->ticket_transaction_id][$ticket->ticket_id] = $ticket_count;
			}

			$existing_used_ekbc = (array_sum($ek_events) > 0) ? true : $existing_used_ekbc ;
		}
 

		if ($existing_used_ekbc) {
			$this->ekbarcode->free_stagnant_barcodes();
		}

		if (!empty($info)) {
			$info["sysdate"] = date("Y-m-d H:i:s");
			$this->olog->add_arrayinfo_to_review($info);
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * update_status
	 *  - updates the status of the ticket
	 */
	function update_status($ticket_ids, $status, $extra=array())
	{	

		//add card logs
		$this->eplus->add_card_logs($ticket_ids);
			
		 
		

		// untag ticket to eplus card number
		$this->db->where_in('eplus_card_ticket_id', $ticket_ids); 
		$q = $this->db->get('eplus_cards');
		
 
		if($q->num_rows() < 1){
		
			// update the status of the senior tickets
			$this->db->where_in('senior_ticket_id', $ticket_ids);
			$this->db->update('senior_transactions', array('senior_status' => 'voided' ));
			
			//untag qrcode 
			
			$fields['qr_transaction_id'] = null;
			$fields['qr_user_id'] = null;
			$fields['qr_ticket_id'] = null;
			$this->db->where_in('qr_ticket_id', $ticket_ids);
			$this->db->update('qrcode', $fields);
			 
			  
						
			$changes = array('ticket_status' => $status );
			$date_mods = array('done' 		=> 'ticket_date_printed',
							   'reserved' 	=> 'ticket_date_reserved',
							   'cancelled'	=> 'ticket_date_cancelled',
							   'reservation_cancelled'	=> 'ticket_date_cancelled',
							   'voided'		=> 'ticket_date_cancelled');
			$changes[ $date_mods[$status] ] =   date('Y-m-d H:i:s');
			
			// update the status of the tickets
			$this->db->where_in('ticket_id', $ticket_ids);
			$this->db->update($this->tickets, $changes);
		}else{
				$this->session->set_flashdata('message', assemble_message('Cannot void transaction. Please untagged all cards to proceed.'));
				redirect('');
		
		} 	  
	 
		return $this->db->affected_rows();
	}
	
	function update_status_by_transaction($transaction_id, $status)
	{
		$changes = array('ticket_status' => $status );
		$date_mods = array('done' 		=> 'ticket_date_printed',
		                   'reserved' 	=> 'ticket_date_reserved',
						   'cancelled'	=> 'ticket_date_cancelled',
						   'reservation_cancelled'	=> 'ticket_date_cancelled',
						   'voided'		=> 'ticket_date_cancelled');
		$changes[ $date_mods[$status] ] =   date('Y-m-d H:i:s');
		
		// update the status of the tickets
		$this->db->where('ticket_transaction_id', $transaction_id);
		$this->db->update($this->tickets, $changes);
		
 
		  
		
		return $this->db->affected_rows();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * ticket_done
	 *
	 */
	function ticket_done($ticket_id)
	{
		// get ticket info
		$ticket = $this->get($ticket_id);
		
		// update the status of the tickets
		$changes = array(
			'ticket_user_id '		=> $this->session->userdata('user_id'),
			'ticket_branch_id '	=> $this->session->userdata('user_branch_id'),
			'ticket_terminal_id '	=> $this->session->userdata('user_terminal_id'),
			'ticket_status'			=> 'done',
			'ticket_date_printed'	=> date('Y-m-d H:i:s'),
		);
		$this->db->where('ticket_id', $ticket_id);
		$this->db->update($this->tickets, $changes);

		// check if it's time to mark the transaction as done as well
		$online_tickets = $this->get_tickets_v2($ticket->ticket_transaction_id, 'paid_online');
		if (count($online_tickets) == 0)
		{
			// update the transactions table
			$this->db->where('transaction_id', $ticket->ticket_transaction_id);
			$this->db->update($this->transactions, array('transaction_status' =>'done'));
		}
		
		return true;
	}

	// --------------------------------------------------------------------
	
	/**
	 * void
	 *
	 */
	function void($transaction, $tickets)
	{
		// get the section id first
		$this->db->select('ticket_section_id');
		$this->db->where('ticket_transaction_id', $transaction->transaction_id);
		$this->db->limit(1);
		$query = $this->db->getwhere($this->tickets);
		$section = $query->row();
		
		if (count($section) > 0)
		{		
			$ticket_ids = $this->input->post('tickets');
			
			// void the tickets
			$ticket_count = $this->update_status($ticket_ids, 'voided');
			
			// also void the transaction if all tickets are voided
			if(count($tickets) == $ticket_count)
			{
				$this->db->where('transaction_id', $transaction->transaction_id);
				$this->db->update($this->transactions, array('transaction_status' => 'voided'));
			}
			
			return array($section->ticket_section_id, $ticket_count);
		}
		else
		{
			return array(0,0);
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * void_ticket
	 *
	 */
	function void_ticket($ticket_id)
	{
		// get the section id first
		$this->db->select('ticket_section_id');
		$this->db->where('ticket_id', $ticket_id);
		$query = $this->db->getwhere($this->tickets);
		$section = $query->row();
		
		// void the tickets
		$ticket_count = $this->update_status($ticket_id, 'voided');
		
		return array($section->ticket_section_id, $ticket_count);
	}
	
	
	// --------------------------------------------------------------------
	
	/**
	 * cancel
	 *
	 */
	function cancel($transaction, $tickets)
	{
		// get the section id first
		$this->db->select('ticket_section_id');
		$this->db->where('ticket_transaction_id', $transaction->transaction_id);
		$this->db->limit(1);
		$query = $this->db->getwhere($this->tickets);
		$section = $query->row();
		
		if (count($section) > 0)
		{		
			$ticket_ids = $this->input->post('tickets');
			
			// void the tickets
			$ticket_count = $this->update_status($ticket_ids, 'cancelled');
			
			// also void the transaction if all tickets are voided
			if(count($tickets) == $ticket_count)
			{
				$this->db->where('transaction_id', $transaction->transaction_id);
				$this->db->update($this->transactions, array('transaction_status' => 'cancelled'));
			}
			
			return array($section->ticket_section_id, $ticket_count);
		}
		else
		{
			return array(0,0);
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * reservation_cancel
	 *
	 */
	function reservation_cancel($transaction, $tickets)
	{
		// get the section id first
		$this->db->select('ticket_section_id');
		$this->db->where('ticket_transaction_id', $transaction->transaction_id);
		$this->db->limit(1);
		$query = $this->db->getwhere($this->tickets);
		$section = $query->row();
		
		if (count($section) > 0)
		{		
			$ticket_ids = $this->input->post('tickets');
			//print_array($ticket_ids);
			//exit;
			
			// cancel the tickets
			$ticket_count = $this->update_status($ticket_ids, 'reservation_cancelled');
			
			// also cancel the transaction if all tickets are cancelled
			if(count($tickets) == $ticket_count)
			{
				$this->db->where('transaction_id', $transaction->transaction_id);
				$this->db->update($this->transactions, array('transaction_status' => 'reservation_cancelled'));
			}
			
			return array($section->ticket_section_id, $ticket_count);
		}
		else
		{
			return array(0,0);
		}
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * generate
	 *
	 * @access	public
	 */
    function generate($transaction_id, $type = 'paid')
    {
		$in = 72; // inch
		$right_panel_width = 2.5 * $in;
		$right_text_height = 80;
		$left_panel_width = 1.5 * $in;
		$line_top_margin = 29; // start of lines
		$line_text_margin = 0;
		$logo_height = 20;
		$logo_width = 0;
		$logo_count = 0;
		$logo_margin = 5;
		$text_margin = 2;
		$left_container_width = 88;
		$left_text_margin = 1;
		//$receipt_number = 0;
		
		if ($transaction_id == '') show_404();

		// get data
		$transaction = $this->transactions_model->get($transaction_id);
		$tickets = $this->get_tickets_by_transaction($transaction_id, '', $type);
		$event = $this->events_model->get($tickets[0]->ticket_event_id);
		$ticket_layout = $this->ticket_layouts_model->get($tickets[0]->ticket_event_id);
		$branch = $this->branches_model->get($transaction->transaction_branch_id);
		$payments = $this->payments_model->get_payments($transaction_id);
		if (count($payments) == 0)
		{
			$payment_type = 'CASH';
		}
		else
		{
			$payment_type = (count($payments) > 1) ? 'Multi' : $payments[0]->payment_type_code;
		}
			
		if ($ticket_layout->logo1 and file_exists($_SERVER["DOCUMENT_ROOT"] . '/uploads/' . $ticket_layout->logo1))
		{
			$logo1 = getimagesize('uploads/'.$ticket_layout->logo1);
 			$logo1_width = floor($logo1[0]*$logo_height/$logo1[1]);
			$logo_width += $logo1_width + $logo_margin;
		}
		
		if ($ticket_layout->logo2 and file_exists($_SERVER["DOCUMENT_ROOT"] . '/uploads/' . $ticket_layout->logo2))
		{
			$logo2 = getimagesize('uploads/'.$ticket_layout->logo2);
			$logo2_width = floor($logo2[0]*$logo_height/$logo2[1]);
			$logo_width += $logo2_width + $logo_margin;
		}
		
		if ($ticket_layout->logo3 and file_exists($_SERVER["DOCUMENT_ROOT"] . '/uploads/' . $ticket_layout->logo3))
		{
			$logo3 = getimagesize('uploads/'.$ticket_layout->logo3);
			$logo3_width = floor($logo3[0]*$logo_height/$logo3[1]);
			$logo_width += $logo3_width + $logo_margin;
		}
		
		if ($ticket_layout->logo4 and file_exists($_SERVER["DOCUMENT_ROOT"] . '/uploads/' . $ticket_layout->logo4))
		{
			$logo4 = getimagesize('uploads/'.$ticket_layout->logo4);
			$logo4_width = floor($logo4[0]*$logo_height/$logo4[1]);
			$logo_width += $logo4_width + $logo_margin;
		}
		
		if ($ticket_layout->logo5 and file_exists($_SERVER["DOCUMENT_ROOT"] . '/uploads/' . $ticket_layout->logo5))
		{
			$logo5 = getimagesize('uploads/'.$ticket_layout->logo5);
			$logo5_width = floor($logo5[0]*$logo_height/$logo5[1]);
			$logo_width += $logo5_width + $logo_margin;
		}
		$logo_left_margin = floor(($right_panel_width - $logo_width)/2);
		$logo_left_margin = ($logo_left_margin > 0) ? $logo_left_margin : 0;
		$logo_left_margin += $left_panel_width;	
		
		// include pdf libraries
		require(BASEPATH.'application/libraries/tfpdf/tfpdf.php');
		
		$pdf = new tFPDF('L', 'pt', array($in * 4, $in * 2));
		$pdf->AddFont('Arial','','arial.ttf',true);
		$pdf->AddFont('Arial','B','arialbd.ttf',true);
		$pdf->AddFont('Courier','','cour.ttf',true);
		$pdf->AddFont('Courier','B','courbd.ttf',true);
		$pdf->AddFont('Times','','times.ttf',true);
		$pdf->AddFont('Times','B','timesbd.ttf',true);
		
		$pdf->SetDrawColor(207, 207, 207);
			
		$count = 0;
		foreach ($tickets as $ticket)
		{

			if ($ticket->ticket_acknowledgment_receipt > 0)
			{
				$receipt_number = $ticket->ticket_acknowledgment_receipt;
			}
			else
			{
				if ($ticket->ticket_type_discount_type == 'Percentage' and $ticket->ticket_type_discount == 100)
				{
					$receipt_number = 'COMPLIMENTARY';
				}
				else
				{
					if ($branch->ar_printing == 1)
					{
						// get receipt number
						$receipt_number = $this->branches_model->get_last_receipt_number($branch->branch_id);
						
						// update transactions table
						$this->update_acknowledgment_receipt($ticket->ticket_id, $receipt_number);
					}
					else 
					{
						$receipt_number = " ";
					}
				}
			}

			
			$pdf->AddPage();
			$pdf->SetAutoPageBreak('Auto', 0);
			
			// get section serial number
			$serial_number = $this->prices_model->get_serial_number($ticket->ticket_price_id);

			
			// left pane
			
			$left_top = 42 + $in * 2 * $count;
			$left = 11;
			
			$size = 4;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', '', $size);
			$pdf->Cell($left_container_width, $size, 'EVENT', 0, 0, 'L');
			$left_top += $size + $left_text_margin;
			
			$size = 10;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', '', $size);
			$pdf->Cell($left_container_width, $size, strtoupper($event->event_code), 0, 0, 'R');
			$left_top += $size + $left_text_margin;
			
			$size = 4;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', '', $size);
			$pdf->Cell($left_container_width, $size, 'SECTION', 0, 0, 'L');
			$left_top += $size + $left_text_margin;
			
			$size = 4; $left_top -= 4;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', '', $size);
			$pdf->Cell($left_container_width, $size,'#'.sprintf('%05s', $ticket->ticket_id), 0, 0, 'R');
			$left_top += $size + $left_text_margin;

			$size = 8;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', 'B', $size);
			$pdf->Cell($left_container_width, $size, strtoupper($ticket->section_name), 0, 0, 'R');
			$left_top += $size + $left_text_margin;
			
			$size = 4;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', '', $size);
			$pdf->Cell($left_container_width, $size, 'ROW - SEAT', 0, 0, 'L');
			$left_top += $size + $left_text_margin;
			
			$size = 4; $left_top -= 4;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', '', $size);
			$pdf->Cell($left_container_width, $size, sprintf('%05s', $serial_number), 0, 0, 'R');
			$left_top += $size + $left_text_margin;
			
			$size = 8;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', 'B', $size);
			$ticket_row = ($ticket->ticket_row) ? $ticket->ticket_row . ' - ' : '';
			$pdf->Cell($left_container_width, $size, strtoupper($ticket_row . $ticket->ticket_seat), 0, 0, 'R');
			$left_top += $size + $left_text_margin;
			
			$size = 4;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', '', $size);
			$pdf->Cell($left_container_width, $size, 'TICKET PRICE', 0, 0, 'L');
			$left_top += $size + $left_text_margin;
		
			$size = 5; $left_top -= 6;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', 'B', $size);
			$text = strtoupper($ticket->ticket_type_code);
			$text .= ($payment_type) ? '/' . strtoupper($payment_type) : '';
			$pdf->Cell($left_container_width, $size, $text , 0, 0, 'R');
			$left_top += $size + $left_text_margin;
			
			if ($ticket->ticket_type_discount_type == 'Amount')
			{
				$ticket_price = ceil($ticket->price_price - $ticket->ticket_type_discount);
			}
            elseif ($ticket->ticket_type_discount_type == 'Percentage')
			{
            	$ticket_price= ceil($ticket->price_price - (($ticket->price_price * $ticket->ticket_type_discount)/100));
			}
			
			$size = 8;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', '', $size);
			$pdf->Cell($left_container_width, $size, 'Php **' . number_format($ticket_price) . '**', 0, 0, 'R');
			$left_top += $size + $left_text_margin;
			
			$size = 4;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', '', $size);
			if ($receipt_number != 'COMPLIMENTARY' && $branch->ar_printing == 1)
					$pdf->Cell($left_container_width, $size, 'AR No.', 0, 0, 'L');
			$left_top += $size + $left_text_margin;

			$size = 5; $left_top -= 6;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', 'B', $size);
			$text = '   TN: ' . sprintf('%05s', $transaction->transaction_id);
			$pdf->Cell($left_container_width, $size, $text , 0, 0, 'R');
			$left_top += $size + $left_text_margin;
			
			$size = 8;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', '', $size);
			if (is_numeric($receipt_number)) {
				$pdf->Cell($left_container_width, $size, sprintf('%07s', $receipt_number), 0, 0, 'R');
			} else {
				$pdf->Cell($left_container_width, $size, $receipt_number, 0, 0, 'R');
			}
			$left_top += $size + $left_text_margin;
			
			
			$isweb = '';
			if ($transaction->transaction_user_id == $this->config->item('online_seller_id')) {
				$isweb = 'WEB';
			}
			
			$size = 4; // $left_top += 2;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', '', $size);
			$pdf->Cell($left_container_width, $size, $isweb, 0, 0, 'R');
			$left_top += $size + $left_text_margin;

			// $size = 4; $left_top += 2;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', '', $size);
			$pdf->Cell($left_container_width, $size, mysqldatetime_to_date($ticket->transaction_date, $format = "m-d-Y"), 0, 0, 'L');
			
			$size = 4;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', '', $size);
			$pdf->Cell($left_container_width, $size, $transaction->terminal_code, 0, 0, 'R');
			$left_top += $size + $left_text_margin;
			
			$size = 4;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', '', $size);
			$pdf->Cell($left_container_width, $size, mysqldatetime_to_date($ticket->transaction_date, $format = "h:i:sA"), 0, 0, 'L');
			
			$size = 4;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', '', $size);
			$pdf->Cell($left_container_width, $size, strtoupper($this->session->userdata('username')), 0, 0, 'R');
			$left_top += $size + $left_text_margin;
			
			// right pane
			
			// reset the left margin
			$left_margin = $logo_left_margin;
			
			if ($ticket_layout->logo1 and isset($logo1))
			{
				$pdf->Image('uploads/'.$ticket_layout->logo1, $left_margin, 5 + $in * 2 * $count, 0, $logo_height);
				$left_margin += $logo1_width + $logo_margin;
			}
			
			if ($ticket_layout->logo2 and isset($logo2))
			{
				$pdf->Image('uploads/'.$ticket_layout->logo2, $left_margin, 5 + $in * 2 * $count, 0, $logo_height);
				$left_margin += $logo2_width + $logo_margin;
			}
			
			if ($ticket_layout->logo3 and isset($logo3))
			{	
				$pdf->Image('uploads/'.$ticket_layout->logo3, $left_margin, 5 + $in * 2 * $count, 0, $logo_height);
				$left_margin += $logo3_width + $logo_margin;
			}
			
			if ($ticket_layout->logo4 and isset($logo4))
			{	
				$pdf->Image('uploads/'.$ticket_layout->logo4, $left_margin, 5 + $in * 2 * $count, 0, $logo_height);
				$left_margin += $logo4_width + $logo_margin;
			}
			
			if ($ticket_layout->logo5 and isset($logo5))
			{	
				$pdf->Image('uploads/'.$ticket_layout->logo5, $left_margin, 5 + $in * 2 * $count, 0, $logo_height);
			}
			
			// reset the top margin
			$top = $line_top_margin;
			
			// line 1
			//if ($ticket_layout->ticket_text_1)
			//{
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont($ticket_layout->ticket_font_face_1, '', $ticket_layout->ticket_font_size_1);
				$pdf->Cell($in * 2.5, $ticket_layout->ticket_font_size_1, $ticket_layout->ticket_text_1, 0, 0, 'C');
				$top += $ticket_layout->ticket_font_size_1 + $text_margin;
			//}
			
			// line 2
			//if ($ticket_layout->ticket_text_2)
			//{
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont($ticket_layout->ticket_font_face_2, '', $ticket_layout->ticket_font_size_2);
				$pdf->Cell($in * 2.5, $ticket_layout->ticket_font_size_2, $ticket_layout->ticket_text_2, 0, 0, 'C');
				$top += $ticket_layout->ticket_font_size_2 + $text_margin;
			//}
			
			// line 3
			//if ($ticket_layout->ticket_text_3)
			//{
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont($ticket_layout->ticket_font_face_3, 'B', $ticket_layout->ticket_font_size_3);
				$pdf->Cell($in * 2.5, $ticket_layout->ticket_font_size_3, $ticket_layout->ticket_text_3, 0, 0, 'C');
				$top += $ticket_layout->ticket_font_size_3 + $text_margin;
			//}
			
			// line 4
			//if ($ticket_layout->ticket_text_4)
			//{
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont($ticket_layout->ticket_font_face_4, 'B', $ticket_layout->ticket_font_size_4);
				$pdf->Cell($in * 2.5, $ticket_layout->ticket_font_size_4, $ticket_layout->ticket_text_4, 0, 0, 'C');
				$top += $ticket_layout->ticket_font_size_4 + $text_margin;
			//}
			
			// line 5
			//if ($ticket_layout->ticket_text_5)
			//{
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont($ticket_layout->ticket_font_face_5, '', $ticket_layout->ticket_font_size_5);
				$pdf->Cell($in * 2.5, $ticket_layout->ticket_font_size_5, $ticket_layout->ticket_text_5, 0, 0, 'C');
				$top += $ticket_layout->ticket_font_size_5 + $text_margin;
			//}
			
			// line 6
			//if ($ticket_layout->ticket_text_6)
			//{
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont($ticket_layout->ticket_font_face_6, '', $ticket_layout->ticket_font_size_6);
				$pdf->Cell($in * 2.5, $ticket_layout->ticket_font_size_6, $ticket_layout->ticket_text_6, 0, 0, 'C');
				$top += $ticket_layout->ticket_font_size_6 + $text_margin;
			//}

			// line 7
			if ($ticket_layout->ticket_text_7)
			{
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont($ticket_layout->ticket_font_face_7, '', $ticket_layout->ticket_font_size_7);
				$pdf->Cell($in * 2.5, $ticket_layout->ticket_font_size_7, $ticket_layout->ticket_text_7, 0, 0, 'C');
			}

			
			// section
			$pdf->SetXY(113, 90 + $in * 2 * $count); 
			$pdf->SetFont('Arial', '', 4);
			$pdf->Cell($in * 2.5, 4, 'SECTION', 0, 0, 'L');
			
			$pdf->SetXY(113, 95 + $in * 2 * $count); 
			$pdf->SetFont('Arial', 'B', 8);
			$pdf->Cell($in * 2.5, 8, strtoupper($ticket->section_name), 0, 0, 'L');
			
			// row - seat
			$pdf->SetXY(113, 106 + $in * 2 * $count); 
			$pdf->SetFont('Arial', '', 4);
			$pdf->Cell(50, 4, 'ROW - SEAT', 0, 0, 'L');
			
			$pdf->SetXY(113, 110 + $in * 2 * $count); 
			$pdf->SetFont('Arial', 'B', 8);
			$ticket_row = ($ticket->ticket_row) ? $ticket->ticket_row . ' - ' : '';
			$pdf->Cell($in * 2.5, 8, strtoupper($ticket_row . $ticket->ticket_seat), 0, 0, 'L');
			
			// receipt
			//$pdf->SetXY(180, 106 + $in * 2 * $count); 
			//$pdf->SetFont('Arial', '', 4);
			//$pdf->Cell($in * 2.5, 4, 'ACK RECEIPT #', 0, 0, 'L');
			
			//$pdf->SetXY(180, 110 + $in * 2 * $count); 
			//$pdf->SetFont('Arial', '', 8);
			//$pdf->Cell($in * 2.5, 8, sprintf('%07s', $receipt_number), 0, 0, 'L');
			
			// price
			$pdf->SetXY(180, 106 + $in * 2 * $count); 
			$pdf->SetFont('Arial', '', 4);
			$pdf->Cell(30, 4, 'PRICE', 0, 0, 'L');
			
			$pdf->SetXY(220, 106 + $in * 2 * $count); 
			$pdf->SetFont('Arial', '', 4);
			$text = strtoupper($ticket->ticket_type_code);
			$text .= ($payment_type) ? '/' . strtoupper($payment_type) : '';
			$pdf->Cell(20, 4, $text, 0, 0, 'R');
			
			$pdf->SetXY(180, 110 + $in * 2 * $count); 
			$pdf->SetFont('Arial', '', 8);
			$pdf->Cell($in * 2.5, 8, 'Php **' . number_format($ticket_price) . '**', 0, 0, 'L');
			
	
			// barcode
			// $pdf->SetXY(247, 88 + $in * 2 * $count); 
			// $pdf->Cell(34, 34, '', 1, 1, 'L');
			
			// others			
			$pdf->SetXY(113, 121 + $in * 2 * $count); 
			$pdf->SetFont('Arial', '', 4);
			$pdf->Cell($in * 2.5, 5, sprintf('%05s', $serial_number) . '   ' .  strtoupper($transaction->terminal_code) . '   ' . strtoupper($this->session->userdata('username')) . '   ' . mysqldatetime_to_date($ticket->transaction_date, $format = "m-d-Y h:iA") . '   TN: ' . sprintf('%05s', $transaction->transaction_id) , 0, 0, 'L');
			
			// para sa BIR
			$pdf->SetXY(113, 125 + $in * 2 * $count); 
			$pdf->SetFont('Arial', '', 4);
			if ($receipt_number == 'COMPLIMENTARY')
			{
				$pdf->Cell($in * 2.5, 5, 'COMPLIMENTARY - NOT FOR SALE     ' . strtoupper($this->config->item('company_name')) . '  ' . strtoupper($branch->branch_city), 0, 0, 'L');
			}
			else
			{
				if ($branch->ar_printing == 1)
				{
					$pdf->Cell($in * 2.5, 5, 'AR No. ' . sprintf('%07s', $receipt_number) . '  ' . strtoupper($this->config->item('company_name')) . '  ' . strtoupper($branch->branch_city) . '  TIN: ' . $branch->branch_tin  , 0, 0, 'L');
				}
				else 
				{
					$pdf->Cell($in * 2.5, 5, strtoupper($this->config->item('company_name')) . '  ' . strtoupper($branch->branch_city) . '  TIN: ' . $branch->branch_tin  , 0, 0, 'L');
				}
			}
		}
		$has_extra_fee = (!empty($event->event_reservation_fee) && is_numeric($event->event_reservation_fee));
		
		if ($has_extra_fee) {
			$has_extra_fee = ($event->event_reservation_fee > 0);
		}
		
    	if ($has_extra_fee && $this->session->userdata('claim') == 'claim' && $branch->or_printing == 1)
		{
			//echo 'hohoy!';
			
			$pdf->AddPage();
			$pdf->SetAutoPageBreak('Auto', 0);
			
			$num_of_tickets = count($tickets);
			$total_resfee = $num_of_tickets * $event->event_reservation_fee;
			$vatable = $total_resfee / 1.12;
			
			$top = $line_top_margin;
			
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont('Arial', '', 4);
				$pdf->Cell($in * 2.5, 4, 'Official Receipt', 0, 0, 'C');
				$top += 4 + $text_margin;
				
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont('Arial', '', 4);
				$pdf->Cell($in * 2.5, 4, 'SM PRIME HOLDINGS, INC.', 0, 0, 'C');
				$top += 4 + $text_margin;
				
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont('Arial', '', 4);
				$pdf->Cell($in * 2.5, 4, 'Bldg. A, SM Corporate Offices', 0, 0, 'C');
				$top += 4 + $text_margin;
				
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont('Arial', '', 4);
				$pdf->Cell($in * 2.5, 4, 'JW Diokno Blvd., MOA Complex, Pasay City', 0, 0, 'C');
				$top += 4 + $text_margin;
				
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont('Arial', '', 4);
				$pdf->Cell($in * 2.5, 4, 'TIN 003-058-789-041 VAT', 0, 0, 'C');
				$top += 4 + $text_margin;
				
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont('Arial', '', 4);
				$pdf->Cell($in * 2.5, 4, 'Convenience Charge', 0, 0, 'L');
				$top += 4 + $text_margin;
				
				$pdf->SetXY(150, $top + $in * 2 * $count); 
				$pdf->SetFont('Arial', 'U', 4);
				$pdf->Cell($in * 2.75, 4, 'Quantity', 0, 0, 'L');
				//$top += 10 + $text_margin;
				
				$pdf->SetXY(210, $top + $in * 2 * $count); 
				$pdf->SetFont('Arial', 'U', 4);
				$pdf->Cell($in * 2.5, 4, 'Unit Price', 0, 0, 'L');
				$top += 4 + $text_margin;
				
				$pdf->SetXY(150, $top + $in * 2 * $count); 
				$pdf->SetFont('Arial', '', 4);
				$pdf->Cell($in * 2.5, 4, $num_of_tickets, 0, 0, 'L');
				
				$pdf->SetXY(180, $top + $in * 2 * $count); 
				$pdf->SetFont('Arial', '', 4);
				$pdf->Cell($in * 2.5, 4, 'x', 0, 0, 'L');
				
				if (!empty($event->event_reservation_fee))
				{
					$pdf->SetXY(210, $top + $in * 2 * $count); 
					$pdf->SetFont('Arial', '', 4);
					$pdf->Cell($in * 2.5, 4, 'Php '.number_format($event->event_reservation_fee, 2), 0, 0, 'L');
				}
				else
				{
					$pdf->SetXY(210, $top + $in * 2 * $count); 
					$pdf->SetFont('Arial', '', 4);
					$pdf->Cell($in * 2.5, 4, 'Php '. 0.00, 0, 0, 'L');
				}
				
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont('Arial', '', 4);
				$pdf->Cell($in * 2.5, 4, 'Php '.number_format($total_resfee, 2), 0, 0, 'R');
				$top += 4 + $text_margin;
				
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont('Arial', '', 4);
				$pdf->Cell($in * 2.5, 4, 'VATable Sales', 0, 0, 'L');
				
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont('Arial', '', 4);
				$pdf->Cell($in * 2.5, 4, 'Php '.number_format($vatable, 2), 0, 0, 'R');
				$top += 4 + $text_margin;
				
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont('Arial', '', 4);
				$pdf->Cell($in * 2.5, 4, 'VAT Amount', 0, 0, 'L');
				
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont('Arial', '', 4);
				$pdf->Cell($in * 2.5, 4, 'Php '.number_format($total_resfee - $vatable, 2), 0, 0, 'R');
				$top += 4 + $text_margin;
				
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont('Arial', '', 4);
				$pdf->Cell($in * 2.5, 4, 'Official Receipt No. '.str_pad($transaction->transaction_receipt_number, 6, 0, STR_PAD_LEFT), 0, 0, 'C');
				$top += 4 + $text_margin;
				
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont('Arial', '', 4);
				$pdf->Cell($in * 2.5, 4, 'Transaction ID '.$transaction->transaction_id, 0, 0, 'C');
				$top += 4 + $text_margin;
				
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont('Arial', '', 4);
				$pdf->Cell($in * 2.5, 4, $transaction->transaction_date, 0, 0, 'C');
				$top += 4 + $text_margin;
				
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont('Arial', '', 4);
				$pdf->Cell($in * 2.5, 4, 'This serves as your official receipt.', 0, 0, 'C');
				$top += 4 + $text_margin;
		}
		
		$pdf->Output($_SERVER["DOCUMENT_ROOT"] . '/uploads/'.md5($transaction_id).'.pdf', 'F');
		$pdf->Close(); 
    }
	
	// --------------------------------------------------------------------
	
	/**
	 * generate_single
	 *
	 * @access	public
	 */
    function generate_single($ticket_id)
    {
		$in = 72; // inch
		$right_panel_width = 2.5 * $in;
		$right_text_height = 80;
		$left_panel_width = 1.5 * $in;
		$line_top_margin = 29; // start of lines
		$line_text_margin = 0;
		$logo_height = 20;
		$logo_width = 0;
		$logo_count = 0;
		$logo_margin = 5;
		$text_margin = 2;
		$left_container_width = 88;
		$left_text_margin = 1;
		
		if ($ticket_id == '') show_404();

		$ticket = $this->get($ticket_id);
		
		if (count($ticket) == 0) show_404();
		
		// get data
		$transaction = $this->transactions_model->get($ticket->ticket_transaction_id);
		$event = $this->events_model->get($ticket->ticket_event_id);
		$ticket_layout = $this->ticket_layouts_model->get($ticket->ticket_event_id);
		$branch = $this->branches_model->get($transaction->transaction_branch_id);
		$payments = $this->payments_model->get_payments($transaction->transaction_id);
		if (count($payments) == 0)
		{
			$payment_type = 'CASH';
		}
		else
		{
			$payment_type = (count($payments) > 1) ? 'Multi' : $payments[0]->payment_type_code;
		}
			
		if ($ticket_layout->logo1 and file_exists($_SERVER["DOCUMENT_ROOT"] . '/uploads/' . $ticket_layout->logo1))
		{
			$logo1 = getimagesize('uploads/'.$ticket_layout->logo1);
 			$logo1_width = floor($logo1[0]*$logo_height/$logo1[1]);
			$logo_width += $logo1_width + $logo_margin;
		}
		
		if ($ticket_layout->logo2 and file_exists($_SERVER["DOCUMENT_ROOT"] . '/uploads/' . $ticket_layout->logo2))
		{
			$logo2 = getimagesize('uploads/'.$ticket_layout->logo2);
			$logo2_width = floor($logo2[0]*$logo_height/$logo2[1]);
			$logo_width += $logo2_width + $logo_margin;
		}
		
		if ($ticket_layout->logo3 and file_exists($_SERVER["DOCUMENT_ROOT"] . '/uploads/' . $ticket_layout->logo3))
		{
			$logo3 = getimagesize('uploads/'.$ticket_layout->logo3);
			$logo3_width = floor($logo3[0]*$logo_height/$logo3[1]);
			$logo_width += $logo3_width + $logo_margin;
		}
		
		if ($ticket_layout->logo4 and file_exists($_SERVER["DOCUMENT_ROOT"] . '/uploads/' . $ticket_layout->logo4))
		{
			$logo4 = getimagesize('uploads/'.$ticket_layout->logo4);
			$logo4_width = floor($logo4[0]*$logo_height/$logo4[1]);
			$logo_width += $logo4_width + $logo_margin;
		}
		
		if ($ticket_layout->logo5 and file_exists($_SERVER["DOCUMENT_ROOT"] . '/uploads/' . $ticket_layout->logo5))
		{
			$logo5 = getimagesize('uploads/'.$ticket_layout->logo5);
			$logo5_width = floor($logo5[0]*$logo_height/$logo5[1]);
			$logo_width += $logo5_width + $logo_margin;
		}
		$logo_left_margin = floor(($right_panel_width - $logo_width)/2);
		$logo_left_margin = ($logo_left_margin > 0) ? $logo_left_margin : 0;
		$logo_left_margin += $left_panel_width;	
		
		// include pdf libraries
		require(BASEPATH.'application/libraries/tfpdf/tfpdf.php');
		
        $pdf = new tFPDF('L', 'pt', array($in * 4, $in * 2));
		$pdf->AddFont('Arial','','arial.ttf',true);
		$pdf->AddFont('Arial','B','arialbd.ttf',true);
		$pdf->AddFont('Courier','','cour.ttf',true);
		$pdf->AddFont('Courier','B','courbd.ttf',true);
		$pdf->AddFont('Times','','times.ttf',true);
		$pdf->AddFont('Times','B','timesbd.ttf',true);
		
		$pdf->SetDrawColor(207, 207, 207);
			
		$count = 0;

			if ($ticket->ticket_acknowledgment_receipt > 0)
			{
				$receipt_number = $ticket->ticket_acknowledgment_receipt;
			}
			else
			{
				if ($ticket->ticket_type_discount_type == 'Percentage' and $ticket->ticket_type_discount == 100)
				{
					$receipt_number = 'COMPLIMENTARY';
				}
				else
				{
					// get receipt number
					$receipt_number = $this->configurations_model->get_last_receipt_number();
					
					// update transactions table
					$this->update_acknowledgment_receipt($ticket->ticket_id, $receipt_number);
				}
			}

			
			$pdf->AddPage();
			$pdf->SetAutoPageBreak('Auto', 0);
			
			// get section serial number
			$serial_number = $this->prices_model->get_serial_number($ticket->ticket_price_id);

			
			// left pane
			
			$left_top = 42 + $in * 2 * $count;
			$left = 11;
			
			$size = 4;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', '', $size);
			$pdf->Cell($left_container_width, $size, 'EVENT', 0, 0, 'L');
			$left_top += $size + $left_text_margin;
			
			$size = 10;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', '', $size);
			$pdf->Cell($left_container_width, $size, strtoupper($event->event_code), 0, 0, 'R');
			$left_top += $size + $left_text_margin;
			
			$size = 4;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', '', $size);
			$pdf->Cell($left_container_width, $size, 'SECTION', 0, 0, 'L');
			$left_top += $size + $left_text_margin;
			
			$size = 8;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', 'B', $size);
			$pdf->Cell($left_container_width, $size, strtoupper($ticket->section_name), 0, 0, 'R');
			$left_top += $size + $left_text_margin;
			
			$size = 4;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', '', $size);
			$pdf->Cell($left_container_width, $size, 'ROW - SEAT', 0, 0, 'L');
			$left_top += $size + $left_text_margin;
			
			$size = 4; $left_top -= 4;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', '', $size);
			$pdf->Cell($left_container_width, $size, sprintf('%05s', $serial_number), 0, 0, 'R');
			$left_top += $size + $left_text_margin;
			
			$size = 8;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', 'B', $size);
			$ticket_row = ($ticket->ticket_row) ? $ticket->ticket_row . ' - ' : '';
			$pdf->Cell($left_container_width, $size, strtoupper($ticket_row . $ticket->ticket_seat), 0, 0, 'R');
			$left_top += $size + $left_text_margin;
			
			$size = 4;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', '', $size);
			$pdf->Cell($left_container_width, $size, 'TICKET PRICE', 0, 0, 'L');
			$left_top += $size + $left_text_margin;
		
			$size = 5; $left_top -= 6;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', 'B', $size);
			$text = strtoupper($ticket->ticket_type_code);
			$text .= ($payment_type) ? '/' . strtoupper($payment_type) : '';
			$pdf->Cell($left_container_width, $size, $text , 0, 0, 'R');
			$left_top += $size + $left_text_margin;
			
			if ($ticket->ticket_type_discount_type == 'Amount')
			{
				$ticket_price = ceil($ticket->price_price - $ticket->ticket_type_discount);
			}
            elseif ($ticket->ticket_type_discount_type == 'Percentage')
			{
            	$ticket_price= ceil($ticket->price_price - (($ticket->price_price * $ticket->ticket_type_discount)/100));
			}
			
			$size = 8;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', '', $size);
			$pdf->Cell($left_container_width, $size, 'Php **' . number_format($ticket_price) . '**', 0, 0, 'R');
			$left_top += $size + $left_text_margin;
			
			$size = 4;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', '', $size);
			if ($receipt_number != 'COMPLIMENTARY')
				$pdf->Cell($left_container_width, $size, 'AR No.', 0, 0, 'L');
			$left_top += $size + $left_text_margin;
			
			$size = 5; $left_top -= 6;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', 'B', $size);
			$text = '   TN: ' . sprintf('%05s', $transaction->transaction_id);
			$pdf->Cell($left_container_width, $size, $text , 0, 0, 'R');
			$left_top += $size + $left_text_margin;

			$size = 8;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', '', $size);
			$pdf->Cell($left_container_width, $size, sprintf('%07s', $receipt_number), 0, 0, 'R');
			$left_top += $size + $left_text_margin;
			
			$size = 4; $left_top += 2;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', '', $size);
			$pdf->Cell($left_container_width, $size, mysqldatetime_to_date($ticket->transaction_date, $format = "m-d-Y"), 0, 0, 'L');
			
			$size = 4;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', '', $size);
			$pdf->Cell($left_container_width, $size, $transaction->terminal_code, 0, 0, 'R');
			$left_top += $size + $left_text_margin;
			
			$size = 4;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', '', $size);
			$pdf->Cell($left_container_width, $size, mysqldatetime_to_date($ticket->transaction_date, $format = "h:i:sA"), 0, 0, 'L');
			
			$size = 4;
			$pdf->SetXY($left, $left_top); 
			$pdf->SetFont('Arial', '', $size);
			$pdf->Cell($left_container_width, $size, strtoupper($this->session->userdata('username')), 0, 0, 'R');
			$left_top += $size + $left_text_margin;
			
			// right pane
			
			// reset the left margin
			$left_margin = $logo_left_margin;
			
			if ($ticket_layout->logo1 and isset($logo1))
			{
				$pdf->Image('uploads/'.$ticket_layout->logo1, $left_margin, 5 + $in * 2 * $count, 0, $logo_height);
				$left_margin += $logo1_width + $logo_margin;
			}
			
			if ($ticket_layout->logo2 and isset($logo2))
			{
				$pdf->Image('uploads/'.$ticket_layout->logo2, $left_margin, 5 + $in * 2 * $count, 0, $logo_height);
				$left_margin += $logo2_width + $logo_margin;
			}
			
			if ($ticket_layout->logo3 and isset($logo3))
			{	
				$pdf->Image('uploads/'.$ticket_layout->logo3, $left_margin, 5 + $in * 2 * $count, 0, $logo_height);
				$left_margin += $logo3_width + $logo_margin;
			}
			
			if ($ticket_layout->logo4 and isset($logo4))
			{	
				$pdf->Image('uploads/'.$ticket_layout->logo4, $left_margin, 5 + $in * 2 * $count, 0, $logo_height);
				$left_margin += $logo4_width + $logo_margin;
			}
			
			if ($ticket_layout->logo5 and isset($logo5))
			{	
				$pdf->Image('uploads/'.$ticket_layout->logo5, $left_margin, 5 + $in * 2 * $count, 0, $logo_height);
			}
			
			// reset the top margin
			$top = $line_top_margin;
			
			// line 1
			//if ($ticket_layout->ticket_text_1)
			//{
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont($ticket_layout->ticket_font_face_1, '', $ticket_layout->ticket_font_size_1);
				$pdf->Cell($in * 2.5, $ticket_layout->ticket_font_size_1, $ticket_layout->ticket_text_1, 0, 0, 'C');
				$top += $ticket_layout->ticket_font_size_1 + $text_margin;
			//}
			
			// line 2
			//if ($ticket_layout->ticket_text_2)
			//{
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont($ticket_layout->ticket_font_face_2, '', $ticket_layout->ticket_font_size_2);
				$pdf->Cell($in * 2.5, $ticket_layout->ticket_font_size_2, $ticket_layout->ticket_text_2, 0, 0, 'C');
				$top += $ticket_layout->ticket_font_size_2 + $text_margin;
			//}
			
			// line 3
			//if ($ticket_layout->ticket_text_3)
			//{
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont($ticket_layout->ticket_font_face_3, '', $ticket_layout->ticket_font_size_3);
				$pdf->Cell($in * 2.5, $ticket_layout->ticket_font_size_3, $ticket_layout->ticket_text_3, 0, 0, 'C');
				$top += $ticket_layout->ticket_font_size_3 + $text_margin;
			//}
			
			// line 4
			//if ($ticket_layout->ticket_text_4)
			//{
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont($ticket_layout->ticket_font_face_4, '', $ticket_layout->ticket_font_size_4);
				$pdf->Cell($in * 2.5, $ticket_layout->ticket_font_size_4, $ticket_layout->ticket_text_4, 0, 0, 'C');
				$top += $ticket_layout->ticket_font_size_4 + $text_margin;
			//}
			
			// line 5
			//if ($ticket_layout->ticket_text_5)
			//{
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont($ticket_layout->ticket_font_face_5, '', $ticket_layout->ticket_font_size_5);
				$pdf->Cell($in * 2.5, $ticket_layout->ticket_font_size_5, $ticket_layout->ticket_text_5, 0, 0, 'C');
				$top += $ticket_layout->ticket_font_size_5 + $text_margin;
			//}
			
			// line 6
			//if ($ticket_layout->ticket_text_6)
			//{
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont($ticket_layout->ticket_font_face_6, '', $ticket_layout->ticket_font_size_6);
				$pdf->Cell($in * 2.5, $ticket_layout->ticket_font_size_6, $ticket_layout->ticket_text_6, 0, 0, 'C');
				$top += $ticket_layout->ticket_font_size_6 + $text_margin;
			//}

			// line 7
			if ($ticket_layout->ticket_text_7)
			{
				$pdf->SetXY(110, $top + $in * 2 * $count); 
				$pdf->SetFont($ticket_layout->ticket_font_face_7, '', $ticket_layout->ticket_font_size_7);
				$pdf->Cell($in * 2.5, $ticket_layout->ticket_font_size_7, $ticket_layout->ticket_text_7, 0, 0, 'C');
			}

			
			// section
			$pdf->SetXY(113, 90 + $in * 2 * $count); 
			$pdf->SetFont('Arial', '', 4);
			$pdf->Cell($in * 2.5, 4, 'SECTION', 0, 0, 'L');
			
			$pdf->SetXY(113, 95 + $in * 2 * $count); 
			$pdf->SetFont('Arial', 'B', 8);
			$pdf->Cell($in * 2.5, 8, strtoupper($ticket->section_name), 0, 0, 'L');
			
			// row - seat
			$pdf->SetXY(113, 106 + $in * 2 * $count); 
			$pdf->SetFont('Arial', '', 4);
			$pdf->Cell(50, 4, 'ROW - SEAT', 0, 0, 'L');
			
			$pdf->SetXY(113, 110 + $in * 2 * $count); 
			$pdf->SetFont('Arial', 'B', 8);
			$ticket_row = ($ticket->ticket_row) ? $ticket->ticket_row . ' - ' : '';
			$pdf->Cell($in * 2.5, 8, strtoupper($ticket_row . $ticket->ticket_seat), 0, 0, 'L');
			
			// receipt
			//$pdf->SetXY(180, 106 + $in * 2 * $count); 
			//$pdf->SetFont('Arial', '', 4);
			//$pdf->Cell($in * 2.5, 4, 'ACK RECEIPT #', 0, 0, 'L');
			
			//$pdf->SetXY(180, 110 + $in * 2 * $count); 
			//$pdf->SetFont('Arial', '', 8);
			//$pdf->Cell($in * 2.5, 8, sprintf('%07s', $receipt_number), 0, 0, 'L');
			
			// price
			$pdf->SetXY(180, 106 + $in * 2 * $count); 
			$pdf->SetFont('Arial', '', 4);
			$pdf->Cell(30, 4, 'PRICE', 0, 0, 'L');
			
			$pdf->SetXY(220, 106 + $in * 2 * $count); 
			$pdf->SetFont('Arial', '', 4);
			$text = strtoupper($ticket->ticket_type_code);
			$text .= ($payment_type) ? '/' . strtoupper($payment_type) : '';
			$pdf->Cell(20, 4, $text, 0, 0, 'R');
			
			$pdf->SetXY(180, 110 + $in * 2 * $count); 
			$pdf->SetFont('Arial', '', 8);
			$pdf->Cell($in * 2.5, 8, 'Php **' . number_format($ticket_price) . '**', 0, 0, 'L');
			
	
			// barcode
			// $pdf->SetXY(247, 88 + $in * 2 * $count); 
			// $pdf->Cell(34, 34, '', 1, 1, 'L');
			
			// others			
			$pdf->SetXY(113, 121 + $in * 2 * $count); 
			$pdf->SetFont('Arial', '', 4);
			$pdf->Cell($in * 2.5, 5, sprintf('%05s', $serial_number) . '   ' .  strtoupper($transaction->terminal_code) . '   ' . strtoupper($this->session->userdata('username')) . '   ' . mysqldatetime_to_date($ticket->transaction_date, $format = "m-d-Y h:iA") . '   TN: ' . sprintf('%05s', $transaction->transaction_id) , 0, 0, 'L');
			
			// para sa BIR
			$pdf->SetXY(113, 125 + $in * 2 * $count); 
			$pdf->SetFont('Arial', '', 4);
			if ($receipt_number == 'COMPLIMENTARY')
			{
				$pdf->Cell($in * 2.5, 5, 'COMPLIMENTARY - NOT FOR SALE     ' . strtoupper($this->config->item('company_name')) . '  ' . strtoupper($branch->branch_city), 0, 0, 'L');
			}
			else
			{
				$pdf->Cell($in * 2.5, 5, 'AR No. ' . sprintf('%07s', $receipt_number) . '  ' . strtoupper($this->config->item('company_name')) . '  ' . strtoupper($branch->branch_city) . '  TIN: ' . $branch->branch_tin  , 0, 0, 'L');
			}

	
		$pdf->Output($_SERVER["DOCUMENT_ROOT"] . '/uploads/'.md5($ticket_id).'.pdf', 'F');
		$pdf->Close(); 
		
    }

		
	function get_event_id($trans_id= false){
	
	
		$this->db->select('ticket_event_id, price_package, price_id');
		$this->db->join($this->prices, 'p.price_id = ti.ticket_price_id', 'left');
		$this->db->where('ticket_transaction_id', $trans_id);
		$this->db->limit(1);
		return $this->db->get('tickets ti')->row();
	
	}
	 
	
	function add_shuttle_transaction($tickets){
		
		if ($this->session->userdata('transaction_type') == 'reserve'){ 
			$trans_type = 4; 
		}else{ 
			$trans_type = 1; 
		}
		
		$shuttle_qty = $this->session->userdata('shuttle_qty');
 	
 		$bus_plate_num = $this->session->userdata('shuttle_plate');
		$event_key = $this->session->userdata('cei');
		$session_id = $this->session->userdata('customer_session_id');
		// $ticket_id = '';
	 
		for ($x = 0; $x < $shuttle_qty; $x++) {
		
			$content = http_build_query (array (
			'event_key' => $event_key,
			'bus_plate_num' =>$bus_plate_num, 
 			'ticket_id' =>$tickets[$x], 
			'ticket_session_id' =>$session_id, 
 			'trans_type' =>$trans_type,
			));

			$context = stream_context_create (array (
				'http' => array (	 
				'method' => 'POST',
				'header' => "Connection: close\r\n".
				"Content-Type: application/x-www-form-urlencoded\r\n",
				'content' => $content,
				)
			));
			
			$res = file_get_contents($this->shuttle_url, null, $context);
		
		}
		
		// echo $xml;
		
		$this->session->set_userdata(array(
			'shuttle_qty' 		=> 0, 
			'shuttle_plate' 	=> '',
			 
		));
	
	}  
	
	function add_shuttle_transaction_reserve($result){
		
		
		$tickets = array();
		foreach($result as $x){
		
			
		$tickets[] = $x->ticket_id;
		
		}
		
		
		if ($this->session->userdata('transaction_type') == 'reserve'){ 
			$trans_type = 4; 
		}else{ 
			$trans_type = 1; 
		}
		
		
		
		
		
		$shuttle_qty = $this->session->userdata('shuttle_qty');
 	
 		$bus_plate_num = $this->session->userdata('shuttle_plate');
		$event_key = $this->session->userdata('cei');
		$session_id = $this->session->userdata('customer_session_id');
		// $ticket_id = '';
	 
		for ($x = 0; $x < $shuttle_qty; $x++) {
		
			$content = http_build_query (array (
			'event_key' => $event_key,
			'bus_plate_num' =>$bus_plate_num, 
 			'ticket_id' =>$tickets[$x], 
			'ticket_session_id' =>$session_id, 
 			'trans_type' =>$trans_type,
			));

			$context = stream_context_create (array (
				'http' => array (	 
				'method' => 'POST',
				'header' => "Connection: close\r\n".
				"Content-Type: application/x-www-form-urlencoded\r\n",
				'content' => $content,
				)
			));
			
			$res = file_get_contents($this->shuttle_url, null, $context);
		
		}
		
		// echo $xml;
		
		$this->session->set_userdata(array(
			'shuttle_qty' 		=> 0, 
			'shuttle_plate' 	=> '',
			 
		));
	
	}  

	
	
	
}
// END tickets_model.php
/* Location: ./application/models/tickets_model.php */		