<?php

class Tickets_model extends CI_Model {

	var $events = 'events e';
	var $users = 'users u';
	var $tickets = 'tickets ti';
	var $sections = 'sections s';
	var $prices = 'prices p';
	var $ticket_types = 'ticket_types tt';
	var $venues = 'venues v';
	var $transactions = 'transactions tr';
	var $terminals = 'terminals te';
	var $ticket_layouts = 'ticket_layouts tl';
	var $logos = 'logos l';
	var $ticket_logos = 'ticket_logos tk';
	
    function __construct()
    {
        // Call the Model constructor
        parent::__construct();
    }
	

	function get_sold_seats($event_id, $section_id)
	{
		$this->db->select('ticket_system_row,ticket_system_col,ticket_row,ticket_seat');
		$this->db->where('ticket_event_id', $event_id);
		$this->db->where('ticket_section_id', $section_id);
		$this->db->where_in('ticket_status', array('done', 'paid', 'paid_online'));
		$query = $this->db->get($this->tickets);
		//echo $this->db->last_query();

		if($query->num_rows() > 0){
		return $query->result();
		}else{
		return false;
		}
		
	}


	function get_sold_count($event_id, $section_id)
	{
		$this->db->select('ticket_system_row,ticket_system_col,ticket_row,ticket_seat');
		$this->db->where('ticket_event_id', $event_id);
		$this->db->where('ticket_section_id', $section_id);
		$this->db->where_in('ticket_status', array('done', 'paid', 'paid_online'));
		$query = $this->db->get($this->tickets);
		
		return $query->num_rows();
	
	}
	
	function get_selected_seats($event_id, $section_id)
	{
		$this->db->select('ticket_system_row,ticket_system_col,ticket_row,ticket_seat');
		$this->db->where('ticket_event_id', $event_id);
		$this->db->where('ticket_section_id', $section_id);
		$this->db->where_in('ticket_status', array('selected'));
		$query = $this->db->get($this->tickets);
		//echo $this->db->last_query();

		if($query->num_rows() > 0){
		return $query->result();
		}else{
		return false;
		}
		
	}


	function get_selected_count($event_id, $section_id)
	{
		$this->db->select('ticket_system_row,ticket_system_col,ticket_row,ticket_seat');
		$this->db->where('ticket_event_id', $event_id);
		$this->db->where('ticket_section_id', $section_id);
		$this->db->where_in('ticket_status', array('selected'));
		$query = $this->db->get($this->tickets);
		
		return $query->num_rows();
	
	}
	
	
	function get_reserved_seats($event_id, $section_id)
	{
		$this->db->select('ticket_system_row,ticket_system_col,ticket_row,ticket_seat');
		$this->db->where('ticket_event_id', $event_id);
		$this->db->where('ticket_section_id', $section_id);
		$this->db->where_in('ticket_status', array('reserved'));
		$query = $this->db->get($this->tickets);
		//echo $this->db->last_query();

		if($query->num_rows() > 0){
		return $query->result();
		}else{
		return false;
		}
		
	}

	function get_reserved_count($event_id, $section_id)
	{
		$this->db->select('ticket_system_row,ticket_system_col,ticket_row,ticket_seat');
		$this->db->where('ticket_event_id', $event_id);
		$this->db->where('ticket_section_id', $section_id);
		$this->db->where_in('ticket_status', array('reserved'));
		$query = $this->db->get($this->tickets);
		
		return $query->num_rows();
	
	}
	

	function is_seat_taken($row, $col, $seats_taken)
	{
		foreach ($seats_taken as $seat)
		{
			if ($seat->ticket_system_row == $row and $seat->ticket_system_col == $col)
			{
				return true;
			}
		}
		
		return false;
	}
	
	function get_selected_tickets($transaction_id)
	{
		$this->db->select('ti.*, tr.*, p.*, tt.ticket_type_discount_type, tt.ticket_type_discount, tt.ticket_type_name, tt.ticket_type_code, s.section_id, s.section_name, s.section_type, s.section_code');
		$this->db->where('ti.ticket_transaction_id', $transaction_id);	
		$this->db->where('ti.ticket_status', 'selected');	
		$this->db->join($this->sections, 's.section_id = ti.ticket_section_id', 'left');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id', 'left');
		$this->db->join($this->prices, 'p.price_id = ti.ticket_price_id', 'left');
		$this->db->join($this->transactions, 'tr.transaction_id = ti.ticket_transaction_id', 'left');
		$this->db->order_by('ti.ticket_row', 'asc');
		$this->db->order_by('ti.ticket_seat + 0', 'asc');
		$query = $this->db->get($this->tickets);
		//echo $this->db->last_query();
		
		return $query->result();
	}
	
	function update_acknowledgment_receipt($ticket_id, $receipt_number)
	{
		// update the tickets table
		$this->db->where('ticket_id', $ticket_id);
		$this->db->update($this->tickets, array('ticket_acknowledgment_receipt' => $receipt_number));
		
		return true;
	}
	
	function get_paid_online_tickets($transaction_id)
	{
		$this->db->select('ti.*, tr.*, p.*, tt.ticket_type_discount_type, tt.ticket_type_discount, tt.ticket_type_name, tt.ticket_type_code, s.section_id, s.section_name, s.section_type, s.section_code');
		$this->db->where('ti.ticket_transaction_id', $transaction_id);	
		$this->db->where('ti.ticket_status', 'paid_online');		
		$this->db->join('sections s', 's.section_id = ti.ticket_section_id', 'left');
		$this->db->join('ticket_types tt', 'tt.ticket_type_id = ti.ticket_type_id', 'left');
		$this->db->join('prices p', 'p.price_id = ti.ticket_price_id', 'left');
		$this->db->join('transactions tr', 'tr.transaction_id = ti.ticket_transaction_id', 'left');
		$this->db->order_by('ti.ticket_row', 'asc');
		$this->db->order_by('ti.ticket_seat + 0', 'asc');
		$query = $this->db->get('tickets ti');
		//echo $this->db->last_query();
		
		return $query->result();
	}
	
	
}

