<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class SMBarcode_model extends CI_Model
{

	var $valid_ticket_status = array("paid", "paid_online","done");
	
	public function __construct()
	{
		parent::__construct();
	}


	function attach_smcode_to_transaction_tickets($transaction_id, $ticket_list, $online_claim = false) {
		$read = $this->load->database('default',true); 
		$write = $this->load->database('live',true);
		
		$ticket_count = count($ticket_list);
		$attach_counter = 0;

		// $transaction_id = $transaction->transaction_id;
		
 		$write->where('sm_transaction_id', $transaction_id);
		$q = $write->get('sm_barcode');
		
		$bcode_details = array();
		if($q->num_rows() > 0){ 
			$result = $q->result();
 			 foreach($result as $x){
				$bcode_details[] = array (
					'sm_prefix' => str_pad($x->sm_prefix, 4, '0', STR_PAD_LEFT),
					'sm_prefix_alt' => $x->sm_prefix_alt,
					'sm_transaction_id' => $x->sm_transaction_id,
					'sm_ticket_id' => $x->sm_ticket_id,
					'sm_code' => $x->sm_code,
				);
				 
			 }
		}else{
			// prefix format = single-digit YEAR + three-digit DAY OF THE YEAR
			$prefix_yr = date("y")* 1000;
			$prefix_yr_day = date("z");
			$prefix = $prefix_yr + $prefix_yr_day;
			$prefix = $prefix % 10000;
			$oddeven = (date("H") % 2);
			$prefix = "$oddeven"."$prefix";
			$prefix_alt = ($prefix_yr_day + ($oddeven*366));
			

			if ($online_claim) {			 
				// $oddeven = date("H", strtotime($transaction->transaction_date));
				// $oddeven = ($oddeven % 2);
				$prefix_alt = 1000 + ($prefix_yr_day + ($oddeven*366));
			}
			
			
			foreach($ticket_list as $tix) {
				$fields = array (
						'sm_prefix' => $prefix,
						'sm_prefix_alt' => $prefix_alt,
						'sm_transaction_id' => $transaction_id,
						'sm_ticket_id' => $tix->ticket_id,
					);

				if (in_array($tix->ticket_status, $this->valid_ticket_status)) {
					$write->insert('sm_barcode', $fields);
					$attach_counter += $write->affected_rows();
				}
				
 				$sm_code = array('sm_code'=> $write->insert_id());
				$fields = array_merge($fields, $sm_code);
				$bcode_details[] = $fields;
			}
			// echo "$ticket_count == $attach_counter";
			$success = false;
			if (($ticket_count > 0) && ($ticket_count == $attach_counter)) {
				$success = true;
			} 
		}
		return $bcode_details;
	}
	

	function mark_printer_for_online_ticket_claim($transaction_id)
	{
		$read = $this->load->database('default',true); $write = $this->load->database('live',true);// update the tickets table		
		$changes = array(
			'ticket_user_id '		=> $this->session->userdata('user_id'),
			'ticket_branch_id '		=> $this->session->userdata('user_branch_id'),
			'ticket_terminal_id '	=> $this->session->userdata('user_terminal_id'),
			'ticket_date_printed'	=> date('Y-m-d H:i:s'),
		);
		
		// update the status of the tickets
		$write->where_in('ticket_status', array('paid', 'paid_online'));
		$write->where('ticket_transaction_id', $transaction_id);
		$write->update("tickets", $changes);
		
		return true;
	}
	
	function generate_access_code(){
		$status = array('done','paid_online');
		$read = $this->load->database('default',true); 
		$write = $this->load->database('live',true);
 
		$write->select('ticket_id,ticket_transaction_id, ticket_event_id,ticket_price_id,ticket_status,online_code_transaction_id,online_code_ticket_id');
		$write->where_in('ticket_status', $status); 
 		$write->where('event_online_concert', 1); 
 		$write->where('online_code_transaction_id', null); 
		$write->where('DATE(ticket_date_entered) between CURDATE() - INTERVAL 10 DAY and CURDATE()'); 
		$write->join('online_codes', 'online_code_ticket_id = ticket_id', 'left');
		$write->join('events_config ec', 'ec.events_config_eventid = ticket_event_id', 'left');

		//$write->order_by('ticket_id','desc'); 
		$write->limit(100); 
		$q = $write->get('tickets');
		$rows = $q->num_rows();
		
		if($rows >0){
			
			foreach($q->result() as $x){
				$data = array(
				'online_code_transaction_id '	=> $x->ticket_transaction_id,
				'online_code_ticket_id '		=> $x->ticket_id 
				);
				
				$write->where('online_code_transaction_id', 0); 
				$write->where('online_code_ticket_id', 0); 
				$write->where('online_code_event_id', $x->ticket_event_id);  
				$write->where('online_code_price_id', $x->ticket_price_id);  
				$write->limit(1);
				$write->update("online_codes", $data);
			}
			
		}
		
		
		echo '<pre>';
		print_r($q->result());
		echo '</pre>';
		die();
	}
	
}
