<?php
class Reports_model extends CI_Model {

var $transactions = 'transactions tr';
var $sections = 'sections s';
var $tickets = 'tickets ti';
var $events = 'events e';
var $ticket_types = 'ticket_types tt';
var $prices = 'prices p';

	public function __construct()
	{
		parent::__construct();
	
		$this->load->database('default',true);
	}	
 
	
	function reports_filter(){
		$date_from = $this->input->get_post('date_from');
		$date = $this->input->get_post('date_to');
		$seller = $this->input->get_post('user_id');
		if($seller == "")
		{
			$seller = 1;
		}
		//$date_to = new DateTime($this->input->post('reports_date_to'));
		//date_time_set($date_to, 00,00,01);	
		$view = 'view';
		$dl = $this->input->post('dl');
		
		//$date_from = $this->input->post('reports_date_from');
		//$date_from = new DateTime($this->input->post('reports_date_from'));
		//date_time_set($date_to, 00,00,01);	
		
		$event_id = $this->input->get_post('event_id');
		$event_long_title = $this->input->get_post('event_long_title');
		$promoter_id = $this->input->get_post('promoter_id');
		
		//return array('reports_date_to' => date_format($date_to, 'Y-m-d'),'reports_date_from' => date_format($date_from, 'Y-m-d'), 'event_id' => $event_id);
		return array('reports_date_from' => $date_from, 'reports_date' => $date, 'event_id' => $event_id, 'promoter_id' => $promoter_id, 'event_long_title' => $event_long_title, 'report_view' => $view, 'report_dl' => $dl, 'sellerr' => $seller);
		 
		
	}

	function top_sales($promoter_id){
		$read = $this->load->database('default',true);

		$sql = "SELECT e.event_title, SUM(CASE WHEN tt.ticket_type_discount_type = 'PERCENTAGE' THEN ROUND(pr.price_price - (pr.price_price * tt.ticket_type_discount / 100)) ELSE ROUND(pr.price_price - tt.ticket_type_discount) END) total_sales FROM events  e
		LEFT JOIN tickets t ON t.ticket_event_id = e.event_id
		LEFT JOIN ticket_types tt ON tt.ticket_type_id = t.ticket_type_id
		LEFT JOIN prices pr ON pr.price_id = t.ticket_price_id
		WHERE e.event_promoter_id = ? AND e.event_date_time > CURDATE() AND t.ticket_status = 'done' AND event_active = 1
		GROUP BY e.event_id
		ORDER BY total_sales DESC";
		return $read->query($sql,[$promoter_id])->result();

		
	}
	
	function month_sales($promoter_id){
		$read = $this->load->database('default',true);

		$sql = "SELECT 
			DATE_FORMAT(t.ticket_date_entered ,'%m/%Y') AS sales_date  , SUM(CASE WHEN tt.ticket_type_discount_type = 'PERCENTAGE' THEN ROUND(pr.price_price - (pr.price_price * tt.ticket_type_discount / 100)) ELSE ROUND(pr.price_price - tt.ticket_type_discount) END) total_sales
			FROM events  e
			LEFT JOIN tickets t ON t.ticket_event_id = e.event_id
			LEFT JOIN ticket_types tt ON tt.ticket_type_id = t.ticket_type_id
			LEFT JOIN prices pr ON pr.price_id = t.ticket_price_id
			WHERE e.event_promoter_id = ? AND e.event_date_time > CURDATE() AND t.ticket_status = 'done' AND event_active = 1
			GROUP BY sales_date
			ORDER BY ticket_date_entered DESC
			 ";
		return $read->query($sql,[$promoter_id])->result();

		
	}

	//new reports
	function get_ticket_list(){
	$read = $this->load->database('default',true);
	$read->query('set transaction isolation level read uncommitted');
	$event_id = $this->input->post('event_id');
	$date_from = $this->input->post('date_from');
	$date_to = $this->input->post('date_to');
 
	
	$read->select('
		p.price_name,
		p.price_price,
		tr.transaction_id,
		t.ticket_id,
		t.ticket_status,
		t.ticket_row,
		t.ticket_seat,
		b.branch_name,
		tr.transaction_date,
		tr.transaction_comment,
		tt.ticket_type_name, 
		ut.used_entry_datetime as date_used,
		ut.used_last_date as last_accessed,
		c.customer_firstname,
		c.customer_lastname,
		c.customer_mobile, 
		c.customer_registration_code, 
		pt.payment_type_name, 
		s.section_name,
		st.*  
		
	');
	
	
	
	$read->join('ticket_types tt', 'tt.ticket_type_id = t.ticket_type_id');
	$read->join('prices p', 'p.price_id = t.ticket_price_id');
	$read->join('transactions tr', 'tr.transaction_id = t.ticket_transaction_id');
	$read->join('branches b', 'b.branch_id = t.ticket_branch_id');
	$read->join('customers c', 'c.customer_id = tr.transaction_customer_id');
	$read->join('used_tickets ut', 'ut.used_ticket_id = t.ticket_id','left');
	$read->join('sections s', 's.section_id = t.ticket_section_id','left');
	$read->join('payments pay', 'pay.payment_transaction_id = tr.transaction_id','left');
	$read->join('payment_types pt', 'pt.payment_type_id = pay.payment_payment_type_id','left');
	$read->join('senior_transactions st', 'st.senior_ticket_id = t.ticket_id','left');
	
 
	
	$read->where("date(tr.transaction_date) <=", $date_to);
	$read->where("t.ticket_event_id", $event_id); 
	$read->where("t.ticket_status", 'done'); 
	
	if($date_from)
	$read->where("date(tr.transaction_date) >=", $date_from);

	$read->group_by('t.ticket_id');
	$read->order_by('tr.transaction_date','desc');
	// $read->limit(10);
	$query = $read->get('tickets t');
	
	return $query->result();
	
	
	}
	
		
	function get_ticket_attendance_report(){
		$read = $this->load->database('default',true);

		$read->query('set transaction isolation level read uncommitted');
		$event_id = $this->input->post('event_id');	
		$date_filter = $this->input->post('date_filter');
		$date_to = $this->input->post('date_to');
		$date_from = $this->input->post('date_from');
		$date_entry = "used_entry_datetime";
		
		if($event_id=="5304"){
			$date_entry = "used_last_date";
		}
		
		if($date_from==$date_to) :
		$querystring = "select * from  
						used_tickets ut 
						inner join tickets t on t.ticket_id = ut.used_ticket_id
						inner join prices p on p.price_id = t.ticket_price_id
						inner join sections s on s.section_id = t.ticket_section_id 
						where t.ticket_event_id = '$event_id'
						and date($date_entry) <= '$date_from' and date($date_entry) >=  '$date_to'
						and used_remark is NULL 
						
						order by p.price_price  desc 
						";
		
		elseif($date_from!=$date_to) :
		// $date_to = date('Y-m-d',date(strtotime("+1 day", strtotime($date_filter))));
		
		// echo $date_to;
		// die();
		$querystring = "select * from  
						used_tickets ut 
						inner join tickets t on t.ticket_id = ut.used_ticket_id
						inner join prices p on p.price_id = t.ticket_price_id
						inner join sections s on s.section_id = t.ticket_section_id 
						where t.ticket_event_id = '$event_id'
						and date($date_entry) >= '$date_from' and date($date_entry) <=  '$date_to'
						and used_remark is NULL 
						
						order by p.price_price  desc 
						";
	 
		else:
		$querystring = "select * from  
						used_tickets ut 
						inner join tickets t on t.ticket_id = ut.used_ticket_id
						inner join prices p on p.price_id = t.ticket_price_id
						inner join sections s on s.section_id = t.ticket_section_id 
						where t.ticket_event_id = '$event_id'
						and used_remark is NULL 
						order by p.price_price  desc 
						";
	 
		endif;
	 
		$query = $read->query($querystring);
		return $query->result();
	}
	
}
