<?php

class api_sections_model extends CI_Model {

	var $seatplans = 'seatplans s';
	var $venues = 'venues v';
	var $sections = 'sections se';
	var $prices = 'prices pc';
	var $tickets = 'tickets ti';
	var $events = 'events e';

    function __construct()
    {
        // Call the Model constructor
        parent::__construct();
		$this->load->database('default',true);
    }
    
	function get($section_id)
	{
		$this->db->where('section_id', $section_id);
		$query = $this->db->get($this->sections);
		//echo $this->db->last_query();
		
		if($query->num_rows() > 0){
			return $query->row();
		}else{
			return false;
		}
	}
	
	function get_section_ids_array($seatplan_id)
	{
		$this->db->select('section_id'); 
		$this->db->where('section_seatplan_id', $seatplan_id);
		//$this->db->order_by('pc.price_price', 'desc'); 
		$this->db->order_by("section_name", "asc");
		$query = $this->db->get($this->sections)->result();
		$arr_sid = array();
		foreach($query as $section) {
			$arr_sid[] = $section->section_id;
		}
		// return $query->result_array();
		return $arr_sid;
	}
	

	
/* 	function getSectionsWithEventID($event_id = false)
	{
	
	
	
	
	
	
	
	
	$this->db->select('  e.event_id
						,s.section_id
						,s.section_name
						,s.section_type
						,s.section_seat_config
						,s.section_stage_location
						,s.section_capacity
						,s.section_row_from
						,s.section_row_to
						,s.section_row_increment
						,s.section_col_from
						,s.section_col_to
						,s.section_col_increment
						,s.section_coords

					');
	$this->db->join('events e', 'e.event_seatplan_id = s.section_seatplan_id');
	
	
		
	$date = date('Y/m/d h:i:s ', time());

	if($event_id){
	$this->db->where('e.event_id', $event_id);

	}

	$this->db->where('e.event_date_time >=', $date);
	$this->db->where('e.event_active', 1);
	$query = $this->db->get('sections s');

	// echo $this->db->last_query();
	
	$result = $query->result();
	return $result;
	}
	 */
	
 
	function getSectionsWithEventID($event_id = false,$sectionid = false){
	
	$this->db->query('set transaction isolation level read uncommitted');
	
	if($sectionid){
		$section_id_string = $sectionid;
	}else{
		$this->db->select('pc.price_sections');
		if ($event_id)
			{
				$this->db->where('pc.price_event_id', $event_id);
			}
			
			$this->db->join($this->events, 'pc.price_event_id = e.event_id', 'left');
			$this->db->order_by('pc.price_price', 'desc'); 
			$query = $this->db->get($this->prices);
			
			$array = $query->result();
			$item = array();

			foreach($array as $a) {
				$item[] = implode(',',unserialize($a->price_sections));

			}
	$section_id_string = implode(',',$item);
	}

	$result = null;
	if($section_id_string){
	// $this->db->cache_on();
	$this->db->query('set transaction isolation level read uncommitted');
	$queryString = "SELECT `e`.`event_id`, `s`.`section_id`, `s`.`section_name`, `s`.`section_type`, `s`.`section_seat_config`, `s`.`section_stage_location`, `s`.`section_capacity`, `s`.`section_available`, `s`.`section_col_aisles`, `s`.`section_row_from`, `s`.`section_row_to`, `s`.`section_row_increment`, `s`.`section_col_from`, `s`.`section_col_to`, `s`.`section_col_increment`, `s`.`section_coords`
					FROM (`sections` s) JOIN `events` e ON `e`.`event_seatplan_id` = `s`.`section_seatplan_id` WHERE `s`.`section_id` IN ( $section_id_string ) ORDER BY `s`.`section_id` DESC";
	
	$query = $this->db->query($queryString);
	$result = $query->result(); 
	
	}
	// $this->db->cache_off();
	return  $result;
	
	}
	

	
	function get_ticket_availability_sections($sections, $seatplan_id = false, $unserialize = false)
	{
		$read = $this->load->database('default',true);
		$write = $this->load->database('live',true);
		$read->query('set transaction isolation level read uncommitted');
		if ($unserialize) {
			$arr_sections = unserialize($sections);
		} else {
			$arr_sections = array($sections);
		}
		
		if (empty($arr_sections)) { return array(); }
		
		foreach($arr_sections as $section_id) {
			$price_section_info['used'][$section_id] = 0;
			$price_section_info['capacity'][$section_id] = 0;
			$price_section_info['available'][$section_id] = 0;
			$price_section_info['available_db'][$section_id] = 0;
			$price_section_info['reserved'][$section_id] = 0;
			$price_section_info['type'][$section_id] = "";
		}
		
		// get capacity and default availability
		$read->select('section_id, section_capacity, section_type, section_available');
		$read->where_in('section_id', $arr_sections);
		$read->where('section_seatplan_id', $seatplan_id);
		
		$query = $read->get($this->sections);

		// filter out non-existingg section_id
		$arr_sections = array();
		foreach($query->result() as $row) {
			$section_id = $row->section_id;
			$arr_sections[] = $section_id;
			$capacity = $row->section_capacity;
			$price_section_info['capacity'][$section_id] = $capacity;
			
			// default value - if no seat is taken yet
			$price_section_info['available'][$section_id] = $capacity; 
			$price_section_info['type'][$section_id] = $row->section_type; 
			$price_section_info['available_db'][$section_id] = $row->section_available;
		}
		
		if (!empty($arr_sections)) {
			$write->query('set transaction isolation level read uncommitted');
			// get taken value
			$write->select('ticket_section_id, count(ticket_id) as taken');
			$write->where_in('ticket_section_id', $arr_sections);
			$write->where_in('ticket_status', array('reserved','done','selected','paid','paid_online'));
			$write->group_by('ticket_section_id');
			$query = $write->get($this->tickets);
			
			foreach($query->result() as $row) {
				$section_id = $row->ticket_section_id;
				$count_used = $row->taken;
				$price_section_info['used'][$section_id] = $count_used;
				$total_capacity = $price_section_info['capacity'][$section_id];
				$price_section_info['available'][$section_id] = $total_capacity - $count_used;
			}

			// get ticket count of reserved seats
			$write->query('set transaction isolation level read uncommitted');
			$write->select('ticket_section_id, count(ticket_id) as reserved');
			$write->where_in('ticket_section_id', $arr_sections);
			$write->where_in('ticket_status', array('reserved'));
			$write->group_by('ticket_section_id');
			$query = $write->get($this->tickets);
			
			foreach($query->result() as $row) {
				$section_id = $row->ticket_section_id;
				$count_reserved = $row->reserved;
				$price_section_info['reserved'][$section_id] = $count_reserved;
			}
			return $price_section_info;
		} else {
			return array();
		}

	}
	
	function get_sections($seatplan_id)
	{
		$this->db->where('section_seatplan_id', $seatplan_id);
		//$this->db->order_by('pc.price_price', 'desc'); 
		$this->db->order_by("section_name", "asc");
		$query = $this->db->get($this->sections);
		if($query->num_rows() > 0){
		return $query->result();
		}else{
		return false;
		}
		
		
	}
	
	
	function get_all_sections()
	{
		//$this->db->order_by('pc.price_price', 'desc'); 
		$this->db->order_by("section_name", "asc");
		$query = $this->db->get($this->sections);
		if($query->num_rows() > 0){
		return $query->result();
		}else{
		return false;
		}
		
		
	}
	

	function get_selected_section_names($seatplan_id, $sections)
	{	
		$array = array();
		
		if (!$sections)
		{
			return false;
		}
		
		$this->db->where('section_seatplan_id', $seatplan_id);
		$query = $this->db->get($this->sections);
			
		$result = $query->result();

		if ($result)
		{
			// transform result to csv
			$sections = unserialize($sections);

			if ($sections) 
			{
				foreach($result as $r)
				{
					if (in_array($r->section_id, $sections))
						$array[$r->section_id] = $r->section_name;
				}
				
				return $array;
			}
			else
				return false;
		}
		else
			return false;
	}
	
		
		
	function get_selected_section($seatplan_id, $sections)
	{	
		$array = array();
		
		if (!$sections)
		{
			return false;
		}
		
		$this->db->where('section_seatplan_id', $seatplan_id);
		$query = $this->db->get($this->sections);
			
		$result = $query->result();


		if ($result)
		{
			// transform result to csv
			$sections = unserialize($sections);

			if ($sections) 
			{
			
				foreach($result as $r)
				{
					if (in_array($r->section_id, $sections)){
						$array[$r->section_id] = $r->section_name;
					}
				}
		
				return $array;
			}
			else
				return false;
		}
		else
			return false;
	}
	

	function get_section_info($sectionID){
		$this->db->select('section_name, section_type');
		$this->db->where('section_id', $sectionID);
		$query = $this->db->get($this->sections);
		return $query->row();

	}
	
	function get_ticket_availability($sections, $seatplan_id = false, $unserialize = false, $breakdown = false) {
		$ret = $this->get_ticket_availability_sections($sections, $seatplan_id, $unserialize);
		
		if (empty($ret)) { 
			return array(
					'total_capacity' => 0
					, 'total_used' => 0
					, 'total_reserved' => 0
					, 'total_available' => 0
					, 'total_available_db' => 0
					, 'type' => 'N/A'
				); 
		}

		$type = current($ret['type']);

		if ($breakdown) {
			$section_info = $ret;
		}
		
		$section_info['total_capacity'] = array_sum($ret['capacity']);
		$section_info['total_used'] = array_sum($ret['used']);
		// $section_info['total_reserved'] = array_sum($ret['reserved']);
		$section_info['total_available'] = array_sum($ret['available']);
		$section_info['total_available_db'] = array_sum($ret['available_db']);
		$section_info['type'] = $type; 

		return $section_info;
	}
	
	
	function section_max_col_row($section_type, $section_col_from, $section_col_to, $section_col_increment ,$section_row_from, $section_row_to, $section_row_increment) 
	{
		$max_col = 0;
		$max_row = 0;

		if ($section_type == "Reserved") {
			$seatcolumns = range($section_col_from, $section_col_to, $section_col_increment);
			$seatrows = range($section_row_from, $section_row_to, $section_row_increment);
			$max_col = count($seatcolumns);
			$max_row = count($seatrows);
		}

		return array($max_col,$max_row);
	}
	
	
	function section_used_seats($event_id = false,$section_id = false){
		$ticket_status  = array('paid', 'done', 'paid_online', 'selected', 'reserved');
		
		$read = $this->load->database('default',true);
		$write = $this->load->database('live',true);
		$write->query('set transaction isolation level read uncommitted');		
		$write->select('tix.ticket_section_id, tix.ticket_system_row, tix.ticket_system_col, tix.ticket_row, tix.ticket_seat, tix.ticket_id');
		$write->join('events ev', 'tix.ticket_event_id = ev.event_id');
		$write->where_in('tix.ticket_status', $ticket_status);
		
		$date = date('Y/m/d h:i:s ', time());
		
		$write->where('ev.event_date_time >=', $date);
		$write->where('ev.event_active = 1');
		
		if($section_id){
		$write->where('tix.ticket_section_id',$section_id);
		}
		
		
		$write->order_by("tix.ticket_section_id", "asc");
		$write->order_by("tix.ticket_system_row", "asc");
		$write->order_by("tix.ticket_system_col", "asc");
		$write->order_by("tix.ticket_row", "asc");
		$write->order_by("tix.ticket_seat", "asc");
		
		
		
		
		
		
		
		
		
		
		if($event_id){
		$write->where('ev.event_id',$event_id);
		}

		$query = $write->get('tickets tix');
		
		
		
		
		// $kamote = $query->result();
		// echo '<pre>';
		// print_r($kamote);
		// echo '</pre>';

		// Die();
		
		
		
		
		if($query->num_rows() > 0){		

		// return $query->result();
		foreach($query->result() as $row) {
			$section_id = $row->ticket_section_id;
			$sys_col = $row->ticket_system_col;
			$sys_row = $row->ticket_system_row;
			$tix_row = $row->ticket_row;
			$tix_seat = $row->ticket_seat;
			$tix_id = $row->ticket_id;
			
			// generate list of used seats -- to be mainly used for sections with reserved seats
			$seat_type = array("Free Seating", "Standing");
			if(!in_array($tix_seat, $seat_type)) {
				// if(isset($sections_used_seats[$section_id][$sys_row][$sys_col])) {
					$sections_used_seats[$section_id][]="R$sys_row|C$sys_col|$tix_row|$tix_seat";
				// }
			}
			
			else{
			$sections_used_seats[$section_id] = array();
			}
			
			// generate count list of used seats -- includes reserved, free seating and guaranted seats
			// can be used to generate number of available tickets by using formula (CAPACITY - USED_COUNT)
			if(!isset($tmp_section_used_count[$section_id])) {
				$tmp_section_used_count[$section_id] = array();
			}
			$tmp_section_used_count[$section_id][] = $tix_id;
		}
		
		foreach($tmp_section_used_count as $section_id => $tix_list) {
			$sections_used_count[$section_id] = count($tix_list);
		}
		
		return array($sections_used_seats, $sections_used_count);
		}
		else{
		return false;
		}
	}
	
	
	function section_used_seats_by_event_id($event_id = false){
		$ticket_status  = array('paid', 'done', 'paid_online', 'selected', 'reserved');
		
		$read = $this->load->database('default',true);
		$write = $this->load->database('live',true);
		$write->query('set transaction isolation level read uncommitted');
		$write->select('tix.ticket_section_id, tix.ticket_system_row, tix.ticket_system_col, tix.ticket_row, tix.ticket_seat, tix.ticket_id');
		$write->join('events ev', 'tix.ticket_event_id = ev.event_id');
		$write->where_in('tix.ticket_status', $ticket_status);
		$write->where('ev.event_active = 1');
		$write->where('ev.event_id = ' . $event_id);
		$query = $write->get('tickets tix');
		
		// return $query->result();
		foreach($query->result() as $row) {
			$section_id = $row->ticket_section_id;
			$sys_col = $row->ticket_system_col;
			$sys_row = $row->ticket_system_row;
			$tix_row = $row->ticket_row;
			$tix_seat = $row->ticket_seat;
			$tix_id = $row->ticket_id;
			
			$sections_used_seats = false;
			// generate list of used seats -- to be mainly used for sections with reserved seats
			$seat_type = array("Free Seating", "Standing");
			if(!in_array($tix_seat, $seat_type)) {
				// if(isset($sections_used_seats[$section_id][$sys_row][$sys_col])) {
					$sections_used_seats[$section_id][]="R$sys_row|C$sys_col|$tix_row|$tix_seat";
				// }
			}
			
			// generate count list of used seats -- includes reserved, free seating and guaranted seats
			// can be used to generate number of available tickets by using formula (CAPACITY - USED_COUNT)
			if(!isset($tmp_section_used_count[$section_id])) {
				$tmp_section_used_count[$section_id] = array();
			}
			$tmp_section_used_count[$section_id][] = $tix_id;
		}
		
		foreach($tmp_section_used_count as $section_id => $tix_list) {
			$sections_used_count[$section_id] = count($tix_list);
		}
		
		return array($sections_used_seats, $sections_used_count);
	}
	
	
	function generate_section_seats($section_type, $section_seat_config) {
		$seat_config = array();
		if ($section_type == "Reserved") {
			$tmp_seat_config = unserialize($section_seat_config);
			
		if(!$tmp_seat_config){
		$tmp_seat_config = false;
		}
		else{	
				foreach($tmp_seat_config as $row => $col) {
					foreach($col as $seat) {
						$seat_config[] = $seat;
					}
				}
			}
			
		}
		
				
		return $seat_config;
	}

	function generate_section_heads($section_type, $section_seat_config) {
		$seat_config = array();
		if ($section_type == "Reserved") {
			$tmp_seat_config = unserialize($section_seat_config);
			
		// if(!$tmp_seat_config){
		// $tmp_seat_config = false;
		// }
		// else{	
				// foreach($tmp_seat_config as $row => $col) {
					// foreach($col as $seat) {
						// $seat_config[] = $seat;
					// }
				// }
			// }
			
		}
		
				
		return $tmp_seat_config;
	}


	function section_used_seats_2($event_id = false,$section_id = false,$date = false){
		
		$ticket_status  = array('paid', 'done', 'paid_online', 'selected', 'reserved');
		
		$read = $this->load->database('default',true);
		$write = $this->load->database('live',true);
		$read->query('set transaction isolation level read uncommitted');
		$read->select('tix.ticket_section_id, tix.ticket_system_row, tix.ticket_system_col, tix.ticket_row, tix.ticket_seat, tix.ticket_id, tix.ticket_status');
		if($date){
			$read->join('transactions tr', 'tix.ticket_transaction_id = tr.transaction_id');
			$read->where('tr.transaction_date_validity', $date);
		}
		
		// $write->join('events ev', 'tix.ticket_event_id = ev.event_id');
		// $write->where_in('tix.ticket_status', $ticket_status);
		
		// $date = date('Y/m/d h:i:s ', time());
		
		// $write->where('ev.event_date_time >=', $date);
		// $write->where('ev.event_active = 1');
		
		if($section_id){
		$read->where('tix.ticket_section_id',$section_id);
		}
		
		
		$read->order_by("tix.ticket_section_id", "asc");
		$read->order_by("tix.ticket_system_row", "asc");
		$read->order_by("tix.ticket_system_col", "asc");
		$read->order_by("tix.ticket_row", "asc");
		$read->order_by("tix.ticket_seat", "asc");
		
		if($event_id){
		$read->where('tix.ticket_event_id',$event_id);
		}

		$query = $read->get('tickets tix');
		
		if($query->num_rows() > 0){		

			// return $query->result();
			$tmp_section_used_count = array();
			$sections_used_count = array();
			$sections_used_seats = array();
			foreach($query->result() as $row) {
				
				if(in_array($row->ticket_status,$ticket_status)){
					
					$section_id = $row->ticket_section_id;
					$sys_col = $row->ticket_system_col;
					$sys_row = $row->ticket_system_row;
					$tix_row = $row->ticket_row;
					$tix_seat = $row->ticket_seat;
					$tix_id = $row->ticket_id;
					
					// generate list of used seats -- to be mainly used for sections with reserved seats
					$seat_type = array("Free Seating", "Standing");
					if(!in_array($tix_seat, $seat_type)) {
						// if(isset($sections_used_seats[$section_id][$sys_row][$sys_col])) {
							$sections_used_seats[$section_id][]="R$sys_row|C$sys_col";
						// }
					}
					
					else{
					$sections_used_seats[$section_id] = array();
					}
					
					// generate count list of used seats -- includes reserved, free seating and guaranted seats
					// can be used to generate number of available tickets by using formula (CAPACITY - USED_COUNT)
					if(!isset($tmp_section_used_count[$section_id])) {
						$tmp_section_used_count[$section_id] = array();
					}
					$tmp_section_used_count[$section_id][] = $tix_id;
				}
			}
			
			foreach($tmp_section_used_count as $section_id => $tix_list) {
				$sections_used_count[$section_id] = count($tix_list);
			}
			
			return array($sections_used_seats, $sections_used_count);
		}
		else{
			return false;
		}
	}
	
	function getSectionsWithEventID_2($event_id = false,$sectionid = false){
	
	$this->db->query('set transaction isolation level read uncommitted');
	
	if($sectionid){
		$section_id_string = $sectionid;
	}else{
		$this->db->select('pc.price_sections');
		if ($event_id)
			{
				$this->db->where('pc.price_event_id', $event_id);
			}
			
			$this->db->join($this->events, 'pc.price_event_id = e.event_id', 'left');
			$this->db->order_by('pc.price_price', 'desc'); 
			$query = $this->db->get($this->prices);
			
			$array = $query->result();
			$item = array();

			foreach($array as $a) {
				$item[] = implode(',',unserialize($a->price_sections));

			}
	$section_id_string = implode(',',$item);
	}

	$result = null;
	if($section_id_string){
	
	$queryString = "SELECT `e`.`event_id`, `s`.`section_id`, `s`.`section_name`, `s`.`section_type`, `s`.`section_seat_config`, `s`.`section_stage_location`, `s`.`section_capacity`, `s`.`section_available`, `s`.`section_col_aisles`, `s`.`section_row_from`, `s`.`section_row_to`, `s`.`section_row_increment`, `s`.`section_col_from`, `s`.`section_col_to`, `s`.`section_col_increment`, `s`.`section_coords`
					FROM (`sections` s) JOIN `events` e ON `e`.`event_seatplan_id` = `s`.`section_seatplan_id` WHERE `s`.`section_id` IN ( $section_id_string ) ORDER BY `s`.`section_id` DESC";
	
	$query = $this->db->query($queryString);
	$result = $query->result(); 
	
	}
	// $this->db->cache_off();
	return  $result;
	
	}
	
	function getSectionsWithEventID_3($event_id = false,$sectionid = false){
	
	$this->db->query('set transaction isolation level read uncommitted');
	
	if($sectionid){
		$section_id_string = $sectionid;
	}else{
		$this->db->select('pc.price_sections');
		if ($event_id)
			{
				$this->db->where('pc.price_event_id', $event_id);
			}
			
			$this->db->join($this->events, 'pc.price_event_id = e.event_id', 'left');
			$this->db->order_by('pc.price_price', 'desc'); 
			$query = $this->db->get($this->prices);
			
			$array = $query->result();
			$item = array();

			foreach($array as $a) {
				$item[] = implode(',',unserialize($a->price_sections));

			}
	$section_id_string = implode(',',$item);
	}

	$result = null;
	if($section_id_string){
	
	$queryString = "SELECT `e`.`event_id`, `s`.`section_id`, `s`.`section_name`, `s`.`section_type`, `s`.`section_seat_heads`,`s`.`section_seat_config`, `s`.`section_stage_location`, `s`.`section_capacity`, `s`.`section_available`, `s`.`section_row_aisles`, `s`.`section_col_aisles`, `s`.`section_row_from`, `s`.`section_row_to`, `s`.`section_row_increment`, `s`.`section_col_from`, `s`.`section_col_to`, `s`.`section_col_increment`, `s`.`section_coords`
					FROM (`sections` s) JOIN `events` e ON `e`.`event_seatplan_id` = `s`.`section_seatplan_id` WHERE `s`.`section_id` IN ( $section_id_string ) ORDER BY `s`.`section_id` DESC";
	
	$query = $this->db->query($queryString);
	$result = $query->result(); 
	
	}
	// $this->db->cache_off();
	return  $result;
	
	}

	 
	function update_ticket_availability_sections($sections, $seatplan_id = false, $unserialize = false)
	{
		$read = $this->load->database('default',true);
		$write = $this->load->database('live',true);
		$read->query('set transaction isolation level read uncommitted');


		if ($unserialize) {
			$arr_sections = unserialize($sections);
		} else {
			$arr_sections = array($sections);
		}
		
		if (empty($arr_sections)) { return false; }
		
		foreach($arr_sections as $section_id) {
			$price_section_info['used'][$section_id] = 0;
			$price_section_info['capacity'][$section_id] = 0;
			$price_section_info['available'][$section_id] = 0;
			$price_section_info['available_db'][$section_id] = 0;
			$price_section_info['reserved'][$section_id] = 0;
			$price_section_info['type'][$section_id] = "";
		}
		
		// get capacity and default availability
		$read->select('section_id, section_capacity, section_type, section_available, date_modified');
		$read->where_in('section_id', $arr_sections);
		$read->where('section_seatplan_id', $seatplan_id);
		
		$query = $read->get($this->sections);

		// filter out non-existingg section_id
		$arr_sections = array();
		$last_update = '';
		foreach($query->result() as $row) {
			$section_id = $row->section_id;
			$arr_sections[] = $section_id;
			$capacity = $row->section_capacity;
 			$price_section_info['capacity'][$section_id] = $capacity;
			
			// default value - if no seat is taken yet
			$price_section_info['available'][$section_id] = $capacity; 
			// $price_section_info['reserved'][$section_id] = $reserved; 
			$price_section_info['type'][$section_id] = $row->section_type; 
			$price_section_info['available_db'][$section_id] = $row->section_available;
		
		
			if($last_update){ 
				if($last_update <= $row->date_modified){
					
					
					$last_update = $row->date_modified;
				}
				
			}else{
				 
				$last_update = $row->date_modified;
				
			}
		
		
		}
		
		
		//set udpate expiration
		
		$minutes = 1;
		$now = strtotime(date("Y-m-d H:i:s"));
		$expire_time = date("Y-m-d H:i:s", strtotime(date("Y-m-d H:i:s"))-($minutes*60));
		
		$date = date('Y-m-d', strtotime($expire_time));
		$newdate = strtotime('-1 day' , strtotime($expire_time));
		$newdate = date ( 'Y-m-d H:i:s' , $newdate );
		
	 
		if($last_update <= $expire_time){
			 // echo 'last update: ' . $last_update . '<br>';
			 // echo 'expire time :' . $expire_time . '<br>';
			// echo 'updated!' . '<br>';
		}else{
			 
			 
			// echo 'not for update'  . '<br>';
			return false;
		 
		}
		
		
		
			 
			
		
		if (!empty($arr_sections)) {
			
		 
			// get taken value
			$read->select('count(1) as qty , ticket_section_id,ticket_status');
			$read->where_in('ticket_section_id', $arr_sections);
			$read->where_in('ticket_status', array('reserved','done','selected','paid','paid_online'));
			$read->group_by('ticket_section_id, ticket_status');
			$query2 = $read->get($this->tickets);
			 
			foreach($query2->result() as $row) {
				
				if(!isset($price_section_info['used'][$section_id])) $price_section_info['used'][$section_id] = 0;
				if(!isset($price_section_info['reserved'][$section_id])) $price_section_info['reserved'][$section_id] = 0;
				
				$section_id = $row->ticket_section_id;
				$count_used = $row->qty;
				$price_section_info['used'][$section_id] += $count_used;
				$total_capacity = $price_section_info['capacity'][$section_id]; 
				 
				//count reserved
				if($row->ticket_status == 'reserved'){
					 
				$section_id = $row->ticket_section_id;
				// $count_reserved += 1;
				$price_section_info['reserved'][$section_id] += $row->qty;
				}
				
				
			}
			
			//update available
			foreach($query->result() as $row) {
			$section_id = $row->section_id; 
			// default value - if no seat is taken yet
			$price_section_info['available'][$section_id] =  $price_section_info['capacity'][$section_id] - $price_section_info['used'][$section_id];  
			$available = $price_section_info['available'][$section_id];
			$reserved = $price_section_info['reserved'][$section_id];
			
			$data = array(
				   'section_reserved' => $reserved,
				   'section_available' => $available,
				   'section_xmap_config' => $now,
				 
			);

			$write->where('section_id', $section_id);
			$write->update('sections', $data); 

			
			
			}
			
			 
			
			
		} else {
			return false;
		}

	}

	
}


