<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Api_reservations_model extends CI_Model
{
	
	var $users = 'users u';
	var $promoters = 'promoters p';
	var $venues = 'venues v';
	var $branches = 'branches o';
	var $reservations = 'reservation re';
	var $customers = 'customers c';	
	var $transactions = 'transactions t';	
	var $tickets = 'tickets ti';	
		
	
	/**
	 * Constructor
	 *
	 * @access	public
	 */
	public function __construct()
	{
		parent::__construct();
	}
	// --------------------------------------------------------------------
	
	/**
	 * get_reservation_list
	 *
	 * @access	public
	 */
	function get_reservations($offset = false, $limit = false)
	{
		$this->db->group_by('t.transaction_id');
		$this->db->where('lower(transaction_status)', strtolower('reserved'));
		$this->db->like('c.customer_mobile', $this->input->post('mobile')); 
		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left');
		$this->db->join($this->tickets, 't.transaction_id = ti.ticket_transaction_id', 'left');
		$this->db->join('events ev', 'ev.event_id=ti.ticket_event_id','left');
		
		$this->db->order_by('t.transaction_id', 'desc');
		if ($limit) $this->db->limit($limit);
		if ($offset) $this->db->offset($offset);
		$query = $this->db->get($this->transactions);

		return $query->result();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * search_reservation_list
	 *
	 * @access	public
	 */
	function search_reservations($searchkey=array(), $offset = false, $limit = false)
	{
		$this->db->select('t.transaction_id,c.customer_firstname,c.customer_lastname,c.customer_mobile,t.transaction_date,ti.ticket_reservation_expiry,ev.event_long_title,se.section_name,t.transaction_branch_id,ti.ticket_branch_id,count(ti.ticket_id) as ticket_count');
		$this->db->group_by('t.transaction_id');
		$this->db->where('ti.ticket_status', 'reserved');
		$this->db->where('lower(transaction_status)', strtolower('reserved'));
		if($this->input->post('mobile')!="")
		$this->db->like('c.customer_mobile', $this->input->post('mobile')); 
		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left');
		$this->db->join($this->tickets, 't.transaction_id = ti.ticket_transaction_id', 'left');
		$this->db->join('sections se', 'se.section_id=ti.ticket_section_id','left');
		$this->db->join('events ev', 'ev.event_id=ti.ticket_event_id','left');

		if (!empty($searchkey) )
		{
			foreach ($searchkey as $key=>$value)
			{
				switch ($key)
				{
					case 'name':
						$this->db->like('CONCAT(customer_lastname,customer_firstname)', $value);
						break;
					default:
  					if($this->session->userdata('user_type') == 'Seller'){ 
						$this->db->where($key, $value);
					}else{
						$this->db->like($key, $value);
					}
					
						break;
				}
			}
		}else{
		
			if($this->session->userdata('user_type') == 'Seller'){
				$this->db->where('t.transaction_id', 0);
			}
		}
		
		
		$this->db->order_by('t.transaction_id', 'desc');
		
		if ($limit) $this->db->limit($limit);
		if ($offset) $this->db->offset($offset);
		$query = $this->db->get($this->transactions);

		return $query->result();
	}
	
	// --------------------------------------------------------------------
	function count_reservations($searchkey=array(), $offset = false, $limit = false)
	{
		$this->db->select('t.transaction_id');
		$this->db->group_by('t.transaction_id');
		$this->db->where('ti.ticket_status', 'reserved');
		$this->db->where('lower(transaction_status)', strtolower('reserved'));
		if($this->input->post('mobile')!="")
		$this->db->like('c.customer_mobile', $this->input->post('mobile')); 
		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left');
		$this->db->join($this->tickets, 't.transaction_id = ti.ticket_transaction_id', 'left');
		// $this->db->join('sections se', 'se.section_id=ti.ticket_section_id','left');
		$this->db->join('events ev', 'ev.event_id=ti.ticket_event_id','left');

		if (!empty($searchkey) )
		{
			foreach ($searchkey as $key=>$value)
			{
				switch ($key)
				{
					case 'name':
						$this->db->like('CONCAT(customer_lastname,customer_firstname)', $value);
						break;
					default:
  					$this->db->like($key, $value);
						break;
				}
			}
		}
		
		
		$this->db->order_by('t.transaction_id', 'desc');
		
		if ($limit) $this->db->limit($limit);
		if ($offset) $this->db->offset($offset);
		$query = $this->db->get($this->transactions);

		return $query->result();
	}
	

	/**
	 * get_customer_ID
	 *
	 * @access	public
	 */
	function get_customer_id($transaction_id)
	{
		$this->db->select('c.customer_id, ti.ticket_session_id, ti.ticket_event_id, ti.ticket_price_id, ti.ticket_transaction_id');
		$this->db->where('t.transaction_id', $transaction_id);
		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left');
		$this->db->join($this->tickets, 't.transaction_id = ti.ticket_transaction_id', 'left');
		$query = $this->db->get($this->transactions);
		
		return $query->row();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * reservation_check
	 *
	 * @access	public
	 */
	function reservation_check()
	{
		$read = $this->load->database('default',true); $write = $this->load->database('live',true);
		$fields = array(
			'ticket_status'		=> 'expired',				
		);
		$write->where('ticket_reservation_expiry', date());
		$write->update($this->tickets, $fields);
		return true;
	}
	// --------------------------------------------------------------------
	
	/**
	 * reservation_expiry
	 *
	 * @access	public
	 */
	function reservation_expiry($transaction_id)
	{
	
		$this->db->where('ticket_transaction_id', $transaction_id);
		$query = $this->db->get($this->tickets);		
		return $query->row();
	}	
	
	// --------------------------------------------------------------------
	
	/**
	 * extend
	 *
	 * @access	public
	 */
	function extend($transaction_id)
	{	
		$read = $this->load->database('default',true); $write = $this->load->database('live',true);
		$no_of_days = ($this->input->post('no_of_days')) ? $this->input->post('no_of_days') : $this->input->post('event_reservation_days');
		$extend_date = date("Y-m-d", strtotime("+$no_of_days days")); 
		
		// update tickets table
		$write->where('ticket_transaction_id', $transaction_id);
		$write->update($this->tickets, array('ticket_reservation_expiry' => $extend_date));
			
		return true;
	}	

	// --------------------------------------------------------------------
	
	/**
	 * expire
	 *
	 */
	function expire()
	{
		$read = $this->load->database('default',true); $write = $this->load->database('live',true);
		// update tickets table
		$write->where('ticket_status', 'reserved');
		$write->where('ticket_reservation_expiry <', date("Y-m-d"));
		$write->update($this->tickets, array('ticket_status' => 'expired'));
		//echo $this->db->last_query();
		return true;
	}

	//for edit reservation
	function get_reservations_details($resID = false)
	{
 		$this->db->where('lower(transaction_status)', strtolower('reserved'));
		$this->db->where('transaction_id', $resID); 
 		$this->db->join($this->customers, 'c.customer_id = t.transaction_customer_id', 'left'); 		
   		$query = $this->db->get($this->transactions);

		return $query->row();
	}
		
	function update_reservation()
	{
	
		 $read = $this->load->database('default',true); $write = $this->load->database('live',true);
		
		// check first if customer is existing
		$customer = $this->get_by_mobile($this->input->post('customer_mobile'));
		
		if (!empty($customer))
		{	
		
			//update notes
			$fields = array(
				'transaction_comment'			=> $this->input->post('customer_notes'),	
				'transaction_customer_id'		=> $customer->customer_id,					
			);
			
			$write->where('transaction_id', $this->input->post('reservation_id'));
			$write->update($this->transactions, $fields);
			
		
			//update customer details
			$fields2 = array(
				'customer_firstname'		=> $this->input->post('customer_firstname'),				
				'customer_lastname'			=> $this->input->post('customer_lastname'),				
 			);
			$write->where('customer_mobile', $this->input->post('customer_mobile'));
			$write->update($this->customers, $fields2);
			
			 
		
		}else{
		 
		
			$fields = array(
				'customer_firstname'		=> $this->input->post('customer_firstname'),				
				'customer_lastname'			=> $this->input->post('customer_lastname'),				
				'customer_gender'			=> 0,		
				'customer_nationality'		=> 0,		
				'customer_marital_status'	=> 0,		
				'customer_address1'			=> 0,		
				'customer_address2'			=> 0,		
				'customer_city'				=> 0,		
				'customer_zip'				=> 0,		
				'customer_phone'			=> 0,		
				'customer_fax'				=> 0,		
				'customer_fax'				=> 0,		
				'customer_email'			=> 0,		
				'customer_website'			=> 0,		
				'customer_notes'			=> 0,		

				
				'customer_mobile'			=> $this->input->post('customer_mobile'),				
 			);
				
			$write->set($fields);
			$write->insert('customers');
		
			
			//update notes
			$fields = array(
				'transaction_comment'			=> $this->input->post('customer_notes'),				
				'transaction_customer_id'		=> $write->insert_id(),				
			);
			
			$write->where('transaction_id', $this->input->post('reservation_id'));
			$write->update($this->transactions, $fields);
			
			 
		}
		
		 
		
		
		return true;
		
	}
	
	function get_by_mobile($mobile)
	{
		$this->db->where('customer_mobile', $mobile);
		$query = $this->db->getwhere($this->customers);
		//echo $this->db->last_query();
		
		return $query->row();
	}
	
}



// END reservations_model.php
/* Location: ./application/models/reservations_model.php */	
