<?php

class api_prices_model extends CI_Model {

	var $seatplans = 'seatplans s';
	var $venues = 'venues v';
	var $prices = 'prices pc';
	var $events = 'events e';	

    function __construct()
    {
        // Call the Model constructor
        parent::__construct();
    }
	
   	function get_prices($event_id = false)
	{
		if ($event_id)
		{
			$this->db->where('pc.price_event_id', $event_id);
		}
		$this->db->join($this->events, 'pc.price_event_id = e.event_id', 'left');
		$this->db->order_by('pc.price_price', 'desc'); 
		$query = $this->db->get($this->prices);
		//echo $this->db->last_query();
		
		return $query->result();
	}
	
		function getPricesForAllEvents($event_id = false)
	{
		// $this->db->cache_on();
		// $this->db->select("price_event_id,price_id,price_name,price_price");
		if ($event_id)
		{
			 $this->db->where('e.event_id', $event_id);
			 // $this->db->where('pc.price_hidden_online', NULL);
			 $this->db->where('(pc.price_hidden_online = 0 or pc.price_hidden_online is null)');
			 // $this->db->or_where('pc.price_hidden_online', 0);
		}
		$this->db->join($this->events, 'pc.price_event_id = e.event_id', 'left');
		$price = array(14203,14202);
		$this->db->where_not_in('pc.price_id', $price);
		$this->db->order_by('pc.price_event_id,pc.price_price', 'desc'); 
		$query = $this->db->get($this->prices);
		
		// $this->db->cache_off();
		return $query->result();
	}
	
	function get($price_id)
	{
		$this->db->where('price_id', $price_id);
		$this->db->join($this->events, 'pc.price_event_id = e.event_id', 'left');
		$query = $this->db->get($this->prices);
		//echo $this->db->last_query();
		
		return $query->row();
	}
	
	function get_serial_number($price_id)
	{
		$read = $this->load->database('default',true); $write = $this->load->database('live',true);
		// get last serial number
		$read->select('price_serial_last');
		$read->where('price_id', $price_id);
		$query = $read->get_where($this->prices);
		$row = $query->row();
		
		$next_serial_number = $row->price_serial_last += 1;
		
		// update last serial number
		$write->where('price_id', $price_id);
		$write->update($this->prices, array('price_serial_last' => $next_serial_number));
		
		return $next_serial_number;
	}

			
	function get_prices_compact($event_id = false)
	{
		$read = $this->load->database('default',true);
		$read->query('set transaction isolation level read uncommitted');
		$read->select('pc.price_id,pc.price_name, pc.price_sections, pc.price_price');
		if ($event_id)
		{
			$read->where('pc.price_event_id', $event_id);
		}
		
		// if (!in_array($this->session->userdata('user_type'), array('Admin','Super Admin','Admin2'))){
			// $read->where('pc.price_hidden_otc ', 0);
			
		
		// }
		
		
		$read->join($this->events, 'pc.price_event_id = e.event_id', 'left');
		$read->order_by('pc.price_price', 'desc'); 
		$query = $read->get($this->prices);
		//echo $this->db->last_query();
		
		return $query->result();
	}
	
	
}


