<?php

class api_payments_model extends CI_Model {

	var $seatplans = 'seatplans s';
	var $venues = 'venues v';
	var $prices = 'prices pc';
	var $events = 'events e';	

    function __construct()
    {
        // Call the Model constructor
        parent::__construct();
    }
	
 	function add($transaction_id, $payment_type_id, $payment_amount, $payment_amount_type = 'tickets')
	{
		$read = $this->load->database('default',true);
		$write = $this->load->database('live',true);
		$fields = array(
			'payment_transaction_id'	=> $transaction_id,
			'payment_payment_type_id'	=> $payment_type_id,
			'payment_amount'			=> prep_amount($payment_amount),
			'payment_amount_type'		=> $payment_amount_type,
			'date_modified'				=> date("Y-m-d H:i:s"),  //rollback
		);

		// insert to db
		$write->set($fields);
		$write->insert('payments');
		
		
		
	}	
 	
	function add_convenience_charge_details($transaction_id, $ticket_count, $payment_amount, $payment_amount_type = 'convenience')
	{
		$read = $this->load->database('default',true);
		$write = $this->load->database('live',true);
		$fields = array(
			'charge_transaction_id'	=> $transaction_id,
			'charge_amount'			=> prep_amount($payment_amount),
			'charge_ticket_count'			=> $ticket_count,
			'charge_type'		=> $payment_amount_type,
			'date_modified'				=> date("Y-m-d H:i:s"),  //rollback
		);

		// insert to db
		$write->set($fields);
		$write->insert('charges');
	}	
	
	function add_totalpay($transaction_id, $payment_type_id, $payment_amount, $payment_amount_type = 'tickets')
	{
		$read = $this->load->database('default',true);
		$write = $this->load->database('live',true);
		
		$fields = array(
			'total_transaction_id'	=> $transaction_id,
			'total_payment_type_id'	=> $payment_type_id,
			'total_amount'			=> prep_amount($payment_amount),
			// 'total_amount_type'		=> $payment_amount_type,
		);

		// insert to db
		$write->set($fields);
		$write->insert('total_amount');
	}	

	function get_payments($transaction_id)
	{
		$this->db->where('payment_transaction_id', $transaction_id);
		$this->db->join('payment_types', 'payment_payment_type_id=payment_type_id','left');
		$query = $this->db->get('payments');
		return $query->result();
	}	
	
	function add_cardnum($transaction_id = false, $CardNum = false, $expiration = false , $card_type = false){
	
		$read = $this->load->database('default',true); $write = $this->load->database('live',true);
		//save card number
		$card_details = array(
			'card_number_transaction_id'	=> $transaction_id,
			'card_number_value'				=> $CardNum,
			'card_number_expiration'		=> $expiration,
			'card_number_card_type'			=> $card_type,
		);
		$write->insert('card_numbers', $card_details); 
	 		
	}
	
	
}



