<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Api_logs_model extends CI_Model
{
	var $logs = 'logs l';
	var $users = 'users u';
	var $branches = 'branches b';
	
	/**
	 * Constructor
	 *
	 * @access	public
	 */
	public function __construct()
	{
		parent::__construct();
		$this->load->library('user_agent');
	}

	// --------------------------------------------------------------------
	
	/**
	 * get_logs
	 *
	 * @access	public
	 */
	function get_logs($searchkey=array(), $offset=false, $limit=false)
	{
		if ($limit) $this->db->limit($limit);
		if ($offset) $this->db->offset($offset);

		if (! empty($searchkey) )
		{
			foreach ($searchkey as $key=>$value)
			{
				if ($value)
				switch ($key)
				{
					case 'name':
					//	$this->db->like('CONCAT(customer_lastname,customer_firstname)', $value);
						break;
					default:
  						$this->db->like($key, $value);
						break;
				}
			}
		}
		
		$this->db->join($this->users, 'u.user_id = l.log_user_id', 'left');
		$this->db->join($this->branches, 'b.branch_id = l.log_branch_id', 'left');
		$this->db->order_by('log_id', 'desc');
		$query = $this->db->get($this->logs);
		
		return $query->result();
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * get_log_count
	 *
	 * @access	public
	 */
	function get_log_count($searchkey=array())
	{
		$this->db->select('count(*) as log_count');
		if (! empty($searchkey) )
		{
			foreach ($searchkey as $key=>$value)
			{
				if ($value)
				switch ($key)
				{
					case 'name':
					//	$this->db->like('CONCAT(customer_lastname,customer_firstname)', $value);
						break;
					default:
  						$this->db->like($key, $value);
						break;
				}
			}
		}
		$query = $this->db->get($this->logs);
		
		$result = $query->row();
		
		return $result->log_count;
	}
	
	// --------------------------------------------------------------------
	
	/**
	 * add
	 *
	 * @access	public
	 */
	function add($action)
	{
		$user_id = ($this->session->userdata('user_id')) ? $this->session->userdata('user_id') : '';
		$branch_id = ($this->session->userdata('user_branch_id')) ? $this->session->userdata('user_branch_id') : '';
		$referrer = (isset($_SERVER["HTTP_REFERER"])) ? $_SERVER["HTTP_REFERER"] : '';
		$details = (isset($_POST)) ? serialize($_POST) : '';
		
		
		$fields = array(
			'log_date'				=> 	date("Y-m-d H:i:s"),
			'log_action'			=>	$action,
			'log_uri'				=> 	$_SERVER["REQUEST_URI"],
			'log_user_id'			=> 	$user_id,
			'log_branch_id'			=>	$branch_id,
			// 'log_ip_address'		=>	get_ip_address(),
			'log_ip_address'		=>	$this->input->ip_address(),
			'log_platform'			=>	$this->agent->platform(),
			'log_browser'			=>	$this->agent->browser(),
			'log_browser_version'	=>	$this->agent->version(),
			'log_agent_string'		=>	$this->agent->agent_string(),
			'log_referrer'			=> 	$referrer,
			'log_details'			=>	$details,
		);
		
		// insert to db
		$read = $this->load->database('default',true); $write = $this->load->database('live',true);
		$write->set($fields);
		$write->insert('logs');
		
		return true;
	}	
	
	function benchmark_add($querytime, $pagetime)
	{
		$fields = array(
			'benchmark_date'				=> 	date("Y-m-d H:i:s"),
			'benchmark_query_time'			=> 	$querytime,
			'benchmark_page_load_time'		=> 	$pagetime,
			'benchmark_uri'					=> 	$_SERVER["REQUEST_URI"],
			'benchmark_ip_address'			=>	get_ip_address(),
			'benchmark_platform'			=>	$this->agent->platform(),
			'benchmark_browser'				=>	$this->agent->browser(),
			'benchmark_browser_version'		=>	$this->agent->version(),
		);
		
		// insert to db
		$read = $this->load->database('default',true); $write = $this->load->database('live',true);
		$write->set($fields);
		$write->insert('benchmark_log');
		
		return true;
	}
	
	// --------------------------------------------------------------------]
}

// END logs_model.php
/* Location: ./application/models/logs_model.php */	