<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Api_generator_model extends CI_Model
{
	var $branch = 'branches br';
	var $events = 'events e';
	var $prices = 'prices p';
	var $sections = 'sections s';
	var $terminals = 'terminals te';
	var $ticket_types = 'ticket_types tt';
	var $tickets = 'tickets ti';
	var $transactions = 'transactions tr';
	var $users = 'users u';
		
	var $paid_status = array('paid','paid_online');

	public function __construct()
	{
		parent::__construct();
		$this->load->model('api_ticket_layouts_model', 'ticket_layouts');

/* 		
	var $venues = 'venues v';
	var $ticket_layouts = 'ticket_layouts tl';
	var $logos = 'logos l';
	var $ticket_logos = 'ticket_logos tk';

		$this->load->model('ekbarcode_model', 'ekbarcode');
		$this->load->model('users_model', 'users');
		$this->load->model('sections_model', 'sections_model');
		$this->load->model('transactions_model', 'transactions_model');
		$this->load->model('events_model', 'events_model');
		$this->load->model('ticket_layouts_model', 'ticket_layouts_model');
		$this->load->model('branches_model', 'branches_model');
		$this->load->model('payments_model', 'payments_model');
		$this->load->model('configurations_model', 'configurations_model');
		$this->load->model('prices_model', 'prices_model');
		$this->load->model('logs_model', 'logs_model');
		$this->load->model('logs_online_model', 'olog');
 */	}


	function GetLayoutDetails($event_id = 0) {
		$layout = array();
		$bgimage = array();
		if ($event_id > 0) {
			$ticket_layout = $this->ticket_layouts->get($event_id);
			$bgimage[1] = $ticket_layout->tb1Path;
			$layout[1][] = array(
					"text" => $ticket_layout->ticket_text_1,
					"font" => $ticket_layout->ticket_font_face_1,
					"size" => $ticket_layout->ticket_font_size_1,
					"style" => "",
				);
			
			$layout[1][] = array(
					"text" => $ticket_layout->ticket_text_2,
					"font" => $ticket_layout->ticket_font_face_2,
					"size" => $ticket_layout->ticket_font_size_2,
					"style" => "",
				);
				
			$layout[1][] = array(
					"text" => $ticket_layout->ticket_text_3,
					"font" => $ticket_layout->ticket_font_face_3,
					"size" => $ticket_layout->ticket_font_size_3,
					"style" => "B",
				);
				
			$layout[1][] = array(
					"text" => $ticket_layout->ticket_text_4,
					"font" => $ticket_layout->ticket_font_face_4,
					"size" => $ticket_layout->ticket_font_size_4,
					"style" => "B",
				);
				
			$layout[1][] = array(
					"text" => $ticket_layout->ticket_text_5,
					"font" => $ticket_layout->ticket_font_face_5,
					"size" => $ticket_layout->ticket_font_size_5,
					"style" => "",
				);
				
			$layout[1][] = array(
					"text" => $ticket_layout->ticket_text_6,
					"font" => $ticket_layout->ticket_font_face_6,
					"size" => $ticket_layout->ticket_font_size_6,
					"style" => "",
				);
				
			$layout[1][] = array(
					"text" => $ticket_layout->ticket_text_7,
					"font" => $ticket_layout->ticket_font_face_7,
					"size" => $ticket_layout->ticket_font_size_7,
					"style" => "",
				);
			
			if ($this->config->item("enable_ticket_4x3")) {
				// SECTION 2: Layout (left)
				$bgimage[2]	 = $ticket_layout->tb2Path;
				$layout[2][] = array(
						"text" => $ticket_layout->ticket_text_1_left,
						"font" => $ticket_layout->ticket_font_face_1_left,
						"size" => $ticket_layout->ticket_font_size_1_left,
						"style" => "",
					);
				
				$layout[2][] = array(
						"text" => $ticket_layout->ticket_text_2_left,
						"font" => $ticket_layout->ticket_font_face_2_left,
						"size" => $ticket_layout->ticket_font_size_2_left,
						"style" => "",
					);
					
				$layout[2][] = array(
						"text" => $ticket_layout->ticket_text_3_left,
						"font" => $ticket_layout->ticket_font_face_3_left,
						"size" => $ticket_layout->ticket_font_size_3_left,
						"style" => "B",
					);
					
				$layout[2][] = array(
						"text" => $ticket_layout->ticket_text_4_left,
						"font" => $ticket_layout->ticket_font_face_4_left,
						"size" => $ticket_layout->ticket_font_size_4_left,
						"style" => "B",
					);
					
				$layout[2][] = array(
						"text" => $ticket_layout->ticket_text_5_left,
						"font" => $ticket_layout->ticket_font_face_5_left,
						"size" => $ticket_layout->ticket_font_size_5_left,
						"style" => "",
					);
				
				// SECTION 3: Layout (right)
				$bgimage[3] = $ticket_layout->tb3Path;
				$layout[3][] = array(
						"text" => $ticket_layout->ticket_text_1_right,
						"font" => $ticket_layout->ticket_font_face_1_right,
						"size" => $ticket_layout->ticket_font_size_1_right,
						"style" => "",
					);
				
				$layout[3][] = array(
						"text" => $ticket_layout->ticket_text_2_right,
						"font" => $ticket_layout->ticket_font_face_2_right,
						"size" => $ticket_layout->ticket_font_size_2_right,
						"style" => "",
					);
					
				$layout[3][] = array(
						"text" => $ticket_layout->ticket_text_3_right,
						"font" => $ticket_layout->ticket_font_face_3_right,
						"size" => $ticket_layout->ticket_font_size_3_right,
						"style" => "B",
					);
					
				$layout[3][] = array(
						"text" => $ticket_layout->ticket_text_4_right,
						"font" => $ticket_layout->ticket_font_face_4_right,
						"size" => $ticket_layout->ticket_font_size_4_right,
						"style" => "B",
					);
					
				$layout[3][] = array(
						"text" => $ticket_layout->ticket_text_5_right,
						"font" => $ticket_layout->ticket_font_face_5_right,
						"size" => $ticket_layout->ticket_font_size_5_right,
						"style" => "",
					);
			}			
		}
		
		return array($bgimage, $layout);
	}
	
	function get_paid_tickets_for_printing($transaction_id, $cpi = false)
	{
		
		$this->db->select('ti.*, tr.*, p.*, tt.ticket_type_discount_type
				, tt.ticket_type_discount, tt.ticket_type_name, tt.ticket_type_code
				, s.section_id, s.section_name, s.section_type, s.section_code
				, ekb.ek_barcode, ekb.ek_days_valid, u.username
				, e.event_code, e.event_id, ec.*
				, smb.*
				, te.terminal_code
				, br.branch_city, br.branch_tin
			');
			
		$this->db->where('ti.ticket_transaction_id', $transaction_id);
		// $this->db->where('tr.transaction_id IS NOT NULL');
		// $this->db->where('smb.sm_prefix IS NOT NULL');
		// $this->db->where('smb.sm_code IS NOT NULL');
		$this->db->where_in('ti.ticket_status', $this->paid_status);
		$this->db->where_in('tr.transaction_status', $this->paid_status);

		$this->db->join('sm_barcode smb', '(smb.sm_ticket_id = ti.ticket_id AND smb.sm_transaction_id = ti.ticket_transaction_id', 'left');
		$this->db->join('ek_barcode ekb', 'ekb.ek_ticket_id = ti.ticket_id', 'left');
		$this->db->join($this->branch, 'br.branch_id = ti.ticket_branch_id', 'left');
		$this->db->join($this->sections, 's.section_id = ti.ticket_section_id', 'left');
		$this->db->join($this->ticket_types, 'tt.ticket_type_id = ti.ticket_type_id', 'left');
		$this->db->join($this->prices, 'p.price_id = ti.ticket_price_id', 'left');
		$this->db->join($this->users, 'u.user_id = ti.ticket_user_id', 'left');
		$this->db->join($this->events, 'e.event_id = ti.ticket_event_id', 'LEFT');
		$this->db->join('events_config ec', 'e.event_id = ec.events_config_eventid', 'LEFT');
		$this->db->join($this->transactions, 'tr.transaction_id = ti.ticket_transaction_id', 'left');
		$this->db->join($this->terminals, 'te.terminal_id = tr.transaction_terminal_id', 'left');
		$this->db->order_by('ti.ticket_row', 'asc');
		$this->db->order_by('ti.ticket_seat + 0', 'asc');
		$query = $this->db->get($this->tickets);
		
		return $query->result();
	}


	function validatePaidTransactionWithXML($yearmonth = false, $id = false, $trans_id = false) {
		$retval = false;
		
		if (($trans_id > 0) && ($yearmonth > 0) && ($id > 0)){
			$this->db->select('tr.transaction_id, g.xml_yearmonth, g.xml_id');
			$this->db->join('generator g', 'g.xml_trans_id = tr.transaction_id');
			$this->db->where('tr.transaction_id', $trans_id);
			$this->db->where('g.xml_yearmonth', $yearmonth);
			$this->db->where('g.xml_id', $id);
			$this->db->where_in('tr.transaction_status', $this->paid_status);
			$query = $this->db->get($this->transactions);
			
			if ($query->num_rows() > 0) {
				$retval = true;
			}
		}
		
		return $retval;
	}
}	