<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class api_error_model extends CI_model{
	
	
	public function __construct()
	{
		parent::__construct();
	}	
	

	var $errorCode = array (
			
		//General Error	
		'ER:00:00' => 'General Error: Tech Support Intervention Required',
		
		//Calling funtions with conflicting IP (possible hacking activity)
		'ER:00:01' => 'Invalid Access',
		'ER:00:02' => 'Invalid Session',

		//ER:01 - Errors related to Authentication  parameters
		'ER:01:01' => 'No PartyCode Provided.',
		'ER:01:02' => 'No UseCode Provided',
		'ER:01:03' => 'No AppCode Provided',
		'ER:01:04' => 'No LiveToken Provided',
		'ER:01:05' => 'No Password Provided',
		'ER:01:06' => 'No AccessCode Provided',
		'ER:01:07' => 'No Username/Email Provided',
		'ER:01:08' => 'No DynaToken Provided',
		'ER:01:09' => 'No UserID Provided',
		
		//ER:02 - Errors related to Authentication Protocol
		'ER:02:01' => 'Invalid AppCode',
		'ER:02:02' => 'Invalid Key Pair',
		'ER:02:03' => 'Email/Username does not exist',
		'ER:02:04' => 'AppCode is already used',
		'ER:02:05' => 'Invalid Password',
		'ER:02:06' => 'Invalid AccessCode',
		'ER:02:07' => 'AccessCode is already used',
		'ER:02:08' => 'Inactive Key Pair',
		'ER:02:09' => 'Inactive Access Code',
		'ER:02:10' => 'Invalid Username/Password and PartyCode combination',
		'ER:02:11' => 'Invalid Key Pair [Data Sync]',
		'ER:02:12' => 'Invalid Key Pair [Purchase Mode]',
		'ER:02:13' => 'Inactive Key Pair [Data Sync]',
		'ER:02:14' => 'Inactive Key Pair [Purchase Mode]',
 		
		//ER:03 Errors related to session expiration
		'ER:03:01' => 'LiveToken Expired',
		'ER:03:02' => 'Appcode Expired',
		'ER:03:03' => 'AccesssCode Expired',
		'ER:03:04' => 'DynaToken Expired',
		
		//ER:04 Errors related to user accounts
		'ER:04:01' => 'Email Already Used',
		'ER:04:02' => 'Mobile Number Already Used',
		'ER:04:03' => 'No Password Provided',
		'ER:04:04' => 'No FirstName Provided',
		'ER:04:05' => 'No LastName Provided',
		'ER:04:06' => 'No BirthDate Provided',
		'ER:04:07' => 'Invalid BirthDate Format',
		'ER:04:08' => 'No Mobile Number Provided',
		'ER:04:09' => 'Invalid Email Format',
		'ER:04:10' => 'No Email Provided',
		'ER:04:11' => 'Invalid Mobile Number Format',
		'ER:04:12' => 'No Username Provided',
		'ER:04:13' => 'Username Already Used',
		'ER:04:14' => 'Invalid Email',
		'ER:04:15' => 'Invalid Username',
		'ER:04:16' => 'No User ID Provided',
		'ER:04:17' => 'Unable to update user beyond your Party',
		'ER:04:18' => 'No new password provided',
		'ER:04:19' => 'No retype password provided',
		'ER:04:20' => 'The new password does not match with retyped password',
		
		//ER:05 Errors related to generic function parameters
		'ER:05:01' => 'No Seat Plan ID Provided',
		'ER:05:02' => 'Invalid Seat Plan ID',
		'ER:05:03' => 'No  Event ID Provided',
		'ER:05:04' => 'Invalid Event ID',
		'ER:05:05' => 'No  Section ID Provided',
		'ER:05:06' => 'Invalid Section ID',
		'ER:05:07' => 'No Price ID Provided',
		'ER:05:08' => 'Invalid Price ID',
		'ER:05:09' => 'No events for today',
		'ER:05:10' => 'Invalid PriceID and SectionID',
		'ER:05:11' => 'No Sold Seats',
		'ER:05:12' => 'No Reserved Seats',
		'ER:05:13' => 'No Selected Seats',
		'ER:05:14' => 'No Open Seats',
		'ER:05:15' => 'No venue ID provided',
		'ER:05:16' => 'Venue ID does not exist',
		'ER:05:17' => 'Event not found',
		
		
		//ER:06 Errors related to Purchase Mode
		'ER:06:01' => 'No Data Message Provided',
		'ER:06:02' => 'Invalid Data Message',
		'ER:06:03' => 'No Reference Number Provided',
		'ER:06:04' => 'Invalid Reference Number Provided',
		'ER:06:05' => 'No Amount Provided', 
		'ER:06:06' => 'Amount paid did not match the transaction amount',
		'ER:06:07' => 'Invalid Transaction Information', 
		'ER:06:08' => 'No PayCode Provided', 
		'ER:06:09' => 'No CardNumber Provided', 
		'ER:06:10' => 'No Total Amount Provided', 
		'ER:06:11' => 'No PayMode Provided', 
		'ER:06:12' => 'Maximum of 10 tickets is allowed', 
		'ER:06:13' => 'Invalid PayCode Provided', 
		'ER:06:14' => 'Total Amount did not match the total ticket prices', 
		'ER:06:15' => 'No Transaction ID provided', 
 	
	);
		

		
	function promptError($errorCode){
	
		$data['errorCode'] = $errorCode;
		$data['errorMessage'] = $this->errorCode[$errorCode];
		$this->load->view("error_code_xml_2", $data);
	
	}
	
	
	
	
	}

