<?php if (!defined('BASEPATH')) exit('No direct script access allowed'); 

class Api_eplus_model extends CI_Model
{
	var $transactions = 'transactions t';
	var $tickets = 'tickets ti';

	var $paid_status = array('paid','paid_online');

	public function __construct()
	{
		parent::__construct();
	}

	function get_payment_details($type, $user_id = false, $session_id){
	  
		// $query = $this->db->select();
		$this->db->select( "'$session_id' as order_id
					 , $user_id as seller_id
					 , '$type' as type
					 , ev.event_title as event_title
					 , ev.event_code as event_code
					 , ev.event_date_time as event_date_time
					 , se.section_code as section
					 , ti.ticket_row as row
					 , ti.ticket_seat as seat
					 , tt.ticket_type_name as ticket_type
 					 , CASE WHEN tt.ticket_type_discount_type = 'PERCENTAGE' THEN ROUND(pr.price_price - (pr.price_price * tt.ticket_type_discount / 100)) ELSE ROUND(pr.price_price - tt.ticket_type_discount) END 'amount'",false);
		
		
  		$this->db->join('ticket_types tt', 'tt.ticket_type_id = ti.ticket_type_id','left');
		$this->db->join('prices pr', 'pr.price_id = ti.ticket_price_id','left');
		$this->db->join('events ev', 'ev.event_id = ti.ticket_event_id','left');
		$this->db->join('sections se', 'se.section_id = ti.ticket_section_id','left');
	
 
	
		$this->db->where('ti.ticket_session_id', $session_id);
		$this->db->where('ti.ticket_type_id !=', '');
		// $this->db->group_by('ti.ticket_session_id');
		// $this->db->group_by('ti.ticket_seat');
  		$query = $this->db->get('tickets ti');
		 
		return $query;
	
	}

	function insert_details($xml_data = false)
	{
		
		if(!empty($xml_data)){
		 
			foreach($xml_data as $x){ 
				 
					
				//insert card details
				$details = array(
					'eplus_payment_order_id'			=> $x['Order_Id'], 	
					'eplus_payment_user_id'	 			=> $x['User_Id'],	
					'eplus_payment_printed_card_num'	=> $x['PrintedCardNumber'],	
					'eplus_payment_internal_card_num'	=> $x['InternalCardNumber'],	
					'eplus_payment_status'				=> $x['Status'],
 
				);

				// insert to db
				$read = $this->load->database('default',true);
				$write = $this->load->database('live',true);
				
				$write->set($details);
				$write->insert('eplus_payments');

			}
			 
		}
 
		return  true;
	}	
	
	
	function void_payment($xml_data = false)
	{
		$read = $this->load->database('default',true); $write = $this->load->database('live',true);
		if(!empty($xml_data)){
		 
			foreach($xml_data as $x){ 
				  
				// insert to db
				$write->set('eplus_payment_status', $x['Status']);
				$write->set('eplus_payment_refund_date', date("Y-m-d H:i:s"));
				$write->where('eplus_payment_order_id', $x['Order_Id']);
				$write->update('eplus_payments');

			}
			 
		}
 
		return  true;
	}
 	
	function check_status($order_id = false, $status = false){
	 
		 
 		$this->db->where('eplus_payment_order_id', $order_id); 
 		$this->db->where('eplus_payment_status', $status); 
		$query = $this->db->get('eplus_payments');
	
		if($query->num_rows() > 0){ 
			return true; 
		}else{
			return false;
		}
 
		 
	}
	
	
	function check_eplus_payment($transaction_id = false){
	
		 
		$this->db->select('eplus_payment_id');
		$this->db->join('eplus_payments ep', 'ep.eplus_payment_order_id = ti.ticket_session_id','left');
		$this->db->where('ti.ticket_transaction_id', $transaction_id);  
		$this->db->where('ep.eplus_payment_status', 'Paid');  
		$query = $this->db->get('tickets ti');
	
		if($query->num_rows() > 0){ 
			return true; 
		}else{
			return false;
		}
 
	
	
	}
	
	
	function get_epayment_details($transaction_id = false){
	
		$this->db->select('payment_amount, ticket_session_id, eplus_payment_internal_card_num');
		$this->db->join('eplus_payments ep', 'ep.eplus_payment_order_id = ti.ticket_session_id','left');
		$this->db->join('payments p', 'p.payment_transaction_id  = ti.ticket_transaction_id','left');
		$this->db->where('ti.ticket_transaction_id', $transaction_id);  
		$this->db->where('p.payment_payment_type_id', 36);  
		$query = $this->db->get('tickets ti');
	
		if($query->num_rows() > 0){ 
			return $query->row(); 
		}else{
			return false;
		}
 
	
	
	}
	
	function update_epayment($transID, $paymentID){
	
		$read = $this->load->database('default',true); $write = $this->load->database('live',true);
		$write->set('eplus_payment_transaction_id', $transID);
		$write->set('eplus_payment_transaction_id', $paymentID);
		$write->where('eplus_payment_order_id', $sessionID);
		$write->update('eplus_payments');
	
	
	}
	
	function check_session($order_id = false, $user= false, $status = false) {
	
		
		if($status == 'paid'){
		
			$this->db->select('ticket_session_id');
			$this->db->where('ticket_user_id', $user);    
			$this->db->where('ticket_status', 'selected');    
			$this->db->order_by('ticket_id', 'desc');    
			$this->db->limit(1);    
			$query = $this->db->get('tickets');
		
			if($query->num_rows() > 0){  
				
					if($order_id == $query->row()->ticket_session_id){
					
						return 1;
					}else{
					
						return false;
					}
				
				
				
			}else{
				return false;
			}
		
		}else{
	  
		
			return 1;
		
		}
		
		
 
	
	
	}
	
	//eplus 1D
	
	function get_ticket_details($transaction_id = false){
	 
		 
		// $query = $this->db->select();
		$this->db->select( 'ev.event_title as event_title
					 , ev.event_code as event_code
					 , ev.event_date_time as event_date_time
					 , ev.event_venue_amusement_tax as amtax
					 , tr.transaction_id
					 , ti.ticket_id as ticket_id
					 , tr.transaction_comment
					 , tr.transaction_date as transaction_date
					 , se.section_code as section
					 , ti.ticket_row as row
					 , ti.ticket_seat as seat
					 , tt.ticket_type_name as ticket_type
					 , tt.ticket_type_discount_type as discount_type
					 , tt.ticket_type_discount as discount
					 , pr.price_price as price
					 , br.branch_name as branch 
					 , ti.ticket_status as status
					 , ti.ticket_status as status',false);
		

		$this->db->join('tickets ti', 'ti.ticket_transaction_id = tr.transaction_id','left');
		$this->db->join('events ev', 'ev.event_id = ti.ticket_event_id','left');
		$this->db->join('sections se', 'se.section_id = ti.ticket_section_id','left');
		$this->db->join('ticket_types tt', 'tt.ticket_type_id = ti.ticket_type_id','left');
		$this->db->join('prices pr', 'pr.price_id = ti.ticket_price_id','left');
		$this->db->join('branches br', 'br.branch_id = tr.transaction_branch_id','left');
		$this->db->join('eplus_cards e', 'e.eplus_card_ticket_id = ti.ticket_id  ','left');

	
		$this->db->where('tr.transaction_id', $transaction_id);
		$this->db->where('tr.transaction_status', 'done');
		$this->db->where('ti.ticket_status', 'done');
		$this->db->where('e.eplus_card_ticket_id IS NULL');
		$this->db->group_by('ti.ticket_id'); 
		$query = $this->db->get('transactions tr');
		 
		 

		return $query;
	
	}

	function insert_card_details($xml_data = false)
	{
		$read = $this->load->database('default',true); $write = $this->load->database('live',true);
	if(!empty($xml_data)){
			if(isset($xml_data['row'][0]['Ticket_Id'])){
				foreach($xml_data as $x){ 
					foreach($x as $y){
						
						//insert card details
						$details = array(
							'eplus_card_ticket_id'			=> $y['Ticket_Id'], 	
					'eplus_card_user_id'	 		=> $y['User_Id'],	
					'eplus_card_printed_card_num'	=> $y['PrintedCardNumber'],	
					'eplus_card_internal_card_num'	=> $y['InternalCardNumber'],	
					'eplus_card_status'				=> $y['Status'],
 						);

						// insert to db
						
						$write->set($details);
						$write->insert('eplus_cards');

						
					} 
				}
			}else{ 
				foreach($xml_data as $x){ 
					 
						
					//insert card details
					$details = array(
						'eplus_card_ticket_id'			=> $x['Ticket_Id'], 	
					'eplus_card_user_id'	 		=> $x['User_Id'],	
					'eplus_card_printed_card_num'	=> $x['PrintedCardNumber'],	
					'eplus_card_internal_card_num'	=> $x['InternalCardNumber'],	
					'eplus_card_status'				=> $x['Status'],
					);

					// insert to db
					$write->set($details);
					$write->insert('eplus_cards');

						
					 
				}
			
			
			
			}
		 
		}
 
		return  true;
	
	}
	  
	function get_card_details($card = false){
	
	
	$this->db->like('eplus_card_printed_card_num', $card);
	$this->db->join('tickets t', 't.ticket_id = e.eplus_card_ticket_id','left');
	$this->db->limit(10);
	$this->db->group_by('e.eplus_card_ticket_id'); 
	$query = $this->db->get('eplus_cards e');
	return $query->result();
	
	} 
	 
	//1d claim
	function get_card_ticket_details($card = false){
	 
		 
		// $query = $this->db->select();
		$this->db->select( 'ev.event_title as event_title
					 , ev.event_code as event_code
					 , ev.event_date_time as event_date_time
					 , ev.event_venue_amusement_tax as amtax
					 , tr.transaction_id
					 , ti.ticket_id as ticket_id
					 , tr.transaction_comment
					 , tr.transaction_date as transaction_date
					 , se.section_code as section
					 , ti.ticket_row as row
					 , ti.ticket_seat as seat
					 , tt.ticket_type_name as ticket_type
					 , tt.ticket_type_discount_type as discount_type
					 , tt.ticket_type_discount as discount
					 , pr.price_price as price
					 , br.branch_name as branch 
					 , ti.ticket_status as status
					 , ti.ticket_status as status',false);
		

		$this->db->join('tickets ti', 'ti.ticket_transaction_id = tr.transaction_id','left');
		$this->db->join('events ev', 'ev.event_id = ti.ticket_event_id','left');
		$this->db->join('sections se', 'se.section_id = ti.ticket_section_id','left');
		$this->db->join('ticket_types tt', 'tt.ticket_type_id = ti.ticket_type_id','left');
		$this->db->join('prices pr', 'pr.price_id = ti.ticket_price_id','left');
		$this->db->join('branches br', 'br.branch_id = tr.transaction_branch_id','left');
		$this->db->join('eplus_cards e', 'e.eplus_card_ticket_id = ti.ticket_id  ','left');

	
		$this->db->where('e.eplus_card_printed_card_num', $card);
		$this->db->where('tr.transaction_status', 'done');
		$this->db->where('ti.ticket_status', 'done');
		$this->db->where('e.eplus_card_status', 'Done');
 		$this->db->group_by('ti.ticket_id'); 
		$query = $this->db->get('transactions tr');
		 
		 

		return $query;
	
	}

 
	function add_card_logs($ticket = false){
	
		$read = $this->load->database('default',true); $write = $this->load->database('live',true);
		if(is_array($ticket)){
		
		
			$read->where_in('eplus_card_ticket_id', $ticket); 
			$query = $read->get('eplus_cards');
			
		
			if($query->num_rows() > 0){ 
				
				$result = $query->result();
				foreach($result as $x){
				
					//insert card details
					$details = array(
						'eplus_card_ticket_id'				=> $x->eplus_card_ticket_id, 	
						'eplus_card_user_id'	 			=> $x->eplus_card_user_id, 	
						'eplus_card_date'	 				=> $x->eplus_card_date, 	
						'eplus_card_printed_card_num'		=> $x->eplus_card_printed_card_num, 	
						'eplus_card_internal_card_num'		=> $x->eplus_card_internal_card_num, 	
						'eplus_card_printed_card_num_new'	=> $x->eplus_card_printed_card_num_new, 	
						'eplus_card_status'					=> $x->eplus_card_status, 	
						'eplus_card_date_claimed'			=> $x->eplus_card_date_claimed, 	
						'eplus_card_claim_user_id'			=> $x->eplus_card_claim_user_id, 	
					);

					// insert to db
					$write->set($details);
					$write->insert('eplus_card_logs');
				 
				}
			}
		
		}else{
		
			 
 			$read->where('eplus_card_ticket_id', $ticket); 
			$query = $read->get('eplus_cards');
			
		
			if($query->num_rows() > 0){ 
				
				$result = $query->row();
				//insert card details
				$details = array(
					'eplus_card_ticket_id'				=> $result->eplus_card_ticket_id, 	
					'eplus_card_user_id'	 			=> $result->eplus_card_user_id, 	
					'eplus_card_date'	 				=> $result->eplus_card_date, 	
					'eplus_card_printed_card_num'		=> $result->eplus_card_printed_card_num, 	
					'eplus_card_internal_card_num'		=> $result->eplus_card_internal_card_num, 	
					'eplus_card_printed_card_num_new'	=> $result->eplus_card_printed_card_num_new, 	
					'eplus_card_status'					=> $result->eplus_card_status, 	
					'eplus_card_date_claimed'			=> $result->eplus_card_date_claimed, 	
					'eplus_card_claim_user_id'			=> $result->eplus_card_claim_user_id, 	
				);

				// insert to db
				$write->set($details);
				$write->insert('eplus_card_logs');
			
		 
			}
		}
		
		
		
	
	
	
	
	}
   	
 	function add_card_logs_($card = false){
	
		 $read = $this->load->database('default',true); $write = $this->load->database('live',true);
		
		$read->where('eplus_card_printed_card_num', $card); 
		$query = $read->get('eplus_cards');
		
	
		if($query->num_rows() > 0){ 
		
			$result = $query->row(); 
			
			//insert card details
			$details = array(
				'eplus_card_ticket_id'				=> $result->eplus_card_ticket_id, 	
				'eplus_card_user_id'	 			=> $result->eplus_card_user_id, 	
				'eplus_card_date'	 				=> $result->eplus_card_date, 	
				'eplus_card_printed_card_num'		=> $result->eplus_card_printed_card_num, 	
				'eplus_card_internal_card_num'		=> $result->eplus_card_internal_card_num, 	
				'eplus_card_printed_card_num_new'	=> $result->eplus_card_printed_card_num_new, 	
				'eplus_card_status'					=> $result->eplus_card_status, 	
				'eplus_card_date_claimed'			=> $result->eplus_card_date_claimed, 	
				'eplus_card_claim_user_id'			=> $result->eplus_card_claim_user_id, 	
			);

			// insert to db
			$write->set($details);
			$write->insert('eplus_card_logs');
		
		}
	
	
	
	}
   
	
    //IPTL
	function get_iptl_ticket_details($transaction_id = false){
	 
		 
		// $query = $this->db->select();
		$this->db->select( 'ev.event_title as event_title
					 , ev.event_code as event_code
					 , ev.event_date_time as event_date_time
					 , ev.event_venue_amusement_tax as amtax
					 , tr.transaction_id
					 , ti.ticket_id as ticket_id
					 , tr.transaction_comment
					 , tr.transaction_date as transaction_date
					 , se.section_code as section
					 , ti.ticket_row as row
					 , ti.ticket_seat as seat
					 , tt.ticket_type_name as ticket_type
					 , tt.ticket_type_discount_type as discount_type
					 , tt.ticket_type_discount as discount
					 ,CASE WHEN (tt.ticket_type_discount_type = "Percentage" ) THEN (pr.price_price - (pr.price_price * tt.ticket_type_discount / 100)) ELSE pr.price_price END "price",
					 , br.branch_name as branch 
					 , ti.ticket_status as status
					 , ti.ticket_status as status',false);
		

		$this->db->join('tickets ti', 'ti.ticket_transaction_id = tr.transaction_id','left');
		$this->db->join('events ev', 'ev.event_id = ti.ticket_event_id','left');
		$this->db->join('sections se', 'se.section_id = ti.ticket_section_id','left');
		$this->db->join('ticket_types tt', 'tt.ticket_type_id = ti.ticket_type_id','left');
		$this->db->join('prices pr', 'pr.price_id = ti.ticket_price_id','left');
		$this->db->join('branches br', 'br.branch_id = tr.transaction_branch_id','left');
		// $this->db->join('eplus_cards e', 'e.eplus_card_ticket_id = ti.ticket_id  ','left');

	
		$this->db->where('tr.transaction_id', $transaction_id);
		$this->db->where('tr.transaction_status', 'done');
		$this->db->where('ti.ticket_status', 'done');
		// $this->db->where('e.eplus_card_ticket_id IS NULL');
		$this->db->group_by('ti.ticket_id'); 
		$query = $this->db->get('transactions tr');
		 
		 

		return $query->result();
	
	}

	
	function insert_iptl_details($xml_data = false)
	{
	
		$result = 0; $read = $this->load->database('default',true); $write = $this->load->database('live',true);
		if(!empty($xml_data)){
			 
			foreach($xml_data as $x){ 
					 
					 
				if($this->check_ticket($x['Ticket_Id'],$x['EventDate'])){
					
					$result = 1;
					//insert card details
					$details = array(
					'eplus_card_ticket_id'			=> $x['Ticket_Id'], 	
					'eplus_card_user_id'	 		=> $x['User_Id'],	
					'eplus_card_printed_card_num'	=> $x['PrintedCardNumber'],	
					'eplus_card_internal_card_num'	=> $x['InternalCardNumber'],	
					'eplus_card_status'				=> $x['Status'],
					'eplus_card_event_date'			=> $x['EventDate'],
					);

					// insert to db
					$write->set($details);
					$write->insert('eplus_cards');

				}
				 
			}
			 
		 }
		 
		return  $result;
	
	}
	  
	  
	function get_ticket_details_by_id($ticket_id = false){
	
		$this->db->select('eplus_card_ticket_id,eplus_card_event_date');
		
		if(!$ticket_id){
			$ticket_id = array(0);
		}
		$this->db->where_in('eplus_card_ticket_id', $ticket_id);
		$query = $this->db->get('eplus_cards');
		return $query->result();
	
	
	}
	 
	
	function check_ticket($ticket_id = false, $event_date = false){
	
	
		$this->db->where('eplus_card_ticket_id', $ticket_id); 
 		$this->db->where('eplus_card_event_date', $event_date); 
		$query = $this->db->get('eplus_cards');
	
		if($query->num_rows() > 0){ 
			return 0; 
		}else{
			return 1;
		}
	
	
	
	}
	
	function add_card_logs2($card = false, $user_id = false, $comment = false){
	
		 
		$read = $this->load->database('default',true); $write = $this->load->database('live',true);
		$read->where('eplus_card_printed_card_num', $card); 
		$query = $read->get('eplus_cards');
		$result = $query->row();
	
		if($query->num_rows() < 1 )
		die('card not found');
		//insert card details
		$details = array(
			'eplus_card_ticket_id'			=> $result->eplus_card_ticket_id, 	
			'eplus_card_user_id'	 			=> $result->eplus_card_user_id, 	
			'eplus_card_void_user_id'	 		=> $user_id, 	
			'eplus_card_date'	 			=> $result->eplus_card_date, 	
			'eplus_card_event_date'	 		=> $result->eplus_card_event_date, 	
			'eplus_card_printed_card_num'		=> $result->eplus_card_printed_card_num, 	
			'eplus_card_internal_card_num'		=> $result->eplus_card_internal_card_num, 	
			'eplus_card_printed_card_num_new'		=> $result->eplus_card_printed_card_num_new, 	
			'eplus_card_status'				=> $result->eplus_card_status, 	
			'eplus_card_date_claimed'			=> $result->eplus_card_date_claimed, 
			'eplus_card_comment'				=> $comment 
	

	
		);

		// insert to db
		$write->set($details);
		$write->insert('eplus_card_logs');
	
	
	
	
	
	}
   
	function add_card_logs3($ticket_id = false, $event_date = false, $user_id = false, $comment = false){
	
		 $read = $this->load->database('default',true); $write = $this->load->database('live',true);
		
		$read->where('eplus_card_ticket_id', $ticket_id); 
		$read->where('eplus_card_event_date', $event_date); 
		$query = $read->get('eplus_cards');
		$result = $query->row();
	
		if($query->num_rows() < 1 ){
			// die('Card not found. Please try again');
			$this->session->set_flashdata('message', assemble_message('Card not found. Please try again')); 
			redirect('eplus/void_iptl_card/'); 
				
		}
		//insert card details
		$details = array(
			'eplus_card_ticket_id'			=> $result->eplus_card_ticket_id, 	
			'eplus_card_user_id'	 			=> $result->eplus_card_user_id, 	
			'eplus_card_void_user_id'	 		=> $user_id, 	
			'eplus_card_date'	 			=> $result->eplus_card_date, 	
			'eplus_card_event_date'	 		=> $result->eplus_card_event_date, 	
			'eplus_card_printed_card_num'		=> $result->eplus_card_printed_card_num, 	
			'eplus_card_internal_card_num'		=> $result->eplus_card_internal_card_num, 	
			'eplus_card_printed_card_num_new'		=> $result->eplus_card_printed_card_num_new, 	
			'eplus_card_status'				=> $result->eplus_card_status, 	
			'eplus_card_date_claimed'			=> $result->eplus_card_date_claimed, 
			'eplus_card_comment'			=> $comment 
	

	
		);

		// insert to db
		$write->set($details);
		$write->insert('eplus_card_logs');
	
	
		return $result->eplus_card_printed_card_num;
	
	
	}
	
	
	 
}