<?php  if ( ! defined('BASEPATH')) exit('No direct script access allowed');

	
// --------------------------------------------------------------------
	
/**
 * character_cutter
 *
 * @access	public
 */
function character_cutter($string, $limit, $end_char = '&#8230;')
{
   return (strlen($string) <= $limit) ? $string : substr($string,0,$limit).' '.$end_char ;
}

// --------------------------------------------------------------------
	
/**
 * assemble_message
 *
 * @access	public
 */
function assemble_message($message) 
{
	return '<div id="success_message" class="success" autohide="5">'.$message.'</div>';
}

// --------------------------------------------------------------------
	
/**
 * assemble_error
 *
 * @access	public
 */
function assemble_error($message) 
{
	return '<div id="error_message" class="error">'.$message.'</div>';
}

function assemble_error_main($message) 
{
	return '<div id="success_message" class="success" style="background-color: #C33;color:FFF">'.$message.'</div>';
}

// --------------------------------------------------------------------
	
/**
 * prep_amount
 *
 * @access	public
 */
function prep_amount($str)
{	
	return str_replace(',', '', $str);
}	
	
// --------------------------------------------------------------------
	
/**
 * print_array
 *
 * @access	public
 */
function print_array($array) 
{
	echo '<pre>';
	print_r($array);
	echo '</pre>';
}

// --------------------------------------------------------------------
	
/**
 * jsencode
 *
 * @access	public
 */
function jsencode( $obj ){
	if( is_array( $obj ) ){
		$code = array();
		if( array_keys($obj) !== range(0, count($obj) - 1) ){
			foreach( $obj as $key => $val ){
				$code []= "\"$key\":" . jsencode( $val );
			}
			$code = '{' . implode( ',', $code ) . '}';
		} else {
			foreach( $obj as $val ){
				$code []= jsencode( $val );
			}
			$code = '[' . implode( ',', $code ) . ']';
		}
		return $code;
	} else {
		return '"' . addslashes( $obj ) . '"';
	}
}

// --------------------------------------------------------------------

/**
 * get_ip_address
 *
 * @access	public
 */
 
function get_ip_address() 
{
	return (empty($_SERVER['HTTP_CLIENT_IP'])?(empty($_SERVER['HTTP_X_FORWARDED_FOR'])? 
		$_SERVER['REMOTE_ADDR']:$_SERVER['HTTP_X_FORWARDED_FOR']):$_SERVER['HTTP_CLIENT_IP']);
}

// --------------------------------------------------------------------

/**
 * array_to_object
 *
 * @access	public
 */

function array_to_object($array) {
	$return = new stdClass();
	foreach ($array as $k => $v) {
		if (is_array($v)) {
			$return->$k = array_to_object($v);
		}
		else {
			$return->$k = $v;
		}
	}

	return $return;
}

// --------------------------------------------------------------------
	
/**
 * object_to_array
 *
 * @access	public
 */
function object_to_array($mixed) 
{
	if(is_object($mixed)) $mixed = (array) $mixed;
	if(is_array($mixed)) {
		$new = array();
		foreach($mixed as $key => $val) {
			$key = preg_replace("/^\\0(.*)\\0/","",$key);
			$new[$key] = object_to_array($val);
		}
	}
	else $new = $mixed;
	return $new;
}



if (! function_exists('printr')){
  function printr($val){
    echo "<pre>" . print_r($val, true). "</pre>";
    return true;
  }
}

if (! function_exists('out_datetime')) {
  function out_datetime($date, $format="F d, Y g:i:s A")
	{
    return date($format, strtotime($date));
	}	
}

if (! function_exists('out_date')) {
  function out_date($date, $format='F d, Y')
	{
	  if (strtotime($date))
        return date($format, strtotime($date));
	}	
}

if (! function_exists('input_date') ) {
  function input_date($date){
    return date('Y-m-d', strtotime($date));
  }
}

if (! function_exists('input_datetime') ) {
  function input_datetime($date){
    return date('Y-m-d G:i:s', strtotime($date));
  }
}

if (! function_exists('qw')) {
  function qw($str='') {
    return preg_split("/\s+/", $str);
  }
}

if (! function_exists('issetVal')) {
  function issetVal($var, $def='') {
    return issetNE($var) ? $var : $def;
  }
}

if (! function_exists('issetNE')) {
  function issetNE($var) {
    return isset($var) && !empty($var);
  }
}

if (! function_exists('issetNE')) {
  function issetNE($var) {
    return isset($var) && !empty($var);
  }
}

if (! function_exists('sanitize'))
{
	function sanitize($str)
	{
		return htmlspecialchars($str);		
	}	
}

if (! function_exists('pretty_title'))
{
	function pretty_title($str)
	{
		// first get
		$titles = explode('-', $str);
		return array_shift($titles);	
	}
}

/* End of file various_helper.php */
/* Location: ./system/helpers/various_helper.php */