<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
include('accesstemplate.php');

// class Generic extends CI_Controller {
class Generic extends AccessTemplate {
	
	public function __construct(){
		parent::__construct();
		$this->load->model('api_seatplans_model', 'seatplans');
		$this->load->model('api_events_model', 'events');
		$this->load->model('api_sections_model', 'sections');
		$this->load->model('api_transaction_model', 'transaction');
		$this->load->model('api_events_model', 'events');
		$this->load->model('api_prices_model', 'prices');
		$this->load->model('api_tickets_model', 'tickets');
		$this->load->model('api_payments_model', 'payments');
		$this->load->model('api_ticket_types_model', 'ticket_types');
		$this->load->model('api_ip_model', 'ip');
		$this->load->model('api_ticket_layouts_model', 'ticket_layouts');
		$this->load->model('api_bcode_model', 'bcode');
		$this->load->model('api_promo_codes_model', 'promo');

		// $this->load->database('default',true); 
	}
	
	function template() {
			
		// the date today
		$today = date("Y-m-d");
		$today = '2013-02-11';
		
		
		
		$dbAccess->select("
				evt.event_code
				, evt.event_title
				, evt.event_long_title
				, evt.event_date_time
			");
			
		$dbAccess->where("evt.event_date_time > '$today 00:00:00'");
		$dbAccess->where("evt.event_date_time < '$today 23:59:59'");
		$dbAccess->where("evt.event_active", 1);
		$query = $dbAccess->get('events evt');
	
	
		$this->load->dbutil();
		
		$config = array (
			  'root'    => 'root',
			  'element' => 'sections', 
			  'newline' => "\n", 
			  'tab'    => "\t"
			);

			
		$xmloutput = $this->dbutil->xml_from_result($query, $config);
		echo $xmloutput;

	}
	

	var $errorMessage = array (
		'ER:00' => 'Incomplete/Invalid Parameters.',
		'ER:01' => 'Invalid access.',
		'ER:02' => 'Inactive KEY',
		'ER:04' => 'In',
		'ER:05' => 'Relay problem and error encountered while storing data. Please contact MGI.',
		'ER:06' => 'Relay problem and error encountered while storing data. Please contact MGI.',
		);
	
	//============================== D A T A S Y N C  M O D E  =======================================
	//======= P a r t y L i n e   A u t h e n t i c a t i o n   P r o t o c o l =======
	function index(){
		date_default_timezone_set('Australia/Melbourne');
		$date = date('Y/m/d h:i:s a', time());
		echo  time() . " </br>";
	echo $date;
	}


	function verify_partyid(){
		
		//initialize parameters
		$partycode = $this->input->get_post('partycode');
		$usecode = $this->input->get_post('usecode');
		$appcodeduration = $this->config->item("appcode_expiry");
		$dbAccess = $this->load->database('default',true);
		$read = $this->load->database('default',true);
		$write = $this->load->database('live',true);

		//Check if parameters are empty
		if(!$partycode){
			$this->promptError('ER:01:01');
		}
		elseif(!$usecode){
			$this->promptError('ER:01:02');
		}else{
		
		//Check existence of partycode &&  usecode..Returns true if exists
		if($this->verifyparty($partycode,$usecode))
			{
				 
				
				//Get partyCredentials
				$partycredentials = array(
				'platform' =>  $this->agent->platform(),
				'browser' =>  $this->agent->browser().' '.$this->agent->version(),
				'ipaddress' =>  $this->input->ip_address(),
				'referrer:' => $this->agent->referrer()
				);
				
				//EXECUTE!
				//Issue an AppCode
				$appcode = $this->generateAppCode($partycode,$usecode,$this->getcurrentdatetime());

				//Save Appcode into api_sessions
				$data = array(
			   'api_partycode' => $partycode,
			   'api_apppcode' => $appcode,
			   'api_livetoken' => 0,
			   'api_duration' => $appcodeduration,
			   'api_gen_active' => 1,
			   'api_time_issued' => $this->getcurrentdatetime(),
			   'api_session_browser' => $partycredentials['browser'],
			   'api_party_ip' => $partycredentials['ipaddress']
				);
				$write->insert('api_sessions', $data); 

				// echo $write->last_query();
				// die();
				$data['content'] = $appcode;

				$xml = '<appcode>'. $appcode.'</appcode>
					<dateTimeActivated>'.$this->getcurrentdatetime().'</dateTimeActivated>
					<expiration>'.$appcodeduration.'</expiration>';
					
				$data['content'] = $xml;	
				$this->load->view("appcode_xml", $data);
		 
			}
	
			else
			{
				$this->promptError('ER:02:02');
			}
		}
	}
	
	
	function initialize_partyline(){
			$dbAccess = $this->load->database('default',true);
			$dbAccess->query('set transaction isolation level read uncommitted');
			$write = $this->load->database('live',true);

			$appcode = $this->input->get_post('appcode');
			$livetoken = null;
					
			//check if appcode exist
			if(!$appcode){
				$this->promptError('ER:01:03');
			}else{				
			
				$dbAccess->where("api_apppcode", $appcode);
				$query = $dbAccess->get('api_sessions');

				$array = $query->result_array();	
						
				// $appcodeIP = $array[0]['api_party_ip'];

				//commpare IP Adresses
				// if($appcodeIP != $this->input->ip_address()){
					// $this->promptError('ER:00:01');
				// }
				//check if appcode exist in the Database
				if($query->num_rows() < 1){
					$this->promptError('ER:02:01');
				}
				//Check if there is a LiveToken already issued for this appcode
				else if($query->num_rows() == 1){
					//Check if appcode is still valid..if valid..
					if(!$this->checksessionexpiration($appcode,0)){
						//issue LiveToken
						$livetoken = $this->generatelivetoken($appcode);

						//Get partyCredentials( browser, ip, etc.. )
						$partycredentials = $this->getpartycredentials();
						
						//deactivate appcode
						$this->session_deactivate($appcode,0);
						
						//Save LiveToken into api_sessions
						$data = array(
					   'api_partycode' => $array[0]['api_partycode'],
					   'api_apppcode' => $appcode,
					   'api_livetoken' => $livetoken,
					   'api_duration' => $this->config->item("livetoken_expiry"),
					   'api_gen_active' => 1,
					   'api_time_issued' => $this->getcurrentdatetime(),
					   'api_session_browser' => $partycredentials['browser'],
					   'api_party_ip' => $partycredentials['ipaddress']
						);
						
						//insert new active LiveToken row into api_sessions
						$write->insert('api_sessions', $data); 	
						$data['content'] =  $livetoken;
						$xml = '<livetoken>'. $livetoken.'</livetoken>
						<dateTimeActivated>'.$this->getcurrentdatetime().'</dateTimeActivated>
						<expiration>'.$this->config->item("livetoken_expiry").'</expiration>';
						$data['content'] = $xml;	
						$this->load->view("livetoken_xml", $data);	
					}else{	//invalid appcode
						$this->promptError('ER:03:02');
					}
				}else{	//AppCode is already used
					$this->promptError('ER:02:04');
				}
			}			
			




		}
	
	 
	function refresh_party(){
	$appcode = $this->input->get_post('appcode');
	$livetoken = $this->input->get_post('livetoken');
	$read = $this->load->database('default',true);
	$write = $this->load->database('live',true);

	//Check if parameters are empty
	if(!$appcode){
		// $data['content'] = 'ERROR: No AppCode Provided';
		$this->promptError('ER:01:03');
	}
	elseif(!$livetoken){
		// $data['content'] = 'ERROR: No LiveToken Provided';
		$this->promptError('ER:01:04');
	}else{
		
			//Checks the validity of $appcode && $livetoken
			if ($this->validatesession($this->input->get_post('appcode'),$this->input->get_post('livetoken')))
			{

				//Check if Expired..if not yet expired..
				if(!$this->checksessionexpiration($appcode,$livetoken))
				{
					//Deactivate an $appcode/$livetoken
					$this->session_deactivate($appcode,$livetoken);
						
					//issue LiveToken
					$livetoken = $this->generatelivetoken($appcode);

					//Get partyCredentials
					$partycredentials = $this->getpartycredentials();

					//Save LiveToken into api_sessions
					$data = array(
				   'api_partycode' => $this->getpartycodebyappcode($appcode),
				   'api_apppcode' => $appcode,
				   'api_livetoken' => $livetoken,
				   'api_duration' => $this->config->item("livetoken_expiry"),
				   'api_gen_active' => 1,
				   'api_time_issued' => $this->getcurrentdatetime(),
				   'api_session_browser' => $partycredentials['browser'],
				   'api_party_ip' => $partycredentials['ipaddress']
					);
					$write->insert('api_sessions', $data); 	

				
					$data['content'] = $livetoken;
						
					$xml = '<livetoken>'. $livetoken.'</livetoken>
					<dateTimeActivated>'.$this->getcurrentdatetime().'</dateTimeActivated>
					<expiration>'.$this->config->item("livetoken_expiry").'</expiration>';
					
					$data['content'] = $xml;		
					$this->load->view("livetoken_xml", $data);	
							
								
				}

				else
				{
				// $data['content'] =  'LiveToken Expired';
				$this->promptError('ER:03:01');
				}
			}
			else
			{
			// $data['content'] =  'Invalid Key Pair';
			$this->promptError('ER:02:02');
			}
		
		}
	}
	
	
	// initialize access to the mobile seagmes view
	function access_page(){
	
		$appcode = $this->input->get_post('appcode');
		$livetoken = $this->input->get_post('livetoken');
 
		
		if(!$appcode){
			$this->promptError('ER:01:03');
		}elseif(!$livetoken){
			$this->promptError('ER:01:04');
		}else{
		
			$sessionStatus = $this->checkTokenStatus($appcode,$livetoken);
			
			if($sessionStatus == "nonexistent"){
			$this->promptError('ER:02:02');
			}elseif($sessionStatus == "expired"){
			$this->promptError('ER:03:01');
			}else{	
  
				echo 'Access Granted';
			}
		}
	}

	
		// Get_Customer_Transactions()
	function get_customer_transactions(){

	$appcode = $this->input->get_post('appcode'); 
	$livetoken = $this->input->get_post('livetoken');
	$email = $this->input->get_post('email'); //email
	
	if(!$appcode){
		$this->promptError('ER:01:03');
	}elseif(!$livetoken){
		$this->promptError('ER:01:04');
	}elseif (!$email){
		$this->promptError('ER:04:10');
	}else{
		
		$sessionStatus = $this->checkTokenStatus($appcode,$livetoken);
				
		if($sessionStatus == "nonexistent"){
		$this->promptError('ER:02:02');
		}elseif($sessionStatus == "expired"){
		$this->promptError('ER:03:01');
		}else{	
			$data['transactions'] = $this->transaction->get_customer_transactions_by_email($email);
			 
			if(empty($data['transactions'])){
			$this->promptError('ER:04:22');
			}else{
			//display the page
			$this->load->view('customer_transactions_xml', $data);
			}
		}
	}
}	
	
	 
	//Checks the existence of partycode and its corresponding usecode..Returns true if exists
	function verifyparty($partycode=false,$usecode=false){
		$isvalid = false;
		
		$dbAccess = $this->load->database('default',true);
		$dbAccess->select("api_user_id");
		$dbAccess->where("partycode", $partycode);
		$dbAccess->where("usecode",  $usecode);
		$query = $dbAccess->get('api_party');

			if ($query->num_rows() > 0)
			{
			$isvalid = True;
			}
			
		return $isvalid;
	}

	//NOTE..$partycode,$usecode and $time are mixed together to  generate an $appcode
	function generateAppCode($partycode = false, $usecode=false, $time=false){
		$appcode = $this->encrypt->sha1($partycode.'MGI'.$usecode.'MGI'.$time );
		return $appcode;
	}
	 
	//NOTE..$appcode and $time are mixed together to  generate a $livetoken
	function generatelivetoken($appcode=false){
		$livetoken = $this->encrypt->sha1($appcode.'MGI'.$this->getcurrentdatetime().'MGI');
		return $livetoken;
	}
	
	//Returns an array of party platform,browser, ipAdress and referrer
	function getpartycredentials(){
		$partycredentials = false;
		
		$partycredentials = array(
		'platform' =>  $this->agent->platform(),
		'browser' =>  $this->agent->browser().' '.$this->agent->version(),
		'ipaddress' =>  $this->input->ip_address(),
		'referrer:' => $this->agent->referrer()
		);
		return $partycredentials;
	}
	 
	function session_deactivate($appcode=false,$livetoken=false){
		$success = false;
		$dbAccess = $this->load->database('live',true);
		
		// update api_gen_active from 1 to 0
		$data = array('api_gen_active' => 0);
		$dbAccess->where('api_apppcode',$appcode);
		$dbAccess->update('api_sessions', $data); 	
		
		if($dbAccess->affected_rows() > 0) { 
			$success = true;
		}
					
		return $success;
	}
	
	//Get $partycode from sessions by appcode/liveToken
	function getpartycodebyappcode($appcode){
		$partycode = false;

		$dbAccess = $this->load->database('default',true);
		$dbAccess->query('set transaction isolation level read uncommitted');
		$dbAccess->select("api_partycode");
		$dbAccess->where("api_apppcode", $appcode);
		$dbAccess->limit(1);
		$query = $dbAccess->get('api_sessions');

		if ($query->num_rows() > 0){
		$row = $query->row();	
		$partycode = $row->api_partycode;
		}
		else
		{
		echo 'Unable to retrieve partycode from the database'; 
		}

		return $partycode;

	}

	function check_customerByID($value=false){
		$exist = false;
		$dbAccess = $this->load->database('default',true);
		$dbAccess->where("customer_id", $value);;
		$query = $dbAccess->get('customers');

			if ($query->num_rows() > 0)
				{
				$exist = true;
				}

	return $exist;
	}

	//Current Time
	function getcurrentdatetime(){
		//Set Current Date
		$date = new DateTime(null, new DateTimeZone('Asia/Manila'));
		return $date = $date->format('Y-m-d H:i:s');
	} 
		
	function testdb(){
		
		
		$servername = "10.141.23.135";
		$username = "web-api3";
		$password = "W3B-@p!_us3r";

		 

		// Create connection
		$conn = new mysqli($servername, $username, $password);

		// Check connection
		if ($conn->connect_error) {
			die("Connection failed: " . $conn->connect_error);
		}
		echo "Connected successfully";

	}
 
		 
	function events_per_cluster(){
		 
		$venue = array(1);	
		$cluster = $this->input->post('cluster');
		if(!$cluster) die('No Cluster provided');
		
		if($cluster == 'manila'){
			$venue = array(691,696,697);	
		} 
		
		if($cluster == 'clark'){
			$venue = array(660,689);	
		} 
		
		if($cluster == 'subic'){
			$venue = array(675,695);	
		} 
		
		if($cluster == 'others'){
			$venue = array(692,693);	
		} 
		
		
		
		
		
		$dbAccess = $this->load->database('market',true);
		
	
		
		$dbAccess->select('	e.event_id
							,e.event_active
							,e.event_title
							,e.event_long_title
							,e.event_image
							,e.event_date_time
							,e.event_performers
							,v.venue_id
							,v.venue_name
							,v.venue_category
							');

		$dbAccess->where("e.event_active",'1');
		$dbAccess->where_in("e.event_venue_id",$venue); 
		$dbAccess->where("e.event_date_time >= now()");
		$dbAccess->join('venues v', 'v.venue_id = e.event_venue_id', 'left' );
		// $dbAccess->join('events_config ec', 'ec.events_config_eventid = e.event_id', 'left' );
		
		 
		
		$dbAccess->order_by('e.event_performers',"asc");
		$dbAccess->order_by('e.event_date_time',"asc");
		
		$query = $dbAccess->get('events e');
		$data['cluster'] = $cluster; 
		$data['events'] = $query->result();


		// print_r($data['events']);
		// die();
		//display the page
		$this->load->view('events_per_cluster_xml', $data);
		 
		 		
				
	}
	
	 
 
 
}




