<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
include('accesstemplate.php');

// class Transaction extends CI_Controller {
class Transaction extends AccessTemplate{


	
	public function __construct()
	{
		parent::__construct();
		$this->load->model('api_transaction_model', 'transaction');
		$this->load->model('api_sections_model', 'sections');
		$this->load->model('api_payment_types_model', 'payment_types');
		$this->load->model('api_payments_model', 'payments');
		$this->load->model('api_branches_model', 'branches');
		$this->load->model('api_bcode_model', 'bcode');
		$this->load->model('api_tickets_model', 'tickets');
		$this->load->model('api_prices_model', 'prices');
		$this->load->model('api_events_model', 'events');
		$this->load->model('api_mobilenum_model', 'mobilenum');
		$this->load->model('api_ip_model', 'ip');
		$this->load->model('api_authentication_model', 'authentication');
		$this->load->model('api_customers_model', 'customers');
		$this->load->model('api_ticket_layouts_model', 'ticket_layouts');
		$this->load->model('admin_model', 'admin');
		$this->load->database('default',true);
		// $this->db->query('set transaction isolation level read uncommitted');
	}	
	
	
	
	function login(){ 
		
		//get required parameters
		$username = $this->input->get_post("username");
		$password = $this->input->get_post("password");
		$partyCode = $this->input->get_post("partycode");
		
		$key = $this->input->get_post("key");
		$fixedPass = $this->config->item("passkey");
		
		$email = $this->input->get_post("email");
		
		$ip = $this->input->ip_address();
		
			if(!$username){
				$this->promptError('ER:01:07');		
			}elseif(!$password){
				$this->promptError('ER:01:05');
			}elseif(!$partyCode){
				$this->promptError('ER:01:01');
			}elseif(!$key || $key == $fixedPass){
		
			//verify credentials and issue accesscode
			$data['result'] = $this->transaction->verify($username, $password, $partyCode,$ip,$key,$email);
			
			if($data['result'] == 'Invalid'){
				$this->promptError('ER:02:10');
			}elseif($data['result'] == 'invalid_ip'){
				$this->promptError('ER:00:01');
			}
			else{
				// $this->log_details("login","","", "", "user: $username | pass: $password");
				$this->load->view("access_code_xml", $data);
				}
		}else{
		$this->promptError('ER:00:00');
		}
	}
	 
	function initialize(){
	
		
		//get required parameters
		$accessCode = $this->input->get_post("accesscode");
		
		if(!$accessCode){
			$this->promptError('ER:01:06');
		}else{
		
			//verify accesscode and generate live token
			$data['result'] = $this->transaction->validateAccessCode($accessCode);
		
			if($data['result'] == 'expired'){
				$this->promptError('ER:03:03');
			}elseif($data['result'] == 'inactive'){
				$this->promptError('ER:02:09');
			}elseif($data['result'] == 'invalid'){
				$this->promptError('ER:02:06');
			}else{
				$this->load->view("initialize_xml", $data);
			}
		}
	}
	
	
	function renew_token(){
	
		//get required parameters
		$accessCode = $this->input->get_post('accesscode');
		$token = $this->input->get_post('dynatoken');
	
		if(!$accessCode){
			$this->promptError('ER:01:06');
		}elseif(!$token){
			$this->promptError('ER:01:08');
		}else{
	
			$data['result'] = $this->transaction->renewToken($accessCode, $token);
			
			if($data['result'] == 'expired'){
				$this->promptError('ER:03:04');
			}elseif($data['result'] == 'inactive'){
				$this->promptError('ER:02:08');
			}elseif($data['result'] == 'invalid'){
				$this->promptError('ER:02:02');
			}else{
			$this->load->view("initialize_xml", $data);
			}
		
		}
	
	
		
	}
	
	 
	  	
	function payment_done()
	{ 
  
		//order details
		$referencenumber =  $this->input->post("referencenumber"); 
		$amount =  $this->input->post("amount"); 
		$paycode =  $this->input->post("paycode"); 
		
		
		$cardNumber =  $this->input->post("cardnumber"); 
		$expiration =  $this->input->post("expiration"); 
		$card_type =  $this->input->post("card_type"); 
		// $others =  $this->input->post("others"); 
 		 
		
		 
		//for security
		$appCode =  $this->input->get_post("appcode"); 
		$liveToken =  $this->input->get_post("livetoken"); 
		$accessCode =  $this->input->get_post("accesscode"); 
		$dynaToken =  $this->input->get_post("dynatoken"); 
		 
  
			 
		if(!$cardNumber){$cardNumber = 'xxxxxxxxxxxxxxxx';} 
		if(!$expiration){$expiration = 'x';} 
		if(!$card_type){$card_type = 0;} 
		
		
		$ref = explode("-", $referencenumber);  
		if(!$appCode){
			$this->promptError('ER:01:03');
		}elseif(!$liveToken){
			$this->promptError('ER:01:04');
		}elseif(!$accessCode){
			$this->promptError('ER:01:06');
		}elseif(!$dynaToken){
			$this->promptError('ER:01:08');
		}elseif(!$referencenumber){ 
			$this->promptError('ER:06:03');  
		}elseif($ref[0] != 99){
			$this->promptError('ER:06:04'); 
		}elseif(!$paycode){
			$this->promptError('ER:06:08'); 
		}elseif(!$amount){
			$this->promptError('ER:06:05'); 
		}else{
			
			
			$access_result = $this->transaction->verify_access_token($accessCode, $dynaToken);
			
			if($access_result == 'expired'){ 
				$this->promptError('ER:03:04');
			}elseif($access_result == 'inactive'){ 
				$this->promptError('ER:02:14');
			}elseif($access_result == 'invalid'){ 
				$this->promptError('ER:02:12'); 
			}else{	
			
				$app_result = $this->transaction->verify_app_token($appCode, $liveToken);
			
				if($app_result == 'expired'){ 
				$this->promptError('ER:03:01');
				}elseif($app_result == 'inactive'){ 
					$this->promptError('ER:02:13');
				}elseif($app_result == 'invalid'){ 
					$this->promptError('ER:02:11'); 
				}else{
					$transaction_id = $ref[1];	 
					// $this->log_details("payment_done3","" ,$transaction_id, "","");
					// default value
					$pid = 0;
					$eid = 0;
					
					//check if the ticket is reserved or selected
					$status = $this->transaction->get_ticket_status($transaction_id);
				
					if($status == 'reserved'){
						$selected_tickets = $this->tickets->get_reserved_tickets($transaction_id);
					}elseif($status == 'selected'){
						 
						$selected_tickets = $this->tickets->get_selected_tickets($transaction_id);
					 
					 
						// identify tickets and the price_id/event_id just in case user opened events with new tab
						
						 
						foreach ($selected_tickets as $ticket) {
							$pid = $ticket->ticket_price_id;
							$eid = $ticket->ticket_event_id;
						}

						// check if valid access
						if (($pid > 0) && ($eid > 0)) { 
							// transaction tickets has valid event_id and price_id info
						 

							// identify price id from tickets
							$data['price'] =  $this->prices->get($pid);
							
							// identify event id from tickets
							$data['event'] = $this->events->get($eid);
							
							// get total amount
							$ticket_count = count($selected_tickets); 
							// $total_amount = $ticket_count * $data['price']->price_price;
							
							 
							
							$total_amount = 0;
							foreach($selected_tickets as $x){
							
							if ($x->ticket_type_discount_type == 'Amount'): 
							
								$price = ceil($x->price_price - $x->ticket_type_discount);  
								$total_amount = $total_amount + $price;
							elseif ($x->ticket_type_discount_type == 'Percentage'): 
							
								$price = ceil($x->price_price - (($x->price_price * $x->ticket_type_discount)/100)); 
								$total_amount = $total_amount + $price;
							endif; 
							 
							}
							
							
							
							
							$orig_amount_raw = $total_amount + ($data['event']->event_internet_sales_charge * $ticket_count);
							$orig_amount = number_format($orig_amount_raw, 2, '', '');
							if ($orig_amount != $amount)
							{
								//error message
								//Amount paid did not match the transaction amount
								echo $orig_amount . ' ' . $amount;
								$this->promptError('ER:06:06'); 
								
							}
							else
							{
								$payment_type = $this->payment_types->get_by_code($paycode);
								
								if(!$payment_type){
								//invalid paycode
								
								echo $payment_type;
								// $this->promptError('ER:06:13');
								}else{ 
									$this->transaction->paid_online2($transaction_id,$status); // mark the transaction as paid_online
									
									$barcode = strtoupper(hash("crc32", $transaction_id));
									
									$this->transaction->add_barcode($transaction_id,$barcode); //Add Barcode
									
									$this->payments->add($transaction_id, $payment_type->payment_type_id, $orig_amount_raw); // add total payment
									// $card_num = $this->input->get("CardNum");
									$this->payments->add_cardnum($transaction_id,$cardNumber,$expiration, $card_type);
									
									$charge_amount = ($data['event']->event_internet_sales_charge * $ticket_count);
									if ($charge_amount > 0) {
										$this->payments->add_convenience_charge_details($transaction_id, $ticket_count, $charge_amount); // add convenience charge details
									}
									$this->payments->add_totalpay($transaction_id, $payment_type->payment_type_id, $orig_amount_raw, 'total'); // add total amount
									$data['payment_type'] = $payment_type->payment_type_code; // payment type
									
									// add receipt numbers
									$or_number = 0;
									$transaction = $this->transaction->get_for_bcode($transaction_id);
									if($transaction){ 
										// OR number  &&  $transaction->customer_id != 82476
										$event_internet_sales_charge = $data['event']->event_internet_sales_charge;
										if (is_numeric($event_internet_sales_charge) && ($event_internet_sales_charge > 0))
										{
											$or_number = $this->branches->get_last_or_number($transaction->transaction_branch_id);
											$this->transaction->update_receipt_number($transaction_id, $or_number);
										}
										else 
										{
											$or_number = 0;
										}
										
															
										foreach ($selected_tickets as $ticket)
										{
											// AR number
											$ar_number = $this->branches->get_last_receipt_number($transaction->transaction_branch_id);
											$this->tickets->update_acknowledgment_receipt($ticket->ticket_id, $ar_number);
											
											
										}
										
									
										//check events_config if bcode is active
										$useBCODE = $this->bcode->isActive($eid);
							
										if ($useBCODE) {
											$d_or_number = sprintf("%06d", $or_number);
											$msg = "OR No: $d_or_number RefNum: $transaction_id Thank you for buying through SM Tickets Online.";
											
											$arrMobileNum = $this->mobilenum->lookup($transaction->customer_mobile);
											if ($arrMobileNum['isLocal']) {
												$carrier = $arrMobileNum['bCODE'];
												$localmobilenum = $arrMobileNum['CountryCode'].$arrMobileNum['MobileNum'];
											} 
											else {
												$localmobilenum = $arrMobileNum['MobileNum'];
											}
											// $sendSMS = $this->session->userdata('sendSMS');
											$sendSMS = '';
											
											if (empty($sendSMS)) {
												$carrier = '';
												$msg = '';
											}
											
											$querydata = array(
												'user' => $this->config->item('bcode_user'),
												'password' => $this->config->item('bcode_pass'),
												'application' => $this->config->item('bcode_app'),
												'mobile' => $localmobilenum,
												'carrier' => $carrier,
												'message' => $msg,
											);
											
											
								
											$xmlResult = $this->extension->__getbcode($querydata);
											if (is_array($xmlResult)) {
												if (isset($xmlResult['Result']) && ($xmlResult['Result'] == 0)) {
													$insertdata = array(
														'bcode_transaction_id' => $transaction_id,
														'bcode_value' => $xmlResult['bCODE'],
														'bcode_sendSMS' => $localmobilenum,
														'bcode_carrier' => $carrier,
													);
													$write = $this->load->database('live',true);
													$write->insert('bcode', $insertdata); 
												}
											}
										}

									
									}	
									// $postrequest = @$this->extension->post2mci($this->session->userdata('tid'));
									// $postrequest = @$this->extension->post2mci($transaction_id);
									// $this->session->unset_userdata('sendSMS');
									// redirect("transaction/payment_receipt/$transaction_id/$hash/$pid/$eid");
									
									sleep(1);
									// get data
									$data['charge_amount'] = $charge_amount; 
									$data['transaction_id'] = $transaction_id; 
									$data['or_receipt'] = $this->transaction->get_or($transaction_id); 
									$data['trans_date'] = date("Y-m-d H:i:s");
									$data['amount'] = $amount;
									$data['tickets'] = $this->tickets->get_paid_online_tickets($transaction_id);
									
									// $this->tag_blink($transaction_id);
									// $this->tag_as_used($transaction_id);

									
									//insert into historical table 
									// $this->admin->copy_tickets($transaction_id, 'paid_online');
									// $this->admin->copy_transactions($transaction_id,'paid_online');
									// $this->admin->copy_payments($transaction_id);
									// $this->admin->copy_charges($transaction_id);
								
									
									$this->add_to_historical($transaction_id);
									 
									$this->load->view("result_seagames_xml", $data);
									//$this->customers->send_payment_notification($appCode,$liveToken,$accessCode,$dynaToken,$transaction_id);
								}
							}
							
							
						}else{
							$this->promptError('ER:06:07'); 
							// die('asd');
						}	
						 
					} else {
						//Invalid transaction information.'
						$this->promptError('ER:06:07'); 
					}
				}
			}
		}
	 	
	}
	
	
	function add_to_historical($transaction_id = false){
		
		if(!$transaction_id) die('Unknown Error Encountered');
		
		//insert into historical table 
		$this->admin->copy_tickets($transaction_id, 'paid_online');
		$this->admin->copy_transactions($transaction_id,'paid_online');
		$this->admin->copy_payments($transaction_id);
		$this->admin->copy_charges($transaction_id);
		
		
	}
	
	 
	function get_voucher(){
	

		$accessCode = $this->input->get_post('accesscode');
		$dynatoken = $this->input->get_post('dynatoken'); 
		$appcode = $this->input->get_post('appcode');
		$livetoken = $this->input->get_post('livetoken');  
		
		$referencenumber = $this->input->get_post('referencenumber');
 
		if(!$appcode){
		$this->promptError('ER:01:03');
		}elseif(!$livetoken){
		$this->promptError('ER:01:04');
		}elseif(!$accessCode){
		$this->promptError('ER:01:06');
		}elseif(!$dynatoken){
		$this->promptError('ER:01:08');
		}elseif(!$referencenumber){ 
			$this->promptError('ER:06:03');
 		}else{  
		
			$ref = explode("-", $referencenumber);  
			$transaction_id = $ref[1];		
			
			
			// $voucher = $this->tickets->getVoucherInfo($transaction_id);
			
			$transaction = $this->transaction->get($transaction_id);	
			 
			// $transaction = $this->transactions->get($transaction_id);
			// $transaction_customer_id = $voucher[0]->transaction_customer_id;
			
			$access_result = $this->transaction->verify_access_token($accessCode, $dynatoken);
				
			if($access_result == 'expired'){ 
				$this->promptError('ER:03:04');
			}elseif($access_result == 'inactive'){ 
				$this->promptError('ER:02:14');
			}elseif($access_result == 'invalid'){ 
				$this->promptError('ER:02:12'); 
			}else{	
			
				$app_result = $this->transaction->verify_app_token($appcode, $livetoken);
			
				if($app_result == 'expired'){ 
				$this->promptError('ER:03:01');
				}elseif($app_result == 'inactive'){ 
					$this->promptError('ER:02:13');
				}elseif($app_result == 'invalid'){ 
					$this->promptError('ER:02:11'); 
				}else{
				
					$data['transaction'] = $transaction;
					if(!$transaction){ 
						$this->error->promptError('ER:06:07');
					}

					$data['tickets'] = $this->tickets->get_tickets($transaction_id);
					// $data['ticket_terms'] = $file = file_get_contents(base_url() . '/resources/terms/ticket_terms.txt', true);
					if (count($data['tickets']) > 0)
					{
						
					// force voucher type to be always all to avoid issue with generation of per ticket voucher
						$type = "all";
						$voucher_type = ($type == 'all') ? 'all' : 'one';
						$data['voucher_type'] = $voucher_type;	
						
						$data['price'] = $this->prices->get($data['tickets'][0]->ticket_price_id);
						$data['event'] = $this->events->get($data['tickets'][0]->ticket_event_id);
						$payments = $this->payments->get_payments($transaction_id);

						$data['payment_type'] = (count($payments) > 0) ? $payments[0]->payment_type_name : 'Unknown Payment Type';
						$total_payment = 0;
						foreach($payments as $payment)
						$total_payment += $payment->payment_amount;
						$data['total_amount'] = $total_payment;
						$data['ticket_layout'] = $this->ticket_layouts->get($data['tickets'][0]->ticket_event_id);
						$data['bcode'] = $this->bcode->get_transaction_bcode($transaction_id);

							
						  
						$data['r'] =  "";	 
						
						// display the page
						// $this->load->view('1transaction_tickets', $data);
						$this->load->view('1transaction_tickets_sea', $data);

					}
					else{
					echo 'Ticket not found';
					}
					
				}
			}
			 
					
		}		 
	}
	
	function auth(){
		$url =  "https://dfsdev.spicelabs.in/dfs-core/api/v1/oauth";
		$client_id = "smtClient";
		$password = 'saZ"4NADgt)"SB&M';
 
 		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL,$url);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER,1);
		curl_setopt($ch, CURLOPT_HTTPAUTH, CURLAUTH_BASIC);
		curl_setopt($ch, CURLOPT_USERPWD, "$client_id:$password");
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);  
		curl_setopt($ch, CURLOPT_HEADER, 1);
		
		$response = curl_exec($ch);
	 
		// Retudn headers seperatly from the Response Body
		$header_size = curl_getinfo($ch, CURLINFO_HEADER_SIZE);
		$headers = substr($response, 0, $header_size);
		$body = substr($response, $header_size);

		curl_close($ch);   
		$headers = explode("\r\n", $headers); // The seperator used in the Response Header is CRLF (Aka. \r\n) 

		$headers = array_filter($headers);
		
		return $headers[6];

		// echo '<pre>';
		// print_r($headers);
		// echo '</pre>';
		
		// echo($_SERVER['HTTP_AUTHORIZATION']);
	}

	function try() {
		$url =  "https://dfsdev.spicelabs.in/dfs-core/api/v1/merchant/initiate/payment";
		$authtoken = $this->auth();
		$token = str_replace("X-AUTH-TOKEN: ", '', $authtoken) ;
		$ch = curl_init();

		$dateTime = time();

		$sourceInfo = array(
			"channelId" => "25", 
			"surroundSystem" => "50"
		);   

		$transacInfo = array(
			"clientTransactionID" => "111119999000", 
			"requestId" => "678452342", 
			"Timestamp" => "12345678"
		);     

		$serviceRequest = array(
			'mfsSourceInfo' => $sourceInfo, 
			"mfsTransactionInfo" => $transacInfo
		);

		$requestInfo = array(
			'Amount' => "2000", 
			"merchantCode" => "MER157", 
			"merchantId" => "10101", 
			"msisdn" => "9896490200"
		);      

		$postData = array(
			"mfsCommonServiceRequest" => $serviceRequest, 
			"mfsRequestInfo" => $requestInfo
		);

		$data_string = json_encode($postData);

		$header = array("Authorization: bearer ". $token);
		curl_setopt($ch, CURLOPT_URL,$url);
       	curl_setopt($ch, CURLOPT_POST, true);                                                                  
       	curl_setopt($ch, CURLOPT_POSTFIELDS, $data_string);                                                                  
       	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);                                                                      
       	curl_setopt($ch, CURLOPT_HTTPHEADER, $header);

       	$result = curl_exec($ch);

       	curl_close($ch);

       	print_r($result);
	}

	function verify_access_token($accessCode, $token){
	
		
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->where('api_accesscode', $accessCode);
		$this->db->where('api_dynatoken', $token);
		$query = $this->db->get('api_sessions');
	
		$count = $query->num_rows();
		if($count > 0)
		{
			$result = $query->row();
			
			//get current date and time
			$currentDateTime = $this->getCurrentDateTime();
			
			$expiryTime = $result->api_duration;
			date_default_timezone_set('Asia/Manila');
			$endtime = new DateTime($result->api_time_issued);
			$endtime->modify("+" .$expiryTime ." minutes");
			$endtime = $endtime->format('Y-m-d-H:i:s');
			//check if expired 
			
			
			// die();
			if($endtime < $currentDateTime){
				//deactivate previous access credentials
				$this->deactivateSession($accessCode, $token);
				echo 'expired';
			
			}else{
				if($result->api_active == 0)
				{
					echo 'inactive';
				}
				else{
				
					echo 'valid';
					
				}
			}
			
		}else{
		
			echo 'invalid';
		
		}
	
	
	
	}
	
	
	function getCurrentDateTime(){
		$date = new DateTime(null, new DateTimeZone('Asia/Manila'));
		return $date->format('Y-m-d-H:i:s');	
		
	}
	

		
	function deactivateSession($accessCode, $token){
	
		$read = $this->load->database('default',true);
		$write = $this->load->database('live',true);
		$write->where('api_accesscode',$accessCode);
		$write->where('api_dynatoken',$token);
		$write->set('api_active', 0);
		$write->update('api_sessions');
		return true;
	}

}