<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
include('accesstemplate.php');

// class Transaction extends CI_Controller {
class Users extends AccessTemplate{


	
	public function __construct()
	{
		parent::__construct();
		$this->load->model('transactions_model', 'transactions');
		$this->load->model('users_model', 'users');
		 
		$this->load->database('default',true);
		// $this->db->query('set transaction isolation level read uncommitted');
	}	
	
 
	function login(){ 
		
		//get required parameters
		$username = $this->input->get_post("username");
		$password = $this->input->get_post("password");
		$partyCode = $this->input->get_post("partycode");
		
		$key = $this->input->get_post("key");
		$fixedPass = $this->config->item("passkey");
		
		$email = $this->input->get_post("email");
		
		$ip = $this->input->ip_address();
		
			if(!$username){
				$this->promptError('ER:01:07');		
			}elseif(!$password){
				$this->promptError('ER:01:05');
			}elseif(!$partyCode){
				$this->promptError('ER:01:01');
			}elseif(!$key || $key == $fixedPass){
		
			//verify credentials and issue accesscode
			$data['result'] = $this->users->verify($username, $password, $partyCode,$ip,$key,$email);
			
			if($data['result'] == 'Invalid'){
				$this->promptError('ER:02:10');
			}elseif($data['result'] == 'not_verified'){
				$this->promptError('ER:04:41');
			}elseif($data['result'] == 'invalid_ip'){
				$this->promptError('ER:00:01');
			}
			else{
				// $this->log_details("login","","", "", "user: $username | pass: $password");
				$this->load->view("access_code_xml", $data);
				}
		}else{
		$this->promptError('ER:00:00');
		}
	}
	
	function register(){
	
			// $byear = $this->input->post('birth_year');
			// $bmonth = $this->input->post('birth_month');
			// $bday = $this->input->post('birth_day');

			$customer_partycode = "ticketmaster";
			$this->load->helper('email');
			$customer_username = $this->input->post('username');
			$customer_password = $this->input->post('password');
			$customer_firstname = $this->input->post('fname');
			// $customer_middlename = $this->input->post('mname');
			$customer_lastname = $this->input->post('lname');
			$customer_email = $this->input->post('email');
			$customer_country = $this->input->post('country'); 
 			$customer_mobile = $this->input->post('mobile_number');
			$customer_province = $this->input->post('region');
			$city = $this->input->post('city');
			$token = $this->input->post('token'); //ewms

			
			
			
			
			$customer_adress_street = $this->input->post('home');
			$gender = $this->input->post('gender');
			$civil_status = $this->input->post('civil_status');
			$dpa =  $this->input->post('dpa');
			$activation_url = 'https://smtickets.com/users/activation/';
			$write = $this->load->database('live',true);
			
				//Check username
				if(!trim($customer_username))
					{ 
					$this->promptError('ER:04:12');
					// echo "No Username Provided";
					}	
				elseif($this->check_username(trim($customer_username)))
				{ 
					$this->promptError('ER:04:13');
					// echo 'Username Already Used.';
					
				}					
				elseif(!$customer_password)
					{ 
					// $customer_password = 'ERROR: No Password Provided';
					$this->promptError('ER:04:03');
					}
				
				//Check FirstName
				elseif(!trim($customer_firstname))
					{
					// $customer_firstname = 'ERROR: No First Name Provided';
					$this->promptError('ER:04:04');
					}
					
					//Check LastName
				elseif(!trim($customer_lastname))
					{ 
					// $customer_lastname = 'ERROR: No Last Name Provided';
					$this->promptError('ER:04:05');
					}	
					 
				//Check if ther is a provided email
				elseif(!trim($customer_email))
					{ 
						// $customer_email = 'ERROR: No Email Provided';
						$this->promptError('ER:04:10');
					}
				 		

				//Check if email Adress string is valid
				elseif(!valid_email(trim($customer_email)))
					{ 
						// $customer_email = 'ERROR: Invalid Email Format';
						$this->promptError('ER:04:09');
					}
					
				//Check if email Adress string is valid
				elseif($this->check_email(trim($customer_email)))
					{ 
  						$this->promptError('ER:04:01');
					}
					
					
 				elseif(!trim($customer_country))
					{ 
 						$this->promptError('ER:04:33');
					}
				 	
				 	
				//Check mobile
				elseif(!trim($customer_mobile))
					{ 
					// $customer_mobile = 'ERROR: No Mobile Number Provided';
					$this->promptError('ER:04:08');
					} 	
					
				 	
				elseif(!$this->validate_phonenumbers(trim($this->input->post('mobile_prefix') . $customer_mobile)))
					{ 
					// $customer_mobile = 'ERROR:Invalid Mobile Format';
					$this->promptError('ER:04:11');
					}
					 
					
				//Check existing mobile number		
			 	elseif($this->check_mobile(trim($customer_mobile)))
					{ 
					// $customer_mobile = 'ER:04:02' => 'Mobile Number Already Used',
					 $this->promptError('ER:04:02');
					 // echo "Mobile Number Already Used";
					} 
					
				// elseif(!trim($customer_province))
					// { 
 					// $this->promptError('ER:04:34');
					// } 	
			
				elseif(!trim($city))
					{ 
					// $customer_mobile = 'ERROR: No Mobile Number Provided';
					$this->promptError('ER:04:35');
					} 	
			 
				else{		
						// $reg_key = $this->encrypt->sha1($customer_username.'MGI'. $customer_email . 'MGI' . $this->getcurrentdatetime());
						$data = array(
					   'customer_username' => $customer_username,
					   'customer_password' => $this->prep_password($customer_password),
					   'customer_firstname' => $customer_firstname,
 					   'customer_lastname' => $customer_lastname,
 					   'customer_mobile' => $customer_mobile,
					   'customer_email' => $customer_email,
					   'customer_country' => $customer_country,
					   'customer_adress_province' => $customer_province,
					   'customer_city' => $city,
					   // 'customer_registration_code' => $reg_key,
 					   'customer_active' => 0,
 					   'customer_privacy' => $dpa,
					   'customer_registration_code' => $token

						);
				 
 						$write->insert('customers', $data); 	
						
						
						//send activation url 
						// $this->send_activation_email($customer_username, $customer_email, $activation_url . $customer_username . '/' .$reg_key);
						
						echo "Registration Successful";
					}
	}

	//change pass inside my account
	function change_password(){
	
		$read = $this->load->database('default',true); 
		$write = $this->load->database('live',true);
	  
		$username = $this->input->get_post('username');
		$new_password = $this->input->get_post('new_pass');
		$old_pass = $this->input->get_post('old_pass');
		
		
		if(!trim($username)){ 
			$this->promptError('ER:04:12');
		}elseif(!trim($new_password)){ 
			$this->promptError('ER:04:18');
		}elseif(!trim($old_pass)){ 
			$this->promptError('ER:04:36');
		}else{
			
			$result = $this->users->check($username, $old_pass);
			
			// echo $result;
			// die();
			if($result < 1){	
				$this->promptError('ER:04:37');	
			}else{
				$data = array(
					'customer_password' => $this->prep_password($new_password),
 				);

				// U P D A T E 	D A T A B A S E
				$write->where('customer_username', $username);
				$write->update('customers', $data); 	
				
				$data['user'] = $username;

				$this->load->view('password_updated_xml', $data);
			}
		}

				 

	}
	 
	 
	//request reset password  
	function reset_password(){

		$username = $this->input->get_post('username');
 		$customer_email = $this->input->post('email');
 		$reset_url = $this->input->post('reset_url');
		
		$read = $this->load->database('default',true);
		$write = $this->load->database('live',true);
						
			if(!trim($username)){
				$this->promptError('ER:04:12');
			}elseif(!trim($customer_email)){ 				
				$this->promptError('ER:04:10');	 
			}elseif(!trim($reset_url)){ 				
				$this->promptError('ER:04:39');	 
			}else{
					
					$read->select("customer_id");
					$read->where("customer_username", $username);
 					$read->where("customer_email",  $customer_email);
					$query = $read->get('customers');
		
						if ($query->num_rows() < 1){
							$this->promptError('ER:04:38');
						}else{
						//Generate a reg key
						$reg_key = sha1($username.'MGI'. $customer_email . 'MGI' . $this->getcurrentdatetime());
						
						//Save reset into api_sessions
						$data = array(
							'customer_registration_code' => $reg_key,
						);
						$write->where("customer_username",  $username);
						$write->update('customers', $data); 		
						
						
						$url = "$reset_url?rs=$reg_key&username=$username";
						
						$this->send_reset_password_email($username, $customer_email, $url);
						
						$xml = 	'<result>'. $url . '</result>';
						
						$data['content'] = $xml;	
						$this->load->view("reset_xml", $data);

					}
			}

	}
	
	
	//forgot password
	function update_password(){
	
		$read = $this->load->database('default',true); 
		$write = $this->load->database('live',true);
	  
		$username = $this->input->get_post('username');
		$new_password = $this->input->get_post('new_pass');
		$reset_key= $this->input->get_post('reset_key'); 
		
		
		if(!trim($username)){ 
			$this->promptError('ER:04:12');
		}elseif(!$this->check_username(trim($username))){ 
			$this->promptError('ER:04:15');
		}elseif(!$new_password){ 
			$this->promptError('ER:04:18');
		}elseif(!$reset_key){ 
			$this->promptError('ER:02:15');
		}elseif(!$this->check_reset_key(trim($username), $reset_key)){ 
			$this->promptError('ER:02:16');
		}else{
			
			$data = array(
				'customer_password' => $this->prep_password($new_password),
				'customer_registration_code' => NULL,
			);

			// U P D A T E 		D A T A B A S E
			$write->where('customer_username', $username);
			$write->update('customers', $data); 	
			
			$data['user'] = $username;

			$this->load->view('password_updated_xml', $data);
		
		}

				 

	}
	 
	
	
	function nt_ViewAPIuserbyUsername(){
		$username = $this->input->get_post('username');
			
		if(!$username){
			$this->promptError('ER:04:12');
		}else{
				
					$dbAccess = $this->load->database('default',true);
					// $dbAccess->cache_on();
					$dbAccess->query('set transaction isolation level read uncommitted');
					$dbAccess->select("
							c.customer_id
							,c.customer_username 
							, c.customer_firstname
							, c.customer_middlename
							, c.customer_lastname
							, c.customer_birthdate
							, c.customer_mobile
							, c.customer_email
							, c.customer_partycode
							, c.customer_address1
							, c.customer_address2
							, c.customer_city
							, c.customer_gender
							, c.customer_marital_status
							");
							

						$dbAccess->where("c.customer_username", $username);
						$query = $dbAccess->get('customers c');	

						$data['user'] = $query->row();
								
						if($query->num_rows() < 1){
									$this->promptError('ER:04:15');
								}else{
								//display the page
								$this->load->view('user_xml', $data);
								}
						// $dbAccess->cache_off();
				
				
			}
			
	}
	
 
	function log_details($type = false,$event_id = false, $transID = false, $totalAmount = false, $description = false){
		// $now = date("Y-m-d H:i:s");
 		// $dbAccess = $this->load->database('pincode',true);
		// $sql = "INSERT INTO `logs` (`log_type`, `log_event_id`, `log_transaction_id`, `log_total_amount`, `log_description`, `log_datetime`) VALUES ('$type', '$event_id','$transID','$totalAmount', '$description', '$now' );";  
		// $dbAccess->query($sql);		
	} 
	 
	function check_username($value=false){
		$exist = false;
		$dbAccess = $this->load->database('default',true);
		$dbAccess->select("customer_id");;
		$dbAccess->where("customer_username", $value);;
		$query = $dbAccess->get('customers');

			if ($query->num_rows() > 0)
				{
				$exist = true;
				}

		return $exist;
	}
	
	//Returns TRUE if date format = YYYY-MM-DD
	//sample..	2011-02-14
	function isValidDate($date){
		if(preg_match("/^(\d{4})-(\d{2})-(\d{2})$/", $date, $matches))
		{
			if(checkdate($matches[2], $matches[3], $matches[1]))
			{
				return true;
			}
		}
	}
	
	function check_mobile($mobileNumber=false){
		$exist = false;
		$dbAccess = $this->load->database('default',true);
		$dbAccess->where("customer_mobile", $mobileNumber);
		$query = $dbAccess->get('customers');
			
		if ($query->num_rows() > 0)
			{
			$exist = true;
			}
		return $exist;
	}
		
	function check_email($email=false){
		$exist = false;
		$dbAccess = $this->load->database('default',true);
		$dbAccess->where("customer_email", $email);
		$query = $dbAccess->get('customers');
			
		if ($query->num_rows() > 0)
			{
			$exist = true;
			}
		return $exist;
	}
	
	function validate_phonenumbers($number = false) {
		// can specify any format indicated below		
		$formats = array(
			// 13 to 14 char +63917-000-0000
			'+############', 
			'+#############', 
			'+##############', 
			// 15 to 20 for longer international number 
			/* '+###############', 
			'+################', 
			'+#################', 
			'+##################', 
			'+###################', 
			'+####################', */ 
			// from 10-digit to 15-digit number
			'##########',
			'###########',
			'############',
			'#############',
			'##############',
			'###############',
		);

		/*
		Add following format when possible:
		
		+639200000000
		+63 920 000 0000
		+63 920 0000000
		
		// +63 920 00000000
		// +63 920 000000000
		// +63 920 0000000000
		// +63 920 00000000000
		// +63 920 00000000000
		// +63 920 000000000000
		
		639200000000
		63 920 000 0000
		63 920 0000000
		09200000000
		0920 0000000		
		*/

		$format = trim(preg_replace("/[0-9]/", "#", $number));
		return (in_array($format, $formats)) ? true : false;
	}

		
	function prep_password($password){
		return sha1($this->config->item('encryption_key').$password);
	}

	function send_reset_password_email($username = false, $email = false,$reset_url = false){
		
		$data['username'] = $username;
 		$data['reset_url'] = $reset_url;
		$this->load->library('email');
		$this->email->from('noreply@smtickets.com', 'SMTICKETS');
		$this->email->to($email); 
		$this->email->subject('Reset Password');
		// $message = "CONGRATULATIONS!\n\n Hi $username, \n This is your password reset link \n $reset_url";
		
 		$message = $this->load->view('reset_template',$data,true);

		$this->email->message($message);
		$this->email->send();
		
		// echo "<pre>";
		// print_r($_POST);
		// echo "</pre>";
		// die();
	
	}
	
	function send_activation_email($username, $email, $activation_url){
		 
		 
		$data['username'] = $username; 
		$data['activation_url'] = $activation_url; 
		$this->load->library('email');
		$this->email->from('noreply@smtickets.com', 'SMTICKETS');
		$this->email->to($email); 
		$this->email->subject('Email Activation');
		// $message = "CONGRATULATIONS!\n\n Hi $username, \n This is your activation link \n $activation_url";
		$message = $this->load->view('registration_template',$data,true);
		$this->email->message($message);
		$this->email->send();
		
		// echo "<pre>";
		// print_r($_POST);
		// echo "</pre>";
		// die();
	
	}
	
	function resend_activation_email(){
		 
		// $username = $this->input->get_post('username');
 		$customer_email = $this->input->post('email'); 
		 
		$read = $this->load->database('default',true);
		$write = $this->load->database('live',true);
						
		if(!trim($customer_email)){ 				
			$this->promptError('ER:04:10');	 
		}else{
			$res = 'failed';
			$activation_url = 'https://smtickets.com/users/activation/';
			
			
			$data['activation_url'] = $activation_url; 
			
			$read->where("customer_email", $customer_email);
			// $read->where("customer_username", $username);
			$query = $read->get('customers');	

			if ($query->num_rows() > 0)
			{
				$result = $query->row(); 
				if($result->customer_registration_code != ''){
				$res = 'success';
				$data['username'] = $result->customer_username; 
				$data['activation_url'] = $activation_url . $result->customer_username . '/' .$result->customer_registration_code;
				$this->load->library('email');
				$this->email->from('noreply@smtickets.com', 'SMTICKETS');
				$this->email->to($customer_email); 
				$this->email->subject('Email Activation');
 				$message = $this->load->view('registration_template',$data,true);

				$this->email->message($message);
				$this->email->send();
				
				}
			}
			
			echo '<root>';
			echo '<result>' . $res . '</result>';
			echo '</root>';
			
		}
		
	
	}
	
	
 	function activate(){
	
		$read = $this->load->database('default',true); 
		$write = $this->load->database('live',true);
	  
		$username = $this->input->get_post('username');
		$reg_key = $this->input->get_post('reg_key');
		
		
		if(!trim($username)){ 
			$this->promptError('ER:04:12');
		}elseif(!trim($reg_key)){ 
			$this->promptError('ER:02:17');
		}else{
			// $result = 1;
			$result = $this->check_reset_key($username, $reg_key);
			 
			// die();
			if($result < 1){	
				$this->promptError('ER:04:40');	
			}else{
				$data = array(
					'customer_registration_code' => NULL,
					'customer_active' => 0,
 				);

				// U P D A T E 	D A T A B A S E
				$write->where('customer_username', $username);
				$write->update('customers', $data); 	
				
				// $data['user'] = $username;
				echo '<root>';
				echo '<result>success</result>';
				echo '</root>';
				// $this->load->view('password_updated_xml', $data);
			}
		}

				 

	}
	

	function check_reset_key($username, $reset_key){
		$exist = false;
		$this->db = $this->load->database('default',true);
		
		
		$this->db->select("customer_id");
		$this->db->where("customer_registration_code", $reset_key);
		$this->db->where("customer_username", $username);
		$query = $this->db->get('customers');	

		if ($query->num_rows() > 0)
		{
		$exist = true;
		}					
		return $exist;
	}

	 
	function insert_privacy_agreement($username = false)
	{
		
		if($username == '') die('Error');
		$dpa = $this->input->post('dpa');
		
		$dpa = unserialize($dpa);
		
		$read = $this->load->database('default',true); 
		$write = $this->load->database('live',true);
		
		//update sm dpa
		if (in_array("sm", $dpa)){
			 
			$read->query('set transaction isolation level read uncommitted');
			$read->where('customer_username', $username);
			$q = $read->get('customers');
			
			if($q->num_rows() > 0){
				
				
				$fields = array(
					'customer_privacy'		=>		1
				);
				
				$write->set($fields);
				$write->where("customer_username",$username);
				$write->update('customers');
				 
			}
			
		}
		
		foreach($dpa as $x){
			
			$fields = array(
				'dpa_username'		=>		$username,
				'dpa_code'			=>		$x
			);
			
			$write->set($fields);
 			$write->insert('dpa');
			 
		}
		
	}
}