<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
include('accesstemplate.php');

// class Transaction extends CI_Controller {
class Transaction extends AccessTemplate{


	
	public function __construct()
	{
		parent::__construct();
		$this->load->model('api_error_model', 'error');
		$this->load->model('api_seatplans_model', 'seatplans');
		$this->load->model('api_events_model', 'events');
		$this->load->model('api_sections_model', 'sections');
		$this->load->model('api_prices_model', 'prices');
		$this->load->model('api_tickets_model', 'tickets');
		$this->load->model('api_payments_model', 'payments');
		$this->load->model('api_ticket_types_model', 'ticket_types');
		$this->load->model('api_ip_model', 'ip');
		$this->load->model('api_ticket_layouts_model', 'ticket_layouts');
		$this->load->model('api_bcode_model', 'bcode');	
		$this->load->model('api_payment_types_model', 'payment_types');
		$this->load->model('api_branches_model', 'branches');
		$this->load->model('api_mobilenum_model', 'mobilenum');
		$this->load->model('admin_model', 'admin');
		$this->load->model('smbarcode_model', 'smbarcode');
		$this->load->model('api_printer_model', 'printer');



		$this->load->model('transactions_model', 'transactions');
		$this->load->model('data_model', 'data');
		$this->load->model('unique_handler_model', 'unique_handler');
		$this->load->model('logs_online_model', 'logs');


				
		$this->load->database('default',true);
		// $this->db->query('set transaction isolation level read uncommitted');
		ini_set('user_agent',$this->agent->agent_string());

		
		
	}	
	
	//=============== Transactional  F u n c t i o n s ===============
	
	
	function nt_GetCustomerTransactions(){

 		$customerid = $this->input->get_post('customerid');
	 
		$data['transactions'] = $this->transactions->get_customer_transactions($customerid);
		 
		if(empty($data['transactions'])){
		$this->promptError('ER:04:22');
		}else{
		//display the page
		$this->load->view('customer_transactions_xml', $data);
		}
	}
	
	
	function nt_Voucher($transaction_id=false,$session = false){
		
		
		if(!$transaction_id){ 
			$this->promptError('ER:06:03');
 		}elseif(!$session){ 
			$this->promptError('ER:06:20');
 		}else{
		
		 
			$type = "all";
			$voucher_type = ($type == 'all') ? 'all' : 'one';
			$transaction_id = ($transaction_id) ? $transaction_id : 0;
			$data['voucher_type'] = $voucher_type;
			
			$transaction = $this->transactions->get($transaction_id);
			
			
			$transaction_customer_id = $transaction->transaction_customer_id;
			$session_customer_id = $this->get_customer_id_by_session($session);
 			if($transaction_customer_id == $session_customer_id){
					
					$data['transaction'] = $transaction;
					if(!$transaction){ 
					$this->error->promptError('ER:06:07');}

					$data['tickets'] = $this->tickets->get_tickets($transaction_id);
					
					$tickets2 = array();
					foreach ($data['tickets'] as $ticket)
					{
						$discount_type = $ticket->ticket_type_discount_type;
						$amount = $ticket->price_price;

						if($discount_type == 'Amount'){
						$amount =  $amount - $ticket->ticket_type_discount;
						
						}elseif($discount_type == 'Percentage'){
						$amount = $amount  - ($amount * ($ticket->ticket_type_discount / 100));
						}
						
						if(isset($tickets2[$ticket->price_name]['price_name'])){
							// $tickets2[$ticket->price_name]['price_name'] = $ticket->price_name;
							$tickets2[$ticket->price_name]['amount'] += ceil($amount);
 							$tickets2[$ticket->price_name]['qty'] += 1;
						}else{
							$tickets2[$ticket->price_name]['price_name'] = $ticket->price_name;
							$tickets2[$ticket->price_name]['amount'] = ceil($amount);
							$tickets2[$ticket->price_name]['price'] = ceil($amount);
 							$tickets2[$ticket->price_name]['qty'] = 1;
							
						}
					
					}
					$data['tickets2'] = $tickets2;
					
					
				 
					// $data['ticket_terms'] = $file = file_get_contents(base_url() . '/resources/terms/ticket_terms.txt', true);
					if (count($data['tickets']) > 0)
					{
					$data['price'] = $this->prices->get($data['tickets'][0]->ticket_price_id);
					$data['event'] = $this->events->get($data['tickets'][0]->ticket_event_id);
					$payments = $this->payments->get_payments($transaction_id);

					$data['payment_type'] = (count($payments) > 0) ? $payments[0]->payment_type_name : 'Unknown Payment Type';
					$total_payment = 0;
					foreach($payments as $payment)
					$total_payment += $payment->payment_amount;
					$data['total_amount'] = $total_payment;
					$data['ticket_layout'] = $this->ticket_layouts->get($data['tickets'][0]->ticket_event_id);
					$data['bcode'] = $this->bcode->get_transaction_bcode($transaction_id);

						
					  
					$data['r'] =  "";	 
					
					// display the page
					// $this->load->view('1transaction_tickets', $data);
					$this->load->view('1transaction_tickets_new', $data);

					}
					else{
					echo 'Ticket not found';
					}
			}else{
				echo "Invalid access";
			}
			
		}

	}

	//for guaranteed seating
	function select_seat(){
		
		$event_id = $this->input->get_post('event_id');
    	$section_id = $this->input->get_post('section_id');
		$price_id = $this->input->get_post('price_id');
		$ticket_type = $this->input->get_post('ticket_type_id');
		$session_id = $this->input->get_post('session_id');
		$section_type = $this->input->get_post('section_type');
		$qty = $this->input->get_post('qty');
   		
		 
			 
		//ADD ONEFC CONDITION live
		if (in_array($event_id, [11440]) && $ticket_type == 1){
			 
			$ticket_type = 1567;
		}
		 
		 
		// if (in_array($price_id, [58657,58662,58667,58671]) && $ticket_type == 1){
			 
			// $ticket_type = 1568;
		// }
		  
		
		//58660,58670 GA  
		// if (in_array($price_id, [58987,58658,58663,58655,58664,58659,58988,58668,58672,58665,58673,58669])  && $ticket_type == 1){
			 
			// $ticket_type = 1569;
		// }
		 
		 
		
		/*check purchase limit */
		//ticket_already_bought
		//tickets_selected
		
		if(!$event_id){
			$this->promptError('ER:05:03');
		}elseif(!$section_id){
			$this->promptError('ER:05:05');
		}elseif(!$price_id){
			$this->promptError('ER:05:07');
		}elseif(!$ticket_type){
			$this->promptError('ER:06:22');
		}elseif(!$session_id){
			$this->promptError('ER:06:20');
		}elseif(!$qty){
			$this->promptError('ER:06:23');
		}elseif(!$section_type){
			$this->promptError('ER:06:25');
		}else{
			$valid = $this->check_restrictions($event_id, $price_id, $ticket_type);
			$section[] = $section_id;
			$event_ticket_limit = $this->data->get_ticket_limit($event_id); 
			list ($selected_tickets, $selected_price)  = $this->transactions->get_selected_seats_by_session($session_id, $event_id);
			$taken_seats = $this->transactions->get_taken_seats_per_section($section); 
			// $capacity = $this->transactions->get_capacity_per_section($section_id); 
			 
			
			// cosplay
			if(in_array($event_id, [11631,11633,11634])){ //live 11631,11633,11634
				$taken_seats = $this->transactions->count_taken_seats($session_id, $event_id);
				$event_ticket_limit = 2 - $taken_seats;
			}
			
			
			
			//checking for multiple price restriction
			$multiple = 0;
			if($selected_price){
				
				if($price_id != $selected_price){
					$multiple = 1;
				}
			}
		

			if(isset($taken_seats[0]->seats_taken)){
				$taken = $taken_seats[0]->seats_taken; 
			}else{
				$taken = 0; 
				
			}
			
			$selected_qty = $qty;
			$result_qty = 'ALL';
			if($qty + $selected_tickets > $event_ticket_limit){ 
				$qty = $event_ticket_limit - $selected_tickets;
			}
			
			if($selected_qty != $qty){
				$result_qty = $qty;
				
			}
			
			
			
			//check if there are still seats available 
			if($qty < 1){
				
				$this->promptError('ER:06:21'); 
				
			}
			// elseif($multiple == 1 && $event_id != 7764){
				
				// $this->promptError('ER:06:29'); 
				
			// }
			elseif($valid != 1){
				$this->promptError('ER:06:26'); 
		
			}else{
				//$event_id, $section_id, $price_id, $ticket_type , $accessCode, $qty
				$this->transactions->select_seat($event_id, $section_id, $price_id, $ticket_type , $session_id, $section_type, $qty);
				echo '<root><result>Success</result><qty>'. $result_qty   .'</qty></root>';
			}
			 
		}
		
		 
	} 
	
	
	//for reserved seating
	function add_seat(){
		
		$event_id = $this->input->get_post('event_id');
    	$section_id = $this->input->get_post('section_id');
		$price_id = $this->input->get_post('price_id');
		$ticket_type = $this->input->get_post('ticket_type_id');
		$session_id = $this->input->get_post('session_id');
 		$seats = $this->input->get_post('seats');
   		
			 
		//ADD ONEFC CONDITION live
		if (in_array($event_id, [11440]) && $ticket_type == 1){
			 
			$ticket_type = 1567;
		}
		
		// if (in_array($price_id, [58657,58662,58667,58671]) && $ticket_type == 1){
			 
			// $ticket_type = 1568;
		// }
		
		//58660,58670 GA  
		// if (in_array($price_id, [58987,58658,58663,58655,58664,58659,58988,58668,58672,58665,58673,58669])  && $ticket_type == 1){
			 
			// $ticket_type = 1569;
		// }
		 
		 		
		 
		
		if(!$event_id){
			$this->promptError('ER:05:03');
		}elseif(!$section_id){
			$this->promptError('ER:05:05');
		}elseif(!$price_id){
			$this->promptError('ER:05:07');
		}elseif(!$ticket_type){
			$this->promptError('ER:06:22');
		}elseif(!$session_id){
			$this->promptError('ER:06:20');
		}elseif(!$seats){
			$this->promptError('ER:06:19');
		}else{
			
			$event_ticket_limit = $this->data->get_ticket_limit($event_id); 
			list ($selected_tickets, $selected_price)  = $this->transactions->get_selected_seats_by_session($session_id, $event_id);
			$seats = unserialize($seats);
			
			$valid = $this->check_restrictions($event_id, $price_id, $ticket_type);

			// cosplay
			if(in_array($event_id, [11631,11633,11634])){ //live 11631,11633,11634
				$taken_seats = $this->transactions->count_taken_seats($session_id, $event_id);
				$event_ticket_limit = 2 - $taken_seats;
			}
			
			
			//checking for multiple price restriction
			$multiple = 0;
			if($selected_price){
				
				if($price_id != $selected_price){
					$multiple = 1;
				}
			}
			
			
			//count($seats) + 
			if(count($seats) + $selected_tickets > $event_ticket_limit){ 
				$this->promptError('ER:06:21'); 
			}
			// elseif($multiple == 1 && $event_id != 7764){  
				// $this->promptError('ER:06:29'); 
			// }
			elseif($valid != 1){
				$this->promptError('ER:06:26'); 
		
			}else{
				
				// echo 'wait..';
				// die();
				$failed = array();	
				$success = array();	
				//check if there are still seats available
					
				
				// $seats = array();
				// $seats[] = 'R0|C0|A|1';
				// $seats[] = 'R0|C0|A|2';
				
				//ticket_system_row
				//ticket_system_col
				//ticket_row
				//ticket_seat
				
				// $seats = serialize($seats);
				// echo $seats;
				// die();
				
				
				// print_r($seats);
				// die();
				$section = $this->sections->get($section_id);
				$seat_config = unserialize($section->section_seat_config);
				echo '<root>';
				foreach($seats as $x){
					
					$x = explode("|",$x);
					
					// print_r($x);
					
					
					$system_row = substr($x[0], 1);
					$system_col = substr($x[1], 1); 
					$ticket_row = $x[2];
					$ticket_seat = $x[3];
					
					//validate seat
					//echo "R$system_row|C$system_col|$ticket_row|$ticket_seat";
					// print_r($seat_config);
					$valid = 0;
					if(isset($seat_config["R$system_row"]["C$system_col"])){
						if($seat_config["R$system_row"]["C$system_col"] == "R$system_row|C$system_col|$ticket_row|$ticket_seat"){
							$valid = 1;
						}
					} 
					
					$seat = array();
					$available = $this->transactions->is_seat_available($section_id, $system_row, $system_col);
					if($available > 0){
						
 						echo '<failed>' . $ticket_row . $ticket_seat  .'</failed>';
 					}elseif($valid == 0){
						
						echo '<failed>' . $ticket_row . $ticket_seat  .'</failed>';
					}else{
						
						$this->transactions->add_seat($event_id, $section_id, $price_id, $ticket_type , $session_id, $system_row,$system_col,$ticket_row, $ticket_seat);
						echo '<success>' . $ticket_row . $ticket_seat  .'</success>';
						
					}
					
				}
				
				echo '</root>';
 
			
				
				
			
			}
			 
		}
		
		 
	} 
	
	
	// unselect_seat
	function unselect_seat(){
		
		$ticket_id = $this->input->post('ticket_id');
		$section_id = $this->input->post('section_id');
		
		
		if(!$ticket_id){ 
			$this->promptError('ER:04:25');
 		}elseif(!$section_id){ 
			$this->promptError('ER:05:05');
 		}else{
		 
			echo $this->transactions->unselect_ticket($ticket_id,$section_id);
			die();
			
		}
	}

	// unselect_seat
	function unselect_seat_all(){
		
		$session_id = $this->input->post('session_id');
		$section_id = $this->input->post('section_id');
		$event_id = $this->input->post('event_id');
		
		
		if(!$session_id){ 
			$this->promptError('ER:06:20');
 		}elseif(!$section_id){ 
			$this->promptError('ER:05:05');
 		}elseif(!$event_id){ 
			$this->promptError('ER:05:03');
 		}else{
		 
			echo $this->transactions->unselect_ticket_all($session_id,$section_id,$event_id);
			die();
			
		}
	}


	
	function selected_seats(){
		$session_id = $this->input->post("session_id");
		$event_id = $this->input->post("event_id");
		
		if(!$session_id){
		$this->promptError('ER:05:20');		
		}elseif(!$event_id){
		$this->promptError('ER:05:03');		
		}else{
		
			$data["selected_tickets"] = $this->transactions->get_selected_seats_per_event($session_id, $event_id);
	
			$used_ticket_types = array();
			foreach($data["selected_tickets"] as $selected_ticket){
			$selected_ticket->ticket_type_id;
				$used_ticket_types[] = $selected_ticket->ticket_type_id;
			}
			$used_ticket_types = array_unique($used_ticket_types);

			$data["ticket_types"] = $this->transactions->get_ticket_types($used_ticket_types);
	
			$this->load->view("selected_tickets_xml",$data);
		}
	}
	
	 
	function purchase(){
 
		$session_id =  $this->input->get_post("session_id"); 
		$event_id =  $this->input->get_post("event_id"); 
		$qr_code =  $this->input->get_post("qr_code"); 
		$ticket_array =  $this->input->get_post("ticket_array"); 

				
		//for seagames
		$firstname = $this->input->get_post("firstname");
		$lastname = $this->input->get_post("lastname");
		$mobile = $this->input->get_post("mobile");
		$email = $this->input->get_post("email");
		
		
		if(!$session_id){
			$this->promptError('ER:06:20');
		}elseif(!$event_id){
			$this->promptError('ER:05:03');
		}
	 
		else{
			$valid = 0;
			$expired = 0;
			//retrieve tickets
			$selected_tickets = $this->transactions->get_selected_seats_per_event($session_id, $event_id);
			$event_ticket_limit = $this->data->get_ticket_limit($event_id);
			
			$ticket_count = count($selected_tickets);
			$cart_seats = explode(",",$ticket_array);
			
			$soundc = 0;
			$non_soundc = 0; 			
			foreach($selected_tickets as $s){
				
				if(in_array($s->ticket_id ,$cart_seats)){
					
				}else{
					$expired = 1;
				}
				
					
				//the vamps checking 
				
				if($s->price_id == 59805){
					$soundc++;
				}else{
					
					$non_soundc++;
				}
				
			}
			
			//the vamps checking 59805 
			if($soundc != 0 && $soundc > $non_soundc){
				$expired = 1;
			}
			
			 
			if($ticket_count < 1 || $ticket_count != count($cart_seats) || $expired == 1){
				$this->promptError('ER:06:26'); //invalid ticket details provided 
			}elseif($ticket_count > $event_ticket_limit){ 
				$this->promptError('ER:06:21'); 
			}else{
				
				$guaranteed_sections = array();
				$reserved_seats = array();
				$sections_capacity = array();
				$price[] = array();
				$total_amount = 0;
				foreach($selected_tickets as $x){
					
					$sections_capacity[$x->section_id] = $x->section_capacity;
						
					if(in_array($x->section_type, array('Free Seating','Standing'))){
						
						$guaranteed_sections[] = $x->section_id;
						
					}else{
						//checking for reserved seat
						$available = $this->transactions->is_seat_available($x->section_id, $x->ticket_system_row, $x->ticket_system_col);
						if($available != 1){ 
							$valid = 1;
						}
						
					}
					
					
					if($x->ticket_type_discount_type == 'Amount'){
						$amount = $x->price_price - $x->ticket_type_discount;
						$price[$x->ticket_id] = $amount;
					}else{
						$amount = $x->price_price - ($x->ticket_type_discount/100 * $x->price_price);
						$price[$x->ticket_id] = $amount;
					}
					
					$total_amount += $amount + $x->event_internet_sales_charge;
						
					
				}
				 
				
				$data['price'] = $price;
				$data['total_amount'] = $total_amount;
				
				$guaranteed_sections = array_unique($guaranteed_sections);
				
				
				if (count($guaranteed_sections) >0 ) {
 				
					//check taken tickets per section 
					$taken_seats = $this->transactions->get_taken_seats_per_section($guaranteed_sections);
					
					// print_r($selected_tickets);
					
					foreach($taken_seats as $taken){ 
						//checking for guaranteed seats
						if($sections_capacity[$taken->ticket_section_id] < $taken->seats_taken){ 
							$valid = 1;
						}
						
					}
				}
				
				
				//check qr_code
				if($qr_code){
					
					if($event_id == 10942){
						$qr_code = $qr_code . $selected_tickets[0]->price_id;
					}
					
					if(in_array($event_id, [11438,11439,11440])){ //onefc
						$qr_code = $qr_code .  $selected_tickets[0]->price_id;
					}
					
					
					// if($event_id == 11415){
						// $event_id = 11414; //txt
					// }
					
					$qr =  $this->transactions->validate_qr($qr_code, $event_id);
					
					if($qr){
						
						$valid = 2;
					}
					
					
					
				}
				
				
				if($valid == 1){
					$this->promptError('ER:06:07');
				}elseif($valid == 2){
					$this->promptError('ER:06:27');
				}else{
					
					//initialize transaction
					$data['result'] = $this->transactions->buy_ticket($selected_tickets , $session_id);
					  
					$result = $data['result'];
					$transaction_id = $result[1]; 
					
					
					//tag seagames customer
					$this->transactions->tag_customer_transaction($transaction_id);
					
					//tag QR 
					if($qr_code){ 
						$qr =  $this->transactions->tag_qr($qr_code, $transaction_id,$event_id);
						   
					}
					
					$data['ticketDetails'] = $selected_tickets; 
					
					$this->load->view("ticket_response_xml", $data); 
					
				}
			
			}

		}
	
	}

   	//for reserve
	function purchase_v2(){
 
		$session_id =  $this->input->get_post("session_id"); 
		$accesscode =  $this->input->get_post("accesscode"); 
		$event_id =  $this->input->get_post("event_id"); 
		$qr_code =  $this->input->get_post("qr_code"); 
		
		//for seagames
		$firstname = $this->input->get_post("firstname");
		$lastname = $this->input->get_post("lastname");
		$mobile = $this->input->get_post("mobile");
		$email = $this->input->get_post("email");
		
		
		
		
		if(!$session_id){
			$this->promptError('ER:06:20');
		}elseif(!$event_id){
			$this->promptError('ER:05:03');
		}elseif(!$accesscode){
			$this->promptError('ER:01:06');
		}
		
		// elseif(!$firstname){
			// $this->promptError('ER:04:04');
		// }elseif(!$lastname){
			// $this->promptError('ER:04:05');
		// }elseif(!$mobile){
			// $this->promptError('ER:04:08');
		// }elseif(!$email){
			// $this->promptError('ER:04:10');
		// }
		else{
			$valid = 0;
			//retrieve tickets
			$selected_tickets = $this->transactions->get_reserved_seats_per_event($session_id, $event_id);
			
			//$event_ticket_limit = $this->data->get_ticket_limit($event_id);
			$event_ticket_limit = $this->data->get_ticket_limit($event_id);
			
			$ticket_count = count($selected_tickets);
			
			if($ticket_count < 1){
				$this->promptError('ER:06:26'); 
			}elseif($ticket_count > $event_ticket_limit){ 
				$this->promptError('ER:06:21'); 
			}else{
				
				$guaranteed_sections = array();
				$reserved_seats = array();
				$sections_capacity = array();
				foreach($selected_tickets as $x){
					
					$sections_capacity[$x->section_id] = $x->section_capacity;
						
					if(in_array($x->section_type, array('Free Seating','Standing'))){
						
						$guaranteed_sections[] = $x->section_id;
						
					}else{
						//checking for reserved seat
						$available = $this->transactions->is_seat_available($x->section_id, $x->ticket_system_row, $x->ticket_system_col);
						if($available != 1){ 
							$valid = 1;
						}
						
					}
				}
				$guaranteed_sections = array_unique($guaranteed_sections);
				
				
				if (count($guaranteed_sections) >0 ) {
 				
					//check taken tickets per section 
					$taken_seats = $this->transactions->get_taken_seats_per_section($guaranteed_sections);
					
					foreach($taken_seats as $taken){ 
						//checking for guaranteed seats
						if($sections_capacity[$taken->ticket_section_id] < $taken->seats_taken){ 
							//$valid = 1;
						}
						
					}
				}
				
				
				//check qr_code
				if($qr_code){
					
					$qr =  $this->transactions->validate_qr($qr_code, $event_id);
					
					if($qr){
						
						$valid = 2;
					}
					
					
					
				}
				
				
				if($valid == 1){
					$this->promptError('ER:06:07');
				}elseif($valid == 2){
					$this->promptError('ER:06:27');
				}else{
					

					//initialize transaction
					$data['result'] = $this->transactions->buy_ticket_v2($selected_tickets , $accesscode, $selected_tickets[0]->ticket_transaction_id);
										
					 if($data['result'][0] < 1){
						$this->promptError('ER:06:07');

					 }else{					 
						$result = $data['result'];
						$transaction_id = $result[1]; 
						
						
						// print_r($data['result'] );
						//tag seagames customer
						$this->transactions->tag_customer_transaction($transaction_id);
						
						//tag QR 
						if($qr_code){ 
							// $qr =  $this->transactions->tag_qr($qr_code, $transaction_id);
							   
						}
						
						$data['ticketDetails'] = $selected_tickets; 
						
						
						$this->load->view("ticket_response_xml", $data); 
					 }
				}
			
			}

		}
	
	}

   	
	function payment_done()
	{ 
  
		//order details
		$referencenumber =  $this->input->post("referencenumber"); 
		$amount =  $this->input->post("amount"); 
		$paycode =  $this->input->post("paycode"); 
		
		
		$cardNumber =  $this->input->post("cardnumber"); 
		$expiration =  $this->input->post("expiration"); 
		$card_type =  $this->input->post("card_type"); 
		// $others =  $this->input->post("others"); 
 		 
		
		 
			 
		if(!$cardNumber){$cardNumber = 'xxxxxxxxxxxxxxxx';} 
		if(!$expiration){$expiration = 'x';} 
		if(!$card_type){$card_type = 0;} 
		
		
		$ref = explode("-", $referencenumber);  
		if(!$referencenumber){ 
			$this->promptError('ER:06:03');  
		}elseif($ref[0] != 99){
			$this->promptError('ER:06:04'); 
		}elseif(!$paycode){
			$this->promptError('ER:06:13'); 
		}elseif(!$amount){
			$this->promptError('ER:06:13'); 
		}else{
		 
			$transaction_id = $ref[1];	 
			
			
			$u = $this->unique_handler->check_duplicate($transaction_id);
			if($u < 1){
				//Invalid transaction information. multiple entry'
				$this->promptError('ER:06:07'); 
			
			}else{
			
				// default value
				$pid = 0;
				$eid = 0;
				
				//check if the ticket is reserved or selected
				$status = $this->transactions->get_ticket_status($transaction_id);
			
				// if($status == 'reserved'){
				if(in_array($status, array('selected','reserved'))){
					
					if($status == 'reserved'){
						$selected_tickets = $this->transactions->get_reserved_tickets($transaction_id);
					}else{
						$selected_tickets = $this->transactions->get_selected_tickets($transaction_id);
					}
				 
					// identify tickets and the price_id/event_id just in case user opened events with new tab
					
					 
					foreach ($selected_tickets as $ticket) {
						$pid = $ticket->ticket_price_id;
						$eid = $ticket->ticket_event_id;
					}

					// check if valid access
					if (($pid > 0) && ($eid > 0)) { 
						// transaction tickets has valid event_id and price_id info
					 

						// identify price id from tickets
						$data['price'] =  $this->prices->get($pid);
						
						// identify event id from tickets
						$data['event'] = $this->events->get($eid);
						
						// get total amount
						$ticket_count = count($selected_tickets); 
						// $total_amount = $ticket_count * $data['price']->price_price;
						
						 
						
						$total_amount = 0;
						foreach($selected_tickets as $x){
						
						if ($x->ticket_type_discount_type == 'Amount'): 
						
							$price = ceil($x->price_price - $x->ticket_type_discount);  
							$total_amount = $total_amount + $price;
						elseif ($x->ticket_type_discount_type == 'Percentage'): 
						
							$price = ceil($x->price_price - (($x->price_price * $x->ticket_type_discount)/100)); 
							$total_amount = $total_amount + $price;
						endif; 
						 
						}
						
						
						
						
						$orig_amount_raw = $total_amount + ($data['event']->event_internet_sales_charge * $ticket_count);
						$orig_amount = number_format($orig_amount_raw, 2, '', '');
						if ($orig_amount != $amount)
						{
							//error message
							//Amount paid did not match the transaction amount
							echo $orig_amount . ' ' . $amount;
							$this->promptError('ER:06:06'); 
							
						}
						else
						{
							$payment_type = $this->payment_types->get_by_code($paycode);
							if(!$payment_type){
							//invalid paycode
							$this->promptError('ER:06:13');
							}else{ 
								$this->transactions->paid_online2($transaction_id,$status); // mark the transaction as paid_online
								
								$barcode = strtoupper(hash("crc32", $transaction_id));
								
								$this->transactions->add_barcode($transaction_id,$barcode); //Add Barcode
								
								$this->payments->add($transaction_id, $payment_type->payment_type_id, $orig_amount_raw); // add total payment
								// $card_num = $this->input->get("CardNum");
								$this->payments->add_cardnum($transaction_id,$cardNumber,$expiration, $card_type);
								
								$charge_amount = ($data['event']->event_internet_sales_charge * $ticket_count);
								if ($charge_amount > 0) {
									$this->payments->add_convenience_charge_details($transaction_id, $ticket_count, $charge_amount); // add convenience charge details
								}
								$this->payments->add_totalpay($transaction_id, $payment_type->payment_type_id, $orig_amount_raw, 'total'); // add total amount
								$data['payment_type'] = $payment_type->payment_type_code; // payment type
								
								// add receipt numbers
								$or_number = 0;
								$transaction = $this->transactions->get_for_bcode($transaction_id);
								if($transaction){ 
									// OR number  &&  $transaction->customer_id != 82476
									$event_internet_sales_charge = $data['event']->event_internet_sales_charge;
									if (is_numeric($event_internet_sales_charge) && ($event_internet_sales_charge > 0))
									{
										$or_number = $this->branches->get_last_or_number($transaction->transaction_branch_id);
										$this->transactions->update_receipt_number($transaction_id, $or_number);
									}
									else 
									{
										$or_number = 0;
									}
									
														
									foreach ($selected_tickets as $ticket)
									{
										// AR number
										$ar_number = $this->branches->get_last_receipt_number($transaction->transaction_branch_id);
										$this->tickets->update_acknowledgment_receipt($ticket->ticket_id, $ar_number);
										
										
									}
									
								
									//check events_config if bcode is active
									$useBCODE = $this->bcode->isActive($eid);
						
									if ($useBCODE) {
										$d_or_number = sprintf("%06d", $or_number);
										$msg = "OR No: $d_or_number RefNum: $transaction_id Thank you for buying through SM Tickets Online.";
										
										$arrMobileNum = $this->mobilenum->lookup($transaction->customer_mobile);
										if ($arrMobileNum['isLocal']) {
											$carrier = $arrMobileNum['bCODE'];
											$localmobilenum = $arrMobileNum['CountryCode'].$arrMobileNum['MobileNum'];
										} 
										else {
											$localmobilenum = $arrMobileNum['MobileNum'];
										}
										// $sendSMS = $this->session->userdata('sendSMS');
										$sendSMS = '';
										
										if (empty($sendSMS)) {
											$carrier = '';
											$msg = '';
										}
										
										$querydata = array(
											'user' => $this->config->item('bcode_user'),
											'password' => $this->config->item('bcode_pass'),
											'application' => $this->config->item('bcode_app'),
											'mobile' => $localmobilenum,
											'carrier' => $carrier,
											'message' => $msg,
										);
										
										
							
										$xmlResult = $this->extension->__getbcode($querydata);
										if (is_array($xmlResult)) {
											if (isset($xmlResult['Result']) && ($xmlResult['Result'] == 0)) {
												$insertdata = array(
													'bcode_transaction_id' => $transaction_id,
													'bcode_value' => $xmlResult['bCODE'],
													'bcode_sendSMS' => $localmobilenum,
													'bcode_carrier' => $carrier,
												);
												$write = $this->load->database('live',true);
												$write->insert('bcode', $insertdata); 
											}
										}
									}

								
								}	
								// $postrequest = @$this->extension->post2mci($this->session->userdata('tid'));
								// $postrequest = @$this->extension->post2mci($transaction_id);
								// $this->session->unset_userdata('sendSMS');
								// redirect("transaction/payment_receipt/$transaction_id/$hash/$pid/$eid");
								
								// get data
								$data['charge_amount'] = $charge_amount; 
								$data['transaction_id'] = $transaction_id; 
								$data['or_receipt'] = $this->transactions->get_or($transaction_id); 
								$data['trans_date'] = date("Y-m-d H:i:s");
								$data['amount'] = $amount;
								$data['tickets'] = $this->tickets->get_paid_online_tickets($transaction_id);
								
								// $this->tag_blink($transaction_id);
								// $this->tag_as_used($transaction_id);

								
								//insert into historical table 
								// $this->admin->copy_tickets($transaction_id, 'paid_online');
								// $this->admin->copy_transactions($transaction_id,'paid_online');
								// $this->admin->copy_payments($transaction_id);
								// $this->admin->copy_charges($transaction_id);
							
								
								$this->add_to_historical($transaction_id);
								$this->getOnlineOR($transaction_id);
								 // echo 'Junie';
								 // die();
								$this->load->view("result_xml", $data);
								//$this->customers->send_payment_notification($appCode,$liveToken,$accessCode,$dynaToken,$transaction_id);
							}
						}
						
						
					}else{
						$this->promptError('ER:06:07'); 
						// die('asd');
					}	
					 
				} else {
					//Invalid transaction information.'
					$this->promptError('ER:06:07'); 
				}	
			}
		}
	 	
	}
	
	
	function reserved_seats(){
		$referencenumber = $this->input->post("referencenumber"); 
		$session_id = $this->input->post('session_id'); 

		
		if(!$referencenumber){
		$this->promptError('ER:06:03');		
		}else{
			//log 
			$customer_id = $this->transactions->get_customer_id($session_id); 
			
 			$details['session_id'] = $session_id; 
			$this->logs->_add('claim_reservation',$customer_id,$referencenumber,serialize($details));
			
			$data["reserved_tickets"] = $this->transactions->get_reserved_seats($referencenumber);
			 
			if($customer_id == ''){
				echo "<root></root>";
			}else{	 
	
				$used_ticket_types = array();
				foreach($data["reserved_tickets"] as $reserved_ticket){
				$reserved_ticket->ticket_type_id;
					$used_ticket_types[] = $reserved_ticket->ticket_type_id;
				}
				$used_ticket_types = array_unique($used_ticket_types);

				$data["ticket_types"] = $this->transactions->get_ticket_types($used_ticket_types);
		
				$this->load->view("reserved_tickets_xml",$data);
				
			}
		}
	}
	
	
	function get_customer_id_by_session($session){
	
	$customer_id = false;
	$dbAccess = $this->load->database('default',true);
	$dbAccess->select('api_customer_id');
	$dbAccess->where("api_accesscode", $session);
	$query = $dbAccess->get("api_sessions");
	
	if($query->num_rows() > 0){
		$customer_id = $query->row()->api_customer_id;
	}
	
	return $customer_id;		
	}

	
	function add_to_historical($transaction_id = false){
		
		if(!$transaction_id) die('Unknown Error Encountered');
		
		//insert into historical table 
		$this->admin->copy_tickets($transaction_id, 'paid_online');
		$this->admin->copy_transactions($transaction_id,'paid_online');
		$this->admin->copy_payments($transaction_id);
		$this->admin->copy_charges($transaction_id);
		
		
	}
	
	
	function get_reservation(){ 

		$reservation_code = $this->input->post('reservation_code');
		$session_id = $this->input->post('session_id');
 		if(!$reservation_code){ 
			$this->promptError('ER:06:28');  
		}else{
			
			if(count(explode( "-" ,$reservation_code))== 3){
				//log
				$res = explode( "-" ,$reservation_code);
				$customer_id = $this->transactions->get_customer_id($session_id); 
				
				$details['reservation_code'] = $reservation_code;
				$details['session_id'] = $session_id; 
				$this->logs->_add('check_reservation',$customer_id,$res[1],serialize($details));
				
				
				$data['transactions'] = $this->transactions->get_reservations($reservation_code);
				if($customer_id == ''){
					$data['transactions'] = [];
				}	
				if(empty($data['transactions'])){
					echo "<root></root>";
				}else{
					$this->load->view('reservations_xml', $data);
				}
			}else{
				echo "<root></root>";
			}
			
		}
	}
	
	function update_ticket_type(){
		
		$session_id = $this->input->post("session_id");
		$event_id = $this->input->post("event_id");
		$ticket_type = $this->input->post("ticket_type");
		
		if(!$session_id){
		$this->promptError('ER:05:20');		
		}elseif(!$event_id){
		$this->promptError('ER:05:03');		
		}elseif(!$ticket_type){
		$this->promptError('ER:06:22');		
		}else{
			
			$this->transactions->update_ticket_type();
			
			echo 'Success';
			
			
			
		}
		
	}
	
	function check_restrictions($event_id = false, $price_id = false, $ticket_type = false){
		
		$valid = 0;
		if(!trim($event_id)) die('error');
		if(!trim($price_id)) die('error 2');
		if(!trim($ticket_type)) die('error 3');
		
		$dbAccess = $this->load->database('default',true);
		$dbAccess->query('set transaction isolation level read uncommitted');
		
		$dbAccess->select('event_id, event_ticket_types');
		$dbAccess->where("e.event_id",$event_id);
		$dbAccess->where("p.price_id",$price_id);
		$dbAccess->where("e.event_active",'1');
		$dbAccess->where("e.event_enable_online_selling",'1');
		$dbAccess->where("e.event_internet_sales_charge !=","");
		$dbAccess->where("p.price_hidden_online",'0');
		$dbAccess->limit(1);
		$dbAccess->join('events e', 'p.price_event_id = e.event_id', 'left' );
		$query = $dbAccess->get('prices p');
		
		if($query->num_rows() > 0){
			$ticket_types = unserialize($query->row()->event_ticket_types);
			
			if(in_array($ticket_type,$ticket_types) && $ticket_type != 2){
				 
				//ticket type restriction
				$dbAccess->where('ticket_type_id', $ticket_type);
				$dbAccess->where('ticket_type_group', 0);
				$query = $dbAccess->get('ticket_types t');
				if($query->num_rows() > 0){
					
					$valid = 1;
					
				}
			
			}
		}
		
		// echo $valid;
		return $valid;
		
		
	}

	function update_availability($event_id = false)
	{
		
		if($event_id == '') return false;

		//restrict update on ytff 
		if($event_id == 7853) return false;
			
		
		// get event
		$event = $this->events->get($event_id);
		
		
		// get prices
		$prices = $this->prices->get_prices_compact($event_id);
		$sec_type_price = array();
		foreach($prices as $price):
			$this->sections->update_ticket_availability_sections($price->price_sections, $event->event_seatplan_id, true); 
			 
		endforeach;

		 echo 'Success';
	}

	function getOnlineOR($transaction_id=false){  
		// $this->getallOR();
	 
		$data['transaction'] = $this->transactions->get_transaction_info($transaction_id);
		
		
		//$dbAccess = $this->load->database('default',true);
		//$dbAccess->where('transaction_id',$transaction_id);
		//$dbAccess->set('transaction_print_or',$data['transaction']->transaction_print_or + 1);
		//$dbAccess->update('transactions');
		
		// $data['mailer'] = json_decode(json_encode($this->config->item('mailer')));
		 
		// echo "<pre>";
		// print_r($data);
		// echo "</pre>";
		// die();
	
		$this->load->view('transaction_or_1', $data,true);

	}
	 
	
 	
	function getOR(){
		
		$this->load->view('transaction_or');
		
	}
	 
	
	function getallOR(){  
		
	 
		
		$data['transactions'] = $this->get_day_transaction_info();
		
 
		// echo "<pre>";
		// print_r($data);
		// echo "</pre>";
		// die();
	
		// $this->load->view('transaction_or_2', $data);
		$this->load->view('transaction_or_text', $data);

	}
	
	function get_day_transaction_info(){
		
		
		$sdate = date('Y-m-d 00:00:00');
		$edate = date('Y-m-d 23:59:59');
				
		$dbAccess = $this->load->database('default',true);
		$dbAccess->select('	t.transaction_date,
							t.transaction_id,
							t.transaction_receipt_number,
							c.charge_ticket_count,
							c.charge_amount	');
		$dbAccess->where('c.charge_datetime >=',$sdate);
		$dbAccess->where('c.charge_datetime <=',$edate);
		$dbAccess->where_in('t.transaction_status',array('done','paid_online'));
		$dbAccess->join('transactions t', 't.transaction_id = c.charge_transaction_id');
		$q = $dbAccess->get('charges c');
		$r = $q->result();
		
		// echo "<pre>";
		// print_r($r);
		// echo "</pre>";
		// die();
		
		return $r;
		
	}
	
 	
 	//COKE
	
	function payment_done_coke()
	{ 
  
		//order details
		$referencenumber =  $this->input->post("referencenumber"); 
		$amount =  $this->input->post("amount"); 
		$paycode =  $this->input->post("paycode"); 
		
		
		$cardNumber =  $this->input->post("cardnumber"); 
		$expiration =  $this->input->post("expiration"); 
		$card_type =  $this->input->post("card_type"); 
		// $others =  $this->input->post("others"); 
 		 
		
		 
			 
		if(!$cardNumber){$cardNumber = 'xxxxxxxxxxxxxxxx';} 
		if(!$expiration){$expiration = 'x';} 
		if(!$card_type){$card_type = 0;} 
		
		
		$ref = explode("-", $referencenumber);  
		if(!$referencenumber){ 
			$this->promptError('ER:06:03');  
		}elseif($ref[0] != 99){
			$this->promptError('ER:06:04'); 
		}elseif(!$paycode){
			$this->promptError('ER:06:13'); 
		}elseif(!$amount){
			$this->promptError('ER:06:13'); 
		}else{
		 
			$transaction_id = $ref[1];	 
			// $this->log_details("payment_done3","" ,$transaction_id, "","");
			// default value
			$pid = 0;
			$eid = 0;
			
			//check if the ticket is reserved or selected
			$status = $this->transactions->get_ticket_status($transaction_id);
		
			// if($status == 'reserved'){
			if(in_array($status, array('selected','reserved'))){
				
				if($status == 'reserved'){
					$selected_tickets = $this->transactions->get_reserved_tickets($transaction_id);
				}else{
					$selected_tickets = $this->transactions->get_selected_tickets($transaction_id);
				}
			 
				// identify tickets and the price_id/event_id just in case user opened events with new tab
				
				 
				foreach ($selected_tickets as $ticket) {
					$pid = $ticket->ticket_price_id;
					$eid = $ticket->ticket_event_id;
				}

				// check if valid access
				if (($pid > 0) && ($eid > 0)) { 
					// transaction tickets has valid event_id and price_id info
				 

					// identify price id from tickets
					$data['price'] =  $this->prices->get($pid);
					
					// identify event id from tickets
					$data['event'] = $this->events->get($eid);
					
					// get total amount
					$ticket_count = count($selected_tickets); 
					// $total_amount = $ticket_count * $data['price']->price_price;
					
					 
					
					$total_amount = 0;
					foreach($selected_tickets as $x){
					
					if ($x->ticket_type_discount_type == 'Amount'): 
					
						$price = ceil($x->price_price - $x->ticket_type_discount);  
						$total_amount = $total_amount + $price;
					elseif ($x->ticket_type_discount_type == 'Percentage'): 
					
						$price = ceil($x->price_price - (($x->price_price * $x->ticket_type_discount)/100)); 
						$total_amount = $total_amount + $price;
					endif; 
					 
					}
					
					
					
					
					$orig_amount_raw = $total_amount + ($data['event']->event_internet_sales_charge * $ticket_count);
					$orig_amount = number_format($orig_amount_raw, 2, '', '');
					if ($orig_amount != $amount)
					{
						//error message
						//Amount paid did not match the transaction amount
						echo $orig_amount . ' ' . $amount;
						$this->promptError('ER:06:06'); 
						
					}
					else
					{
						$payment_type = $this->payment_types->get_by_code($paycode);
						if(!$payment_type){
						//invalid paycode
						$this->promptError('ER:06:13');
						}else{ 
							$this->transactions->paid_online2($transaction_id,$status); // mark the transaction as paid_online
							
							$barcode = strtoupper(hash("crc32", $transaction_id));
							
							$this->transactions->add_barcode($transaction_id,$barcode); //Add Barcode
							
							// $this->payments->add($transaction_id, $payment_type->payment_type_id, $orig_amount_raw); // add total payment
							// $card_num = $this->input->get("CardNum");
							$this->payments->add_cardnum($transaction_id,$cardNumber,$expiration, $card_type);
							
							$charge_amount = ($data['event']->event_internet_sales_charge * $ticket_count);
							if ($charge_amount > 0) {
								$this->payments->add_convenience_charge_details($transaction_id, $ticket_count, $charge_amount); // add convenience charge details
							}
							// $this->payments->add_totalpay($transaction_id, $payment_type->payment_type_id, $orig_amount_raw, 'total'); // add total amount
							$data['payment_type'] = $payment_type->payment_type_code; // payment type
							
							// add receipt numbers
							$or_number = 0;
							$transaction = $this->transactions->get_for_bcode($transaction_id);
							if($transaction){ 
								// OR number  &&  $transaction->customer_id != 82476
								$event_internet_sales_charge = $data['event']->event_internet_sales_charge;
								// if (is_numeric($event_internet_sales_charge) && ($event_internet_sales_charge > 0))
								// {
									// $or_number = $this->branches->get_last_or_number($transaction->transaction_branch_id);
									$this->transactions->update_receipt_number($transaction_id, 0);
								// }
								// else 
								// {
									// $or_number = 0;
								// }
								
													
								foreach ($selected_tickets as $ticket)
								{
									// AR number
									// $ar_number = $this->branches->get_last_receipt_number($transaction->transaction_branch_id);
									$this->tickets->update_acknowledgment_receipt($ticket->ticket_id, 0);
									
									
								}
								
							
								//check events_config if bcode is active
								$useBCODE = $this->bcode->isActive($eid);
					
								if ($useBCODE) {
									$d_or_number = sprintf("%06d", $or_number);
									$msg = "OR No: $d_or_number RefNum: $transaction_id Thank you for buying through SM Tickets Online.";
									
									$arrMobileNum = $this->mobilenum->lookup($transaction->customer_mobile);
									if ($arrMobileNum['isLocal']) {
										$carrier = $arrMobileNum['bCODE'];
										$localmobilenum = $arrMobileNum['CountryCode'].$arrMobileNum['MobileNum'];
									} 
									else {
										$localmobilenum = $arrMobileNum['MobileNum'];
									}
									// $sendSMS = $this->session->userdata('sendSMS');
									$sendSMS = '';
									
									if (empty($sendSMS)) {
										$carrier = '';
										$msg = '';
									}
									
									$querydata = array(
										'user' => $this->config->item('bcode_user'),
										'password' => $this->config->item('bcode_pass'),
										'application' => $this->config->item('bcode_app'),
										'mobile' => $localmobilenum,
										'carrier' => $carrier,
										'message' => $msg,
									);
									
									
						
									$xmlResult = $this->extension->__getbcode($querydata);
									if (is_array($xmlResult)) {
										if (isset($xmlResult['Result']) && ($xmlResult['Result'] == 0)) {
											$insertdata = array(
												'bcode_transaction_id' => $transaction_id,
												'bcode_value' => $xmlResult['bCODE'],
												'bcode_sendSMS' => $localmobilenum,
												'bcode_carrier' => $carrier,
											);
											$write = $this->load->database('live',true);
											$write->insert('bcode', $insertdata); 
										}
									}
								}

							
							}	
							// $postrequest = @$this->extension->post2mci($this->session->userdata('tid'));
							// $postrequest = @$this->extension->post2mci($transaction_id);
							// $this->session->unset_userdata('sendSMS');
							// redirect("transaction/payment_receipt/$transaction_id/$hash/$pid/$eid");
							
							// get data
							$data['charge_amount'] = $charge_amount; 
							$data['transaction_id'] = $transaction_id; 
							$data['or_receipt'] = $this->transactions->get_or($transaction_id); 
							$data['trans_date'] = date("Y-m-d H:i:s");
							$data['amount'] = $amount;
							$data['tickets'] = $this->tickets->get_paid_online_tickets($transaction_id);
							
							// $this->tag_blink($transaction_id);
							// $this->tag_as_used($transaction_id);

							
							//insert into historical table 
							// $this->admin->copy_tickets($transaction_id, 'paid_online');
							// $this->admin->copy_transactions($transaction_id,'paid_online');
							// $this->admin->copy_payments($transaction_id);
							// $this->admin->copy_charges($transaction_id);
						
							
							$this->add_to_historical($transaction_id);
							// $this->getOnlineOR($transaction_id);
							 // echo 'Junie';
							 // die();
							$this->load->view("result_coke_xml", $data);
							//$this->customers->send_payment_notification($appCode,$liveToken,$accessCode,$dynaToken,$transaction_id);
						}
					}
					
					
				}else{
					$this->promptError('ER:06:07'); 
					// die('asd');
				}	
				 
			} else {
				//Invalid transaction information.'
				$this->promptError('ER:06:07'); 
			}	
		}
	 	
	}
	
	function check_winner(){
		
		
		$customer_id = $this->input->get_post('customer_id');
		if(!$customer_id){
			
			echo 'No customer ID provided';
			die();
		}
		$dbAccess = $this->load->database('default',true);
		$dbAccess->select('ticket_id');
		$dbAccess->where('transaction_customer_id',$customer_id);
		$dbAccess->where('ticket_event_id',8823);
		$dbAccess->where('ticket_price_id',49920);
		$dbAccess->where_in('transaction_status',array('done','paid','paid_online','selected','reserved'));
		$dbAccess->join('transactions t', 't.transaction_id = tix.ticket_transaction_id');
		$q = $dbAccess->get('tickets tix');
		//echo $dbAccess->last_query();
		//die();
		
		echo $q->num_rows();
		
	}
	
	//for billie eilish
	function check_customer(){
		
		
		$customer_id = $this->input->get_post('customer_id');
		$event_id = $this->input->get_post('event_id');
		if(!$customer_id){die('No customer ID provided');} 
		if(!$event_id){die('No event ID provided');} 
		
		$dbAccess = $this->load->database('default',true);
		$dbAccess->select('ticket_id');
		$dbAccess->where('transaction_customer_id',$customer_id);
		$dbAccess->where('ticket_event_id',$event_id); 
		$dbAccess->where_in('transaction_status',array('done','paid','paid_online','selected','reserved'));
		$dbAccess->join('transactions t', 't.transaction_id = tix.ticket_transaction_id');
		$q = $dbAccess->get('tickets tix');
		//echo $dbAccess->last_query();
		//die();
		
		echo $q->num_rows();
		
	}
	/* function update_or(){
		$or = '324232';
		$write = $this->load->database('live',true);
		$write->order_by('id','asc');
		$query = $write->get('duplicates');
		$result = $query->result();
		
		// echo '<pre>';
		// print_r($result);
		// echo '</pre>';
		$current_or = 0;
		foreach($result as $x){
			if($current_or == $x->transaction_receipt_number){
				
				$or_new = $or;
				$or += 1;
			}else{
				$or_new = $x->transaction_receipt_number;
				
				
			}
			
			$write->where('transaction_id', $x->transaction_id);
			$write->update('duplicates', array('transaction_receipt_number_new' => $or_new));
		
			$current_or = $x->transaction_receipt_number;
			
		}
		
		echo $or;
		
		
		
	}
	 */

	function eticket($transaction_id=false,$session = false){  
		

				
		if(!$transaction_id){ 
			$this->promptError('ER:06:03');
 		}elseif(!$session){ 
			$this->promptError('ER:06:20');
 		}else{
		// $transaction_id = 2683;
			// $event = 9017;
			$this->transactions->transaction_done($transaction_id); // mark transction as done
			$transaction = $this->transactions->get($transaction_id);
				
				
			$transaction_customer_id = $transaction->transaction_customer_id;
			$session_customer_id = $this->get_customer_id_by_session($session);
			if($transaction_customer_id == $session_customer_id){
				
			 
				$data['tickets'] = $this->printer->get_trans_details($transaction_id);
				$data['barcode'] = $this->smbarcode->attach_smcode_to_transaction_tickets($transaction_id, $data['tickets'], true);
				$data['layout'] = $this->printer->get_ticket_layout($data['tickets'][0]->ticket_event_id);
				 
				
 				
				if($data['tickets'][0]->ticket_event_id == 9422){$this->load->view('etickets_daymond',$data);
				}elseif($data['tickets'][0]->ticket_event_id == 9511){$this->load->view('etickets_lipa_9511',$data);
				}elseif($data['tickets'][0]->ticket_event_id == 9512){$this->load->view('etickets_lipa_9512',$data);
				}elseif($data['tickets'][0]->ticket_event_id == 9513){$this->load->view('etickets_lipa_9513',$data);
				}elseif($data['tickets'][0]->ticket_event_id == 9514){$this->load->view('etickets_lipa_9514',$data);
				}elseif($data['tickets'][0]->ticket_event_id == 9515){$this->load->view('etickets_lipa_9515',$data);
				}elseif($data['tickets'][0]->ticket_event_id == 9578){$this->load->view('etickets_9578',$data);
				}elseif($data['tickets'][0]->ticket_event_id == 9579){$this->load->view('etickets_9578',$data);
 				}else{
					
					// if(in_array($data['tickets'][0]->ticket_event_id, array(9234,9235,9236,9237,9238,9239,9240))){
					if($data['tickets'][0]->ticket_event_id == 9658){
						// 9658   - HELLO STRANGERS  link
						$data['image1'] = "https://images1.smtickets.com/v3/resources/images/marketing/smtickets_carousel_02092021_3.jpg"; //landscape
						$data['image2'] = "https://images1.smtickets.com/v3/resources/images/marketing/smtickets_portrait_02092021_3.jpg"; //portrait
						$data['image3'] = "https://images1.smtickets.com/v3/resources/images/marketing/smtickets_carousel_02092021_3.jpg"; //landscape
						$this->load->view('etickets',$data);
					}
					
					elseif($data['tickets'][0]->ticket_event_id == 9648){
						// 9648 – The company
						$data['image1'] = "https://images1.smtickets.com/v3/resources/images/marketing/smtickets_carousel_02092021_1.jpg";
						$data['image2'] = "https://images1.smtickets.com/v3/resources/images/marketing/smtickets_portrait_02092021_1.jpg"; 
						$data['image3'] = "https://images1.smtickets.com/v3/resources/images/marketing/smtickets_carousel_02092021_1.jpg"; 
						$this->load->view('etickets',$data);
					}
					
					elseif($data['tickets'][0]->ticket_event_id == 9649){
						// 9649 – regine
						$data['image1'] = "https://images1.smtickets.com/v3/resources/images/marketing/smtickets_carousel_02162021_1.jpg";
						$data['image2'] = "https://images1.smtickets.com/v3/resources/images/marketing/smtickets_portrait_02162021.jpg"; 
						$data['image3'] = "https://images1.smtickets.com/v3/resources/images/marketing/smtickets_carousel_02162021_1.jpg"; 
						$this->load->view('etickets',$data);
					}
					
					elseif($data['tickets'][0]->ticket_event_id == 9650){
						// 9650 – first name anew
						$data['image1'] = "https://images1.smtickets.com/v3/resources/images/marketing/smtickets_carousel_02092021_4.jpg";
						$data['image2'] = "https://images1.smtickets.com/v3/resources/images/marketing/smtickets_portrait_02092021_4.jpg"; 
						$data['image3'] = "https://images1.smtickets.com/v3/resources/images/marketing/smtickets_carousel_02092021_4.jpg"; 
						$this->load->view('etickets',$data);
					}
					  	
					elseif($data['tickets'][0]->ticket_price_id == 54210){
						$data['image1'] = "https://images1.smtickets.com/v3/resources/images/marketing/smtickets_carousel_02162021_2.jpg"; //landscape
						$data['image2'] = "https://images1.smtickets.com/v3/resources/images/marketing/smtickets_portrait_02162021_2.jpg"; //portrait
						$data['image3'] = "https://images1.smtickets.com/v3/resources/images/marketing/smtickets_landscape_02162021_2.jpg"; //top left
						$this->load->view('etickets_w_image',$data);

					}
						
					elseif($data['tickets'][0]->ticket_price_id == 54209){
						$data['image1'] = "https://images1.smtickets.com/v3/resources/images/marketing/smtickets_carousel_02162021_2.jpg"; //landscape
						$data['image2'] = "https://images1.smtickets.com/v3/resources/images/marketing/smtickets_portrait_02162021_2.jpg"; //portrait
						$data['image3'] = "https://images1.smtickets.com/v3/resources/images/marketing/smtickets_landscape_02162021_1.jpg"; //top left
						$this->load->view('etickets_w_image',$data);

					}
					
					elseif($data['tickets'][0]->ticket_price_id == 54211){
						$data['image1'] = "https://images1.smtickets.com/v3/resources/images/marketing/smtickets_carousel_02162021_2.jpg"; //landscape
						$data['image2'] = "https://images1.smtickets.com/v3/resources/images/marketing/smtickets_portrait_02162021_2.jpg"; //portrait
						$data['image3'] = "https://images1.smtickets.com/v3/resources/images/marketing/smtickets_landscape_02162021_3.jpg"; //top left
						$this->load->view('etickets_w_image',$data);

					}
					
					elseif(in_array($data['tickets'][0]->ticket_event_id, array(9664,9666,9667))){
						
						$data['image1'] = "https://images1.smtickets.com/v3/resources/images/marketing/smtickets_carousel_03012021_1.jpg";
						$data['image2'] = "https://images1.smtickets.com/v3/resources/images/marketing/smtickets_portrait_03012021_1.jpg"; 
						$data['image3'] = "https://images1.smtickets.com/v3/resources/images/marketing/smtickets_carousel_03012021_1.jpg"; 
						$this->load->view('etickets',$data);
					}
					
					elseif(in_array($data['tickets'][0]->ticket_event_id, array(9704))){ //ewms
						
						$data['image1'] = "https://images1.smtickets.com/images/carousel_08072021172242.jpg";
						$data['image2'] = "https://images1.smtickets.com/images/portrait_08072021105234.jpg"; 
						$data['image3'] = "https://images1.smtickets.com/images/carousel_08072021172242.jpg";   
						$this->load->view('etickets',$data);
					}
					
					
					elseif($data['tickets'][0]->ticket_event_id == 9703){
						$data['image1'] = "https://images1.smtickets.com/images/carousel_24062021215807.jpg"; //landscape
						$data['image2'] = "https://images1.smtickets.com/images/portrait_24062021215636.jpg"; //portrait
						$data['image3'] = "https://images1.smtickets.com/images/background_24062021220530.jpg"; //top left
						$this->load->view('etickets_w_image',$data);

					}
					
					elseif($data['tickets'][0]->ticket_event_id == 9707){
						$data['image1'] = "https://images1.smtickets.com/images/carousel_29072021140919.jpg"; //landscape
						$data['image2'] = "https://images1.smtickets.com/images/portrait_29072021140737.jpg"; //portrait
						$data['image3'] = "https://images1.smtickets.com/images/background_30072021110344.jpg"; //top left
						$this->load->view('etickets_w_image',$data);

					}
					
					elseif($data['tickets'][0]->ticket_event_id == 9034){
						$data['image1'] = "https://images1.smtickets.com/images/carousel_09082021140510.jpg"; //landscape
						$data['image2'] = "https://images1.smtickets.com/images/portrait_09082021140910.jpg"; //portrait
						$data['image3'] = "https://images1.smtickets.com/images/background_09082021133653.jpg"; //top left
						$this->load->view('etickets_w_image',$data);

					}
					
					elseif($data['tickets'][0]->ticket_event_id == 9711){ //milo
						$data['image1'] = "https://images1.smtickets.com/images/carousel_20102021122640.jpg"; //landscape
						$data['image2'] = "https://images1.smtickets.com/images/portrait_07102021102504.jpg"; //portrait
						$data['image3'] = "https://images1.smtickets.com/images/background_22102021181748.jpg"; //top left
						$this->load->view('etickets_w_image',$data);
					}
					
					
					elseif($data['tickets'][0]->ticket_event_id == 9712){ //milo
						$data['image1'] = "https://images1.smtickets.com/images/carousel_20102021122640.jpg"; //landscape
						$data['image2'] = "https://images1.smtickets.com/images/portrait_20102021120903.jpg"; //portrait
						$data['image3'] = "https://images1.smtickets.com/images/background_22102021181748.jpg"; //top left
						$this->load->view('etickets_w_image',$data);

					}
					
					
					
					else{
					
						// $this->load->view('1_print_at_home_tickets',$data);
						$this->load->view('etickets_dynamic',$data);

					 
					
					}
					 
				}
				
			}else{
				echo "Invalid access";
			}
		}
	}
	
	function acticket($transaction_id=false,$session = false){  
		
 
		if(!$transaction_id){ 
			$this->promptError('ER:06:03');
 		}elseif(!$session){ 
			$this->promptError('ER:06:20');
 		}else{
		// $transaction_id = 2683;
			// $event = 9017;
			$this->transactions->transaction_done($transaction_id); // mark transction as done
			$transaction = $this->transactions->get($transaction_id);
				
				
			$transaction_customer_id = $transaction->transaction_customer_id;
			$session_customer_id = $this->get_customer_id_by_session($session);
			if($transaction_customer_id == $session_customer_id){
				
					$data['tickets'] = $this->printer->get_trans_details($transaction_id);
					$data['barcode'] = $this->smbarcode->attach_smcode_to_transaction_tickets($transaction_id, $data['tickets'], true);
					$data['layout'] = $this->printer->get_ticket_layout($data['tickets'][0]->ticket_event_id);
					
					// echo '<pre>';
					// print_r($data['tickets']);
					// die();
				$this->load->view('ac_tickets',$data);
			}else{
				echo "Invalid access";
			}
		}
	}
	
	//for online concert
	function generate_access_codes(){
		
		$this->smbarcode->generate_access_code();
	}
	
	//manual generate OR from profile and success page
	function generate_manual_or($transaction_id=false){  
		// $this->getallOR();
	 
		$data['transaction'] = $this->transactions->get_transaction_info($transaction_id); 
		$this->load->view('transaction_or_manual', $data,true);

	}
  
}	