<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
include('accesstemplate.php');

class Email extends AccessTemplate {

	public function __construct(){
		parent::__construct();
		$this->load->model('seatplans_model', 'seatplans');
		$this->load->model('sections_model', 'sections');
		$this->load->model('transaction_model', 'transaction');
		$this->load->model('events_model', 'events');
		$this->load->model('prices_model', 'prices');
		$this->load->model('tickets_model', 'tickets');
		$this->load->model('ticket_types_model', 'ticket_types');
		$this->load->database('default',true);
	}
	
	function send_reset_password_email(){
		
		$username = $this->input->get_post('username');
		$email = $this->input->get_post('email');
		$reset_url = $this->input->get_post('reset_url');

		$this->load->library('email');
		$this->email->from('noreply@smtickets.com', 'SMTICKETS');
		$this->email->to($email); 
		$this->email->subject('Email Activation');
		$message = "CONGRATULATIONS!\n\n Hi	$username, \n This is your password reset link \n $reset_url";
		$this->email->message($message);
		$this->email->send();
		
		echo "<pre>";
		print_r($_POST);
		echo "</pre>";
		die();
	
	}
	 
	
	function send_feedback(){
		
		$name = $this->input->post('name');
		$subject = $this->input->post('subject');	
		$message = $this->input->post('message');
		$email = $this->input->post('email');
		
		// $name = 'Japsy';
		// $subject = 'Test Subject';
		// $message = 'Test message';
		
		$sender = 'inquiry@smtickets.com';

		if(!$name){
			$this->promptError('ER:05:21');
		}elseif(!$subject){
			$this->promptError('ER:05:22');
		}elseif(!$message){
			$this->promptError('ER:05:23');
		}elseif(!$email){
			$this->promptError('ER:05:24');
		}else{
		
			$this->load->library('email');
			$this->email->from($sender, 'SMTICKETS'); 
			$this->email->to('customercare@smtickets.com'); 
			// $this->email->to('herbert.miralles@mobilegroupinc.com'); 
			$this->email->subject('[' . $subject . ']');
			$this->email->message("Name:$name \nEmail:$email \n \n $message");
			$this->email->send();
			
			// die();
			$xml = 	'<root><result>Success</result></root>';
			echo $xml;
		}
	}
}


?>