<?php 
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
include('accesstemplate.php');


class Data extends AccessTemplate {
 
	public function __construct(){
		parent::__construct();
		$this->load->model('api_prices_model', 'prices');
		$this->load->model('api_sections_model', 'sections');
		$this->load->database('default',true); 
		ini_set('user_agent',$this->agent->agent_string());
		
	}
	
	 
	//=============== G e n e r i c   D a t a   F u n c t i o n s ===============
	
	 
	function list_events(){
		
			$event_id = $this->input->get_post('eventid');
			$dbAccess = $this->load->database('default',true);
			// $dbAccess = $this->load->database('market',true);
			$dbAccess->query('set transaction isolation level read uncommitted');
			// $event_hidden = array(5577);
	
			$dbAccess->select('evt.event_id,	
			evt.event_long_title');
				
				
			$dbAccess->where("evt.event_active",'1');
			$dbAccess->where("evt.event_date_time >= now()");  
			//hide seagames in dropdown
			// $dbAccess->where_not_in("evt.event_venue_id",array(691,696,697,660,689,675,695,693));
			//$dbAccess->where_not_in("event_id",array(11162,11163,11165,11166));//hide events

			if($event_id){
				$dbAccess->where("evt.event_id", $event_id);
			}

			//hide event
			$dbAccess->where('event_hide_online',0);  
			$dbAccess->join('events_config ec', 'ec.events_config_eventid = event_id', 'left' );
			
			$query = $dbAccess->get('events evt');

		 
			// if(!in_array($event_id,$event_hidden)){
			$data['eventDetails'] = $query->result();
				 
			//display the page
			$this->load->view('event_long_titles', $data);
	}
 
	function getbytitle() {
				

		$dbAccess = $this->load->database('market',true);
		$event_long_title = trim($this->input->get_post("eventlongtitle"));
		 

		$dbAccess->select('evt.event_id,	
 			evt.event_long_title,
			evt.event_date_time');
 
			
			$dbAccess->where('evt.event_long_title', $event_long_title);
			$dbAccess->where("evt.event_active",'1');
			$dbAccess->where("evt.event_date_time >= now()");
			

			$query = $dbAccess->get('events evt');
			$data['eventDetails'] = $query->result();


		$this->load->view('event_by_title', $data);
	}
	
	function getactiveeventsfullMarket_new(){
		
			$event_id = $this->input->get_post('eventid');
			$dbAccess = $this->load->database('default',true);
			// $dbAccess = $this->load->database('market',true);
			//$dbAccess->query('set transaction isolation level read uncommitted');
			// $event_hidden = array(5577);
	
			$dbAccess->select('evt.event_id,	
			evt.event_code,
			evt.event_title,
			evt.event_long_title,
			evt.event_date_time,
			evt.event_description,
			evt.event_image,
			evt.event_image_1,
			evt.event_seatplan_id,
			evt.event_recommended,
			evt.event_description,
			s.seatplan_image,
			evt.event_venue_id,
			v.venue_name,
			evt.event_internet_sales_charge as convenience_charge,
			evt.event_type,
			ec.events_config_ekbarcode_active,
			evt.event_enable_online_selling,
			evt.event_active,
			evt.event_parent,
			evt.event_ticket_types,
			evt.event_hotel,
			evt.event_always_show,
			evt.event_online_registration,
			evt.event_max_ticket, 
			ec.event_display_venue_online,
			ec.event_display_date_online,
			ec.allow_multiple_price,
			ec.events_valid_dates,
			ec.other_event_date_time,
			ec.events_date_validity');
				
				
			$dbAccess->where("evt.event_active",'1');
			$dbAccess->where("evt.event_date_time >= now()");

			$dbAccess->join('events_config ec', 'ec.events_config_eventid = evt.event_id', 'left' );
			$dbAccess->join('venues v', 'v.venue_id = evt.event_venue_id', 'left' );

			$dbAccess->join('seatplans s', 's.seatplan_id = evt.event_seatplan_id', 'left' );

			if($event_id){
				$dbAccess->where("evt.event_id", $event_id);
			}

			$query = $dbAccess->get('events evt');

		 
			// if(!in_array($event_id,$event_hidden)){
			$data['eventDetails'] = $query->result();
				 
				//display the page
				$this->load->view('event_details_xml_new', $data);
		}
 	
	
	function nt_getActiveEventsForListing(){

			$event_id = $this->input->get_post('id');
			$event_match = $this->input->get_post('match');
			
			$event_categories = explode( ' or ',  $this->input->get_post('category') );
				
			// echo $this->input->get_post('category');
			
			
			
			// echo "<pre>";
			// print_r(	$event_categories	);
			// echo "</pre>";
			
			// die();
							
			$long_title = $this->input->get_post('title');
			$venue = $this->input->get_post('venue');

			$json = $this->input->get_post('json');

				$dbAccess = $this->load->database('market',true);
				$dbAccess->select('	e.event_id
									,e.event_active
									,e.event_title
									,e.event_long_title
									,e.event_image
									,e.event_image_1
									,e.event_date_time
									,e.event_announcement_date
									,e.event_tags
									,e.event_category
									,e.event_type
									,e.event_parent
									,e.date_modified as event_date_modified
									,v.venue_id,
									,v.venue_name
									,ec.other_event_date_time
									');

				$dbAccess->where("e.event_active",'1');
				
				//Hidden Pages
				// $dbAccess->where("e.event_id !=", 5279);
				$dbAccess->where("e.event_id !=", 5280);
				$dbAccess->where("e.event_id !=", 5359);
				$dbAccess->where("e.event_id !=", 5360);
				// $dbAccess->where("e.event_id !=", 5788);
				// $dbAccess->where("e.event_id !=", 5577);
				// $dbAccess->where("e.event_id !=", 5157);
				// $dbAccess->where("e.event_id !=", 5645);
				$dbAccess->where("e.event_id !=", 5861);
				//
				
				$dbAccess->where("e.event_date_time >= now()");
				$dbAccess->join('venues v', 'v.venue_id = e.event_venue_id', 'left' );
				$dbAccess->join('events_config ec', 'ec.events_config_eventid = e.event_id', 'left' );
				
				if($event_id){
					$dbAccess->where("e.event_id", $event_id);
				}
				
				if($event_match){
					$dbAccess->like('e.event_title',$event_match,'both');
					// $dbAccess->or_like('e.event_tags',$event_match,'both');	
				}
				
				if($event_categories){
					foreach(	$event_categories as $event_category	){
						if($event_category){
							
						$dbAccess->or_like('e.event_category',$event_category);
						}
					}
				}
				
				if($venue){
				$dbAccess->where("e.event_venue_id",$venue);
				}

				if($long_title){
				$dbAccess->where("e.event_long_title",$long_title);
				}else{
				}
				
				// $dbAccess->order_by('e.event_title',"asc");
				$dbAccess->order_by('e.event_date_time',"asc");
				
				$query = $dbAccess->get('events e');
				
				
				// echo $dbAccess->last_query();
				// die();
				
				$data['events'] = $query->result();
	
				 if(!$json){
					//display the page
					$this->load->view('events_listing_xml', $data);
				}else{
					echo json_encode($query->result());				
					die();
				} 
				
				
		 }
	 
	 
	 
	function events_per_venue(){
		 
		$venue_category = $this->input->post('venue_category');

		$dbAccess = $this->load->database('market',true);
		
		
		if($venue_category){
			if($venue_category == 'MOA Arena'){$dbAccess->where('event_listing_id', 1); }
			if($venue_category == 'SM Venue'){$dbAccess->where('event_listing_id', 2); }
			if($venue_category == 'Other Venue'){$dbAccess->where('event_listing_id', 3); }
			if($venue_category == 'Attractions'){$dbAccess->where('event_listing_id', 5); }
			 
		}else{
			//$dbAccess->where('event_listing_id !=', 4);
		}
		
		 
		
		$q = $dbAccess->get('events_listing');
		$r = $q->result();
	 
	  

		$event_ids = array();
		$event_venues = array();
		foreach($r as $x){
			
				$event_ids = array_merge($event_ids,explode(',',$x->event_ids));
				$event_venues[$x->event_listing_name] = $x->event_ids;
		}
		
		 
		 
		//$event_ids = explode(',',$event_ids);
		
		 
		$dbAccess->select('	e.event_id
							,e.event_active
							,e.event_title
							,e.event_long_title
							,e.event_image
							,e.event_image_1
							,e.event_date_time
							,ec.other_event_date_time 
							,v.venue_id
							,v.venue_name
							,v.venue_category
							');

		$dbAccess->where("e.event_active",'1');
		// $dbAccess->where("venue_category !=","MOA Arena");
		
		
		//Hidden Pages
		// $dbAccess->where("e.event_id !=", 5279);
		$dbAccess->where("e.event_id !=", 5280);
		$dbAccess->where("e.event_id !=", 5359);
		$dbAccess->where("e.event_id !=", 5360);
		// $dbAccess->where("e.event_id !=", 5788);
		// $dbAccess->where("e.event_id !=", 5577);
		// $dbAccess->where("e.event_id !=", 5157);
		// $dbAccess->where("e.event_id !=", 5645);
		$dbAccess->where("e.event_id !=", 5861);
		$dbAccess->where_in("e.event_id", $event_ids); 
		
		$dbAccess->where("e.event_date_time >= now()");
		$dbAccess->join('venues v', 'v.venue_id = e.event_venue_id', 'left' );
		$dbAccess->join('events_config ec', 'ec.events_config_eventid = e.event_id', 'left' );
		
		 
		
		$dbAccess->order_by('e.event_date_time',"asc");
		
		$query = $dbAccess->get('events e');
		 
		$data['events'] = $query->result();
		$data['event_venues'] = $event_venues;

		//display the page 
		$this->load->view('events_per_venue_xml', $data);
		 
		 		 
				
	}
	  
	function attractions(){
		 
		$category = 'attractions';
		$dbAccess = $this->load->database('market',true);
		
		 
		
		
		$dbAccess->select('	e.event_id
							,e.event_active
							,e.event_title
							,e.event_long_title
							,e.event_image
							,e.event_date_time
							,v.venue_id
							,v.venue_name
							,v.venue_category
							');

		$dbAccess->where("e.event_active",'1');
		// $dbAccess->where("venue_category !=","MOA Arena");
		
		
		//Hidden Pages
		// $dbAccess->where("e.event_id !=", 5279);
		$dbAccess->where("e.event_id !=", 5280);
		$dbAccess->where("e.event_id !=", 5359);
		$dbAccess->where("e.event_id !=", 5360);
		// $dbAccess->where("e.event_id !=", 5788);
		// $dbAccess->where("e.event_id !=", 5577);
		// $dbAccess->where("e.event_id !=", 5157);
		// $dbAccess->where("e.event_id !=", 5645);
		$dbAccess->where("e.event_id !=", 5861); 
		$dbAccess->like('e.event_category',$category); 
		$dbAccess->where("e.event_date_time >= now()");
		$dbAccess->join('venues v', 'v.venue_id = e.event_venue_id', 'left' );
		// $dbAccess->join('events_config ec', 'ec.events_config_eventid = e.event_id', 'left' );
		
		 
		
		$dbAccess->order_by('e.event_date_time',"asc");
		
		$query = $dbAccess->get('events e');
		 
		$data['events'] = $query->result();
 
		//display the page
		$this->load->view('attractions_xml', $data);
		 
		 		
				
	}
	 
	function events_per_venue_all(){
		 
		$venue_category = $this->input->post('venue_category');

		$dbAccess = $this->load->database('market',true);
		
		 
		$dbAccess->select('	e.event_id
							,e.event_active
							,e.event_title
							,e.event_long_title
							,e.event_image
							,e.event_date_time
							,v.venue_id
							,v.venue_name
							,v.venue_category
							');

		$dbAccess->where("e.event_active",'1');
		$dbAccess->where("venue_category",$venue_category);
		
		
		//Hidden Pages
		// $dbAccess->where("e.event_id !=", 5279);
		$dbAccess->where("e.event_id !=", 5280);
		$dbAccess->where("e.event_id !=", 5359);
		$dbAccess->where("e.event_id !=", 5360);
		// $dbAccess->where("e.event_id !=", 5788);
		// $dbAccess->where("e.event_id !=", 5577);
		// $dbAccess->where("e.event_id !=", 5157);
		// $dbAccess->where("e.event_id !=", 5645);
		$dbAccess->where("e.event_id !=", 5861);
 		
		$dbAccess->where("e.event_date_time >= now()");
		$dbAccess->join('venues v', 'v.venue_id = e.event_venue_id', 'left' );
		// $dbAccess->join('events_config ec', 'ec.events_config_eventid = e.event_id', 'left' );
		
		 
		
		$dbAccess->order_by('e.event_date_time',"asc");
		$dbAccess->limit(200);
		$query = $dbAccess->get('events e');
		 
		$data['events'] = $query->result();

		//display the page
		$this->load->view('events_per_venue_all_xml', $data);
		 
		 		
				
	}
 
	function calendar(){
		 
		$month = $this->input->post('month');
		$year = $this->input->post('year');

		$dbAccess = $this->load->database('market',true);
		
		
		
		$dbAccess->select('	e.event_id
							,e.event_active
							,e.event_title
							,e.event_long_title
							,e.event_image
							,e.event_date_time
							,v.venue_id
							,v.venue_name
							,v.venue_category
							');

		$dbAccess->where("e.event_active",'1');
		// $dbAccess->where("venue_category !=","MOA Arena");
		
		
		
		if($month)
		$dbAccess->where("MONTH(e.event_date_time)", $month);
	
		if($year)
		$dbAccess->where("YEAR(e.event_date_time)", $year);
	
	
		$dbAccess->where("e.event_date_time >= now()");
		$dbAccess->join('venues v', 'v.venue_id = e.event_venue_id', 'left' );
		 
		
		$dbAccess->order_by('e.event_date_time',"asc");
		
		$query = $dbAccess->get('events e');
		 
		$data['events'] = $query->result();


		// print_r($data['events']);
		// die();
		//display the page
		$this->load->view('events_calendar_xml', $data);
		 
		 		
				
	}
	
	 
	function search(){

		 
		$event_match = $this->input->post('match');

		$dbAccess = $this->load->database('market',true);
		$dbAccess->select('	e.event_id
							,e.event_active
							,e.event_title
							,e.event_long_title
 							,e.event_date_time
							,v.venue_id
							,v.venue_name
							,v.venue_category
							');

		$dbAccess->where("e.event_active",'1');
		
		//Hidden Pages
		// $dbAccess->where("e.event_id !=", 5279);
		$dbAccess->where("e.event_id !=", 5280);
		$dbAccess->where("e.event_id !=", 5359);
		$dbAccess->where("e.event_id !=", 5360);
		// $dbAccess->where("e.event_id !=", 5788);
		// $dbAccess->where("e.event_id !=", 5577);
		// $dbAccess->where("e.event_id !=", 5157);
		// $dbAccess->where("e.event_id !=", 5645);
		$dbAccess->where("e.event_id !=", 5861);
		//
		
		$dbAccess->where("e.event_date_time >= now()");
		//$dbAccess->where_not_in("event_id",array(11162,11163,11165,11166));//hide events
		$dbAccess->join('venues v', 'v.venue_id = e.event_venue_id', 'left' );
 	 
		
		if($event_match){
			$dbAccess->like('e.event_long_title',$event_match,'both');
			// $dbAccess->or_like('e.event_tags',$event_match,'both');	
		}
			
		//hide event
		$dbAccess->where('event_hide_online',0);  
		$dbAccess->join('events_config ec', 'ec.events_config_eventid = event_id', 'left' );
		
		
		$dbAccess->order_by('e.event_date_time',"asc");
		
		
		$query = $dbAccess->get('events e');
		 
		$data['events'] = $query->result();

		//display the page
		$this->load->view('event_search_xml', $data);
		 
		 		
				
	}
	
	function category(){

		 
		$category = $this->input->post('category');

		$dbAccess = $this->load->database('market',true);
		$dbAccess->select('	e.event_id
							,e.event_active
							,e.event_title
							,e.event_long_title
 							,e.event_date_time
 							,e.event_category
							,v.venue_id
							,v.venue_name
							,v.venue_category
							');

		$dbAccess->where("e.event_active",'1');
		
		//Hidden Pages
		// $dbAccess->where("e.event_id !=", 5279);
		$dbAccess->where("e.event_id !=", 5280);
		$dbAccess->where("e.event_id !=", 5359);
		$dbAccess->where("e.event_id !=", 5360);
		// $dbAccess->where("e.event_id !=", 5788);
		// $dbAccess->where("e.event_id !=", 5577);
		// $dbAccess->where("e.event_id !=", 5157);
		// $dbAccess->where("e.event_id !=", 5645);
		$dbAccess->where("e.event_id !=", 5861);
		//$dbAccess->where_not_in("event_id",array(11162,11163,11165,11166));//hide events

		
		$dbAccess->where("e.event_date_time >= now()");
		$dbAccess->join('venues v', 'v.venue_id = e.event_venue_id', 'left' );
 	 
		
		if($category){
			$dbAccess->like('e.event_category',$category);
		}
			
		
		//hide event
		$dbAccess->where('event_hide_online',0);  
		$dbAccess->join('events_config ec', 'ec.events_config_eventid = event_id', 'left' );
		
		
		$dbAccess->order_by('e.event_date_time',"asc");
		
		$query = $dbAccess->get('events e');
		 
		$data['events'] = $query->result();

		//display the page
		$this->load->view('event_category_xml', $data);
		 
		 		
				
	}
	 
	
	function featured() {
				

		$dbAccess = $this->load->database('market',true);
		// $event_long_title = trim($this->input->get_post("eventlongtitle"));
		 
		 
			
		$dbAccess->where('event_listing_id', 4);
		$q = $dbAccess->get('events_listing');
		$r = $q->row();
		$event_ids = $r->event_ids;
		
		$event_ids = explode(',',$event_ids);
			
			// print_r($event_ids);
			// die();

		$dbAccess->select('evt.event_id,	
 			evt.event_long_title,
			evt.event_image,
			evt.event_image_1,
			evt.event_date_time');
 
			
 			// $dbAccess->where("evt.event_recommended",'Yes');
 			$dbAccess->where("evt.event_active",'1');
			$dbAccess->where("evt.event_date_time >= now()");
			$dbAccess->where_in("evt.event_id", $event_ids);
			
			  

			$query = $dbAccess->get('events evt');
			$data['eventDetails'] = $query->result();


		$this->load->view('featured_xml', $data);
	}


 
	function GetPriceSectionForAllActiveEvents(){
		$event_id = $this->input->get_post('eventid');
		
		if(!$event_id){
			$this->promptError('ER:05:03');
		}else{
		
		
		$data['prices'] = $this->prices->getPricesForAllEvents($event_id);
		
		$this->load->view('prices_active_events_xml', $data);
		}
	}
	 
	
	function GetVenueListForAllActiveEvents(){
		
		$venue_id = $this->input->get_post('venueid');
		// $dbAccess = $this->load->database('market',true);
		$dbAccess = $this->load->database('default',true);
		
		$dbAccess->select("	v.venue_id
							,v.venue_type
							, v.venue_name
							, v.venue_address1");
			
		$dbAccess->distinct();
		$dbAccess->join('events e','e.event_venue_id = v.venue_id');
		
		$dbAccess->where('e.event_active',1);
		
		if($venue_id){
		$dbAccess->where('v.venue_id',$venue_id);
		}

		$query = $dbAccess->get('venues v');
		$content = $query->result();
		$data['Venues'] = $content;
		$this->load->view('venues_xml', $data);
	}
	
	function nt_GetSectionsforAllActiveEvents(){

		$event_id = $this->input->get_post('eventid');
		if(!$event_id){
			$this->promptError('ER:05:03');
		}else{
				
			$data['sections'] = $this->sections->getSectionsWithEventID($event_id);

			if(!$data['sections']){
			$this->load->view('blank', $data);
			}else{
			//display the page
			$this->load->view('seatplans_active_events_xml', $data);
			}
		}
	}
	
	function nt_getActiveEventsForCalendar(){

				$date = $this->input->get_post('date');	
				
				// $c_event_date = date('Y-m-d 00:00:00',$date);
				// $p_event_date = date('Y-m-d 23:59:59',$date);
				
				
				
				
				$json = $this->input->get_post('json');
	
				$dbAccess = $this->load->database('default',true);
				$dbAccess->select('	e.event_id
									,e.event_active
									,e.event_title
									,e.event_long_title
									,e.event_image
									,e.event_image_1
									,e.event_date_time
									,e.event_announcement_date
									,e.event_tags
									,e.event_category
									,e.event_type
									,e.event_parent
									,e.date_modified as event_date_modified
									,v.venue_id,
									,v.venue_name,
									,ec.other_event_date_time,
									');

				$dbAccess->where("e.event_active",'1');
				
				$dbAccess->where("date(e.event_date_time)", $date);
				// $dbAccess->where("e.event_date_time <", $p_event_date);

				
				$dbAccess->join('venues v', 'v.venue_id = e.event_venue_id', 'left' );
				$dbAccess->join('events_config ec', 'ec.events_config_eventid = e.event_id', 'left' );

				
				$dbAccess->order_by('e.event_title',"asc");
				
				$query = $dbAccess->get('events e');
				
				
				// echo $dbAccess->last_query();
				// die();
				
				$data['events'] = $query->result();
	
				 if(!$json){
					//display the page
					$this->load->view('events_listing_xml', $data);
				}else{
					echo json_encode($query->result());				
					die();
				} 
				
				
		 }

	function get_seats(){
			
		$event_id = $this->input->get_post('event_id');	
		$section_id = $this->input->get_post('section_id');
		
		if(!$event_id){
			$this->promptError('ER:05:03');
		}elseif(!$section_id){
			$this->promptError('ER:05:05');
		}else{
			

			$data['event_id'] = $event_id;
			$data['sections'] = $this->sections->getSectionsWithEventID_3($event_id,$section_id);
		
			if(!$data['sections']){
				$this->load->view('blank', $data);
			}else{
				//display the page
				$this->load->view('seats_xml', $data);
			}
			
		}
		
	}
	
	function check_promo(){
		
		$event_id = $this->input->get_post('event_id');	
		$price_id = $this->input->get_post('price_id');	
		// $section_id = $this->input->get_post('section_id');
		
		if(!$event_id){
			$this->promptError('ER:05:03');
		}elseif(!$price_id){
			$this->promptError('ER:05:07');
		}else{
			
				
			// if($event_id == 11415){
				// $event_id = 11414; //txt
			// }
			
			if(in_array($price_id,[60116,60117,60118,60119,60120,60121,60122,60123,60124])){ //onefc globe
				//price id here 
				$event_id = 60116;
			}
 			 
			
			$dbAccess = $this->load->database('default',true);
			// $dbAccess->select('count(1) as x, qr_required');
			$dbAccess->where('qr_event_id',$event_id);
			$dbAccess->where("now() >= qr_start_date");
			$dbAccess->where("now() < qr_end_date");
			
			$query = $dbAccess->get('qrcode_setup');
			
			$count = 0;
			$required = 0;
			if($query->num_rows() > 0){
				$result = $query->row();
				
				if($result->qr_price_id == 0){
					
					$count = 1;
				}else{
					
					$price = explode(",", $result->qr_price_id);
					if (in_array("$price_id", $price)){
						
						$count = 1;
					}
					
				}
				$required = $result->qr_required;
				
			}
			
			
			echo '<root>';
			echo '<result>' . $count .'</result>';
			echo '<required>' . $required .'</required>';
			echo '</root>';
			
		}
		
	}
	
	function validate_promo(){
		
		$event_id = $this->input->get_post('event_id');	
		$price_id = $this->input->get_post('price_id');
		$qr_code = $this->input->get_post('qr_code');	
		$status = array('done','paid','paid_online','reserved','selected');
		
		if(!$event_id){
			$this->promptError('ER:05:03');
		}elseif(!$price_id){
			$this->promptError('ER:05:07');
		}elseif(!$qr_code){
			$this->promptError('ER:05:25');
		}else{
			
			if($event_id == 10942){
				$qr_code = $qr_code . $price_id;
			}
			
			if(in_array($event_id, [11438,11439,11440])){ //onefc
				$qr_code = $qr_code . $price_id;
			}
			
			
			// if($event_id == 11415){
				// $event_id = 11414; //txt
			// }
			
			
			
			$dbAccess = $this->load->database('default',true);
			$dbAccess->select('qr_type, qr_usage,qr_transaction_id,qr_price_id , ticket_type_id, ticket_type_name,ticket_type_discount_type, ticket_type_discount, t.transaction_id, t.transaction_status');
			$dbAccess->where('qr_event_id',$event_id);
			$dbAccess->where("now() >= qr_start_date");
			$dbAccess->where("now() < qr_end_date");
			$dbAccess->where('qr_qrcode',$qr_code);
			$dbAccess->join('ticket_types tt', 'tt.ticket_type_id = qr.qr_ticket_type_id', 'left' );
			$dbAccess->join('transactions t', 't.transaction_id = qr.qr_transaction_id', 'left' );

			$query = $dbAccess->get('qrcode qr');
			
			// echo $dbAccess->last_query();
			
			// die();
			$valid = 1;
			if($query->num_rows() > 0){ 
				$result = $query->row();
			 
				if($result->qr_type == 1){
					if($result->transaction_id){
					
						// die('test');
						if(in_array($result->transaction_status, $status)){
							$valid = 0;
						}
					
					}
				}
				
				if($result->qr_price_id == 0){
					
				}else{
					
					if($result->qr_price_id != $price_id){
						
						$valid = 0;
					}else{
						
					}
				}
				 
				
			 
			}else{
			
				$valid = 0;
				
			}
			
			
			if($valid == 0){
				
				echo '<root>';
				echo '<result>Invalid</result>';
				echo '</root>';
			}else{
				
				echo '<root>';
				echo '<ticket_type_id>' . $result->ticket_type_id  .  '</ticket_type_id>';
				echo '<ticket_type_name>' . $result->ticket_type_name  .  '</ticket_type_name>';
				echo '<ticket_type_discount_type>' . $result->ticket_type_discount_type  .  '</ticket_type_discount_type>';
				echo '<ticket_type_discount>' . $result->ticket_type_discount  .  '</ticket_type_discount>';
				echo '</root>';
				
				
			}
			
				
				
			
		}
		
	}
	 
	function disney(){
		 
		$venue_category = $this->input->post('venue_category');

		$dbAccess = $this->load->database('market',true);
		
		 
		$dbAccess->select('	e.event_id
							,e.event_active
							,e.event_title
							,e.event_long_title
							,e.event_image
							,e.event_date_time
							,v.venue_id
							,v.venue_name
							,v.venue_category
							');

		$dbAccess->where("e.event_active",'1');
		
		//Hidden Pages
		// $dbAccess->where("e.event_id !=", 5279);
		$dbAccess->where("e.event_id !=", 5280);
		$dbAccess->where("e.event_id !=", 5359);
		$dbAccess->where("e.event_id !=", 5360);
		// $dbAccess->where("e.event_id !=", 5788);
		// $dbAccess->where("e.event_id !=", 5577);
		// $dbAccess->where("e.event_id !=", 5157);
		// $dbAccess->where("e.event_id !=", 5645);
		$dbAccess->where("e.event_id !=", 5861);
		$dbAccess->like('e.event_title','disney','both');
		
		$dbAccess->where("e.event_date_time >= now()");
		$dbAccess->join('venues v', 'v.venue_id = e.event_venue_id', 'left' );
		// $dbAccess->join('events_config ec', 'ec.events_config_eventid = e.event_id', 'left' );
		
		 
		
		$dbAccess->order_by('e.event_date_time',"asc");
		$dbAccess->limit(200);
		$query = $dbAccess->get('events e');
		 
		$data['events'] = $query->result();

		//display the page
		$this->load->view('disney_events_xml', $data);
		 
		 		
				
	}
	
	function check_coke(){
		
		$event_id = $this->input->get_post('event_id');	
		$customer_id = $this->input->get_post('customer_id');	
		// $section_id = $this->input->get_post('section_id');
		
		if(!$event_id){
			$this->promptError('ER:05:03');
		}elseif(!$customer_id){
			$this->promptError('ER:05:26');
		}else{
			
			$dbAccess = $this->load->database('default',true);
			$dbAccess->select('ticket_id');
			$dbAccess->where('transaction_customer_id',$customer_id);
			$dbAccess->where('ticket_event_id',$event_id);
			$dbAccess->where_in('transaction_status',array('done','paid','paid_online','reserved'));
 			$dbAccess->join('tickets tix', 'tix.ticket_transaction_id = t.transaction_id', 'left' );
 			$dbAccess->limit(1);
		
			$query = $dbAccess->get('transactions t');
			
			$result = 0;
			if($query->num_rows() > 0){
				$result = 1;
				
			}
			
			
			echo '<root>';
			echo '<result>' . $result .'</result>';
			echo '</root>';
			
		}
		
	} 

	function cinema(){
		 
		$category = $this->input->post('category');
		 
		$movies = [9651,9652,9653,9654,9655,9656];
		
		$lipa_movies = [9511,9512,9513,9514,9515];
		
		$venue_category = $this->input->post('venue_category');

		$dbAccess = $this->load->database('market',true);
		
		 
		$dbAccess->select('	e.event_id
							,e.event_active
							,e.event_title
							,e.event_long_title
							,e.event_image
							,e.event_date_time
							,v.venue_id
							,v.venue_name
							,v.venue_category
							');

		$dbAccess->where("e.event_active",'1');
		
		if($category == 'lipa') 
			$dbAccess->where_in("e.event_id", $lipa_movies); 
		else
			$dbAccess->where_in("e.event_id", $movies); 
		
		$dbAccess->where("e.event_date_time >= now()");
		$dbAccess->join('venues v', 'v.venue_id = e.event_venue_id', 'left' );
		// $dbAccess->join('events_config ec', 'ec.events_config_eventid = e.event_id', 'left' );
		
		 
		
		$dbAccess->order_by('e.event_date_time',"asc");
		$dbAccess->limit(200);
		$query = $dbAccess->get('events e');
		 
		$data['events'] = $query->result();

		//display the page
		$this->load->view('disney_events_xml', $data);
		 
		 		
				
	}
	 
	function smcinema(){
		 
		$movies = [788,789,787,786 ,754,755,756,757,758,759,760,761,762,763,764,765,766,767,768,769,770,771,772,773,774,775,776,777,778,779,780,781,782,784,785]; //venue ids
		$venue_category = $this->input->post('venue_category');

		$dbAccess = $this->load->database('market',true);
		
		 
		$dbAccess->select('	e.event_id
							,e.event_active
							,e.event_title
							,e.event_long_title
							,e.event_image
							,e.event_date_time
							,v.venue_id
							,v.venue_name
							,v.venue_category
							');

		$dbAccess->where("e.event_active",'1');
		
	 
		$dbAccess->where_in("e.event_venue_id", $movies); 
		
		$dbAccess->where("e.event_date_time >= now()");
		$dbAccess->join('venues v', 'v.venue_id = e.event_venue_id', 'left' );
		// $dbAccess->join('events_config ec', 'ec.events_config_eventid = e.event_id', 'left' );
		
		 
		
		$dbAccess->order_by('venue_name,e.event_date_time',"asc");
		$dbAccess->limit(200);
		$query = $dbAccess->get('events e');
		 
		 // echo $query->last_query();
		$data['events'] = $query->result();

		//display the page
		$this->load->view('disney_events_xml', $data);
		 
		 		
				
	}
	
	
	function landing(){
		$dbAccess = $this->load->database('market',true);
		 
		$code = $this->input->post('code');
		// $code = 'horanghae';
		$events = array();
		$x['image_landscape'] = '';
		$x['image_portrait'] = '';
		$data['events2'] = (object)$x;
		// $events = [9578,9579,9580,9581];
		if($code){
			
			if($code == 1){$events = [9578,9579,9580,9581];}
			if($code == 2){$events = [9031,9032,9033,9714,9716,9717,9718,10665];} //bowling
			if($code == 4){$events = [9694,9695,9696,9698,9699];} //virtualtours
			if($code == 5){$events = [9711 , 9712 ];} //miloonlinelessson
			if($code == 'lany'){$events = [11171,11163,11165,11166, 11180];}
			if($code == 'aff'){$events = [11224,11225,11233,11234,11235,11236,11237,11238,11239,11240,11241,11242,11243,11244,11245,11246,11247];}
			if($code == 'seven'){$events = [11250 ,11265, 11266];}
			if($code == 'beatles'){$events = [11285,11286,11287];}
			if($code == 'planeshakers'){$events = [11301,11296,11289,11306];}
			if($code == 'cinemalaya'){$events = [11309,11312,11313,11314,11315,11316,11317,11318,11319,11320,11321,11322,11323,11324,11325,11326,11327,11328,11329,11330,11331,11332,11333,11334,11335,11336,11337,11338,11339,11340,11341,11342,11343,11344,11345,11346,11347,11348,11349,11350,11351,11352,11353,11354,11355,11356,11357,11358,11359,11360,11361,11362,11363,11364,11365,11366,11367,11368,11369,11370,11371,11372,11373,11397,11398];}
			
			if(empty($events)){
				$dbAccess->where("code",$code);
				$dbAccess->where("active",1);
				$dbAccess->limit(1);
				$query = $dbAccess->get("events_landing");
				$result = $query->row();
				 
				if($query->num_rows() > 0){
					
					$data['events2']= $result;
					$events = explode(",",$result->events);
					
				} 
			
			}
		}
		
		 
		$dbAccess->select('	e.event_id
							,e.event_active
							,e.event_title
							,e.event_long_title
							,e.event_image
							,e.event_date_time
							,ec.other_event_date_time
							,v.venue_id
							,v.venue_name
							,v.venue_category
							');

		$dbAccess->where("e.event_active",'1');
		
		
		
		$dbAccess->where_in("e.event_id", $events); 
		
		$dbAccess->where("e.event_date_time >= now()");
		$dbAccess->join('venues v', 'v.venue_id = e.event_venue_id', 'left' );
		$dbAccess->join('events_config ec', 'ec.events_config_eventid = e.event_id', 'left' );
		
		 
		
		$dbAccess->order_by('e.event_date_time',"asc");
		$dbAccess->limit(200);
		$query = $dbAccess->get('events e');
		 
		$data['events'] = $query->result();

		//display the page
		$this->load->view('landing_events_xml', $data);
		 
		 		
				
	}
	 
	function routes(){
		$read = $this->load->database('default',true);
		 
		$today = date("Y-m-d H:i:s");
		//$this->db->where('qr_section_id', $this->session->userdata('csi'));
		$read->where('route_end >', $today);
		$read->where('route_start <', $today);
		

		$read->where('route_active',1);
		$query = $read->get('routes');
		$data = $query->result_array();
		
		header('Content-Type: application/json; charset=utf-8');
		echo json_encode($data);

	}

	function getCodeByEvent(){

		$event_id = $this->input->get_post('eventid');
		$read = $this->load->database('default',true);
		$today = date("Y-m-d H:i:s");
		$read->where('end_date >', $today);
		$read->where('start_date <', $today);
		$read->where('event_id',$event_id);
		$read->where('is_active',1);
		$query = $read->get('event_pre_code');
		$data['pre_code'] = $query->result();
		
		$this->load->view('event_with_code_xml', $data);
	}

}
/* End of file generic_mod.php */
/* Location: ./application/controllers/generic_mod.php */