<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
include('accesstemplate.php');

// class Transaction extends CI_Controller {
class Transaction extends AccessTemplate{


	
	public function __construct()
	{
		parent::__construct();
		$this->load->model('api_transaction_model', 'transaction');
		$this->load->model('api_sections_model', 'sections');
		$this->load->model('api_payment_types_model', 'payment_types');
		$this->load->model('api_payments_model', 'payments');
		$this->load->model('api_branches_model', 'branches');
		$this->load->model('api_bcode_model', 'bcode');
		$this->load->model('api_tickets_model', 'tickets');
		$this->load->model('api_prices_model', 'prices');
		$this->load->model('api_events_model', 'events');
		$this->load->model('api_mobilenum_model', 'mobilenum');
		$this->load->model('api_ip_model', 'ip');
		$this->load->model('api_authentication_model', 'authentication');
		$this->load->model('api_customers_model', 'customers');
		$this->load->model('admin_model', 'admin');
		$this->load->database('default',true);
		// $this->db->query('set transaction isolation level read uncommitted');
	}	
	
	
	function nt_activate_customer($username,$hashed_username){
		
		// die("A");
		$result = "<result>failed</result>";
		 if($this->transaction->nt_activate_customer($username,$hashed_username)){
			$result = "<result>success</result>";
		 }
		
		echo $result;
	}
		
	
	
	function login(){ 
		
		//get required parameters
		$username = $this->input->get_post("username");
		$password = $this->input->get_post("password");
		$partyCode = $this->input->get_post("partycode");
		
		$key = $this->input->get_post("key");
		$fixedPass = $this->config->item("passkey");
		
		$email = $this->input->get_post("email");
		
		$ip = $this->input->ip_address();
		
			if(!$username){
				$this->promptError('ER:01:07');		
			}elseif(!$password){
				$this->promptError('ER:01:05');
			}elseif(!$partyCode){
				$this->promptError('ER:01:01');
			}elseif(!$key || $key == $fixedPass){
		
			//verify credentials and issue accesscode
			$data['result'] = $this->transaction->verify($username, $password, $partyCode,$ip,$key,$email);
			
			if($data['result'] == 'Invalid'){
				$this->promptError('ER:02:10');
			}elseif($data['result'] == 'invalid_ip'){
				$this->promptError('ER:00:01');
			}
			else{
				$this->log_details("login","","", "", "user: $username | pass: $password");
				$this->load->view("access_code_xml", $data);
				}
		}else{
		$this->promptError('ER:00:00');
		}
	}
	
	function login_eplus(){
	
		//get required parameters
		$username = $this->input->get_post("username");
		$password = $this->input->get_post("password");
		$partyCode = $this->input->get_post("partycode");
		$ip = $this->input->ip_address();
		if(!$username){
			$this->promptError('ER:01:07');
		}elseif(!$password){
			$this->promptError('ER:01:05');
		}elseif(!$partyCode){
			$this->promptError('ER:01:01');
		
		}else{
		
			//verify credentials and issue accesscode
			$data['result'] = $this->transaction->verify($username, $password, $partyCode,$ip);
			
			if($data['result'] == 'Invalid'){
				$this->promptError('ER:02:10');
			}
			/* elseif($data['result'] == 'invalid_ip'){
				$this->promptError('ER:00:01'); 
			}
*/
			else{
				$this->load->view("access_code_xml", $data);
				}
			
		}
	}
	
	function initialize(){
	
		
		//get required parameters
		$accessCode = $this->input->get_post("accesscode");
		
		if(!$accessCode){
			$this->promptError('ER:01:06');
		}else{
		
			//verify accesscode and generate live token
			$data['result'] = $this->transaction->validateAccessCode($accessCode);
		
			if($data['result'] == 'expired'){
				$this->promptError('ER:03:03');
			}elseif($data['result'] == 'inactive'){
				$this->promptError('ER:02:09');
			}elseif($data['result'] == 'invalid'){
				$this->promptError('ER:02:06');
			}else{
				$this->load->view("initialize_xml", $data);
			}
		}
	}
	
	function renewToken(){
	
		//get required parameters
		$accessCode = $this->input->get_post('accesscode');
		$token = $this->input->get_post('dynatoken');
	
		if(!$accessCode){
			$this->promptError('ER:01:06');
		}elseif(!$token){
			$this->promptError('ER:01:08');
		}else{
	
			$data['result'] = $this->transaction->renewToken($accessCode, $token);
			
			if($data['result'] == 'expired'){
				$this->promptError('ER:03:04');
			}elseif($data['result'] == 'inactive'){
				$this->promptError('ER:02:08');
			}elseif($data['result'] == 'invalid'){
				$this->promptError('ER:02:02');
			}else{
			$this->load->view("initialize_xml", $data);
			}
		
		}
	
	
		
	}
	
	// Buy_Ticket()
	function purchaseTicket(){
 
		$ticketDetails = array();
		$accessCode =  $this->input->get_post("accesscode"); 
		$dynaToken =  $this->input->get_post("dynatoken"); 
		$totalAmount =  $this->input->post("totalamount"); 
		
	
		if(!$accessCode){
			$this->promptError('ER:01:06');
		}elseif(!$dynaToken){
			$this->promptError('ER:01:08');
		}elseif(!$totalAmount){
			$this->promptError('ER:06:10');
		}else{
		
			// verify access credentials before processing order request
			$result = $this->transaction->verify_access_token($accessCode, $dynaToken);
			
			if($result == 'expired'){ 
				$this->promptError('ER:03:04');
			}elseif($result == 'inactive'){ 
				$this->promptError('ER:02:08');
			}elseif($result == 'invalid'){ 
				$this->promptError('ER:02:02'); 
			}else{ 
			
				//get ticket parameters

				$dm = $this->input->post("datamessage");
 				foreach($dm as $x){
					if(empty($x)) { }
					else {
 						$ticketDetails[] = explode("|", $x);
 					}
				}
				// print_r($ticketDetails);
					
				if(empty($ticketDetails)){	 
				$this->promptError('ER:06:01');  
				}else{ 
					
					if(count($ticketDetails) > 10){ 
					$this->promptError('ER:06:12');  
					}else{
								
					
						$valid = $this->transaction->check_ticket_details($ticketDetails, $totalAmount,$accessCode);
						

						// echo $valid;
						// Die();

						if($valid == 0){
							$this->promptError('ER:06:02'); 
						}else{ 
							if($valid == 2){
							$this->promptError('ER:06:14');  
							}else{
								$data['ticketDetails'] = $ticketDetails;
								//buy ticket
								$data['result'] = $this->transaction->buy_ticket($ticketDetails , $accessCode);
								$result = $data['result'];
								$transaction_id = $result[1]; 
								$data['total_amount'] = $totalAmount; 
								
								$this->load->view("ticket_response_xml", $data);
							}
						}
					}
				}
			}
			 
		}
	
	}

	function payment_done()
	{ 
  
		//order details
		$referenceNumber =  $this->input->post("referencenumber"); 
		$amount =  $this->input->post("amount"); 
		$paycode =  $this->input->post("paycode"); 
		$cardNumber =  $this->input->post("cardnumber"); 
		$expiration =  $this->input->post("expiration"); 
		$card_type =  $this->input->post("card_type"); 
		$others =  $this->input->post("others"); 
 		 
		//for security
		$appCode =  $this->input->get_post("appcode"); 
		$liveToken =  $this->input->get_post("livetoken"); 
		$accessCode =  $this->input->get_post("accesscode"); 
		$dynaToken =  $this->input->get_post("dynatoken"); 
		 
 
		if(!$appCode){
			$this->promptError('ER:01:03');
		}elseif(!$liveToken){
			$this->promptError('ER:01:04');
		}elseif(!$accessCode){
			$this->promptError('ER:01:06');
		}elseif(!$dynaToken){
			$this->promptError('ER:01:08');
		}elseif(!$referenceNumber){
			$this->promptError('ER:06:03');
		}elseif(!$amount){
			$this->promptError('ER:06:05');
		}elseif(!$paycode){
			$this->promptError('ER:06:08');
		}else{
		 
			if(!$cardNumber){
			
				$cardNumber = 'xxxxxxxxxxxxxxxx';
			}
			// elseif(!$cardNumber){
			// $this->promptError('ER:06:09');
		// }
		 
		 
		 
			
			// verify access credentials before processing order request
			$access_result = $this->transaction->verify_access_token($accessCode, $dynaToken);
			
			if($access_result == 'expired'){ 
				$this->promptError('ER:03:04');
			}elseif($access_result == 'inactive'){ 
				$this->promptError('ER:02:14');
			}elseif($access_result == 'invalid'){ 
				$this->promptError('ER:02:12'); 
			}else{	
		 
				$app_result = $this->transaction->verify_app_token($appCode, $liveToken);
				
				// if($app_result == 'expired'){ 
				// $this->promptError('ER:03:01');
				// }elseif($app_result == 'inactive'){ 
					// $this->promptError('ER:02:13');
				// }elseif($app_result == 'invalid'){ 
					// $this->promptError('ER:02:11'); 
				// }else{
				
				 
					$ref = explode("-", $referenceNumber);  
					if($ref[0] != 99){
						$this->promptError('ER:06:04'); 
					}else{
					 
						$transaction_id = $ref[1];	 
						// default value
						$pid = 0;
						$eid = 0;
						
						// identify tickets and the price_id/event_id just in case user opened events with new tab
						$selected_tickets = $this->tickets->get_selected_tickets($transaction_id);
						foreach ($selected_tickets as $ticket) {
							$pid = $ticket->ticket_price_id;
							$eid = $ticket->ticket_event_id;
						}

						// check if valid access
						if (($pid > 0) && ($eid > 0)) { 
							// transaction tickets has valid event_id and price_id info
						 

							// identify price id from tickets
							$data['price'] =  $this->prices->get($pid);
							
							// identify event id from tickets
							$data['event'] = $this->events->get($eid);
							
							// get total amount
							$ticket_count = count($selected_tickets); 
							// $total_amount = $ticket_count * $data['price']->price_price;
							
							//korewa
							if ($selected_tickets[0]->ticket_type_discount_type == 'Amount'): 
							$price = ceil($selected_tickets[0]->price_price - $selected_tickets[0]->ticket_type_discount);  
							elseif ($selected_tickets[0]->ticket_type_discount_type == 'Percentage'): 
							$price = ceil($selected_tickets[0]->price_price - (($selected_tickets[0]->price_price * $selected_tickets[0]->ticket_type_discount)/100)); 
							endif; 
							
							$total_amount = $ticket_count * $price;
							
							$orig_amount_raw = $total_amount + ($data['event']->event_internet_sales_charge * $ticket_count);
							$orig_amount = number_format($orig_amount_raw, 2, '', '');
							if ($orig_amount != $amount)
							{
								//error message
								//Amount paid did not match the transaction amount
								$this->promptError('ER:06:06'); 
								
							}
							else
							{
								$payment_type = $this->payment_types->get_by_code($paycode);
								if(!$payment_type){
								//invalid paycode
								$this->promptError('ER:06:13');
								}else{ 
									$this->transaction->paid_online($transaction_id); // mark the transaction as paid_online
									$this->payments->add($transaction_id, $payment_type->payment_type_id, $orig_amount_raw); // add total payment
									// $card_num = $this->input->get("CardNum");
									$this->payments->add_cardnum($transaction_id,$cardNumber,$expiration, $card_type);
									
									$charge_amount = ($data['event']->event_internet_sales_charge * $ticket_count);
									if ($charge_amount > 0) {
										$this->payments->add_convenience_charge_details($transaction_id, $ticket_count, $charge_amount); // add convenience charge details
									}
									$this->payments->add_totalpay($transaction_id, $payment_type->payment_type_id, $orig_amount_raw, 'total'); // add total amount
									$data['payment_type'] = $payment_type->payment_type_code; // payment type
									
									// add receipt numbers
									$or_number = 0;
									$transaction = $this->transaction->get_for_bcode($transaction_id);
									if($transaction){ 
										// OR number
										$event_internet_sales_charge = $data['event']->event_internet_sales_charge;
										if (is_numeric($event_internet_sales_charge) && ($event_internet_sales_charge > 0))
										{
											$or_number = $this->branches->get_last_or_number($transaction->transaction_branch_id);
											$this->transaction->update_receipt_number($transaction_id, $or_number);
										}
										else 
										{
											$or_number = 0;
										}
										
															
										foreach ($selected_tickets as $ticket)
										{
											// AR number
											$ar_number = $this->branches->get_last_receipt_number($transaction->transaction_branch_id);
											$this->tickets->update_acknowledgment_receipt($ticket->ticket_id, $ar_number);
											
											
										}
										
									
										//check events_config if bcode is active
										$useBCODE = $this->bcode->isActive($eid);
							
										if ($useBCODE) {
											$d_or_number = sprintf("%06d", $or_number);
											$msg = "OR No: $d_or_number RefNum: $transaction_id Thank you for buying through SM Tickets Online.";
											
											$arrMobileNum = $this->mobilenum->lookup($transaction->customer_mobile);
											if ($arrMobileNum['isLocal']) {
												$carrier = $arrMobileNum['bCODE'];
												$localmobilenum = $arrMobileNum['CountryCode'].$arrMobileNum['MobileNum'];
											} 
											else {
												$localmobilenum = $arrMobileNum['MobileNum'];
											}
											// $sendSMS = $this->session->userdata('sendSMS');
											$sendSMS = '';
											
											if (empty($sendSMS)) {
												$carrier = '';
												$msg = '';
											}
											
											$querydata = array(
												'user' => $this->config->item('bcode_user'),
												'password' => $this->config->item('bcode_pass'),
												'application' => $this->config->item('bcode_app'),
												'mobile' => $localmobilenum,
												'carrier' => $carrier,
												'message' => $msg,
											);
											
											
								
											$xmlResult = $this->extension->__getbcode($querydata);
											if (is_array($xmlResult)) {
												if (isset($xmlResult['Result']) && ($xmlResult['Result'] == 0)) {
													$insertdata = array(
														'bcode_transaction_id' => $transaction_id,
														'bcode_value' => $xmlResult['bCODE'],
														'bcode_sendSMS' => $localmobilenum,
														'bcode_carrier' => $carrier,
													);
													$write = $this->load->database('live',true);
													$write->insert('bcode', $insertdata); 
												}
											}
										}
 
									
									}	
									// $postrequest = @$this->extension->post2mci($this->session->userdata('tid'));
									// $postrequest = @$this->extension->post2mci($transaction_id);
									// $this->session->unset_userdata('sendSMS');
									// redirect("transaction/payment_receipt/$transaction_id/$hash/$pid/$eid");
									
									// get data
									$data['charge_amount'] = $charge_amount; 
									$data['transaction_id'] = $transaction_id; 
									$data['or_receipt'] = $this->transaction->get_or($transaction_id); 
									$data['trans_date'] = date("Y-m-d H:i:s");
									$data['amount'] = $amount;
									$data['tickets'] = $this->tickets->get_paid_online_tickets($transaction_id);
									
									 
									$this->load->view("result_xml", $data);
									//$this->customers->send_payment_notification($appCode,$liveToken,$accessCode,$dynaToken,$transaction_id);
								}
							}
							 
						} else {
							//Invalid transaction information.'
							$this->promptError('ER:06:07'); 
						}	
					}
				// }	
					
			}
			 
		}
	}
 
	
	function payment_done_2()
	{ 
  
		//order details
		$referenceNumber =  $this->input->post("referencenumber"); 
		$amount =  $this->input->post("amount"); 
		$paycode =  $this->input->post("paycode"); 
		$cardNumber =  $this->input->post("cardnumber"); 
		$expiration =  $this->input->post("expiration"); 
		$card_type =  $this->input->post("card_type");
		$others =  $this->input->post("others"); 
 		 
		//for security
		/* $appCode =  $this->input->get_post("appcode"); 
		$liveToken =  $this->input->get_post("livetoken"); 
		$accessCode =  $this->input->get_post("accesscode"); 
		$dynaToken =  $this->input->get_post("dynatoken"); 
		 
 
		if(!$appCode){
			$this->promptError('ER:01:03');
		}elseif(!$liveToken){
			$this->promptError('ER:01:04');
		}elseif(!$accessCode){
			$this->promptError('ER:01:06');
		}elseif(!$dynaToken){
			$this->promptError('ER:01:08');
		}else */
		if(!$referenceNumber){
			$this->promptError('ER:06:03');
		}elseif(!$amount){
			$this->promptError('ER:06:05');
		}elseif(!$paycode){
			$this->promptError('ER:06:08');
		}elseif(!$cardNumber){
			$this->promptError('ER:06:09');
		}else{
		 
			/* 
			// verify access credentials before processing order request
			$access_result = $this->transaction->verify_access_token($accessCode, $dynaToken);
			
			if($access_result == 'expired'){ 
				$this->promptError('ER:03:04');
			}elseif($access_result == 'inactive'){ 
				$this->promptError('ER:02:14');
			}elseif($access_result == 'invalid'){ 
				$this->promptError('ER:02:12'); 
			}else{	
		 
				$app_result = $this->transaction->verify_app_token($appCode, $liveToken);
				
				// if($app_result == 'expired'){ 
				// $this->promptError('ER:03:01');
				// }elseif($app_result == 'inactive'){ 
					// $this->promptError('ER:02:13');
				// }elseif($app_result == 'invalid'){ 
					// $this->promptError('ER:02:11'); 
				// }else{
				
				  */
					$ref = explode("-", $referenceNumber);  
					if($ref[0] != 99){
						$this->promptError('ER:06:04'); 
					}else{
					 
						$transaction_id = $ref[1];	 
						// default value
						$pid = 0;
						$eid = 0;
						
						// identify tickets and the price_id/event_id just in case user opened events with new tab
						$selected_tickets = $this->tickets->get_unselected_tickets($transaction_id);
						foreach ($selected_tickets as $ticket) {
							$pid = $ticket->ticket_price_id;
							$eid = $ticket->ticket_event_id;
						}

						// check if valid access
						if (($pid > 0) && ($eid > 0)) { 
							// transaction tickets has valid event_id and price_id info
						 

							// identify price id from tickets
							$data['price'] =  $this->prices->get($pid);
							
							// identify event id from tickets
							$data['event'] = $this->events->get($eid);
							
							// get total amount
							$ticket_count = count($selected_tickets); 
							// $total_amount = $ticket_count * $data['price']->price_price;
							
							//korewa
							if ($selected_tickets[0]->ticket_type_discount_type == 'Amount'): 
							$price = ceil($selected_tickets[0]->price_price - $selected_tickets[0]->ticket_type_discount);  
							elseif ($selected_tickets[0]->ticket_type_discount_type == 'Percentage'): 
							$price = ceil($selected_tickets[0]->price_price - (($selected_tickets[0]->price_price * $selected_tickets[0]->ticket_type_discount)/100)); 
							endif; 
							
							$total_amount = $ticket_count * $price;
							
							
							$orig_amount_raw = $total_amount + ($data['event']->event_internet_sales_charge * $ticket_count);
							$orig_amount = number_format($orig_amount_raw, 2, '', '');
							if ($orig_amount != $amount)
							{
								//error message
								//Amount paid did not match the transaction amount
								$this->promptError('ER:06:06'); 
								
							}
							else
							{
								$payment_type = $this->payment_types->get_by_code($paycode);
								if(!$payment_type){
								//invalid paycode
								$this->promptError('ER:06:13');
								}else{ 
									$this->transaction->paid_online_override($transaction_id); // mark the transaction as paid_online
									$this->payments->add($transaction_id, $payment_type->payment_type_id, $orig_amount_raw); // add total payment
									// $card_num = $this->input->get("CardNum");
									$this->payments->add_cardnum($transaction_id,$cardNumber,$expiration, $card_type);
									
									$charge_amount = ($data['event']->event_internet_sales_charge * $ticket_count);
									if ($charge_amount > 0) {
										$this->payments->add_convenience_charge_details($transaction_id, $ticket_count, $charge_amount); // add convenience charge details
									}
									$this->payments->add_totalpay($transaction_id, $payment_type->payment_type_id, $orig_amount_raw, 'total'); // add total amount
									$data['payment_type'] = $payment_type->payment_type_code; // payment type
									
									// add receipt numbers
									$or_number = 0;
									$transaction = $this->transaction->get_for_bcode($transaction_id);
									if($transaction){ 
										// OR number
										$event_internet_sales_charge = $data['event']->event_internet_sales_charge;
										if (is_numeric($event_internet_sales_charge) && ($event_internet_sales_charge > 0))
										{
											$or_number = $this->branches->get_last_or_number($transaction->transaction_branch_id);
											$this->transaction->update_receipt_number($transaction_id, $or_number);
										}
										else 
										{
											$or_number = 0;
										}
										
															
										foreach ($selected_tickets as $ticket)
										{
											// AR number
											$ar_number = $this->branches->get_last_receipt_number($transaction->transaction_branch_id);
											$this->tickets->update_acknowledgment_receipt($ticket->ticket_id, $ar_number);
											
											
										}
										
									
										//check events_config if bcode is active
										$useBCODE = $this->bcode->isActive($eid);
							
										if ($useBCODE) {
											$d_or_number = sprintf("%06d", $or_number);
											$msg = "OR No: $d_or_number RefNum: $transaction_id Thank you for buying through SM Tickets Online.";
											
											$arrMobileNum = $this->mobilenum->lookup($transaction->customer_mobile);
											if ($arrMobileNum['isLocal']) {
												$carrier = $arrMobileNum['bCODE'];
												$localmobilenum = $arrMobileNum['CountryCode'].$arrMobileNum['MobileNum'];
											} 
											else {
												$localmobilenum = $arrMobileNum['MobileNum'];
											}
											// $sendSMS = $this->session->userdata('sendSMS');
											$sendSMS = '';
											
											if (empty($sendSMS)) {
												$carrier = '';
												$msg = '';
											}
											
											$querydata = array(
												'user' => $this->config->item('bcode_user'),
												'password' => $this->config->item('bcode_pass'),
												'application' => $this->config->item('bcode_app'),
												'mobile' => $localmobilenum,
												'carrier' => $carrier,
												'message' => $msg,
											);
											
											
								
											$xmlResult = $this->extension->__getbcode($querydata);
											if (is_array($xmlResult)) {
												if (isset($xmlResult['Result']) && ($xmlResult['Result'] == 0)) {
													$insertdata = array(
														'bcode_transaction_id' => $transaction_id,
														'bcode_value' => $xmlResult['bCODE'],
														'bcode_sendSMS' => $localmobilenum,
														'bcode_carrier' => $carrier,
													);
													$write = $this->load->database('live',true);
													$write->insert('bcode', $insertdata); 
												}
											}
										}
 
									
									}	
									// $postrequest = @$this->extension->post2mci($this->session->userdata('tid'));
									// $postrequest = @$this->extension->post2mci($transaction_id);
									// $this->session->unset_userdata('sendSMS');
									// redirect("transaction/payment_receipt/$transaction_id/$hash/$pid/$eid");
									
									// get data
									$data['charge_amount'] = $charge_amount; 
									$data['transaction_id'] = $transaction_id; 
									$data['or_receipt'] = $this->transaction->get_or($transaction_id); 
									$data['trans_date'] = date("Y-m-d H:i:s");
									$data['amount'] = $amount;
									$data['tickets'] = $this->tickets->get_paid_online_tickets($transaction_id);
									
									 
									$this->load->view("result_xml", $data);
									//$this->customers->send_payment_notification($appCode,$liveToken,$accessCode,$dynaToken,$transaction_id);
								}
							}
							 
						} else {
							//Invalid transaction information.'
							$this->promptError('ER:06:07'); 
						}	
					}
				// }	
					
			}
			 
		// }
	}

 
	//created 9-18-2013
	// select_seat
	function select_seat(){
		
		//get required parameters
		
		$appcode = $this->input->get_post('appcode');
		$livetoken = $this->input->get_post('livetoken');
		
		$accessCode =  $this->input->get_post("accesscode"); 
		$dynaToken =  $this->input->get_post("dynatoken"); 
		
		$event_id = $this->input->get_post("eventid");
		$section_id = $this->input->get_post("sid");
		$system_row = $this->input->get_post("sr");
		$system_col = $this->input->get_post("sc");
		$row = $this->input->get_post("row");
		$seat = $this->input->get_post("seat");
		
		

		// verify access credentials before processing order request
			$result = $this->transaction->verify_access_token($accessCode, $dynaToken);
		
		if(!$event_id){
			$this->promptError('ER:05:03');
		}elseif(!$appcode){
			$this->promptError('ER:01:03');
		}elseif(!$livetoken){
			$this->promptError('ER:01:04');
		}elseif(!$this->authentication->validatesession($appcode,$livetoken)){
			$this->promptError('ER:02:02');
		}elseif($this->authentication->checksessionexpiration($appcode,$livetoken)){
			$this->promptError('ER:03:01');
		}elseif(!$accessCode){
			$this->promptError('ER:01:06');
		}elseif(!$dynaToken){
			$this->promptError('ER:01:08');
		}elseif($result == 'expired'){ 
			$this->promptError('ER:03:04');
		}elseif($result == 'inactive'){ 
			$this->promptError('ER:02:08');
		}elseif($result == 'invalid'){ 
			$this->promptError('ER:02:02'); 
		}
		
		
		elseif(!$section_id){
			$this->promptError('ER:05:05');
		}elseif($system_row==""){
			$this->promptError('ER:06:16');
		}elseif($system_col==""){
			$this->promptError('ER:06:17');
		}elseif(!$row){
			$this->promptError('ER:06:18');
		}elseif($seat==""){
			$this->promptError('ER:06:19');
		}
		else{
	
		
		// check parameters
		// if (!$section_id or !$event_id or !$row or !$seat) show_404();
		
		// log this
		// $this->logs->add('Select Seat');
		
		// check user session
		// $this->users->check_session(array('Admin', 'Seller', 'Manager', 'Promoter'));
		
		// get row
		// preg_match("/^(seat\[R)(.*)(\]\[\])$/", $row, $matches);
		// $system_row = $matches[2];
		
		$this->tickets->select_ticket($event_id, $section_id, $system_row, $system_col, $row, $seat,$accessCode);
		}
	
	
		}
	
	// unselect_seat
	function unselect_seat(){
		
		//get required parameters
		
		$appcode = $this->input->get_post('appcode');
		$livetoken = $this->input->get_post('livetoken');
		
		$accessCode =  $this->input->get_post("accesscode"); 
		$dynaToken =  $this->input->get_post("dynatoken"); 
		
		$event_id = $this->input->get_post("eventid");
		$section_id = $this->input->get_post("sid");
		$system_row = $this->input->get_post("sr");
		$system_col = $this->input->get_post("sc");
		$row = $this->input->get_post("row");
		$seat = $this->input->get_post("seat");
		
		

		// verify access credentials before processing order request
			$result = $this->transaction->verify_access_token($accessCode, $dynaToken);
		
		if(!$event_id){
			$this->promptError('ER:05:03');
		}elseif(!$appcode){
			$this->promptError('ER:01:03');
		}elseif(!$livetoken){
			$this->promptError('ER:01:04');
		}elseif(!$this->authentication->validatesession($appcode,$livetoken)){
			$this->promptError('ER:02:02');
		}elseif($this->authentication->checksessionexpiration($appcode,$livetoken)){
			$this->promptError('ER:03:01');
		}elseif(!$accessCode){
			$this->promptError('ER:01:06');
		}elseif(!$dynaToken){
			$this->promptError('ER:01:08');
		}elseif($result == 'expired'){ 
			$this->promptError('ER:03:04');
		}elseif($result == 'inactive'){ 
			$this->promptError('ER:02:08');
		}elseif($result == 'invalid'){ 
			$this->promptError('ER:02:02'); 
		}
		
		
		elseif(!$section_id){
			$this->promptError('ER:05:05');
		}elseif($system_row ==''){
			$this->promptError('ER:06:16');
		}elseif($system_col==''){
			$this->promptError('ER:06:17');
		}
		// elseif(!$row){
			// $this->promptError('ER:06:18');
		// }elseif(!$seat){
			// $this->promptError('ER:06:19');
		// }
		else{
	
		
		// check parameters
		// if (!$section_id or !$event_id or !$row or !$seat) show_404();
		
		// log this
		// $this->logs->add('Select Seat');
		
		// check user session
		// $this->users->check_session(array('Admin', 'Seller', 'Manager', 'Promoter'));
		
		// get row
		// preg_match("/^(seat\[R)(.*)(\]\[\])$/", $row, $matches);
		// $system_row = $matches[2];
		
		$this->tickets->unselect_ticket($event_id, $section_id, $system_row, $system_col);
		}
	
	
		}

	function clear_selected_seats()
	{
			$read = $this->load->database('default',true);
			$write = $this->load->database('live',true);
			$read->query('set transaction isolation level read uncommitted');
			// $write->query('set transaction isolation level read uncommitted');
			$ticket_count = 0;
			$unselected_rows = 0;
			// expire time set to 60 minutes from 15 minutes. This is to ensure that no one is holding a rightfully locked seat.
			// expiry check time uses ticket_date_entered for expiry check.
			// $minutes = 60;
			 
			$minutes =  $this->config->item("selected_seat_expiry");
			$expire_time = date("Y-m-d H:i:s", strtotime(date("Y-m-d H:i:s"))-($minutes*60));
			$date = date('Y-m-d', strtotime($expire_time));
			$newdate = strtotime('-1 day' , strtotime($expire_time));
			$newdate = date ( 'Y-m-d H:i:s' , $newdate );
			
			
			$read->join($this->tickets->transactions, 'tr.transaction_id = ti.ticket_transaction_id', 'left');
			$read->where('tr.transaction_ipay_status !=', 'Successful payment');
			
			
			// get selected seats that are due for clearing
			$read->where('ti.ticket_date_entered <=', $expire_time);
			$read->where('ti.ticket_date_entered >=', $newdate);
			// from selected and paid status to selected only. This is to ensure that no one is holding a rightfully locked seat.
			// $this->db->where('ticket_transaction_id', '0');
			$read->where('ti.ticket_status', 'selected');
			$query = $read->get($this->tickets->tickets);
			$tickets = $query->result();


			$info = array();
			// use this as identifier there is an existing ekbarcode
			// $existing_used_ekbc = false;
			if (count($tickets) > 0)
			{
			// identify list of EK Events
			// $ek_events = $this->ekbarcode->listing_active_array();

			$info["expire"] = $expire_time;
			foreach ($tickets as $ticket)
			{
			// count tickets to identify if there is one that has ek_barcode
			/* if (isset($ek_events[$ticket->ticket_event_id])) {
			$ek_events[$ticket->ticket_event_id]++;
			} */

			//-------UNSELECT SEATS
			$write->where('ti.ticket_id', $ticket->ticket_id);
			$write->where('ti.ticket_status', 'selected');
			$write->update($this->tickets->tickets, array('ticket_status' => 'unselected'));
			$ticket_count = $write->affected_rows();

			//-------UPDATE AVAILABLE SEATS COUNT
			$this->tickets->update_available($ticket->ticket_section_id, 'increase', $ticket_count);	
			$info["tixid"][$ticket->ticket_transaction_id][] = $ticket->ticket_id;
			$unselected_rows++;
			}
			// $existing_used_ekbc = (array_sum($ek_events) > 0) ? true : $existing_used_ekbc ;

			// unselect the selected transactions with no associated tickets
				/* $t_selected = $this->transaction->get_transaction_selected_only();
				foreach($t_selected as $t) {
				$tid = $t->transaction_id;
				$read->where_in('ticket_status', array('selected','paid_online','done','paid'));
				$read->where_in('ticket_transaction_id', $tid);
				$query = $read->get($this->tickets->tickets);
				$tickets = $query->result();

				if (count($tickets) > 0) {
				// transaction ID still has selected tickets -- cannot unselect transaction
				}
				else {
				$this->transaction->unselect($tid);
				$info["tid_e"][] = $tid;
				}
				} */
			}
			/* if ($existing_used_ekbc) {
			$this->ekbarcode->free _stagnant_barcodes();
			} */
			echo "<root><result>$unselected_rows selected seats cleared</result></root>";
			//-------LOG
			/* if (!empty($info)) {
			$info["sysdate"] = date("Y-m-d H:i:s");
			$this->olog->add_arrayinfo_to_review($info);
			} */
		}


		
		 
	 function nt_select_seat($event_id=false, $section_id=false, $ticket_type=false, $system_row=false, $system_col=false, $row=false, $seat=false,$priceID=false,$session=false){
 
		if(!$session){
		$this->promptError('ER:01:06');
		}else{
		$this->tickets->nt_select_ticket($event_id, $section_id, $ticket_type,$system_row, $system_col, $row, $seat,$priceID,$session);
		// echo $this->db->last_query();
		die();
		}
	}
	
	// unselect_seat
	function nt_unselect_seat($ticketID,$sectionID){
		echo $this->tickets->nt_unselect_ticket($ticketID,$sectionID);
		die();
	}


 
	function nt_get_all_selected_seats(){
		$session = $this->input->get_post("sessionid");
		if(!$session){
		$this->promptError('ER:05:20');		
		}else{
		
		$data["selected_tickets"] = $this->tickets->nt_get_selected_seats_by_session($session);
		
				$used_ticket_types = array();
				foreach($data["selected_tickets"] as $selected_ticket){
				$selected_ticket->ticket_type_id;
					$used_ticket_types[] = $selected_ticket->ticket_type_id;
				}
				$used_ticket_types = array_unique($used_ticket_types);

		$data["ticket_types"] = $this->tickets->nt_get_ticket_types($used_ticket_types);
		
		$this->load->view("nt_selected_tickets_xml",$data);
		}
	}
	
	
	function nt_replace_session_for_selected_seats($old_session,$new_session){
	
		
		if(!$old_session){
		$this->promptError('ER:05:20');		
		}elseif(!$new_session){
		$this->promptError('ER:05:20');	
		}else{
		
		
		// echo "old:$old_session new:$new_session <br>";
		 $this->tickets->nt_replace_session_for_selected_seats($old_session,$new_session);
	
		echo "<root></root>";
		}
	}
	
	
	
	
	function nt_unsellect_all_by_session($session,$section_id=false){
	
		if(!$session){
		$this->promptError('ER:05:20');		
		}else{
		 $this->tickets->nt_unsellect_all_by_session($session,$section_id);
		echo "<root></root>";
		}
	}
	
	
	
		// Buy_Ticket()
	function nt_purchaseTicket(){
 
		$ticketDetails = array();
		$accessCode =  $this->input->get_post("accesscode"); 
		$totalAmount =  $this->input->post("totalamount"); 
		$referrer =  $this->input->post("referrer"); 
		$profession =  $this->input->post("profession"); 
		
	
		if(!$accessCode){
			$this->promptError('ER:01:06');
		}elseif(!$totalAmount){
			$this->promptError('ER:06:10');
		}else{
		
			// verify access credentials before processing order request
			// $result = $this->transaction->verify_access_token($accessCode, $dynaToken);
			
		 
			
			//get ticket parameters

			$dm = $this->input->post("datamessage");
			foreach($dm as $x){
				if(empty($x)) { }
				else {
					$ticketDetails[] = explode("|", $x);
				}
			}
			// print_r($ticketDetails);
				
			if(empty($ticketDetails)){	 
			$this->promptError('ER:06:01');  
			}else{ 
				
				if(count($ticketDetails) > 10){ 
				$this->promptError('ER:06:12');  
				}else{
							
				
					// $valid = $this->transaction->check_ticket_details($ticketDetails, $totalAmount,$accessCode);
					$valid = $this->transaction->check_ticket_details_2($ticketDetails, $totalAmount,$accessCode);
					

					// echo $valid;
					// Die();

					if($valid == 0){
						$this->promptError('ER:06:02'); 
					}else{ 
						if($valid == 2){
						$this->promptError('ER:06:14');  
						}else{
							$data['ticketDetails'] = $ticketDetails;
							//buy ticket
							$data['result'] = $this->transaction->buy_ticket($ticketDetails , $accessCode, $referrer, $profession );
							
							
							
							$result = $data['result'];
							$transaction_id = $result[1]; 
							$data['total_amount'] = $totalAmount; 
							
							$this->log_details("submit",$ticketDetails[0][0] ,$transaction_id, ($data['total_amount']/100), print_r($ticketDetails, true));
							$this->load->view("ticket_response_xml", $data);
						}
					}
				}
			}
	 
			 
		}
	
	}

	function payment_done3()
	{ 
  
		//order details
		$referenceNumber =  $this->input->post("referencenumber"); 
		$amount =  $this->input->post("amount"); 
		$paycode =  $this->input->post("paycode"); 
		$cardNumber =  $this->input->post("cardnumber"); 
		$expiration =  $this->input->post("expiration"); 
		$card_type =  $this->input->post("card_type"); 
		$others =  $this->input->post("others"); 
 		 
		 
			if(!$cardNumber){
			
				$cardNumber = 'xxxxxxxxxxxxxxxx';
			}
			// elseif(!$cardNumber){
			// $this->promptError('ER:06:09');
		// }
		 
		  
		 
				// $app_result = $this->transaction->verify_app_token($appCode, $liveToken);
				
				// if($app_result == 'expired'){ 
				// $this->promptError('ER:03:01');
				// }elseif($app_result == 'inactive'){ 
					// $this->promptError('ER:02:13');
				// }elseif($app_result == 'invalid'){ 
					// $this->promptError('ER:02:11'); 
				// }else{
				
				 
					$ref = explode("-", $referenceNumber);  
					if($ref[0] != 99){
						$this->promptError('ER:06:04'); 
					}else{
					 
						$transaction_id = $ref[1];	 
						$this->log_details("payment_done3","" ,$transaction_id, "","");
						// default value
						$pid = 0;
						$eid = 0;
						
						// identify tickets and the price_id/event_id just in case user opened events with new tab
						$selected_tickets = $this->tickets->get_selected_tickets($transaction_id);
						foreach ($selected_tickets as $ticket) {
							$pid = $ticket->ticket_price_id;
							$eid = $ticket->ticket_event_id;
						}

						// check if valid access
						if (($pid > 0) && ($eid > 0)) { 
							// transaction tickets has valid event_id and price_id info
						 

							// identify price id from tickets
							$data['price'] =  $this->prices->get($pid);
							
							// identify event id from tickets
							$data['event'] = $this->events->get($eid);
							
							// get total amount
							$ticket_count = count($selected_tickets); 
							// $total_amount = $ticket_count * $data['price']->price_price;
							
							//korewa
							// if ($selected_tickets[0]->ticket_type_discount_type == 'Amount'): 
							// $price = ceil($selected_tickets[0]->price_price - $selected_tickets[0]->ticket_type_discount);  
							// elseif ($selected_tickets[0]->ticket_type_discount_type == 'Percentage'): 
							// $price = ceil($selected_tickets[0]->price_price - (($selected_tickets[0]->price_price * $selected_tickets[0]->ticket_type_discount)/100)); 
							// endif; 
							
							
							// echo '<pre>';
							// print_r($selected_tickets);
							// echo '</pre>';
							// die();
							
							
							
							
							// $total_amount = $ticket_count * $price;
							
							
							$total_amount = 0;
							foreach($selected_tickets as $x){
							
							if ($x->ticket_type_discount_type == 'Amount'): 
							
								$price = ceil($x->price_price - $x->ticket_type_discount);  
								$total_amount = $total_amount + $price;
							elseif ($x->ticket_type_discount_type == 'Percentage'): 
							
								$price = ceil($x->price_price - (($x->price_price * $x->ticket_type_discount)/100)); 
								$total_amount = $total_amount + $price;
							endif; 
							 
							}
							
							
							
							
							$orig_amount_raw = $total_amount + ($data['event']->event_internet_sales_charge * $ticket_count);
							$orig_amount = number_format($orig_amount_raw, 2, '', '');
							if ($orig_amount != $amount)
							{
								//error message
								//Amount paid did not match the transaction amount
								echo $orig_amount . ' ' . $amount;
								$this->promptError('ER:06:06'); 
								
							}
							else
							{
								$payment_type = $this->payment_types->get_by_code($paycode);
								if(!$payment_type){
								//invalid paycode
								$this->promptError('ER:06:13');
								}else{ 
									$this->transaction->paid_online($transaction_id); // mark the transaction as paid_online
									$this->payments->add($transaction_id, $payment_type->payment_type_id, $orig_amount_raw); // add total payment
									// $card_num = $this->input->get("CardNum");
									$this->payments->add_cardnum($transaction_id,$cardNumber,$expiration, $card_type);
									
									$charge_amount = ($data['event']->event_internet_sales_charge * $ticket_count);
									if ($charge_amount > 0) {
										$this->payments->add_convenience_charge_details($transaction_id, $ticket_count, $charge_amount); // add convenience charge details
									}
									$this->payments->add_totalpay($transaction_id, $payment_type->payment_type_id, $orig_amount_raw, 'total'); // add total amount
									$data['payment_type'] = $payment_type->payment_type_code; // payment type
									
									// add receipt numbers
									$or_number = 0;
									$transaction = $this->transaction->get_for_bcode($transaction_id);
									if($transaction){ 
										// OR number
										$event_internet_sales_charge = $data['event']->event_internet_sales_charge;
										if (is_numeric($event_internet_sales_charge) && ($event_internet_sales_charge > 0))
										{
											$or_number = $this->branches->get_last_or_number($transaction->transaction_branch_id);
											$this->transaction->update_receipt_number($transaction_id, $or_number);
										}
										else 
										{
											$or_number = 0;
										}
										
															
										foreach ($selected_tickets as $ticket)
										{
											// AR number
											$ar_number = $this->branches->get_last_receipt_number($transaction->transaction_branch_id);
											$this->tickets->update_acknowledgment_receipt($ticket->ticket_id, $ar_number);
											
											
										}
										
									
										//check events_config if bcode is active
										$useBCODE = $this->bcode->isActive($eid);
							
										if ($useBCODE) {
											$d_or_number = sprintf("%06d", $or_number);
											$msg = "OR No: $d_or_number RefNum: $transaction_id Thank you for buying through SM Tickets Online.";
											
											$arrMobileNum = $this->mobilenum->lookup($transaction->customer_mobile);
											if ($arrMobileNum['isLocal']) {
												$carrier = $arrMobileNum['bCODE'];
												$localmobilenum = $arrMobileNum['CountryCode'].$arrMobileNum['MobileNum'];
											} 
											else {
												$localmobilenum = $arrMobileNum['MobileNum'];
											}
											// $sendSMS = $this->session->userdata('sendSMS');
											$sendSMS = '';
											
											if (empty($sendSMS)) {
												$carrier = '';
												$msg = '';
											}
											
											$querydata = array(
												'user' => $this->config->item('bcode_user'),
												'password' => $this->config->item('bcode_pass'),
												'application' => $this->config->item('bcode_app'),
												'mobile' => $localmobilenum,
												'carrier' => $carrier,
												'message' => $msg,
											);
											
											
								
											$xmlResult = $this->extension->__getbcode($querydata);
											if (is_array($xmlResult)) {
												if (isset($xmlResult['Result']) && ($xmlResult['Result'] == 0)) {
													$insertdata = array(
														'bcode_transaction_id' => $transaction_id,
														'bcode_value' => $xmlResult['bCODE'],
														'bcode_sendSMS' => $localmobilenum,
														'bcode_carrier' => $carrier,
													);
													$write = $this->load->database('live',true);
													$write->insert('bcode', $insertdata); 
												}
											}
										}
 
									
									}	
									// $postrequest = @$this->extension->post2mci($this->session->userdata('tid'));
									// $postrequest = @$this->extension->post2mci($transaction_id);
									// $this->session->unset_userdata('sendSMS');
									// redirect("transaction/payment_receipt/$transaction_id/$hash/$pid/$eid");
									
									// get data
									$data['charge_amount'] = $charge_amount; 
									$data['transaction_id'] = $transaction_id; 
									$data['or_receipt'] = $this->transaction->get_or($transaction_id); 
									$data['trans_date'] = date("Y-m-d H:i:s");
									$data['amount'] = $amount;
									$data['tickets'] = $this->tickets->get_paid_online_tickets($transaction_id);
									
									$this->tag_blink($transaction_id);
									$this->tag_as_used($transaction_id);
									
									$this->log_details("done",$eid ,$transaction_id, ($amount/100), print_r($data['tickets'], true));
									
									$this->load->view("result_xml", $data);
									//$this->customers->send_payment_notification($appCode,$liveToken,$accessCode,$dynaToken,$transaction_id);
								}
							}
							 
						} else {
							//Invalid transaction information.'
							$this->promptError('ER:06:07'); 
						}	
					}
				// }	
	}
	
	
 	function tag_as_used($refno){

		$result = false;
		$dbAccess = $this->load->database('default',true);
			
			$data = array(
			'qr_status' => "used",
			'qr_datetime' =>  date("Y-m-d H:i:s"),
			);

			$dbAccess->where('qr_status', 'pending');
			$dbAccess->where('qr_transaction_id', $refno);
			
			$dbAccess->update('qrcode', $data); 			
			$ticket_count = $dbAccess->affected_rows();
	

		header ("Content-Type:text/xml");
		// echo "<root>";
		// if($ticket_count > 0){
			// echo "<result>success</result>";
		// }else{
			// echo "<result>failed</result>";
		// }		
		// echo "</root>";
			
	}
	
	
	function tag_blink($ref = false){
		// $dbAccess = $this->load->database('pincode',true);
		// if($ref){
	
		// $sql = "update pin_codes p set p.pin_status = 'used', p.pin_refno =?
			// where p.pin_status = '0'
			// and p.pin_set = 'blink'
			// limit 1";  
		// $dbAccess->query($sql, array($ref));
		// }
	
	}
	
	function log_details($type = false,$event_id = false, $transID = false, $totalAmount = false, $description = false){
		// $now = date("Y-m-d H:i:s");
 		// $dbAccess = $this->load->database('pincode',true);
		// $sql = "INSERT INTO `logs` (`log_type`, `log_event_id`, `log_transaction_id`, `log_total_amount`, `log_description`, `log_datetime`) VALUES ('$type', '$event_id','$transID','$totalAmount', '$description', '$now' );";  
		// $dbAccess->query($sql);		
	} 

	function nt_purchaseTicketReserve(){
 
		$ticketDetails = array();

		$accessCode =  $this->input->get_post("accesscode"); 
		$totalAmount =  $this->input->post("totalamount"); 
		$referrer =  $this->input->post("referrer"); 
		$profession =  $this->input->post("profession"); 
		$transaction_id = $this->input->post("transaction_id"); 
	
		if(!$accessCode){
			$this->promptError('ER:01:06');
		}elseif(!$totalAmount){
			$this->promptError('ER:06:10');
		}else{
		
			// verify access credentials before processing order request
			// $result = $this->transaction->verify_access_token($accessCode, $dynaToken);
			
		 
			
			//get ticket parameters

			$dm = $this->input->post("datamessage");
			
			foreach($dm as $x){
				if(empty($x)) { }
				else {
					$ticketDetails[] = explode("|", $x);
				}
			}
			
			// echo '<pre>';
			// print_r($_POST);
			// echo '</pre>';
			// die();	
			
			
			if(empty($ticketDetails)){	 
			$this->promptError('ER:06:01');  
			}else{ 
				
				if(count($ticketDetails) > 99){ 
				$this->promptError('ER:06:12');  
				}else{
							
				
					$valid = $this->transaction->check_ticket_details_reserve($ticketDetails, $totalAmount,$accessCode);
					

					// echo $valid;
					// Die();

					if($valid == 0){
						$this->promptError('ER:06:02'); 
					}else{ 
						if($valid == 2){
						$this->promptError('ER:06:14');  
						}else{
							$data['ticketDetails'] = $ticketDetails;
							//buy ticket
							$data['result'] = $this->transaction->ticket_reserve_info($transaction_id, $ticketDetails , $accessCode, $referrer, $profession );
							
							// print_r($data['result']);
							// die();
							
							$result = $data['result'];
							$transaction_id = $result[1]; 
							$data['total_amount'] = $totalAmount; 
							
							$this->log_details("submit",$ticketDetails[0][0] ,$transaction_id, ($data['total_amount']/100), print_r($ticketDetails, true));
							$this->load->view("ticket_response_xml", $data);
						}
					}
				}
			}
	 
			 
		}
	
	}
	
		
	function payment_done3A()
	{ 
  
		//order details
		$referenceNumber =  $this->input->post("referencenumber"); 
		$amount =  $this->input->post("amount"); 
		$paycode =  $this->input->post("paycode"); 
		$cardNumber =  $this->input->post("cardnumber"); 
		$expiration =  $this->input->post("expiration"); 
		$card_type =  $this->input->post("card_type"); 
		$others =  $this->input->post("others"); 
 		 
		
		// echo '<pre>';
		// print_r($_POST);
		// echo '</pre>';
		// die();
		
		 
			if(!$cardNumber){
			
				$cardNumber = 'xxxxxxxxxxxxxxxx';
			}
			// elseif(!$cardNumber){
			// $this->promptError('ER:06:09');
		// }
		 
		  
		 
				// $app_result = $this->transaction->verify_app_token($appCode, $liveToken);
				
				// if($app_result == 'expired'){ 
				// $this->promptError('ER:03:01');
				// }elseif($app_result == 'inactive'){ 
					// $this->promptError('ER:02:13');
				// }elseif($app_result == 'invalid'){ 
					// $this->promptError('ER:02:11'); 
				// }else{
				
				 
					$ref = explode("-", $referenceNumber);  
					if($ref[0] != 99){
						$this->promptError('ER:06:04'); 
					}else{
					 
						$transaction_id = $ref[1];	 
						$this->log_details("payment_done3","" ,$transaction_id, "","");
						// default value
						$pid = 0;
						$eid = 0;
						
						//check if the ticket is reserved or selected
						$status = $this->transaction->get_ticket_status($transaction_id);
						
						
						if($status == 'reserved'){
							$selected_tickets = $this->tickets->get_reserved_tickets($transaction_id);
						}elseif($status == 'selected'){
							$selected_tickets = $this->tickets->get_selected_tickets($transaction_id);
						}else{
							die();
						}
						
						// identify tickets and the price_id/event_id just in case user opened events with new tab
						
						// echo '<pre>';
						// print_r($selected_tickets);
						// echo '</pre>';
						// die();
						foreach ($selected_tickets as $ticket) {
							$pid = $ticket->ticket_price_id;
							$eid = $ticket->ticket_event_id;
						}

						// check if valid access
						if (($pid > 0) && ($eid > 0)) { 
							// transaction tickets has valid event_id and price_id info
						 

							// identify price id from tickets
							$data['price'] =  $this->prices->get($pid);
							
							// identify event id from tickets
							$data['event'] = $this->events->get($eid);
							
							// get total amount
							$ticket_count = count($selected_tickets); 
							// $total_amount = $ticket_count * $data['price']->price_price;
							
							//korewa
							// if ($selected_tickets[0]->ticket_type_discount_type == 'Amount'): 
							// $price = ceil($selected_tickets[0]->price_price - $selected_tickets[0]->ticket_type_discount);  
							// elseif ($selected_tickets[0]->ticket_type_discount_type == 'Percentage'): 
							// $price = ceil($selected_tickets[0]->price_price - (($selected_tickets[0]->price_price * $selected_tickets[0]->ticket_type_discount)/100)); 
							// endif; 
							
							
							// echo '<pre>';
							// print_r($selected_tickets);
							// echo '</pre>';
							// die();
							
							
							
							
							// $total_amount = $ticket_count * $price;
							
							
							$total_amount = 0;
							foreach($selected_tickets as $x){
							
							if ($x->ticket_type_discount_type == 'Amount'): 
							
								$price = ceil($x->price_price - $x->ticket_type_discount);  
								$total_amount = $total_amount + $price;
							elseif ($x->ticket_type_discount_type == 'Percentage'): 
							
								$price = ceil($x->price_price - (($x->price_price * $x->ticket_type_discount)/100)); 
								$total_amount = $total_amount + $price;
							endif; 
							 
							}
							
							
							
							
							$orig_amount_raw = $total_amount + ($data['event']->event_internet_sales_charge * $ticket_count);
							$orig_amount = number_format($orig_amount_raw, 2, '', '');
							if ($orig_amount != $amount)
							{
								//error message
								//Amount paid did not match the transaction amount
								echo $orig_amount . ' ' . $amount;
								$this->promptError('ER:06:06'); 
								
							}
							else
							{
								$payment_type = $this->payment_types->get_by_code($paycode);
								if(!$payment_type){
								//invalid paycode
								$this->promptError('ER:06:13');
								}else{ 
									$this->transaction->paid_online2($transaction_id,$status); // mark the transaction as paid_online
									
									$barcode = strtoupper(hash("crc32", $transaction_id));
									
									$this->transaction->add_barcode($transaction_id,$barcode); //Add Barcode
									
									$this->payments->add($transaction_id, $payment_type->payment_type_id, $orig_amount_raw); // add total payment
									// $card_num = $this->input->get("CardNum");
									$this->payments->add_cardnum($transaction_id,$cardNumber,$expiration, $card_type);
									
									$charge_amount = ($data['event']->event_internet_sales_charge * $ticket_count);
									if ($charge_amount > 0) {
										$this->payments->add_convenience_charge_details($transaction_id, $ticket_count, $charge_amount); // add convenience charge details
									}
									$this->payments->add_totalpay($transaction_id, $payment_type->payment_type_id, $orig_amount_raw, 'total'); // add total amount
									$data['payment_type'] = $payment_type->payment_type_code; // payment type
									
									// add receipt numbers
									$or_number = 0;
									$transaction = $this->transaction->get_for_bcode($transaction_id);
									if($transaction){ 
										// OR number  &&  $transaction->customer_id != 82476
										$event_internet_sales_charge = $data['event']->event_internet_sales_charge;
										if (is_numeric($event_internet_sales_charge) && ($event_internet_sales_charge > 0))
										{
											$or_number = $this->branches->get_last_or_number($transaction->transaction_branch_id);
											$this->transaction->update_receipt_number($transaction_id, $or_number);
										}
										else 
										{
											$or_number = 0;
										}
										
															
										foreach ($selected_tickets as $ticket)
										{
											// AR number
											$ar_number = $this->branches->get_last_receipt_number($transaction->transaction_branch_id);
											$this->tickets->update_acknowledgment_receipt($ticket->ticket_id, $ar_number);
											
											
										}
										
									
										//check events_config if bcode is active
										$useBCODE = $this->bcode->isActive($eid);
							
										if ($useBCODE) {
											$d_or_number = sprintf("%06d", $or_number);
											$msg = "OR No: $d_or_number RefNum: $transaction_id Thank you for buying through SM Tickets Online.";
											
											$arrMobileNum = $this->mobilenum->lookup($transaction->customer_mobile);
											if ($arrMobileNum['isLocal']) {
												$carrier = $arrMobileNum['bCODE'];
												$localmobilenum = $arrMobileNum['CountryCode'].$arrMobileNum['MobileNum'];
											} 
											else {
												$localmobilenum = $arrMobileNum['MobileNum'];
											}
											// $sendSMS = $this->session->userdata('sendSMS');
											$sendSMS = '';
											
											if (empty($sendSMS)) {
												$carrier = '';
												$msg = '';
											}
											
											$querydata = array(
												'user' => $this->config->item('bcode_user'),
												'password' => $this->config->item('bcode_pass'),
												'application' => $this->config->item('bcode_app'),
												'mobile' => $localmobilenum,
												'carrier' => $carrier,
												'message' => $msg,
											);
											
											
								
											$xmlResult = $this->extension->__getbcode($querydata);
											if (is_array($xmlResult)) {
												if (isset($xmlResult['Result']) && ($xmlResult['Result'] == 0)) {
													$insertdata = array(
														'bcode_transaction_id' => $transaction_id,
														'bcode_value' => $xmlResult['bCODE'],
														'bcode_sendSMS' => $localmobilenum,
														'bcode_carrier' => $carrier,
													);
													$write = $this->load->database('live',true);
													$write->insert('bcode', $insertdata); 
												}
											}
										}
 
									
									}	
									// $postrequest = @$this->extension->post2mci($this->session->userdata('tid'));
									// $postrequest = @$this->extension->post2mci($transaction_id);
									// $this->session->unset_userdata('sendSMS');
									// redirect("transaction/payment_receipt/$transaction_id/$hash/$pid/$eid");
									
									// get data
									$data['charge_amount'] = $charge_amount; 
									$data['transaction_id'] = $transaction_id; 
									$data['or_receipt'] = $this->transaction->get_or($transaction_id); 
									$data['trans_date'] = date("Y-m-d H:i:s");
									$data['amount'] = $amount;
									$data['tickets'] = $this->tickets->get_paid_online_tickets($transaction_id);
									
									$this->tag_blink($transaction_id);
									$this->tag_as_used($transaction_id);

									
									//insert into historical table 
									// $this->admin->copy_tickets($transaction_id, 'paid_online');
									// $this->admin->copy_transactions($transaction_id,'paid_online');
									// $this->admin->copy_payments($transaction_id);
									// $this->admin->copy_charges($transaction_id);
								
									
									$this->add_to_historical($transaction_id);
									
									$this->log_details("done",$eid ,$transaction_id, ($amount/100), print_r($data['tickets'], true));
									
									$this->load->view("result_xml", $data);
									//$this->customers->send_payment_notification($appCode,$liveToken,$accessCode,$dynaToken,$transaction_id);
								}
							}
							 
						} else {
							//Invalid transaction information.'
							$this->promptError('ER:06:07'); 
						}	
					}
				// }	
	}
	
		
	function get($transaction_id)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->join('terminals te', 't.transaction_terminal_id = te.terminal_id');
		$this->db->join('branches b', 't.transaction_branch_id = b.branch_id');
		$this->db->join('users u', 't.transaction_user_id = u.user_id');
		$this->db->join('customers c', 't.transaction_customer_id = c.customer_id', 'left');
 		//$this->db->join($this->tickets, 't.transaction_id = ti.ticket_transaction_id', 'left');
		//$this->db->join($this->events, 'ti.ticket_event_id = e.event_id', 'left');
		// $this->db->where('transaction_id', $transaction_id);
		
		$query = $this->db->get_where('transactions t', array('transaction_id' => $transaction_id));
		
		// echo "<pre>";
		// print_r($query->row());
		// echo "</pre>";
		// die(); 
	
		$data['trans'] = $query->row();	
		
		$this->load->view('trans_xml', $data);
	}	 
	
	function get_eventid($transID){
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->select('ticket_event_id');
		$this->db->distinct('ticket_event_id');
		$this->db->where('ticket_transaction_id',$transID);
		$query = $this->db->get('tickets');
		
		echo $query->row()->ticket_event_id;
	}
	
	function test(){
		
		
		$dm = array('5587|335819|31660|1|2|2|C|3|2100|100','5587|335819|31660|1|2|1|C|2|2100|100','5587|335819|31660|1|2|6|C|7|2100|100','5587|335819|31660|1|2|7|C|8|2100|100');
			foreach($dm as $x){
				if(empty($x)) { }
				else {
					$ticketDetails[] = explode("|", $x);
				}
			}
		
		$totalAmount = 8800;
		
		$valid = $this->transaction->check_ticket_details_3($ticketDetails, $totalAmount);
		
		
		echo '<pre>';
		print_r($valid);
		echo '</pre>';
		die();
	}

	function get_ticket_count_customer($username,$event_id){
		
		$read = $this->load->database('default',true);
		$read->query('set transaction isolation level read uncommitted');
		$read->join('transactions t','t.transaction_id = ti.ticket_transaction_id','left');
		$read->join('customers c', 't.transaction_customer_id = c.customer_id', 'left');
		$read->where("ti.ticket_event_id",$event_id);
		$read->where("c.customer_username",$username);
		$read->where_in("ti.ticket_status",array('done','paid','paid_online','selected'));
		$query = $read->count_all_results('tickets ti');	
		
		echo $query;
	}
	
	function update_date_validity(){
		$transaction_id = $this->input->post('transaction_id');
		$transaction_date_validity = $this->input->post('transaction_date_validity');
		$write = $this->load->database('live',true);
		
		// update the transactions table
		$write->where('transaction_id', $transaction_id);
		$write->update('transactions', array('transaction_date_validity' => $transaction_date_validity));
		
		return true;
	}
	
	function clear_selected_seats2()
	{
			$read = $this->load->database('default',true);
			$write = $this->load->database('live',true);
			$read->query('set transaction isolation level read uncommitted');
			// $write->query('set transaction isolation level read uncommitted');
			$ticket_count = 0;
			$unselected_rows = 0;
			// expire time set to 60 minutes from 15 minutes. This is to ensure that no one is holding a rightfully locked seat.
			// expiry check time uses ticket_date_entered for expiry check.
			// $minutes = 60;
			 
			$minutes =  $this->config->item("selected_seat_expiry");
			$expire_time = date("Y-m-d H:i:s", strtotime(date("Y-m-d H:i:s"))-($minutes*60));
			$date = date('Y-m-d', strtotime($expire_time));
			$newdate = strtotime('-1 day' , strtotime($expire_time));
			$newdate = date ( 'Y-m-d H:i:s' , $newdate );
			
			
			$read->join($this->tickets->transactions, 'tr.transaction_id = ti.ticket_transaction_id', 'left');
			$read->where('tr.transaction_ipay_status !=', 'Successful payment');
			
			
			// get selected seats that are due for clearing
			$read->where('ti.ticket_date_entered <=', $expire_time);
			$read->where('ti.ticket_date_entered >=', $newdate);
			// from selected and paid status to selected only. This is to ensure that no one is holding a rightfully locked seat.
			// $this->db->where('ticket_transaction_id', '0');
			$read->where('ti.ticket_status', 'selected');
			$query = $read->get($this->tickets->tickets);
			$tickets = $query->result();

			echo "<pre>";
			print_r($tickets);
			echo "</pre>";
			die();

			$info = array();
			// use this as identifier there is an existing ekbarcode
			// $existing_used_ekbc = false;
			if (count($tickets) > 0)
			{
			// identify list of EK Events
			// $ek_events = $this->ekbarcode->listing_active_array();

			$info["expire"] = $expire_time;
			foreach ($tickets as $ticket)
			{
			// count tickets to identify if there is one that has ek_barcode
			/* if (isset($ek_events[$ticket->ticket_event_id])) {
			$ek_events[$ticket->ticket_event_id]++;
			} */

			//-------UNSELECT SEATS
			$write->where('ticket_id', $ticket->ticket_id);
			$write->update($this->tickets->tickets, array('ticket_status' => 'unselected'));
			$ticket_count = $write->affected_rows();

			//-------UPDATE AVAILABLE SEATS COUNT
			$this->tickets->update_available($ticket->ticket_section_id, 'increase', $ticket_count);	
			$info["tixid"][$ticket->ticket_transaction_id][] = $ticket->ticket_id;
			$unselected_rows++;
			}
			// $existing_used_ekbc = (array_sum($ek_events) > 0) ? true : $existing_used_ekbc ;

			// unselect the selected transactions with no associated tickets
				/* $t_selected = $this->transaction->get_transaction_selected_only();
				foreach($t_selected as $t) {
				$tid = $t->transaction_id;
				$read->where_in('ticket_status', array('selected','paid_online','done','paid'));
				$read->where_in('ticket_transaction_id', $tid);
				$query = $read->get($this->tickets->tickets);
				$tickets = $query->result();

				if (count($tickets) > 0) {
				// transaction ID still has selected tickets -- cannot unselect transaction
				}
				else {
				$this->transaction->unselect($tid);
				$info["tid_e"][] = $tid;
				}
				} */
			}
			/* if ($existing_used_ekbc) {
			$this->ekbarcode->free _stagnant_barcodes();
			} */
			echo "<root><result>$unselected_rows selected seats cleared</result></root>";
			//-------LOG
			/* if (!empty($info)) {
			$info["sysdate"] = date("Y-m-d H:i:s");
			$this->olog->add_arrayinfo_to_review($info);
			} */
	}
	
	function check_ticket_id($ticket_id){
		
		$ticket_ids = explode("-",$ticket_id);
		
		$read = $this->load->database('default',true);
		$read->query('set transaction isolation level read uncommitted');
		$read->select("ti.ticket_transaction_id");
		$read->where_in("ti.ticket_id",$ticket_ids);
		$read->group_by("ti.ticket_transaction_id");
		$query = $read->get('tickets ti');	
		
		if($query->num_rows() == '1'){
			if($query->row()->ticket_transaction_id == '0'){
				echo '0';
			}else{
				echo '1';
			}
		}else{
			echo '1';
		}
	}
	
	function check_privacy_agreement($customer_name)
	{
		$read = $this->load->database('default',true);
		$read->query('set transaction isolation level read uncommitted');
		$read->select("customer_privacy");
		$read->where("customer_username",$customer_name);
		$query = $read->get('customers');	
		
		if($query->num_rows() > 0){
			echo json_encode($query->row());
		}else{
			echo false;
		}
	}
	
	function insert_privacy_agreement($customer_name = false,$agree = FALSE)
	{
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->where('customer_username', $customer_name);
		$q = $this->db->get('customers');
		
		if($q->num_rows() > 0){
			
			if(!$agree){
				$agree = "0";
			}
			
			$fields = array(
				'customer_privacy'		=>		$agree
			);
			
			// if($agree){
				// $fields['privacy_agree'] = "0";
			// }
					
			$this->db->set($fields);
			$this->db->where("customer_username",$customer_name);
			$this->db->update('customers');
			$id = $this->db->affected_rows();
			
			if($id){
				echo true;
			}else{
				echo false;
			}
		}	
		
	}
	
	function add_to_historical($transaction_id = false){
		
		if(!$transaction_id) die('Unknown Error Encountered');
		
		//insert into historical table 
		$this->admin->copy_tickets($transaction_id, 'paid_online');
		$this->admin->copy_transactions($transaction_id,'paid_online');
		$this->admin->copy_payments($transaction_id);
		$this->admin->copy_charges($transaction_id);
		
		
	}
	
	
	//for YTF		
	function payment_done_claim()
	{ 
  
		//order details
		$referenceNumber =  $this->input->post("referencenumber"); 
		$amount =  $this->input->post("amount"); 
		$paycode =  $this->input->post("paycode"); 
		$cardNumber =  $this->input->post("cardnumber"); 
		$expiration =  $this->input->post("expiration"); 
		$card_type =  $this->input->post("card_type"); 
		$others =  $this->input->post("others"); 
 		 
		
		// echo '<pre>';
		// print_r($_POST);
		// echo '</pre>';
		// die();
		 
			if(!$cardNumber){
			
				$cardNumber = 'xxxxxxxxxxxxxxxx';
			}
			// elseif(!$cardNumber){
			// $this->promptError('ER:06:09');
		// }
		 
		  
		 
				// $app_result = $this->transaction->verify_app_token($appCode, $liveToken);
				
				// if($app_result == 'expired'){ 
				// $this->promptError('ER:03:01');
				// }elseif($app_result == 'inactive'){ 
					// $this->promptError('ER:02:13');
				// }elseif($app_result == 'invalid'){ 
					// $this->promptError('ER:02:11'); 
				// }else{
				
				 
					$ref = explode("-", $referenceNumber);  
					if($ref[0] != 99){
						$this->promptError('ER:06:04'); 
					}else{
					 
						$transaction_id = $ref[1];	 
						$this->log_details("payment_done3","" ,$transaction_id, "","");
						// default value
						$pid = 0;
						$eid = 0;
						
						//check if the ticket is reserved or selected
						$status = $this->transaction->get_ticket_status($transaction_id);
						
						
						if($status == 'reserved'){
							$selected_tickets = $this->tickets->get_reserved_tickets($transaction_id);
						}elseif($status == 'selected'){
							$selected_tickets = $this->tickets->get_selected_tickets($transaction_id);
						}else{
							die();
						}
						
						// identify tickets and the price_id/event_id just in case user opened events with new tab
						
						// echo '<pre>';
						// print_r($selected_tickets);
						// echo '</pre>';
						// die();
						foreach ($selected_tickets as $ticket) {
							$pid = $ticket->ticket_price_id;
							$eid = $ticket->ticket_event_id;
						}

						// check if valid access
						if (($pid > 0) && ($eid > 0)) { 
							// transaction tickets has valid event_id and price_id info
						 

							// identify price id from tickets
							$data['price'] =  $this->prices->get($pid);
							
							// identify event id from tickets
							$data['event'] = $this->events->get($eid);
							
							// get total amount
							$ticket_count = count($selected_tickets); 
							// $total_amount = $ticket_count * $data['price']->price_price;
							
							//korewa
							// if ($selected_tickets[0]->ticket_type_discount_type == 'Amount'): 
							// $price = ceil($selected_tickets[0]->price_price - $selected_tickets[0]->ticket_type_discount);  
							// elseif ($selected_tickets[0]->ticket_type_discount_type == 'Percentage'): 
							// $price = ceil($selected_tickets[0]->price_price - (($selected_tickets[0]->price_price * $selected_tickets[0]->ticket_type_discount)/100)); 
							// endif; 
							
							
							// echo '<pre>';
							// print_r($selected_tickets);
							// echo '</pre>';
							// die();
							
							
							
							
							// $total_amount = $ticket_count * $price;
							
							
							$total_amount = 0;
							foreach($selected_tickets as $x){
							
							if ($x->ticket_type_discount_type == 'Amount'): 
							
								$price = ceil($x->price_price - $x->ticket_type_discount);  
								$total_amount = $total_amount + $price;
							elseif ($x->ticket_type_discount_type == 'Percentage'): 
							
								$price = ceil($x->price_price - (($x->price_price * $x->ticket_type_discount)/100)); 
								$total_amount = $total_amount + $price;
							endif; 
							 
							}
							
							
							
							
							$orig_amount_raw = $total_amount + ($data['event']->event_internet_sales_charge * $ticket_count);
							$orig_amount = number_format($orig_amount_raw, 2, '', '');
							if ($orig_amount != $amount)
							{
								//error message
								//Amount paid did not match the transaction amount
								echo $orig_amount . ' ' . $amount;
								$this->promptError('ER:06:06'); 
								
							}
							else
							{
								$payment_type = $this->payment_types->get_by_code($paycode);
								if(!$payment_type){
								//invalid paycode
								$this->promptError('ER:06:13');
								}else{ 
									$this->transaction->paid_online2($transaction_id,$status); // mark the transaction as paid_online
									
									$barcode = strtoupper(hash("crc32", $transaction_id));
									
									$this->transaction->add_barcode($transaction_id,$barcode); //Add Barcode
									
									$this->payments->add($transaction_id, $payment_type->payment_type_id, $orig_amount_raw); // add total payment
									// $card_num = $this->input->get("CardNum");
									$this->payments->add_cardnum($transaction_id,$cardNumber,$expiration, $card_type);
									
									$charge_amount = ($data['event']->event_internet_sales_charge * $ticket_count);
									if ($charge_amount > 0) {
										$this->payments->add_convenience_charge_details($transaction_id, $ticket_count, $charge_amount); // add convenience charge details
									}
									$this->payments->add_totalpay($transaction_id, $payment_type->payment_type_id, $orig_amount_raw, 'total'); // add total amount
									$data['payment_type'] = $payment_type->payment_type_code; // payment type
									
									// add receipt numbers
									$or_number = 0;
									$transaction = $this->transaction->get_for_bcode($transaction_id);
									if($transaction){ 
										// OR number  &&  $transaction->customer_id != 82476
										$event_internet_sales_charge = $data['event']->event_internet_sales_charge;
										// if (is_numeric($event_internet_sales_charge) && ($event_internet_sales_charge > 0))
										// {
											// $or_number = $this->branches->get_last_or_number($transaction->transaction_branch_id);
											$this->transaction->update_receipt_number($transaction_id, $or_number);
										// }
										// else 
										// {
											// $or_number = 0;
										// }
										
															
										foreach ($selected_tickets as $ticket)
										{
											// AR number
											$ar_number = $this->branches->get_last_receipt_number($transaction->transaction_branch_id);
											// $this->tickets->update_acknowledgment_receipt($ticket->ticket_id, $ar_number);
											
											
										}
										
									
										//check events_config if bcode is active
										$useBCODE = $this->bcode->isActive($eid);
							
										if ($useBCODE) {
											$d_or_number = sprintf("%06d", $or_number);
											$msg = "OR No: $d_or_number RefNum: $transaction_id Thank you for buying through SM Tickets Online.";
											
											$arrMobileNum = $this->mobilenum->lookup($transaction->customer_mobile);
											if ($arrMobileNum['isLocal']) {
												$carrier = $arrMobileNum['bCODE'];
												$localmobilenum = $arrMobileNum['CountryCode'].$arrMobileNum['MobileNum'];
											} 
											else {
												$localmobilenum = $arrMobileNum['MobileNum'];
											}
											// $sendSMS = $this->session->userdata('sendSMS');
											$sendSMS = '';
											
											if (empty($sendSMS)) {
												$carrier = '';
												$msg = '';
											}
											
											$querydata = array(
												'user' => $this->config->item('bcode_user'),
												'password' => $this->config->item('bcode_pass'),
												'application' => $this->config->item('bcode_app'),
												'mobile' => $localmobilenum,
												'carrier' => $carrier,
												'message' => $msg,
											);
											
											
								
											$xmlResult = $this->extension->__getbcode($querydata);
											if (is_array($xmlResult)) {
												if (isset($xmlResult['Result']) && ($xmlResult['Result'] == 0)) {
													$insertdata = array(
														'bcode_transaction_id' => $transaction_id,
														'bcode_value' => $xmlResult['bCODE'],
														'bcode_sendSMS' => $localmobilenum,
														'bcode_carrier' => $carrier,
													);
													$write = $this->load->database('live',true);
													$write->insert('bcode', $insertdata); 
												}
											}
										}
 
									
									}	
									// $postrequest = @$this->extension->post2mci($this->session->userdata('tid'));
									// $postrequest = @$this->extension->post2mci($transaction_id);
									// $this->session->unset_userdata('sendSMS');
									// redirect("transaction/payment_receipt/$transaction_id/$hash/$pid/$eid");
									
									// get data
									$data['charge_amount'] = $charge_amount; 
									$data['transaction_id'] = $transaction_id; 
									$data['or_receipt'] = $this->transaction->get_or($transaction_id); 
									$data['trans_date'] = date("Y-m-d H:i:s");
									$data['amount'] = $amount;
									$data['tickets'] = $this->tickets->get_paid_online_tickets($transaction_id);
									
									$this->tag_ytff($transaction_id, $transaction->customer_id ,$eid);
									$this->tag_blink($transaction_id);
									$this->tag_as_used($transaction_id);
									
									$this->log_details("done",$eid ,$transaction_id, ($amount/100), print_r($data['tickets'], true));
									
									$this->load->view("result_xml", $data);
									//$this->customers->send_payment_notification($appCode,$liveToken,$accessCode,$dynaToken,$transaction_id);
								}
							}
							 
						} else {
							//Invalid transaction information.'
							$this->promptError('ER:06:07'); 
						}	
					}
				// }	
	}
	 
	function tag_ytff($ref = false , $customer_id = false, $eid = false){
		$dbAccess = $this->load->database('live',true);
		if($ref){ 
			$sql = "INSERT INTO transaction_restrictions(transaction_rst_trans_id, transaction_rst_customer_id , transaction_rst_event_id) VALUES (?,?,?)";  
			$dbAccess->query($sql, array($ref ,$customer_id,$eid));
		}
	
	}
	
	function check_trans_restriction(){
		
		$customer_id =  $this->input->post("customer_id"); 
		$event_id =  $this->input->post("event_id"); 
		
		// $customer_id = 6;
		// $event_id = 4521;
		$dbAccess = $this->load->database('live',true);
		$this->db->select('transaction_id');
		$dbAccess->join('transactions', 'transaction_rst_trans_id = transaction_id', 'inner');
		$dbAccess->where('transaction_rst_customer_id',$customer_id);
		$dbAccess->where('transaction_rst_event_id',$event_id);
		$dbAccess->where_in('transaction_status',array('done','paid','paid_online','expired'));
		$query =$dbAccess->get('transaction_restrictions');
		 
			
		if($query->num_rows()> 0){
			
			echo 1;
		}else{
			
			echo 0;
			
		}
			
		 
		
	
		}
	
	
	function update_availability($event_id = false)
	{
		
		//restrict update on ytff 
		if($event_id == 7853) return false;
			
		
		// get event
		$event = $this->events->get($event_id);
		
		
		// get prices
		$prices = $this->prices->get_prices_compact($event_id);
		$sec_type_price = array();
		foreach($prices as $price):
			$this->sections->update_ticket_availability_sections($price->price_sections, $event->event_seatplan_id, true); 
			 
		endforeach;

		 
	}
	
	function clear_selected_seats_ytff()
	{
			$read = $this->load->database('default',true);
			$write = $this->load->database('live',true);
			$read->query('set transaction isolation level read uncommitted');
			// $write->query('set transaction isolation level read uncommitted');
			$ticket_count = 0;
			$unselected_rows = 0;
			// expire time set to 60 minutes from 15 minutes. This is to ensure that no one is holding a rightfully locked seat.
			// expiry check time uses ticket_date_entered for expiry check.
			// $minutes = 60;
			
			$minutes =  10;
			$expire_time = date("Y-m-d H:i:s", strtotime(date("Y-m-d H:i:s"))-($minutes*60));
			$date = date('Y-m-d', strtotime($expire_time));
			$newdate = strtotime('-1 day' , strtotime($expire_time));
			$newdate = date ( 'Y-m-d H:i:s' , $newdate );
			
			
			$read->join($this->tickets->transactions, 'tr.transaction_id = ti.ticket_transaction_id', 'left');
			$read->where('tr.transaction_ipay_status !=', 'Successful payment');
			
			
			// get selected seats that are due for clearing
			$read->where('ti.ticket_date_entered <=', $expire_time);
			$read->where('ti.ticket_date_entered >=', $newdate);
			// from selected and paid status to selected only. This is to ensure that no one is holding a rightfully locked seat.
			// $this->db->where('ticket_transaction_id', '0');
			$read->where('ti.ticket_status', 'selected');
			$read->where('ti.ticket_event_id', 7788);
			$query = $read->get($this->tickets->tickets);
			$tickets = $query->result();


			$info = array();
			// use this as identifier there is an existing ekbarcode
			// $existing_used_ekbc = false;
			if (count($tickets) > 0)
			{
			// identify list of EK Events
			// $ek_events = $this->ekbarcode->listing_active_array();

			$info["expire"] = $expire_time;
			foreach ($tickets as $ticket)
			{
			// count tickets to identify if there is one that has ek_barcode
			/* if (isset($ek_events[$ticket->ticket_event_id])) {
			$ek_events[$ticket->ticket_event_id]++;
			} */

			//-------UNSELECT SEATS
			$write->where('ti.ticket_id', $ticket->ticket_id);
			$write->where('ti.ticket_status', 'selected');
			$write->update($this->tickets->tickets, array('ticket_status' => 'unselected'));
			$ticket_count = $write->affected_rows();

			//-------UPDATE AVAILABLE SEATS COUNT
			$this->tickets->update_available($ticket->ticket_section_id, 'increase', $ticket_count);	
			$info["tixid"][$ticket->ticket_transaction_id][] = $ticket->ticket_id;
			$unselected_rows++;
			}
			// $existing_used_ekbc = (array_sum($ek_events) > 0) ? true : $existing_used_ekbc ;

			// unselect the selected transactions with no associated tickets
				/* $t_selected = $this->transaction->get_transaction_selected_only();
				foreach($t_selected as $t) {
				$tid = $t->transaction_id;
				$read->where_in('ticket_status', array('selected','paid_online','done','paid'));
				$read->where_in('ticket_transaction_id', $tid);
				$query = $read->get($this->tickets->tickets);
				$tickets = $query->result();

				if (count($tickets) > 0) {
				// transaction ID still has selected tickets -- cannot unselect transaction
				}
				else {
				$this->transaction->unselect($tid);
				$info["tid_e"][] = $tid;
				}
				} */
			}
			/* if ($existing_used_ekbc) {
			$this->ekbarcode->free _stagnant_barcodes();
			} */
			echo "<root><result>$unselected_rows selected seats cleared</result></root>";
			//-------LOG
			/* if (!empty($info)) {
			$info["sysdate"] = date("Y-m-d H:i:s");
			$this->olog->add_arrayinfo_to_review($info);
			} */
		}


	
}