<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
include('accesstemplate.php');

// class Generic extends CI_Controller {
class Trans extends CI_Controller {

	public function __construct(){
		parent::__construct();
		$this->load->model('seatplans_model', 'seatplans');
		$this->load->model('sections_model', 'sections');
		$this->load->model('transaction_model', 'transaction');
		$this->load->model('events_model', 'events');
		$this->load->model('prices_model', 'prices');
		$this->load->model('tickets_model', 'tickets');
		$this->load->model('ticket_types_model', 'ticket_types');
		$this->load->database('default',true);
	}
	
	function get($transaction_id)
	{
		$this->db->join('terminals te', 't.transaction_terminal_id = te.terminal_id');
		$this->db->join('branches b', 't.transaction_branch_id = b.branch_id');
		$this->db->join('users u', 't.transaction_user_id = u.user_id');
		$this->db->join('customers c', 't.transaction_customer_id = c.customer_id', 'left');
 		//$this->db->join($this->tickets, 't.transaction_id = ti.ticket_transaction_id', 'left');
		//$this->db->join($this->events, 'ti.ticket_event_id = e.event_id', 'left');
		// $this->db->where('transaction_id', $transaction_id);
		
		$query = $this->db->get_where('transactions t', array('transaction_id' => $transaction_id));
		
		// echo "<pre>";
		// print_r($query->row());
		// echo "</pre>";
		// die(); 
	
		$data['trans'] = $query->row();	
		
		$this->load->view('trans_xml', $data);
	}
}


?>