<?php 
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
include('accesstemplate.php');


class Trans_api extends AccessTemplate {
	
	public function __construct(){
		parent::__construct();
		$this->load->database('default',true); 
		$this->load->model('trans_api_model', 'transaction');
	}
	
	
	
	//=============== Transactional  F u n c t i o n s ===============
	function login(){ 
		
		//get required parameters
		$username = $this->input->get_post("username");
		$password = $this->input->get_post("password");
		$partyCode = $this->input->get_post("partycode");
		
		$key = $this->input->get_post("key");
		$fixedPass = $this->config->item("passkey");
		
		$email = $this->input->get_post("email");
		
		$ip = $this->input->ip_address();
		
			if(!$username){
				$this->promptError('ER:01:07');		
			}elseif(!$password){
				$this->promptError('ER:01:05');
			}elseif(!$partyCode){
				$this->promptError('ER:01:01');
			}elseif(!$key || $key == $fixedPass){
		
			//verify credentials and issue accesscode
			$data['result'] = $this->transaction->verify($username, $password, $partyCode,$ip,$key,$email);
			
			if($data['result'] == 'Invalid'){
				$this->promptError('ER:02:10');
			}elseif($data['result'] == 'invalid_ip'){
				$this->promptError('ER:00:01');
			}
			else{
				$this->log_details("login","","", "", "user: $username | pass: $password");
				$this->load->view("access_code_xml", $data);
				}
		}else{
		$this->promptError('ER:00:00');
		}
	}
	
	
	
}
/* End of file generic_mod.php */
/* Location: ./application/controllers/generic_mod.php */