<?php 

if ( ! defined('BASEPATH')) exit('No direct script access allowed');
include('accesstemplate.php');

// class Generic extends CI_Controller {
class Thirdparty extends AccessTemplate {
	
	public function __construct(){
		parent::__construct();
		$this->load->model('api_seatplans_model', 'seatplans');
		$this->load->model('api_events_model', 'events');
		$this->load->model('api_sections_model', 'sections');
		$this->load->model('api_transaction_model', 'transaction');
		$this->load->model('api_events_model', 'events');
		$this->load->model('api_prices_model', 'prices');
		$this->load->model('api_tickets_model', 'tickets');
		$this->load->model('api_payments_model', 'payments');
		$this->load->model('api_ticket_types_model', 'ticket_types');
		$this->load->model('api_ip_model', 'ip');
		$this->load->model('api_ticket_layouts_model', 'ticket_layouts');
		$this->load->model('api_bcode_model', 'bcode');
		$this->load->model('api_promo_codes_model', 'promo');
		$this->load->model('api_authentication_model', 'authentication');
		$this->load->database('default',true); 
	}
	
	function template() {
			
		// the date today
		$today = date("Y-m-d");
		$today = '2013-02-11';
		
		
		
		$dbAccess->select("
				evt.event_code
				, evt.event_title
				, evt.event_long_title
				, evt.event_date_time
			");
			
		$dbAccess->where("evt.event_date_time > '$today 00:00:00'");
		$dbAccess->where("evt.event_date_time < '$today 23:59:59'");
		$dbAccess->where("evt.event_active", 1);
		$query = $dbAccess->get('events evt');
	
	
		$this->load->dbutil();
		
		$config = array (
			  'root'    => 'root',
			  'element' => 'sections', 
			  'newline' => "\n", 
			  'tab'    => "\t"
			);

			
		$xmloutput = $this->dbutil->xml_from_result($query, $config);
		echo $xmloutput;

	}
	

	var $errorMessage = array (
		'ER:00' => 'Incomplete/Invalid Parameters.',
		'ER:01' => 'Invalid access.',
		'ER:02' => 'Inactive KEY',
		'ER:04' => 'In',
		'ER:05' => 'Relay problem and error encountered while storing data. Please contact MGI.',
		'ER:06' => 'Relay problem and error encountered while storing data. Please contact MGI.',
		);
			
	/* nt_FeaturedEvents() */
	function nt_FeaturedEvents(){
		
		$dbAccess = $this->load->database('market',true);
		$dbAccess->select('event_listing_name,event_ids');
		$dbAccess->where('event_listing_id',3);
		$q = $dbAccess->get('events_listing');
		$r = $q->row();
		
		$featured = explode(",", $r->event_ids);
		
		$dbAccess->select('	e.event_id
							,e.event_active
							,e.event_title
							,e.event_long_title
							,e.event_image
							,e.event_image_1
							,e.event_date_time
							,e.event_announcement_date
							,e.event_tags
							,e.event_category
							,e.event_type
							,e.event_parent
							,e.date_modified as event_date_modified
							,v.venue_id,
							,v.venue_name,
						');
		
		$dbAccess->where("e.event_active",'1');
		$dbAccess->where("e.event_date_time >= now()");
		$dbAccess->join('venues v', 'v.venue_id = e.event_venue_id', 'left' );
		$dbAccess->where_in("e.event_id", $featured);
		$query = $dbAccess->get('events e');
		$data['events'] = $query->result();
		
		$this->load->view('events_listing_xml', $data);
		
	}
	
	/* nt_EventCategory() for music, sports, family */
	function nt_EventCategory($event_category){
		
		$dbAccess = $this->load->database('market',true);
		
		$dbAccess->select('	e.event_id
							,e.event_active
							,e.event_title
							,e.event_long_title
							,e.event_image
							,e.event_image_1
							,e.event_date_time
							,e.event_announcement_date
							,e.event_tags
							,e.event_category
							,e.event_type
							,e.event_parent
							,e.date_modified as event_date_modified
							,v.venue_id,
							,v.venue_name,
						');
		
		$dbAccess->where("e.event_active",'1');
		$dbAccess->where("e.event_date_time >= now()");
		$dbAccess->join('venues v', 'v.venue_id = e.event_venue_id', 'left' );
		$dbAccess->or_like('e.event_category',$event_category);
		$query = $dbAccess->get('events e');
		$data['events'] = $query->result();
		
		$this->load->view('events_listing_xml', $data);
		
	}
	
	/* nt_MOAArenaEvents() */
	function nt_MOAArenaEvents(){
		
		$dbAccess = $this->load->database('market',true);
		
		$dbAccess->select('	e.event_id
							,e.event_active
							,e.event_title
							,e.event_long_title
							,e.event_image
							,e.event_image_1
							,e.event_date_time
							,e.event_announcement_date
							,e.event_tags
							,e.event_category
							,e.event_type
							,e.event_parent
							,e.date_modified as event_date_modified
							,v.venue_id,
							,v.venue_name,
						');
		
		$dbAccess->where("e.event_active",'1');
		$dbAccess->where("e.event_date_time >= now()");
		$dbAccess->join('venues v', 'v.venue_id = e.event_venue_id', 'left' );
		$dbAccess->where('e.event_venue_id',115);
		$query = $dbAccess->get('events e');
		$data['events'] = $query->result();
		
		$this->load->view('events_listing_xml', $data);
		
	}
	
	/* nt_EventsVenue() */
	function nt_EventsVenue($venue_id){
		
		$dbAccess = $this->load->database('market',true);
		
		$dbAccess->select('	e.event_id
							,e.event_active
							,e.event_title
							,e.event_long_title
							,e.event_image
							,e.event_image_1
							,e.event_date_time
							,e.event_announcement_date
							,e.event_tags
							,e.event_category
							,e.event_type
							,e.event_parent
							,e.date_modified as event_date_modified
							,v.venue_id,
							,v.venue_name,
						');
		
		$dbAccess->where("e.event_active",'1');
		$dbAccess->where("e.event_date_time >= now()");
		$dbAccess->join('venues v', 'v.venue_id = e.event_venue_id', 'left' );
		$dbAccess->where('e.event_venue_id',$venue_id);
		$query = $dbAccess->get('events e');
		$data['events'] = $query->result();
		
		$this->load->view('events_listing_xml', $data);
		
	}
	
	function nt_getVenueCountByEvent($limit=false){
		// die('test');
		// $limit = 6;
		$dbAccess = $this->load->database('market',true);

		$dbAccess->select('v.venue_name,
						v.venue_id,
						count(e.event_venue_id) as event_count');
			

		$dbAccess->where("e.event_active",1);
		$dbAccess->where("e.event_date_time >= now()");
		$dbAccess->join('events_config ec', 'ec.events_config_eventid = e.event_id', 'left' );
		$dbAccess->join('venues v', 'v.venue_id = e.event_venue_id', 'left' );
		if($limit)
		$dbAccess->limit($limit);
		$dbAccess->order_by('count(e.event_venue_id)', 'DESC');
		$dbAccess->group_by('e.event_venue_id');
		$query = $dbAccess->get('events e');

		// echo $dbAccess->last_query();
		 // die();
		
		$this->load->dbutil(); 
		$config = array (
						  'root'    => 'root',
						  'element' => 'element', 
						  'newline' => "\n", 
						  'tab'    => "\t"
						);

						
		echo $this->dbutil->xml_from_result($query, $config);
			 
	}
			
		
}
/* End of file thirdparty.php */
/* Location: ./application/controllers/thirdparty.php */