<?php 
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
include('accesstemplate.php');


class Transactions_pro extends AccessTemplate {
 
	public function __construct(){
		parent::__construct();
		$this->load->model('api_prices_model', 'prices');
		$this->load->model('api_sections_model', 'sections');
		$this->load->database('default',true); 
			
	
	}
	 
	 
	function get(){
		
		$transaction_id = $this->input->post('transaction_id'); 
		if(!$transaction_id){
			$this->promptError('ER:06:15'); 
		}else{
				
			$result = $this->get_trans_info($transaction_id);
			// for proper display of XML output on browser
			$this->load->helper('file');
			$this->output->set_header('Content-type: '.get_mime_by_extension('test.xml'));
			echo '<?xml version="1.0"?>';
			echo PHP_EOL;
			// echo $read->last_query();
			$this->load->dbutil();
			$config = array (
			  'root'    => 'root',
			  'element' => 'row', 
			  'newline' => "\n", 
			  'tab'    => "\t"
			);
			
			if($result->row()->transaction_id == ''){
				
			 echo "<root></root>";
			}else{
				
			echo $this->dbutil->xml_from_result($result, $config);
			}
			
		}
	}
	 
	function voucher(){
		
		$transaction_id = $this->input->post('transaction_id'); 
		$refund_date = $this->input->post('refund_date'); 
		
		// $transaction_id = 2699; 
		// $transaction_id = 2700; 
		// $refund_date = '2020-10-27'; 
		
		 	
		if(!$transaction_id){
			$this->promptError('ER:06:15'); 
		}else if(!$refund_date){
			$this->promptError('ER:05:28'); 
		}else{
			$q =  $this->get_branch($transaction_id); 
			if($q->num_rows() < 1){
				echo 'Invalid Transaction Information';
				die();
			} 
			 
			$branch_id = $this->branch_mapping($q->row()->branch_id);
			$read = $this->load->database('default',true); 
			$read->query('set transaction isolation level read uncommitted');  
			$read->select('count(1) as count');
			$read->where('queue_refund_transaction_id',$transaction_id);
			// $read->where('queue_refund_date',$refund_date);
			$result = $read->get('queue_refund')->row()->count;
			if($result < 1){ 
			
 				$rdate=date('Y-m-d', strtotime($refund_date));
 				$day_of_week=date('N', strtotime($refund_date));
				// $rstart = date('Y-m-d', strtotime("2020-07-06"));
				$rstart = date('Y-m-d', strtotime(' +9 days')); 
				$rend = date('Y-m-d', strtotime("2021-01-31")); 
				$invalid_dates = array('2020-12-04','2020-12-05','2020-12-06');
 			 
				
				if (($rdate >= $rstart) && ($rdate <= $rend) && !in_array($refund_date, $invalid_dates) && ($day_of_week == 7 || $day_of_week == 5 || $day_of_week == 6)){
					$this->generate_queue_no($transaction_id, $refund_date, $branch_id); 
				}else{
					
					echo 'Invalid Date provied'; 
					die();
				}
				 
			}
			
			$result =  $this->get_trans_info($transaction_id); 
			$data['result'] = $result; 
			if($result->num_rows() < 1){
				$this->promptError('ER:06:07'); 
			}else{
				$this->load->view('refund_voucher_pro',$data);
			}
			 
			 
		}
		
		
		
	}
	
	function generate_voucher($transaction_id = false){
		
		// $transaction_id = $this->input->post('transaction_id'); 
		// $refund_date = $this->input->post('refund_date'); 
		
		// $transaction_id = 2942867; 
		// $refund_date = '2020-10-27'; 
		
		
		
		if(!isset($transaction_id)){
			$this->promptError('ER:06:15'); 
		}else{
			
			$read = $this->load->database('default',true); 
			$read->query('set transaction isolation level read uncommitted');  
			$read->select('count(1) as count');
			$read->where('queue_refund_transaction_id',$transaction_id);
			// $read->where('queue_refund_date',$refund_date);
			$result = $read->get('queue_refund')->row()->count;
			if($result < 1){
				$this->promptError('ER:06:07'); 
				// die();
				
			}else{
			
				$result =  $this->get_trans_info($transaction_id); 
				$data['result'] = $result;
				// echo $result->num_rows();
				// die();
				if($result->num_rows() < 1){
					$this->promptError('ER:06:07'); 
				}else{
					$this->load->view('refund_voucher',$data);
				}
			
			}
		}
		
	}
	
	
	function get_trans_info($transaction_id){
			//8322,
		$write = $this->load->database('live',true); 
		$write->query('set transaction isolation level read uncommitted');  
		$sql = "SELECT 
			a.transaction_id, a.customer_firstname, a.customer_lastname, a.event_title,a.section, a.refund_date,a.queue_refund_number,
			SUM(a.cash_amount) AS cash_amount, SUM(card_amount) AS card_amount, a.ticket_count, a.event_id, a.branch_name from
			(SELECT 
						 `transaction_id`, `customer_firstname`, `customer_lastname`, `event_title`, `price_name` AS section, `queue_refund_date` AS refund_date, `queue_refund_number`,
						  CASE WHEN pa.payment_payment_type_id = 1 THEN pa.payment_amount - transaction_cash_change - pa.payment_amount_voided ELSE 0 END AS cash_amount, 
						  CASE WHEN pa.payment_payment_type_id != 1 THEN pa.payment_amount - pa.payment_amount_voided ELSE 0 END AS card_amount,event_id, branch_name, COUNT(DISTINCT t.ticket_id) AS ticket_count
			FROM (`tickets` t)
			LEFT JOIN `events` e ON `e`.`event_id` = `t`.`ticket_event_id`
			LEFT JOIN `transactions` tr ON `tr`.`transaction_id` = `t`.`ticket_transaction_id`
			LEFT JOIN `prices` p ON `p`.`price_id` = `t`.`ticket_price_id`
			LEFT JOIN `customers` c ON `c`.`customer_id` = `tr`.`transaction_customer_id`
			LEFT JOIN `queue_refund` q ON `q`.`queue_refund_transaction_id` = `tr`.`transaction_id`
			INNER JOIN payments pa ON pa.payment_transaction_id = tr.transaction_id
			LEFT JOIN `branches` b ON `b`.`branch_id` = `q`.`queue_refund_branch_id`
			WHERE `transaction_status` = 'done' AND `ticket_transaction_id` = ? AND ticket_branch_id IN (7,8,10,11,13,15,16,17,18,19,20,23,28,29,30,32,35,36,39,40,91,92,104,108,121,125,130,133,135,137,138,139,140,143,146,147,153,154,155,156,157,158,159,161,162,163,164,165,166,167,170,171,172,173,175,176,180,184,185,188,189,190,192,193,195,196,197,198,199,202,203) AND ticket_event_id IN (8980,8981,9014,9015,8892,8884,8781,8948,8758,8778,9007,9010,8717,8875,8874,8949,8987,8988,8776,8877,8382,8708,8777,8819,8782,8768,8769,8756,8824,8946,8983,8943,8992,8945,8926,8829,8927)
			GROUP BY pa.payment_id
			LIMIT 100) AS a";
			
 		return $write->query($sql, [$transaction_id]);
 	}
	 
	function get_trans_info2($transaction_id){
		 
			$write = $this->load->database('live',true); 
		$write->query('set transaction isolation level read uncommitted');  
		$sql = "SELECT 
			 a.`transaction_id`, a.`customer_firstname`, a.`customer_lastname`, a.`event_title`, a.section, a.refund_date, 
			 a.ticket_count, a.`queue_refund_number`, a.cash_amount, SUM(pt.payment_amount - pt.payment_amount_voided) as card_amount, a.event_id, a.branch_name
			FROM(
			SELECT 
			 `transaction_id`, `customer_firstname`, `customer_lastname`, `event_title`, `price_name` AS section, `queue_refund_date` AS refund_date, COUNT(1) AS ticket_count, `queue_refund_number`, tr.transaction_cash_change,pa.payment_amount - transaction_cash_change - pa.payment_amount_voided as cash_amount,event_id,branch_name
			FROM (`tickets` t)
			LEFT JOIN `events` e ON `e`.`event_id` = `t`.`ticket_event_id`
			LEFT JOIN `transactions` tr ON `tr`.`transaction_id` = `t`.`ticket_transaction_id`
			LEFT JOIN `prices` p ON `p`.`price_id` = `t`.`ticket_price_id`
			LEFT JOIN `customers` c ON `c`.`customer_id` = `tr`.`transaction_customer_id`
			LEFT JOIN `queue_refund` q ON `q`.`queue_refund_transaction_id` = `tr`.`transaction_id`
			INNER JOIN payments pa ON pa.payment_transaction_id = tr.transaction_id 
			LEFT JOIN `branches` b ON `b`.`branch_id` = `q`.`queue_refund_branch_id`
			WHERE `transaction_status` = 'done'  AND `ticket_transaction_id` = ? GROUP BY `transaction_id` LIMIT 100
			) AS a
			LEFT JOIN payments pt ON pt.payment_transaction_id = a.transaction_id  
			GROUP BY pt.payment_transaction_id";
		return $write->query($sql, [$transaction_id]);
 	}
	 
	function generate_queue_no($transaction_id= false,$refund_date =false,$branch_id =false){
		
		 $last_queue_no = 0;
		$read = $this->load->database('default',true); 
		$write = $this->load->database('live',true); 
		$read->query('set transaction isolation level read uncommitted');  
		$read->select('queue_refund_number');
		$read->where('queue_refund_date',$refund_date);
		$read->where('queue_refund_branch_id',$branch_id);
		$read->order_by('queue_refund_number','desc');
		$read->limit(1);
		$result = $read->get('queue_refund');
		 
		if($result->num_rows() > 0){
			$last_queue_no = $result->row()->queue_refund_number; 
		}
		
		if($last_queue_no >= 20){
			echo 1;
			die();
		}else{
			$fields = array(
				'queue_refund_number'		=> $last_queue_no + 1,
				'queue_refund_transaction_id'	=> $transaction_id,
				'queue_refund_date'			=> $refund_date,
				'queue_refund_branch_id'	=> $branch_id,
			);
			
			// insert to db
			$write->set($fields);
			$write->insert('queue_refund');
			// echo 'success';
		}
		
		
		 
	}
	 
	function get_branch($transaction_id = false){
		
		$write = $this->load->database('live',true); 
		$write->query('set transaction isolation level read uncommitted');  
		$sql = "select ticket_branch_id as branch_id from tickets where ticket_transaction_id = ? limit 1";
		return $write->query($sql, [$transaction_id]);
	}
	
	function branch_mapping($b){
		

		switch ($b) {
			 
			//case 31:return	31;break;
			//case 33:return	33;break;
			//case 106:return	106;break;
			//case 168:return	33;break;
			//case 182:return	106;break;
			//case 183:return	31;break;
			//case 199:return	8;break;
			case 7:return	7;break;
			case 8:return   8;break;
			case 10:return	10;break;
			case 11:return	11;break;
			case 13:return	11;break;
			case 15:return	15;break;
			case 16:return	16;break;
			case 17:return	17;break;
			case 18:return	18;break;
			case 19:return	19;break;
			case 20:return	10;break;
			case 23:return	23;break;
			case 28:return	11;break;
			case 29:return	143;break;
			case 30:return	30;break;
			case 32:return	32;break;
			case 35:return	35;break;
			case 36:return	36;break;
			case 39:return	39;break;
			case 40:return	40;break;
			case 91:return	91;break;
			case 92:return	202;break;
			case 104:return	32;break;
			case 108:return	35;break;
			case 121:return	121;break;
			case 125:return	11;break;
			case 130:return	135;break;
			case 133:return	133;break;
			case 135:return	135;break;
			case 137:return	32;break;
			case 138:return	15;break;
			case 139:return	8;break;
			case 140:return	140;break;
			case 143:return	143;break;
			case 146:return	146;break;
			case 147:return	147;break;
			case 153:return	143;break;
			case 154:return	35;break;
			case 155:return	15;break;
			case 156:return	17;break;
			case 157:return	36;break;			
			case 158:return	19;break;
			case 159:return	40;break;
			case 161:return	30;break;
			case 162:return	35;break;
			case 163:return	23;break;
			case 164:return	11;break;
			case 165:return	10;break;
			case 166:return	39;break;
			case 167:return	121;break;
			case 170:return	18;break;
			case 171:return	7;break;
			case 172:return	8;break;
			case 173:return	91;break;
			case 175:return	202;break;
			case 176:return	10;break;
			case 180:return	16;break;
			case 184:return	32;break;
			case 185:return	32;break;
			case 188:return	135;break;
			case 189:return	135;break;
			case 190:return	143;break;
			case 192:return	147;break;
			case 193:return	11;break;
			case 195:return	140;break;
			case 196:return	133;break;
			case 197:return	32;break;
			case 198:return	146;break;
			case 199:return	8;break;
			case 202:return	202;break;	
			case 203:return	202;break;
 
			default:
			return $b;
		}

	}
 
	 
}
/* End of file generic_mod.php */
/* Location: ./application/controllers/generic_mod.php */