<?php 
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
include('accesstemplate.php');


class Transactions extends AccessTemplate {
	
	var $moaarenaBranches = [103,4,3,22,12,91,15,27,110,21];
	var $metrocinemaBranches = []; //24,26,107
	var $bowlingBranches = [0];
	var $cebuBranches = [];
	var $province = [32]; //cebu
	
	public function __construct(){
		parent::__construct();
		$this->load->model('api_prices_model', 'prices');
		$this->load->model('api_sections_model', 'sections');
		$this->load->database('default',true); 
			
	
	}
	
	 
	 
	function get(){
		$branch_id = 0;
		$transaction_id = $this->input->post('transaction_id'); 
		$branch = $this->input->post('branch'); 
		if(!$transaction_id){
			$this->promptError('ER:06:15'); 
		}else{
				
			$result = $this->get_trans_info($transaction_id,$branch);
			// for proper display of XML output on browser
			$this->load->helper('file');
			$this->output->set_header('Content-type: '.get_mime_by_extension('test.xml'));
			echo '<?xml version="1.0"?>';
			echo PHP_EOL;
			// echo $read->last_query();
			$this->load->dbutil();
			$config = array (
			  'root'    => 'root',
			  'element' => 'row', 
			  'newline' => "\n", 
			  'tab'    => "\t"
			);
			
			echo $this->dbutil->xml_from_result($result, $config);
		}
	}
	  
	function voucher(){
		$branch_id = 0;
		$transaction_id = $this->input->post('transaction_id'); 
		$refund_date = $this->input->post('refund_date'); 
		$branch_id = $this->input->post('branch'); 
		
		// $transaction_id = 2512; 
		// $refund_date = '2020-04-24'; 
		
		 	
		if(!$transaction_id){
			$this->promptError('ER:06:15'); 
		}else if(!$refund_date){
			$this->promptError('ER:05:28'); 
		}else{
			
			$read = $this->load->database('default',true); 
			$read->query('set transaction isolation level read uncommitted');  
			$read->select('count(1) as count');
			$read->where('queue_refund_transaction_id',$transaction_id);
			// $read->where('queue_refund_date',$refund_date);
			$result = $read->get('queue_refund')->row()->count;
			if($result < 1){ 
				
				$rdate=date('Y-m-d', strtotime($refund_date));
 				$day_of_week=date('N', strtotime($refund_date));
				$rend = date('Y-m-d', strtotime("2023-01-31")); 
				$invalid_dates = array('2022-11-01','2023-01-03');
				
				// 1 monday  7 sunday
				//set default values
       			$daysValid = [6,7];
				
				if(in_array($branch_id, $this->moaarenaBranches)){
					$rstart = date('Y-m-d', strtotime(' +11 days')); 
					$daysValid = [2]; 
 					//$rend = date('Y-m-d', strtotime("2020-12-26")); 
				}
				
				// if(in_array($branch_id, $this->bowlingBranches)){
					// $rstart = date('Y-m-d', strtotime(' +2 days')); 
					// $daysValid = [5,6,7];
					// $rend = date('Y-m-d', strtotime("2021-02-28")); 
				// }
				
				/* if(in_array($branch_id, $this->metrocinemaBranches)){
					$rstart = date('Y-m-d', strtotime(' +2 days')); 
					$daysValid = [1,2,3,4,5,6,7];
					$rend = date('Y-m-d', strtotime("2021-01-02")); 

				}
				
				
				if(in_array($branch_id, $this->cebuBranches)){
					$rstart = date('Y-m-d', strtotime(' +2 days')); 
					$daysValid = [1,2,3,4,5,6,7];
					$rend = date('Y-m-d', strtotime("2021-01-31")); 
				}
				 */
				
				if(in_array($branch_id, $this->province)){
					$rstart = date('Y-m-d', strtotime(' +11 days')); 
					$daysValid = [2]; 
 					//$rend = date('Y-m-d', strtotime("2020-12-26")); 
				}
				
				
				
				
				if (($rdate >= $rstart) && ($rdate <= $rend) && in_array($day_of_week, $daysValid) && !in_array($rdate, $invalid_dates)){
					$this->generate_queue_no($transaction_id, $refund_date, $branch_id); 
				}else{
					
					echo 'Invalid Date provied'; 
					die();
				}
				 
			}
			
			$result =  $this->get_trans_info($transaction_id , $branch_id); 
			$data['branch_id'] = $branch_id;
			$data['result'] = $result;
			// echo $result->num_rows();
			// die();
			if($result->num_rows() < 1){
				$this->promptError('ER:06:07'); 
			}else{
				
				if(in_array($branch_id, $this->moaarenaBranches)){
					$this->load->view('refund_voucher',$data);
				}
				
				if(in_array($branch_id, $this->bowlingBranches)){
 					$this->load->view('refund_voucher_bowling',$data);
 				}
				
				if(in_array($branch_id, $this->metrocinemaBranches)){
 					$this->load->view('refund_voucher_metrocinema',$data);
					
				}
				
				
				if(in_array($branch_id, $this->cebuBranches)){
					$this->load->view('refund_voucher_cebu',$data);

				}
				
				if(in_array($branch_id, $this->province)){
					$this->load->view('refund_voucher_pro',$data);

				}
				
				
			}
			 
		}
		
		
		
	}
	
	 
	
	function generate_voucher($transaction_id = false){
		
		// $transaction_id = $this->input->post('transaction_id'); 
		// $refund_date = $this->input->post('refund_date'); 
		
		// $transaction_id = 2508; 
		// $refund_date = '2020-06-24'; 
		
		
		
		if(!isset($transaction_id)){
			$this->promptError('ER:06:15'); 
		}else{
			
			$read = $this->load->database('default',true); 
			$read->query('set transaction isolation level read uncommitted');  
			$read->select('count(1) as count');
			$read->where('queue_refund_transaction_id',$transaction_id);
			// $read->where('queue_refund_date',$refund_date);
			$result = $read->get('queue_refund')->row()->count;
			if($result < 1){
				$this->promptError('ER:06:07'); 
				// die();
				
			}else{
			
				$result =  $this->get_trans_info2($transaction_id); 
				$data['result'] = $result;
				// echo $result->num_rows();
				// die();
				if($result->num_rows() < 1){
					$this->promptError('ER:06:07'); 
				}else{
					$this->load->view('refund_voucher',$data);
				}
			
			}
		}
		
	}
	
	
	function get_trans_info($transaction_id, $branch_id){
			//8322,
		$branches = '173,21,116,151,132,1,2,3,4,5,12,14,22,25,26,27,34,37,38,103,107,110,111,112,113,114,115,117,118,119,120,122,124,126,134,136,141,149,150,152,169,177,178,186,191,201,204,208,209,211,212,155,196,133,125,193,104,137,184,185,197';
		
		// if(in_array($branch_id, $this->cebuBranches)){
			
			// $branches = '32,104,137,184,185,197';
		// }
		
		$write = $this->load->database('live',true); 
		$write->query('set transaction isolation level read uncommitted');  
		$sql = "SELECT 
			a.transaction_id, a.customer_firstname, a.customer_lastname, a.event_title,a.section, a.refund_date,a.queue_refund_number,
			SUM(a.cash_amount) AS cash_amount, SUM(card_amount) AS card_amount, a.ticket_count, a.event_id, a.branch_name from
			(SELECT 
						 `transaction_id`, `customer_firstname`, `customer_lastname`, `event_title`, `price_name` AS section, `queue_refund_date` AS refund_date, `queue_refund_number`,
						  CASE WHEN pa.payment_payment_type_id = 1 THEN pa.payment_amount - transaction_cash_change - pa.payment_amount_voided ELSE 0 END AS cash_amount, 
						  CASE WHEN pa.payment_payment_type_id != 1 THEN pa.payment_amount - pa.payment_amount_voided ELSE 0 END AS card_amount,event_id, branch_name, COUNT(DISTINCT t.ticket_id) AS ticket_count
			FROM (`tickets` t)
			LEFT JOIN `events` e ON `e`.`event_id` = `t`.`ticket_event_id`
			LEFT JOIN `transactions` tr ON `tr`.`transaction_id` = `t`.`ticket_transaction_id`
			LEFT JOIN `prices` p ON `p`.`price_id` = `t`.`ticket_price_id`
			LEFT JOIN `customers` c ON `c`.`customer_id` = `tr`.`transaction_customer_id`
			LEFT JOIN `queue_refund` q ON `q`.`queue_refund_transaction_id` = `tr`.`transaction_id`
			INNER JOIN payments pa ON pa.payment_transaction_id = tr.transaction_id
			LEFT JOIN `branches` b ON `b`.`branch_id` = `q`.`queue_refund_branch_id`
			WHERE `transaction_status` = 'done' AND `ticket_transaction_id` = ? AND ticket_event_id IN (8980,8981,9014,9015,8892,8884,8781,8948,8758,8778,9007,9010,8717,8875,8874,8949,8987,8988,8776,8877,8382,8708,8777,8819,8782,8768,8769,8756,8824,8983,8943,8992,8945,8926,8829,8927,8886,8947,11035,11310,11455,11449,11095,11504)
			GROUP BY pa.payment_id
			LIMIT 100) AS a";
		return $write->query($sql, [$transaction_id]);
		
		 
 	}
	 
	function get_trans_info2($transaction_id){
		 
			$write = $this->load->database('live',true); 
		$write->query('set transaction isolation level read uncommitted');  
		$sql = "SELECT 
			a.transaction_id, a.customer_firstname, a.customer_lastname, a.event_title,a.section, a.refund_date,a.queue_refund_number,
			SUM(a.cash_amount) AS cash_amount, SUM(card_amount) AS card_amount, a.ticket_count, a.event_id, a.branch_name from
			(SELECT 
						 `transaction_id`, `customer_firstname`, `customer_lastname`, `event_title`, `price_name` AS section, `queue_refund_date` AS refund_date, `queue_refund_number`,
						  CASE WHEN pa.payment_payment_type_id = 1 THEN pa.payment_amount - transaction_cash_change - pa.payment_amount_voided ELSE 0 END AS cash_amount, 
						  CASE WHEN pa.payment_payment_type_id != 1 THEN pa.payment_amount - pa.payment_amount_voided ELSE 0 END AS card_amount,event_id, branch_name, COUNT(DISTINCT t.ticket_id) AS ticket_count
			FROM (`tickets` t)
			LEFT JOIN `events` e ON `e`.`event_id` = `t`.`ticket_event_id`
			LEFT JOIN `transactions` tr ON `tr`.`transaction_id` = `t`.`ticket_transaction_id`
			LEFT JOIN `prices` p ON `p`.`price_id` = `t`.`ticket_price_id`
			LEFT JOIN `customers` c ON `c`.`customer_id` = `tr`.`transaction_customer_id`
			LEFT JOIN `queue_refund` q ON `q`.`queue_refund_transaction_id` = `tr`.`transaction_id`
			INNER JOIN payments pa ON pa.payment_transaction_id = tr.transaction_id
			LEFT JOIN `branches` b ON `b`.`branch_id` = `q`.`queue_refund_branch_id`
			WHERE `transaction_status` = 'done' AND `ticket_transaction_id` = ? 
			GROUP BY pa.payment_id
			LIMIT 100) AS a"; 
		return $write->query($sql, [$transaction_id]);
 	}
	 
	function generate_queue_no($transaction_id= false,$refund_date =false,$branch_id =false){
		
		 $last_queue_no = 0;
		$read = $this->load->database('default',true); 
		$write = $this->load->database('live',true); 
		$read->query('set transaction isolation level read uncommitted');  
		$read->select('queue_refund_number');
		$read->where('queue_refund_date',$refund_date);
		$read->where('queue_refund_branch_id',$branch_id);
		$read->order_by('queue_refund_number','desc');
		$read->limit(1);
		$result = $read->get('queue_refund');
		 
		if($result->num_rows() > 0){
			$last_queue_no = $result->row()->queue_refund_number; 
		}
		
		$limit = 1; //default value
		
		if(in_array($branch_id, $this->moaarenaBranches)){
			$limit = 100;
		}
		
		if(in_array($branch_id, $this->bowlingBranches)){
			$limit = 20;
		}
		
		if(in_array($branch_id, $this->metrocinemaBranches)){
			$limit = 50;
		}
		
		
		if(in_array($branch_id, $this->cebuBranches)){
			$limit = 50;
		}
		
		if(in_array($branch_id, $this->province)){
			$limit = 100;
		}
		
		
		
		
		if($last_queue_no >= $limit){
			echo 1;
			die();
		}else{
			$fields = array(
				'queue_refund_number'		=> $last_queue_no + 1,
				'queue_refund_transaction_id'	=> $transaction_id,
				'queue_refund_date'			   => $refund_date,
				'queue_refund_branch_id'			=> $branch_id,
			);
			
			// insert to db
			$write->set($fields);
			$write->insert('queue_refund');
			// echo 'success';
		}
		
		
		 
	}
	 
		
}
/* End of file generic_mod.php */
/* Location: ./application/controllers/generic_mod.php */