<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
include('accesstemplate.php');

class Queue extends CI_Controller{
	
	
	public function __construct()
	{
		parent::__construct();
		$this->load->model('api_error_model', 'error');
		$this->load->model('api_seatplans_model', 'seatplans');
		$this->load->model('api_events_model', 'events');
		$this->load->model('api_sections_model', 'sections');
		$this->load->model('api_transaction_model', 'transactions');
		$this->load->model('api_prices_model', 'prices');
		$this->load->model('api_tickets_model', 'tickets');
		$this->load->model('api_payments_model', 'payments');
		$this->load->model('api_ticket_types_model', 'ticket_types');
		$this->load->model('api_ip_model', 'ip');
		$this->load->model('api_ticket_layouts_model', 'ticket_layouts');
		$this->load->model('api_bcode_model', 'bcode');		
	
		$this->load->database('default',true); 
	}	

	function nt_Queue($id=false,$event_id = false){
		
		if($id && $event_id){
			$id = explode("-",$id);
			$ticket_id = $id[0];
			$trans_id = $id[1];
			
			$dbAccess = $this->load->database('default',true);
			$dbAccess->query('set transaction isolation level read uncommitted');
			$dbAccess->join("sections s","s.section_id = q.queue_section_id");
			$dbAccess->join("events e","e.event_id = q.queue_event_id");
			$dbAccess->join("tickets t","t.ticket_id = q.queue_ticket_id");
			$dbAccess->where("q.queue_ticket_id",$ticket_id);
			$dbAccess->where("q.queue_transaction_id",$trans_id);
			$dbAccess->where("q.queue_event_id",$event_id);
			// $dbAccess->where("q.queue_claim","0");
			$dbAccess->where_in("t.ticket_status",array("done","paid","paid_online"));
			$dbAccess->order_by("q.queue_number","ASC");
			$dbAccess->limit(1);
			$query = $dbAccess->get('queue q');
			
			// print_r($query->row());
			// die();
			if ($query->num_rows() > 0){
				if($query->row()->queue_claim == false){
					$dbAccess->where("q.queue_ticket_id",$ticket_id);
					$dbAccess->where("q.queue_event_id",$event_id);
					$dbAccess->update('queue q', array('q.queue_claim' => '1'));
				}	
				$data['queue'] = $query->row();
				
				if(in_array($event_id , [11651,11647])){
					
				$this->load->view('queue_voucher_pulp', $data); //seventeen
					
				}elseif(in_array($event_id , [11766,11706,11712])){
					$this->load->view('queue_voucher_enhypen', $data); //ENHYPEN DAY 1,2, and 3
				}else{
					$this->load->view('queue_voucher_newp', $data); //seventeen
				}
					
				// $this->load->view('queue_voucher_pulp', $data);
				//$this->load->view('queue_voucher_livenation', $data);
				// $this->load->view('queue_voucher', $data);
			}else{
				echo "invalid access 1";
			}
			
		}else{
			echo "invalid access";
		}
		
	}
	
	public function sample_layout($event_id=FALSE){
		
		if($event_id){
			if($event_id == 6771){
				$queue = array(
					"event_id" => 6771,
					"event_title" => "SUPER JUNIOR SUPER SHOW 7 IN MANILA",
					"event_date_time" => "2018-06-30",
					"queue_transaction_id" => "1234567",
					"queue_ticket_id" => "12345678",
					"section_name" => "STANDING CENTER",
					"queue_number" => 9999
				);
			}else if($event_id == 7017){
				$queue = array(
					"event_id" => 7017,
					"event_title" => "2018 SEVENTEEN 'IDEAL CUT' IN MANILA",
					"event_date_time" => "2018-09-29",
					"queue_transaction_id" => "1234567",
					"queue_ticket_id" => "12345678",
					"section_name" => "STANDING A",
					"queue_number" => 9999
				);
			}else{
				show_404();
			}
			
			
			$data['queue'] = json_decode(json_encode($queue));
			
			$this->load->view('1_voucher_queue_v2', $data);
			// $this->load->view('0_voucher_queue_v2');
		}else{
			show_404();
		}

	}
	
	function nt_check_ticket($id,$event_id){
		
		$id = explode("-",$id);
		$ticket_id = $id[0];
		$trans_id = $id[1];
		
		$dbAccess = $this->load->database('default',true);
		$dbAccess->query('set transaction isolation level read uncommitted');
		$dbAccess->join("tickets t","t.ticket_id = q.queue_ticket_id");
		$dbAccess->where("q.queue_ticket_id",$ticket_id);
		$dbAccess->where("q.queue_transaction_id",$trans_id);
		$dbAccess->where("q.queue_event_id",$event_id);
		$dbAccess->where_in("t.ticket_status",array("done","paid","paid_online"));
		$dbAccess->order_by("q.queue_number","ASC");
		$dbAccess->limit(1);
		$query = $dbAccess->get('queue q');

		if ($query->num_rows() > 0){
			echo true;
		}else{
			echo false;
		} 
	}

	function voucher(){
		
		$this->load->view('refund_voucher');

		
	}
}
