<?php

class Printer extends CI_Controller {

	/* NOTE: using a model class to handle dbproc causes 
		memory to run out and greatly affects 
		PDF generation based on XML generator
		
		Tested 100-200 ticket nodes for loading using
		initial output design for db storage and PDF generation
	*/
		
	public function __construct(){
		
		parent::__construct();
		$this->load->model('api_generator_model', 'generator');
		$this->load->model('api_events_model', 'events');
		$this->load->model('api_tickets_model', 'tickets');
		$this->load->model('api_printer_model', 'printer');
		$this->load->model('api_transaction_model', 'transactions');
		$this->load->database('default');
	}

	function payment_done_db2xml2pdf($yearmonth = false, $id = false, $trans_id = false){
		// called by PrinterApp - remove .pdf filename extension
		$barcode = strtoupper(hash("crc32", $trans_id));
		$trans_id = str_replace(".pdf","",$trans_id);

		$xmldata = "";
		$validcall = false;
		if (($trans_id > 0) && ($yearmonth > 0) && ($id > 0)){
			// validate transaction 
			$validcall = $this->generator->validatePaidTransactionWithXML($yearmonth, $id, $trans_id);
		}
		
		if (!$validcall) {
			show_404();
			// echo $this->db->last_query();
			die("invalid call");
		}
		
		if ($yearmonth && $id) {
			$this->db->where("xml_id", $id);
			$this->db->where("xml_yearmonth", $yearmonth);
			$query = $this->db->get("generator");
			
			foreach($query->result() as $row) {
				$xmldata = $row->xml_content;
			}
		} else {
			die ("Invalid access.");
		}


		$this->load->library('simplexml');  
		$content = $this->simplexml->xml_parse($xmldata, "&amp");

		// echo "<pre>";
		// print_r($content);
		// echo "</pre>";
		// die();

		$data['layout'] = $content['layout']['@attributes'];
		if(isset( $content['ticket'][0])){
			$data['tickets']  = $content['ticket'];
		} else {
			$data['tickets'][0]  = $content['ticket'];
		}
		$this->load->helper('file'); 
		
		$event_id = $this->tickets->get_event_id($trans_id);
		$data['event'] = $this->events->get_event_details($event_id->ticket_event_id);
		
		
		
		
		 
		 
		 
		//================================================================================================
				
			foreach($data['tickets'] as &$ticket){
				
				
	
				
				
					foreach($ticket as &$t){
						
						
	
						
						
						foreach($t as &$item){

									$new = str_replace("202.57.62.28", "10.141.23.61", $item);
									$item = $new;
									
						}  
					}
			}
			 
		//================================================================================================

		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		$data['event_details'] = $this->events->get_all_event_details($data['event']->event_id);
		$data['base_url'] = $this->config->item('base_url');
	
		// $this->transactions->transaction_done($trans_id);
		//
		 
		 // echo "<pre>";
		 // print_r($data);
		 // echo "</pre>";
		 // die();
		 
		if($event_id->price_package > 1){
		
			$data['count'] = $event_id->price_package;
			// echo '<pre>';
			// print_r($data);
			// echo '</pre>';
			// die();
			// $this->load->view('printer_xml2pdf_dynamic',$data);
			
			$this->load->view('0_print_at_home_tickets',$data);
			

		}

		else{
			
			// echo '<pre>';
			// print_r($data);
			// echo '</pre>';
			// die();
			// $this->load->view('printer_xml2pdf',$data);
			$this->load->view('0_print_at_home_tickets',$data);

		}

		$update_data = array(
			'transaction_status' => 'done'
		);

		/*$this->db->where('transaction_barcode', $barcode);
		$this->db->update('transactions', $update_data);*/
		$this->transactions->transaction_done($trans_id);
	

	}

	function eventSample($event_id, $enableBG = false, $testmode = false){
		// $callparam = $_GET;
		//the path of the xml that will be converted to pdf
		$url = base_url()."generators/eventSample/$event_id/$enableBG";
		$this->load->library('HTTPCall');
		
		$callparam = array();
		$this->httpcall->do_http_get_request($url,$callparam);

		$xmldata = $this->httpcall->rawoutput;
		$this->load->library('simplexml');  
		$content = $this->simplexml->xml_parse($xmldata, "&amp");
		$data['layout'] = $content['layout']['@attributes'];
		if(isset( $content['ticket'][0])){
			$data['tickets']  = $content['ticket'];
			
		} else {
			$data['tickets'][0]  = $content['ticket'];
		}
		
		// $data["testmode"] = $testmode;
		$data["testmode"] = 1;
		if (!$testmode) {
			$this->load->helper('file');
			$this->output->set_header('Content-type: '.get_mime_by_extension('test.pdf'));
		}
		
		
		$data['event'] = $this->events->get_event_details($event_id);
		$this->load->view('printer_xml2pdf',$data);

	}


	function generate_card_details($transID = false)
	{
		
		
		// parse_str($_SERVER['QUERY_STRING'],$_GET);
		
		 //get paramters needed	
		// $transactionID = $this->input->get('transID');
		
		// for proper display of XML output on browser
		$this->load->helper('file');
		$this->output->set_header('Content-type: '.get_mime_by_extension('test.xml'));
		echo '<?xml version="1.0"?>';
		echo PHP_EOL;
		 
		$result = $this->printer->get_ticket_details($transID);
		
 
		
		$this->load->dbutil();
		$config = array (
			  'root'    => 'root',
			  'element' => 'row', 
			  'newline' => "\n", 
			  'tab'    => "\t"
			);
			
		echo $this->dbutil->xml_from_result($result, $config);
		 
	 
	}
	
	function mark_as_released($transID = false){
		
		// $this->users->check_session(array('Admin', 'Seller', 'Manager', 'Finance'));
	
		$this->load->library('simplexml');  

		$xml_data = $this->input->post('xml_data');
		 
	 
		$xml_data = $this->simplexml->xml_parse($xml_data, "&amp");
		// echo '<pre>';
		print_r($xml_data);
		// echo '</pre>';
		
		 
		 
		
		$this->printer->insert_details($xml_data);
		
 
	 
	}
	
	function check_ticket_status(){
	
	$this->load->library('simplexml');  

		$xml_data = $this->input->post('xml_data');
		 
	 
		$xml_data = $this->simplexml->xml_parse($xml_data, "&amp");
		// echo '<pre>';
		// print_r($xml_data);
		// echo '</pre>';
		
		  
	    $result =  $this->printer->check_status($xml_data);
			
		// $this->load->dbutil();
		// $config = array (
			  // 'root'    => 'root',
			  // 'element' => 'row', 
			  // 'newline' => "\n", 
			  // 'tab'    => "\t"
		// );
			
		// echo $this->dbutil->xml_from_result($result, $config);
	 
	}
	
	function sampleLayout(){  
		
		// $this->load->view('1_print_at_home_tickets_v2');
		$this->load->view('1_print_at_home_tickets');

	}

	function print_pdf($yearmonth = false, $id = false, $trans_id = false){
		// called by PrinterApp - remove .pdf filename extension
		$barcode = strtoupper(hash("crc32", $trans_id));
		$trans_id = str_replace(".pdf","",$trans_id);

		$xmldata = "";
		$validcall = false;
		if (($trans_id > 0) && ($yearmonth > 0) && ($id > 0)){
			// validate transaction 
			// $validcall = $this->generator->validatePaidTransactionWithXML($yearmonth, $id, $trans_id);
		}
		
		// if (!$validcall) {
			// show_404();
			// // echo $this->db->last_query();
			// die("invalid call");
		// }
		
		if ($yearmonth && $id) {
			$this->db->where("xml_id", $id);
			$this->db->where("xml_yearmonth", $yearmonth);
			$query = $this->db->get("generator");
			
			foreach($query->result() as $row) {
				$xmldata = $row->xml_content;
			}
		} else {
			die ("Invalid access.");
		}


		$this->load->library('simplexml');  
		$content = $this->simplexml->xml_parse($xmldata, "&amp");

		// echo "<pre>";
		// print_r($content);
		// echo "</pre>";
		// die();

		$data['layout'] = $content['layout']['@attributes'];
		if(isset( $content['ticket'][0])){
			$data['tickets']  = $content['ticket'];
		} else {
			$data['tickets'][0]  = $content['ticket'];
		}
		$this->load->helper('file'); 
		
		$event_id = $this->tickets->get_event_id($trans_id);
		$data['event'] = $this->events->get_event_details($event_id->ticket_event_id);
		
		
		
		
		 
		 
		 
		//================================================================================================
				
			foreach($data['tickets'] as &$ticket){
				
				
	
				
				
					foreach($ticket as &$t){
						
						
	
						
						
						foreach($t as &$item){

									$new = str_replace("202.57.62.28", "10.141.23.61", $item);
									$item = $new;
									
						}  
					}
			}
			 
		//================================================================================================

		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		
		$data['event_details'] = $this->events->get_all_event_details($data['event']->event_id);
		$data['base_url'] = $this->config->item('base_url');
	
		// $this->transactions->transaction_done($trans_id);
		//
		 
		 // echo "<pre>";
		 // print_r($data);
		 // echo "</pre>";
		 // die();
		 
		if($event_id->price_package > 1){
		
			$data['count'] = $event_id->price_package;
			// echo '<pre>';
			// print_r($data);
			// echo '</pre>';
			// die();
			// $this->load->view('printer_xml2pdf_dynamic',$data);
			
			$this->load->view('0_print_at_home_tickets',$data);
			

		}

		else{
			
			// echo '<pre>';
			// print_r($data);
			// echo '</pre>';
			// die();
			// $this->load->view('printer_xml2pdf',$data);
			$this->load->view('0_print_at_home_tickets',$data);

		}

		$update_data = array(
			'transaction_status' => 'done'
		);

		/*$this->db->where('transaction_barcode', $barcode);
		$this->db->update('transactions', $update_data);*/
		// $this->transactions->transaction_done($trans_id);
	

	}

} 

/* End of file printer.php */
/* Location: ./system/application/controllers/printer.php */
