<?php 
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
include('accesstemplate.php');
require(APPPATH.'/libraries/fpdf_1.8.1/fpdf.php');
require(APPPATH.'/libraries/PHPMailer/PHPMailerAutoload.php');

class Users extends AccessTemplate {
 
	public function __construct(){
		parent::__construct();
		$this->load->model('api_prices_model', 'prices');
		$this->load->model('api_sections_model', 'sections');
		$this->load->model('users_model', 'users');
		$this->load->database('default',true); 
			
		// for proper display of XML output on browser
		$this->load->helper('file');
		$this->output->set_header('Content-type: '.get_mime_by_extension('test.xml'));
		echo '<?xml version="1.0"?>';
		echo PHP_EOL;
	}
	 
	function login(){
		
		$username = $this->input->post('username');
		$password = $this->input->post('password');
		
		if(!$username){ 
		$this->promptError('ER:04:12');
		}else if(!$password){ 
		$this->promptError('ER:04:03');
		}else{
			 
			$result = $this->users->login();
			 
			
			$this->load->dbutil();
			$config = array (
			  'root'    => 'root',
			  'element' => 'row', 
			  'newline' => "\n", 
			  'tab'    => "\t"
			);
			
			echo $this->dbutil->xml_from_result($result, $config);
		}
	}
	
	function prep_password($password){

		return sha1($this->config->item('encryption_key').$password);
	}
	
	function forgot_password(){

		 
 		$email = $this->input->post('email');
		
		if(!$email){ 
		$this->promptError('ER:04:10');
		}else{
				
			$result = $this->users->forgot_password();
			 
			echo "<result>$result</result>";
		}
		
		
	}
	
	function change_password(){

		 
 		$email = $this->input->post('email');
 		$old_password = $this->input->post('old_password');
 		$new_password = $this->input->post('new_password');
		
		if(!$email){ 
		$this->promptError('ER:04:10');
		}else if(!$old_password){
		$this->promptError('ER:04:36'); 	
		}else if(!$new_password){
		$this->promptError('ER:04:18'); 	
		}else{
				
			$result = $this->users->change_password();
			 
			echo "<result>$result</result>";
		}
		
		
	}
	
	function request_otp(){
		
		$username = $this->input->post('username'); 
		
		if(!$username){ 
		$this->promptError('ER:04:12');
		}else{
			
			//check username
			$result = $this->users->get_email($username);
		 
			if($result){
				//generate otp code
				$otp = mt_rand(100000, 999999);
				$this->users->add_auth($otp, $username, $result->email);
				
				$this->users->send_twofactor($result->email,$username, $otp);
				 echo "<result>1</result>";
			}else{
				 echo "<result>0</result>";				
			}
			
			 
		}
		
		
		
		
	}
	
	function check_otp(){
		
		$username = $this->input->post('username'); 
		$otp = $this->input->post('otp'); 
		
		
		if(!$username){ 
		$this->promptError('ER:04:12');
		}else if(!$otp){ 
		$this->promptError('ER:07:04');
		}else{
			$result = $this->users->check_otp($otp,$username);
			if($result){
				$otp_timestamp = strtotime($result->timestamp);
				if (time() - $otp_timestamp > 15 * 60) {
					// 15 mins has passed
					echo "<result>0</result>";		
				}else{ 
					echo "<result>1</result>";		
				}

			}else{
				 echo "<result>0</result>";		
			}
		}
		
		
	}
	
}
/* End of file generic_mod.php */
/* Location: ./application/controllers/generic_mod.php */