<?php 
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
include('accesstemplate.php');


class Transactions extends AccessTemplate {
 
	public function __construct(){
		parent::__construct();
		$this->load->model('api_prices_model', 'prices');
		$this->load->model('api_sections_model', 'sections');
		$this->load->model('transactions_model', 'transactions');
		$this->load->model('data_model', 'data');
		$this->load->database('default',true); 
			
		// for proper display of XML output on browser
		$this->load->helper('file');
		$this->output->set_header('Content-type: '.get_mime_by_extension('test.xml'));
		echo '<?xml version="1.0"?>';
		echo PHP_EOL;
	}
	
	
	//for guaranteed/free seating or add to cart
	function select_seat(){
		
		$event_id = $this->input->get_post('event_id');
    	$section_id = $this->input->get_post('section_id');
		$price_id = $this->input->get_post('price_id');
		$ticket_type = $this->input->get_post('ticket_type_id');
		$session_id = $this->input->get_post('session_id');
		$section_type = $this->input->get_post('section_type');
		$qty = $this->input->get_post('qty');
   		
		 
		
		
		/*check purchase limit */
		//ticket_already_bought
		//tickets_selected
		
		if(!$event_id){
			$this->promptError('ER:05:03');
		}elseif(!$section_id){
			$this->promptError('ER:05:05');
		}elseif(!$price_id){
			$this->promptError('ER:05:07');
		}elseif(!$ticket_type){
			$this->promptError('ER:06:22');
		}elseif(!$session_id){
			$this->promptError('ER:06:20');
		}elseif(!$qty){
			$this->promptError('ER:06:23');
		}elseif(!$section_type){
			$this->promptError('ER:06:25');
		}else{
			$valid = $this->check_restrictions($event_id, $price_id, $ticket_type);
			$section[] = $section_id;
			$event_ticket_limit = $this->data->get_ticket_limit($event_id); 
			list ($selected_tickets, $selected_price)  = $this->transactions->get_selected_seats_by_session($session_id, $event_id);
			$taken_seats = $this->transactions->get_taken_seats_per_section($section); 
			// $capacity = $this->transactions->get_capacity_per_section($section_id); 
			 
			
			
			//checking for multiple price restriction
			$multiple = 0;
			if($selected_price){
				
				if($price_id != $selected_price){
					$multiple = 1;
				}
			}
		

			if(isset($taken_seats[0]->seats_taken)){
				$taken = $taken_seats[0]->seats_taken; 
			}else{
				$taken = 0; 
				
			}
			
			$selected_qty = $qty;
			$result_qty = 'ALL';
			if($qty + $selected_tickets > $event_ticket_limit){ 
				$qty = $event_ticket_limit - $selected_tickets;
			}
			
			if($selected_qty != $qty){
				$result_qty = $qty;
				
			}
			
			
			
			//check if there are still seats available 
			if($qty < 1){
				
				$this->promptError('ER:06:21'); 
				
			}
			// elseif($multiple == 1 && $event_id != 7764){
				
				// $this->promptError('ER:06:29'); 
				
			// }
			elseif($valid != 1){
				$this->promptError('ER:06:26'); 
		
			}else{
				//$event_id, $section_id, $price_id, $ticket_type , $accessCode, $qty
				$this->transactions->select_seat($event_id, $section_id, $price_id, $ticket_type , $session_id, $section_type, $qty);
				echo '<root><result>Success</result><qty>'. $result_qty   .'</qty></root>';
			}
			 
		}
		
		 
	} 
	
	//for reserved seating
	function add_seat(){
		
		$event_id = $this->input->get_post('event_id');
    	$section_id = $this->input->get_post('section_id');
		$price_id = $this->input->get_post('price_id');
		$ticket_type = $this->input->get_post('ticket_type_id');
		$session_id = $this->input->get_post('session_id');
 		$seats = $this->input->get_post('seats');
   		  
		if(!$event_id){
			$this->promptError('ER:05:03');
		}elseif(!$section_id){
			$this->promptError('ER:05:05');
		}elseif(!$price_id){
			$this->promptError('ER:05:07');
		}elseif(!$ticket_type){
			$this->promptError('ER:06:22');
		}elseif(!$session_id){
			$this->promptError('ER:06:20');
		}elseif(!$seats){
			$this->promptError('ER:06:19');
		}else{
			
			$event_ticket_limit = $this->data->get_ticket_limit($event_id); 
			list ($selected_tickets, $selected_price)  = $this->transactions->get_selected_seats_by_session($session_id, $event_id);
			$seats = unserialize($seats);
			
			$valid = $this->check_restrictions($event_id, $price_id, $ticket_type);

			
			//checking for multiple price restriction
			$multiple = 0;
			if($selected_price){
				
				if($price_id != $selected_price){
					$multiple = 1;
				}
			}
			
			
			//count($seats) + 
			if(count($seats) + $selected_tickets > $event_ticket_limit){ 
				$this->promptError('ER:06:21'); 
			}
			// elseif($multiple == 1 && $event_id != 7764){  
				// $this->promptError('ER:06:29'); 
			// }
			elseif($valid != 1){
				$this->promptError('ER:06:26'); 
		
			}else{
				
				// echo 'wait..';
				// die();
				$failed = array();	
				$success = array();	
				//check if there are still seats available
					
				
				// $seats = array();
				// $seats[] = 'R0|C0|A|1';
				// $seats[] = 'R0|C0|A|2';
				
				//ticket_system_row
				//ticket_system_col
				//ticket_row
				//ticket_seat
				
				// $seats = serialize($seats);
				// echo $seats;
				// die();
				
				
				// print_r($seats);
				// die();
				echo '<root>';
				foreach($seats as $x){
					
					$x = explode("|",$x);
					
					// print_r($x);
					
					
					$system_row = substr($x[0], 1);
					$system_col = substr($x[1], 1); 
					$ticket_row = $x[2];
					$ticket_seat = $x[3];
					
					// die();
					
					$seat = array();
					$available = $this->transactions->is_seat_available($section_id, $system_row, $system_col);
					if($available > 0){
						
 						echo '<failed>' . $ticket_row . $ticket_seat  .'</failed>';
 					}else{
						
						$this->transactions->add_seat($event_id, $section_id, $price_id, $ticket_type , $session_id, $system_row,$system_col,$ticket_row, $ticket_seat);
						echo '<success>' . $ticket_row . $ticket_seat  .'</success>';
						
					}
					
				}
				
				echo '</root>';
 
			
				
				
			
			}
			 
		}
		
		 
	} 
	
	
		
	// unselect_seat
	function unselect_seat(){
		
		$ticket_id = $this->input->post('ticket_id');
		$section_id = $this->input->post('section_id');
		
		
		if(!$ticket_id){ 
			$this->promptError('ER:04:25');
 		}elseif(!$section_id){ 
			$this->promptError('ER:05:05');
 		}else{
		 
			echo $this->transactions->unselect_ticket($ticket_id,$section_id);
			die();
			
		}
	}

	// unselect_seat
	function unselect_seat_all(){
		
		$session_id = $this->input->post('session_id');
		$section_id = $this->input->post('section_id');
		$event_id = $this->input->post('event_id');
		
		
		if(!$session_id){ 
			$this->promptError('ER:06:20');
 		}elseif(!$section_id){ 
			$this->promptError('ER:05:05');
 		}elseif(!$event_id){ 
			$this->promptError('ER:05:03');
 		}else{
		 
			echo $this->transactions->unselect_ticket_all($session_id,$section_id,$event_id);
			die();
			
		}
	}




	//cart
	function selected_seats(){
		$session_id = $this->input->post("session_id");
		$event_id = $this->input->post("event_id");
		
		if(!$session_id){
		$this->promptError('ER:05:20');		
		}elseif(!$event_id){
		$this->promptError('ER:05:03');		
		}else{
		
			$data["selected_tickets"] = $this->transactions->get_selected_seats_per_event($session_id, $event_id);
	
			$used_ticket_types = array();
			foreach($data["selected_tickets"] as $selected_ticket){
			$selected_ticket->ticket_type_id;
				$used_ticket_types[] = $selected_ticket->ticket_type_id;
			}
			$used_ticket_types = array_unique($used_ticket_types);

			$data["ticket_types"] = $this->transactions->get_ticket_types($used_ticket_types);
	
			$this->load->view("selected_tickets_xml",$data);
		}
	}
	
	
	function check_restrictions($event_id = false, $price_id = false, $ticket_type = false){
		
		$valid = 0;
		if(!trim($event_id)) die('error');
		if(!trim($price_id)) die('error 2');
		if(!trim($ticket_type)) die('error 3');
		
		$dbAccess = $this->load->database('default',true);
		$dbAccess->query('set transaction isolation level read uncommitted');
		
		$dbAccess->select('event_id, event_ticket_types');
		$dbAccess->where("e.event_id",$event_id);
		$dbAccess->where("p.price_id",$price_id);
		$dbAccess->where("e.event_active",'1');
		$dbAccess->where("e.event_enable_online_selling",'1');
		$dbAccess->where("e.event_internet_sales_charge !=","");
		$dbAccess->where("p.price_hidden_online",'0');
		$dbAccess->limit(1);
		$dbAccess->join('events e', 'p.price_event_id = e.event_id', 'left' );
		$query = $dbAccess->get('prices p');
		
		if($query->num_rows() > 0){
			$ticket_types = unserialize($query->row()->event_ticket_types);
			
			if(in_array($ticket_type,$ticket_types) && $ticket_type != 2){
				 
				//ticket type restriction
				$dbAccess->where('ticket_type_id', $ticket_type);
				$dbAccess->where('ticket_type_group', 0);
				$query = $dbAccess->get('ticket_types t');
				if($query->num_rows() > 0){
					
					$valid = 1;
					
				}
			
			}
		}
		
		// echo $valid;
		return $valid;
		
		
	}

	
}
/* End of file generic_mod.php */
/* Location: ./application/controllers/generic_mod.php */