<?php 
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
include('accesstemplate.php');


class Sections extends AccessTemplate {
 
	public function __construct(){
		parent::__construct();
		$this->load->model('api_prices_model', 'prices');
		$this->load->model('api_sections_model', 'sections');
		$this->load->database('default',true); 
			
		// for proper display of XML output on browser
		$this->load->helper('file');
		$this->output->set_header('Content-type: '.get_mime_by_extension('test.xml'));
		echo '<?xml version="1.0"?>';
		echo PHP_EOL;
	}
	
	
	
	function get(){
		$event_id = $this->input->post('event_id');
		
		if(!$event_id){
			$this->promptError('ER:05:03');
		}else{
		
		
		$data['prices'] = $this->prices->getPricesForAllEvents($event_id);
		
		$this->load->view('prices_active_events_xml', $data);
		}
	}
	
	function all(){

		$event_id = $this->input->post('event_id');
		if(!$event_id){
			$this->promptError('ER:05:03');
		}else{
				
			$data['sections'] = $this->sections->getSectionsWithEventID($event_id);

			if(!$data['sections']){
			$this->load->view('blank', $data);
			}else{
			//display the page
			$this->load->view('seatplans_active_events_xml', $data);
			}
		}
	}
	 
	function get_seats(){
			
		$event_id = $this->input->get_post('event_id');	
		$section_id = $this->input->get_post('section_id');
		
		if(!$event_id){
			$this->promptError('ER:05:03');
		}elseif(!$section_id){
			$this->promptError('ER:05:05');
		}else{
			

			$data['event_id'] = $event_id;
			$data['sections'] = $this->sections->getSectionsWithEventID_3($event_id,$section_id);
		
			if(!$data['sections']){
				$this->load->view('blank', $data);
			}else{
				//display the page
				$this->load->view('seats_xml', $data);
			}
			
		}
		
	}

}
/* End of file generic_mod.php */
/* Location: ./application/controllers/generic_mod.php */