<?php 
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
include('accesstemplate.php');


class Reservations extends AccessTemplate {
 
	public function __construct(){
		parent::__construct();
		$this->load->model('api_prices_model', 'prices');
		$this->load->model('api_sections_model', 'sections');
		$this->load->model('transactions_model', 'transactions');
		$this->load->database('default',true); 
			
		// for proper display of XML output on browser
		$this->load->helper('file');
		$this->output->set_header('Content-type: '.get_mime_by_extension('test.xml'));
		echo '<?xml version="1.0"?>';
		echo PHP_EOL;
	}
	
	function add(){
		
		
		$session_id = $this->input->post('session_id');
		$event_id = $this->input->post('event_id');
		$email = $this->input->post('email');
		$mobile = $this->input->post('mobile');
		$firstname = $this->input->post('firstname');
		$lastname = $this->input->post('lastname');
		$notes = $this->input->post('notes'); 
		$promoter_id = $this->input->post('promoter_id'); 
		$user_id = $this->input->post('user_id');
		
		if(!$session_id){
			$this->promptError('ER:05:20'); 
		}elseif(!$user_id){
			$this->promptError('ER:07:05');
		}elseif(!$promoter_id){
			$this->promptError('ER:07:03'); 
		}elseif(!$event_id){
			$this->promptError('ER:05:03');
		}elseif(!$mobile){
			$this->promptError('ER:04:08');
		}elseif(!$firstname){
			$this->promptError('ER:04:04');
		}elseif(!$lastname){
			$this->promptError('ER:04:05');
		}else{
			
			  
			// check ticket status
			$result = $this->transactions->_check_tix_stat($session_id, $event_id);
			if($result){
				// add customer to db
				$customer_id = $this->transactions->customer_quick_add();
				// $data['events']= $this->events->reservation_expiry($this->session->userdata('cei'));
				$result = $this->transactions->customer_info($customer_id);
				  
				 echo "<result>$result</result>";
			}else{
				$this->promptError('ER:06:07');
				
			}
			
		
			
		}
		 
	}
	 
	function list(){
		
		$promoter_id = $this->input->post('promoter_id');
		$user_id = $this->input->post('user_id');
		$search = $this->input->post('search');
		$length = $this->input->post('length');
		$start = $this->input->post('start');
		$order_col = $this->input->post('order_col');
		$order_dir = $this->input->post('order_dir');
		$order_cols = array('transaction_id','customer_firstname','customer_lastname','event_title','price_name','transaction_date','branch_name');
		
		if(!$promoter_id){
			$this->promptError('ER:07:03'); 
		}elseif(!$user_id){
			$this->promptError('ER:07:05');
		}else{
				
			 
			$read = $this->load->database('default',true); 
			$read->query('set transaction isolation level read uncommitted');  
			$read->select('transaction_id as reservation_id,customer_firstname, customer_lastname,event_title,price_name as section, transaction_date as date_reserved, branch_name as reservation_branch,ticket_reservation_expiry, sum(price_price) as amount, count(1) as qty '); 
			$read->join('events e', 'e.event_id = t.ticket_event_id', 'left' ); 
			$read->join('transactions tr', 'tr.transaction_id = t.ticket_transaction_id', 'left' ); 
			$read->join('prices p', 'p.price_id = t.ticket_price_id', 'left' ); 
			$read->join('customers c', 'c.customer_id = tr.transaction_customer_id', 'left' ); 
			$read->join('branches b', 'b.branch_id = tr.transaction_branch_id', 'left' ); 
			$read->where('event_promoter_id', $promoter_id);   			
			$read->where('ticket_user_id', $user_id); 
			$read->where('transaction_status', 'reserved'); 
			
			if($search){
				$where = "(transaction_id = '$search' OR event_title like '%$search%'
				OR customer_firstname like '%$search%' OR customer_lastname like '%$search%' 
				OR price_name like '%$search%')"; 
				$read->where($where); 
			}
			if($length && $start){
				$read->limit($length, $start);  
			}
 
			if($order_col >= 0 && $order_dir){ 
				$read->order_by($order_cols[$order_col],$order_dir);
			}else{ 
				$read->order_by('transaction_id','desc');
			}
			$read->group_by('transaction_id');
			$result = $read->get('tickets t');
			// echo $read->last_query();
			$this->load->dbutil();
			$config = array (
			  'root'    => 'root',
			  'element' => 'row', 
			  'newline' => "\n", 
			  'tab'    => "\t"
			);
			
			echo $this->dbutil->xml_from_result($result, $config);
		}
	}
	 
	function list_count(){
		
		$promoter_id = $this->input->post('promoter_id');
		$user_id = $this->input->post('user_id');
		if(!$promoter_id){
			$this->promptError('ER:07:03'); 
		}elseif(!$user_id){
			$this->promptError('ER:07:05'); 
		}else{
				
				
			$read = $this->load->database('default',true); 
			$read->query('set transaction isolation level read uncommitted');  
			$read->select('count(distinct(transaction_id)) as total_count'); 
			$read->join('events e', 'e.event_id = t.ticket_event_id', 'left' ); 
			$read->join('transactions tr', 'tr.transaction_id = t.ticket_transaction_id', 'left' ); 
   			$read->where('event_promoter_id', $promoter_id); 
   			$read->where('ticket_user_id', $user_id); 
			$read->where('transaction_status', 'reserved'); 
			// $read->group_by('event_promoter_id');

			$result = $read->get('tickets t');
			// echo $read->last_query();
			$this->load->dbutil();
			$config = array (
			  'root'    => 'root',
			  'element' => 'row', 
			  'newline' => "\n", 
			  'tab'    => "\t"
			);
			
			echo $this->dbutil->xml_from_result($result, $config);
		}
	}
	  
	function cancel()
	{
		
		$transaction_id = $this->input->post('transaction_id');
		// $promoter_id = $this->input->post('promoter_id');
		
		if(!$transaction_id){
			$this->promptError('ER:06:15');
		}else{
			$result = $this->transactions->reservation_cancel($transaction_id);
			 echo "<result>$result</result>";
		}		
	}
	
	function extend(){
		$transaction_id = $this->input->post('transaction_id');
		$days = $this->input->post('days');
		
		if(!$transaction_id){
			$this->promptError('ER:06:15'); 
		}elseif(!$days){
			$this->promptError('ER:07:02');
		}else{
		
		$result =  $this->transactions->extend_reservation($transaction_id);
		echo "<result>$result</result>";
		// echo 'Success';
		}
	}
	
 
}
/* End of file generic_mod.php */
/* Location: ./application/controllers/generic_mod.php */