<?php 
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
include('accesstemplate.php');


class Reports extends AccessTemplate {
 
	public function __construct(){
		parent::__construct();
		$this->load->model('api_prices_model', 'prices');
		$this->load->model('api_sections_model', 'sections');
		$this->load->model('branches_model', 'branches');
		$this->load->model('reports_model', 'reports');
		$this->load->database('default',true); 
		// echo $this->input->ip_address();
		
	}
	
	function get_branches(){
		
			
		// for proper display of XML output on browser
		$this->load->helper('file');
		$this->output->set_header('Content-type: '.get_mime_by_extension('test.xml'));
		echo '<?xml version="1.0"?>';
		echo PHP_EOL;
		
		$result = $this->branches->getall();
		$this->load->dbutil();
			$config = array (
			  'root'    => 'root',
			  'element' => 'row', 
			  'newline' => "\n", 
			  'tab'    => "\t"
			);
			
			echo $this->dbutil->xml_from_result($result, $config);
		
	}
	
	
	function advance_sales_report() 
	{
		  
		$event_id = $this->input->get_post('event_id'); //required
		$event_long_title = $this->input->get_post('event_long_title'); //required
		$date_from = $this->input->get_post('date_from');
		$date_to = $this->input->get_post('date_to'); //required
		$branch = $this->input->get_post('branch_id');
 		$promoter_id = $this->input->get_post('promoter_id');
		
			
		// if(!$event_id){ 
			// $this->promptError('ER:07:01');
		// }else 
		if(!$date_to){ 
			$this->promptError('ER:07:00');
		}elseif(!$event_long_title && !$event_id){ 
			$this->promptError('ER:07:01'); 
		}elseif(!$promoter_id){ 
			$this->promptError('ER:07:03'); 
		}else{
		
			ini_set("memory_limit","3000M");
			// ini_set("max_execution_time", 120);
		 
			$data['starttime'] = microtime(true);
			$data['form_url'] = uri_string();
			$data['branchkey'] = $branch;
 	 
			$data['page_title'] = 'Advance Sale Reports (Per Show)'; 
			$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
			
		 
			// retrieve form filter values: event_id / reports_date
			$data['reports'] = $this->reports->reports_filter('ADVANCE');
			 
			$data["referrer"] = $this->input->get_post("referrer");
			$data["date_validity"] = $this->input->get_post("event_dates");
			
			 
			
			$this->load->view('promoters_asr_report',$data);
			
		}
			 
		 
	}
	
	function top_sales(){
		
		$promoter_id = $this->input->post('promoter_id'); //required

		if(!$promoter_id){
			$this->promptError('ER:07:03'); 
		}else{
			$result = $this->reports->top_sales($promoter_id);
			if($result){
			
				echo json_encode($result);
			}
			
		}
	}
	
	function month_sales(){
		
		$promoter_id = $this->input->post('promoter_id'); //required

		if(!$promoter_id){
			$this->promptError('ER:07:03'); 
		}else{
			$result = $this->reports->month_sales($promoter_id);
			if($result){
			
				echo json_encode($result);
			}
			
		}
	}
	 
	//new reports
	function ticket_list()
    {

        $event_id = $this->input->get_post('event_id'); //required
		$event_long_title = $this->input->get_post('event_long_title'); //required
		$date_from = $this->input->get_post('date_from');
		$date_to = $this->input->get_post('date_to'); //required
		$branch = $this->input->get_post('branch_id');
 		$promoter_id = $this->input->get_post('promoter_id');
		
			
		// if(!$event_id){ 
			// $this->promptError('ER:07:01');
		// }else 
		if(!$date_to){ 
			$this->promptError('ER:07:00');
		}elseif(!$event_long_title && !$event_id){ 
			$this->promptError('ER:07:01'); 
		}elseif(!$promoter_id){ 
			$this->promptError('ER:07:03'); 
		}else{
			
			ini_set("memory_limit","3000M");
			// ini_set("max_execution_time", 120);
		 
			$data['starttime'] = microtime(true);
			$data['form_url'] = uri_string();
			$data['branchkey'] = $branch;
 	 
			$data['page_title'] = 'Ticket List Report'; 
			$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
			
		 
			// retrieve form filter values: event_id / reports_date
			$data['reports'] = $this->reports->reports_filter('ADVANCE');
			  
  			
			$data['result'] = $result =  $this->reports->get_ticket_list();
 			$this->load->view('ticket_list_report',$data);
			
		}	
			
  
	}

	function ticket_attendance()
    {

        $event_id = $this->input->get_post('event_id'); //required
		$event_long_title = $this->input->get_post('event_long_title'); //required
		$date_from = $this->input->get_post('date_from');
		$date_to = $this->input->get_post('date_to'); //required
		$branch = $this->input->get_post('branch_id');
 		$promoter_id = $this->input->get_post('promoter_id');
		
			
		// if(!$event_id){ 
			// $this->promptError('ER:07:01');
		// }else 
		if(!$date_to){ 
			$this->promptError('ER:07:00');
		}elseif(!$event_long_title && !$event_id){ 
			$this->promptError('ER:07:01'); 
		}elseif(!$promoter_id){ 
			$this->promptError('ER:07:03'); 
		}else{
			
			ini_set("memory_limit","3000M");
			// ini_set("max_execution_time", 120);
		 
			$data['starttime'] = microtime(true);
			$data['form_url'] = uri_string();
			$data['branchkey'] = $branch;
 	 
			$data['page_title'] = 'Ticket Attendance Report'; 
			$data['browser_title'] = $this->config->item('site_title') . ' - ' . $data['page_title'];
			
		 
			// retrieve form filter values: event_id / reports_date
			$data['reports'] = $this->reports->reports_filter('ADVANCE');
			  
  			
			$data['result'] = $this->reports->get_ticket_attendance_report();
			$this->load->view('ticket_attendance_report',$data);
			
		}	
			
  
	}

	
}
/* End of file generic_mod.php */
/* Location: ./application/controllers/generic_mod.php */