<?php 
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
include('accesstemplate.php');


class Events extends AccessTemplate {
 
	public function __construct(){
		parent::__construct();
		$this->load->model('api_prices_model', 'prices');
		$this->load->model('api_sections_model', 'sections');
		$this->load->database('default',true); 
			
		// for proper display of XML output on browser
		$this->load->helper('file');
		$this->output->set_header('Content-type: '.get_mime_by_extension('test.xml'));
		echo '<?xml version="1.0"?>';
		echo PHP_EOL;
	}
	
	
	function get(){
		
		$event_id = $this->input->post('event_id');
		
		if(!$event_id){
			$this->promptError('ER:05:03'); 
		}else{
		
			$dbAccess = $this->load->database('default',true);
			// $dbAccess = $this->load->database('market',true);
			$dbAccess->query('set transaction isolation level read uncommitted');
			// $event_hidden = array(5577);

			$dbAccess->select('evt.event_id,	
			evt.event_code,
			evt.event_title,
			evt.event_long_title,
			evt.event_date_time,
			evt.event_description,
			evt.event_image,
			evt.event_image_1,
			evt.event_seatplan_id,
			evt.event_recommended,
			evt.event_description,
			s.seatplan_image,
			evt.event_venue_id,
			v.venue_name,
			evt.event_internet_sales_charge as convenience_charge,
			evt.event_type,
			ec.events_config_ekbarcode_active,
			evt.event_enable_online_selling,
			evt.event_active,
			evt.event_parent,
			evt.event_ticket_types,
			evt.event_hotel,
			evt.event_always_show,
			evt.event_online_registration,
			evt.event_max_ticket, 
			ec.event_display_venue_online,
			ec.event_display_date_online,
			ec.allow_multiple_price,
			ec.events_valid_dates,
			ec.events_date_validity'); 
			$dbAccess->where("evt.event_active",'1');
			$dbAccess->where("evt.event_date_time >= now()"); 
			$dbAccess->join('events_config ec', 'ec.events_config_eventid = evt.event_id', 'left' );
			$dbAccess->join('venues v', 'v.venue_id = evt.event_venue_id', 'left' ); 
			$dbAccess->join('seatplans s', 's.seatplan_id = evt.event_seatplan_id', 'left' );
 			$dbAccess->where("evt.event_id", $event_id); 
			$query = $dbAccess->get('events evt');

		 
			// if(!in_array($event_id,$event_hidden)){
			$data['eventDetails'] = $query->result();
				// print_r($_POST);
				// die(); 
				//display the page
				$this->load->view('event_details_xml_new', $data);
				
		}
	}
 	  
	function list(){
		
		$promoter_id = $this->input->post('promoter_id');
		$search = $this->input->post('search');
		$length = $this->input->post('length');
		$start = $this->input->post('start');
		$order_col = $this->input->post('order_col');
		$order_dir = $this->input->post('order_dir');
		$order_cols = array('event_id','event_image','event_title','event_date_time','venue_name');
		$group = $this->input->post('group');
		
		if(!$promoter_id){
			$this->promptError('ER:07:03'); 
		}else{
				
				 
			$read = $this->load->database('default',true); 
			$read->query('set transaction isolation level read uncommitted');  
			$read->select('e.event_id,	e.event_title, e.event_long_title, e.event_image,e.event_date_time,v.venue_name,event_promoter_id'); 
			$read->join('venues v', 'v.venue_id = e.event_venue_id', 'left' );
			$read->where("e.event_date_time >= now()");  
			$read->where('event_promoter_id', $promoter_id); 
			$read->where("e.event_active", 1); 

			if($search){
				$where = "(event_id = '$search' OR event_title like '%$search%' OR venue_name like '%$search%')"; 
				$read->where($where); 
			}
			
			if($group == 1){
				$read->group_by('event_long_title');
			}
			
			
			if($length && $start){
				$read->limit($length, $start);  
			}
 
			if($order_col >= 0 && $order_dir){ 
			$read->order_by($order_cols[$order_col],$order_dir);
			}else{ 
				$read->order_by('event_id','desc');
			}
			$result = $read->get('events e');
			// echo $read->last_query();
			$this->load->dbutil();
			$config = array (
			  'root'    => 'root',
			  'element' => 'row', 
			  'newline' => "\n", 
			  'tab'    => "\t"
			);
			
			echo $this->dbutil->xml_from_result($result, $config);
		}
	}
	 
	function list_count(){
		
		$promoter_id = $this->input->post('promoter_id');
		if(!$promoter_id){
			$this->promptError('ER:07:03'); 
		}else{
				
				
			$read = $this->load->database('default',true); 
			$read->query('set transaction isolation level read uncommitted');  
			$read->select('count(1) as total_count'); 
			$read->join('venues v', 'v.venue_id = e.event_venue_id', 'left' );
 			$read->where("e.event_date_time >= now()");  
			$read->where('event_promoter_id', $promoter_id); 

			$result = $read->get('events e');
			// echo $read->last_query();
			$this->load->dbutil();
			$config = array (
			  'root'    => 'root',
			  'element' => 'row', 
			  'newline' => "\n", 
			  'tab'    => "\t"
			);
			
			echo $this->dbutil->xml_from_result($result, $config);
		}
	}
	
	 
}
/* End of file generic_mod.php */
/* Location: ./application/controllers/generic_mod.php */