<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class AccessTemplate extends CI_Controller {

	var $objMessage = array (
			0 => 'Successfully processed.',
			1 => 'Invalid access.',
			2 => 'Relay problem but successfully saved data. Please contact MGI.',
			3 => 'Relay problem and error encountered while storing data. Please contact MGI.',
			4 => 'Error encountered while storing data. Please contact MGI.',
			5 => 'Unauthorized access.',
		);
		
	var $errorMessage = array (
		'EC:00' => 'Incomplete or Invalid Parameters.',
		'EC:01' => 'Invalid User Credentials',
		'EC:02' => 'AccessCode Timeout Expired',
		'EC:03' => 'Inactive AccessCode',
		'EC:04' => 'Invalid AccessCode',
		'EC:05' => 'Expired AccessCode & Token',
		'EC:06' => 'Inactive AccessCode & Token',
		'EC:07' => 'Expired AccessCode & Token',
		'EC:08' => 'Expired AccessCode & Token',
	
	);
	
	var $errorCode = array (
			
		//General Error	
		'ER:00:00' => 'General Error: Tech Support Intervention Required',
		
		//Calling funtions with conflicting IP (possible hacking activity)
		'ER:00:01' => 'Invalid Access',
		'ER:00:02' => 'Invalid Session',

		//ER:01 - Errors related to Authentication  parameters
		'ER:01:01' => 'No PartyCode Provided.',
		'ER:01:02' => 'No UseCode Provided',
		'ER:01:03' => 'No AppCode Provided',
		'ER:01:04' => 'No LiveToken Provided',
		'ER:01:05' => 'No Password Provided',
		'ER:01:06' => 'No AccessCode Provided',
		'ER:01:07' => 'No Username/Email Provided',
		'ER:01:08' => 'No DynaToken Provided',
		'ER:01:09' => 'No UserID Provided',
		
		//ER:02 - Errors related to Authentication Protocol
		'ER:02:01' => 'Invalid AppCode',
		'ER:02:02' => 'Invalid Key Pair',
		'ER:02:03' => 'Email/Username does not exist',
		'ER:02:04' => 'AppCode is already used',
		'ER:02:05' => 'Invalid Password',
		'ER:02:06' => 'Invalid AccessCode',
		'ER:02:07' => 'AccessCode is already used',
		'ER:02:08' => 'Inactive Key Pair',
		'ER:02:09' => 'Inactive Access Code',
		'ER:02:10' => 'Invalid Username/Password and PartyCode combination',
		'ER:02:11' => 'Invalid Key Pair [Data Sync]',
		'ER:02:12' => 'Invalid Key Pair [Purchase Mode]',
		'ER:02:13' => 'Inactive Key Pair [Data Sync]',
		'ER:02:14' => 'Inactive Key Pair [Purchase Mode]',
		'ER:02:15' => 'No reset key provided',
		'ER:02:16' => 'Invalid reset key',
		'ER:02:17' => 'No registration key provided',
 		
		//ER:03 Errors related to session expiration
		'ER:03:01' => 'LiveToken Expired',
		'ER:03:02' => 'Appcode Expired',
		'ER:03:03' => 'AccesssCode Expired',
		'ER:03:04' => 'DynaToken Expired',
		
		//ER:04 Errors related to user accounts
		'ER:04:01' => 'Email Already Used',
		'ER:04:02' => 'Mobile Number Already Used',
		'ER:04:03' => 'No Password Provided',
		'ER:04:04' => 'No FirstName Provided',
		'ER:04:05' => 'No LastName Provided',
		'ER:04:06' => 'No BirthDate Provided',
		'ER:04:07' => 'Invalid BirthDate Format',
		'ER:04:08' => 'No Mobile Number Provided',
		'ER:04:09' => 'Invalid Email Format',
		'ER:04:10' => 'No Email Provided',
		'ER:04:11' => 'Invalid Mobile Number Format',
		'ER:04:12' => 'No Username Provided',
		'ER:04:13' => 'Username Already Used',
		'ER:04:14' => 'Invalid Email',
		'ER:04:15' => 'Invalid Username',
		'ER:04:16' => 'No User ID Provided',
		'ER:04:17' => 'Unable to update user beyond your Party',
		'ER:04:18' => 'No new password provided',
		'ER:04:19' => 'No retype password provided',
		'ER:04:20' => 'The new password does not match with retyped password',
		'ER:04:21' => 'No Customer ID Provided',
		'ER:04:22' => 'Customer has no Transactions yet',
		'ER:04:23' => 'Invalid Customer ID',
		'ER:04:24' => 'No Address Provided',
		'ER:04:25' => 'No TicketID Provided',
		'ER:04:26' => 'Invalid TicketID',
		'ER:04:27' => 'Account does not exist',
		'ER:04:28' => 'No Contact person in case of emergency provided',
		'ER:04:29' => 'No Relationship to the contact person in case of emergency provided',
		'ER:04:30' => 'No address of the contact person in case of emergency provided',
		'ER:04:31' => 'No number of the contact person in case of emergency provided',
		'ER:04:32' => 'No gender provided',
		'ER:04:33' => 'No Country provided',
		'ER:04:34' => 'No Region provided',
		'ER:04:35' => 'No City provided',
		'ER:04:36' => 'No Old Password provided',
		'ER:04:37' => 'Invalid Old Password provided',
		'ER:04:38' => 'Invalid Username/Email provided',
		'ER:04:39' => 'No Reset url provided',
		'ER:04:40' => 'Invalid registration key  provided',
		'ER:04:41' => 'Account not verified',
		'ER:04:42' => 'No status provided',
		
		
	
		
		
		
		//ER:05 Errors related to generic function parameters
		'ER:05:01' => 'No Seat Plan ID Provided',
		'ER:05:02' => 'Invalid Seat Plan ID',
		'ER:05:03' => 'No Event ID Provided',
		'ER:05:04' => 'Invalid Event ID',
		'ER:05:05' => 'No  Section ID Provided',
		'ER:05:06' => 'Invalid Section ID',
		'ER:05:07' => 'No Price ID Provided',
		'ER:05:08' => 'Invalid Price ID',
		'ER:05:09' => 'No events for today',
		'ER:05:10' => 'Invalid PriceID and SectionID',
		'ER:05:11' => 'No Sold Seats',
		'ER:05:12' => 'No Reserved Seats',
		'ER:05:13' => 'No Selected Seats',
		'ER:05:14' => 'No Open Seats',
		'ER:05:15' => 'No venue ID provided',
		'ER:05:16' => 'Venue ID does not exist',
		'ER:05:17' => 'Event not found',
		'ER:05:18' => 'No Type Provided',
		'ER:05:19' => 'No Category ID Provided', 
		'ER:05:20' => 'No Session ID Provided', 
		'ER:05:21' => 'No Name Provided', 
		'ER:05:22' => 'No Subject Provided', 
		'ER:05:23' => 'No Message Provided', 
		'ER:05:24' => 'No Email Provided', 
		'ER:05:25' => 'No Qr Code Provided', 
		'ER:05:26' => 'No Customer ID Provided', 
 		
		
		
		
		
		
		
		
		//ER:06 Errors related to Purchase Mode
		'ER:06:00' => 'Invalid Parameters.',
		'ER:06:01' => 'No Data Message Provided',
		'ER:06:02' => 'Invalid Data Message',
		'ER:06:03' => 'No Reference Number Provided',
		'ER:06:04' => 'Invalid Reference Number Provided',
		'ER:06:05' => 'No Amount Provided', 
		'ER:06:06' => 'Amount paid did not match the transaction amount',
		'ER:06:07' => 'Invalid Transaction Information', 
		'ER:06:08' => 'No PayCode Provided', 
		'ER:06:09' => 'No CardNumber Provided', 
		'ER:06:10' => 'No Total Amount Provided', 
		'ER:06:11' => 'No PayMode Provided', 
		'ER:06:12' => 'Maximum of 10 tickets is allowed', 
		'ER:06:13' => 'Invalid PayCode Provided', 
		'ER:06:14' => 'Total Amount did not match the total ticket prices', 
		'ER:06:15' => 'No Transaction ID provided', 
		'ER:06:16' => 'No System row provided', 
		'ER:06:17' => 'No System column provided', 
		'ER:06:18' => 'No Seat Row provided', 
		'ER:06:19' => 'No Seats provided', 
		'ER:06:20' => 'No Session ID provided', 
		'ER:06:21' => 'Max ticket per event reached', 
		'ER:06:22' => 'No Ticket type provided', 
		'ER:06:23' => 'No Quantity provided', 
		'ER:06:24' => 'You have reached the maximum amount of seats to purchase.', 
		'ER:06:25' => 'No Section Type provided', 
		'ER:06:26' => 'Invalid ticket details provided', 
		'ER:06:27' => 'QR Code provided is already used', 
		'ER:06:28' => 'No Reservation Code provided', 
		'ER:06:29' => 'Selection of multiple sections are not allowed for this event.', 
  	
		//ER:06 Errors related to Promoters Portal
		'ER:07:00' => 'No Date provided',
		'ER:07:01' => 'No Event id provided',
		'ER:07:02' => 'No days provided',  
		'ER:07:03' => 'No promoter ID provided',  
		'ER:07:04' => 'No OTP provided',  
		'ER:07:05' => 'No User ID provided',  
  	
	);
		

	
	
	var $validMethod = array("GET","POST");
	var $api_table = 'generic_formdata';
	
	var $insertID = 0;
	var $__status = 0;
	var $ip_addr = '';
	
	var $callparam = array();

	public function __construct() {
	
		parent::__construct();
		 
	}
	
	public function index()
	{
		$retcode = 1;
		set_status_header(500);
		$data["retcode"] = $retcode;
		$data["message"] = $this->objMessage[$retcode];
		$data["ref"] = false;
		$this->load->view("output_xml", $data);
	}
	
		
	function promptError($errorCode){
	
		$data['errorCode'] = $errorCode;
		$data['errorMessage'] = $this->errorCode[$errorCode];
		$this->load->view("error_code_xml", $data);
		
	
	}
			
	//*************************************************
	
	//Returns TRUE if the $appcode or $livetoken is already INACTIVE or EXPIRED
		function checksessionexpiration($appcode=false,$livetoken=false){
	
		$status = false;

				//Get the latest appcode row
				$dbAccess = $this->load->database('default',true);
				
				$dbAccess->select('api_time_issued,api_duration,api_gen_active,api_livetoken');
				$dbAccess->where("api_apppcode", $appcode);
				$dbAccess->where("api_livetoken", $livetoken);
				$dbAccess->order_by('api_session_id','desc');
				$dbAccess->limit(1);
				
				$query = $dbAccess->get('api_sessions');
				$row = $query->row_array();	
				
				if($row){
				$livetoken = $row['api_livetoken'];
				$duration = $row['api_duration'];// in minutes; 
				$issuetime =  $row['api_time_issued'];//time when appcode was issued
				$active = $row['api_gen_active'];
				
				
						//Check if still active
						if($active == 1)
							{
							//Declare 
							date_default_timezone_set('Asia/Manila');
							$endtime = new DateTime($row['api_time_issued']);
							$endtime->modify("+" .$duration ." minutes");
							
							$endtime = $endtime->format('Y-m-d H:i:sP');

										
							
									//Compare $endtime to Current date
									if ($endtime < $this->getcurrentdatetime()){
										//expired
										$status = "expired";
										
										//Deactivate
										$isdeactivated = false;
										$isdeactivated = $this->session_deactivate($appcode,$livetoken);
									
										if (!$isdeactivated){
										echo 'Unable to deactivate an appcode/livetoken';
										}
									}
									else
									{
									$status = False;
									}
							}
							elseif($active == 0){
								$status = "expired";						
							}

				}			
				else{
				echo 'nonexistent';
				}
			
		return 	$status;												
		}

		function checkTokenStatus($appcode=false,$livetoken=false){
	
		$status = false;

				//Get the latest appcode row
				$dbAccess = $this->load->database('default',true);
				
				$dbAccess->select('api_time_issued,api_duration,api_gen_active,api_livetoken');
				$dbAccess->where("api_apppcode", $appcode);
				$dbAccess->where("api_livetoken", $livetoken);
				$dbAccess->order_by('api_session_id','desc');
				$dbAccess->limit(1);
				
				$query = $dbAccess->get('api_sessions');
				$row = $query->row_array();	
				
				if($row){
				$livetoken = $row['api_livetoken'];
				$duration = $row['api_duration'];// in minutes; 
				$issuetime =  $row['api_time_issued'];//time when appcode was issued
				$active = $row['api_gen_active'];
				
				
						//Check if still active
						if($active == 1)
							{
							//Declare 
							date_default_timezone_set('Asia/Manila');
							$endtime = new DateTime($row['api_time_issued']);
							$endtime->modify("+" .$duration ." minutes");
							
							$endtime = $endtime->format('Y-m-d H:i:sP');

										
							
									//Compare $endtime to Current date
									if ($endtime < $this->getcurrentdatetime()){
										//expired
										$status = "expired";
										
										//Deactivate
										$isdeactivated = false;
										$isdeactivated = $this->session_deactivate($appcode,$livetoken);
									
										if (!$isdeactivated){
										echo 'Unable to deactivate an appcode/livetoken';
										}
									}
									else
									{
									$status = False;
									}
							}
							elseif($active == 0){
								$status = "expired";						
							}

				}			
				else{
				$status = 'nonexistent';
				}
			
		return 	$status;												
		}

		
			//Deactivates an $appcode/$livetoken
		function session_deactivate($appcode=false,$livetoken=false){
			$success = false;
			$dbAccess = $this->load->database('live',true);
			
						// update api_gen_active from 1 to 0
						$data = array('api_gen_active' => 0);
						$dbAccess->where('api_apppcode',$appcode);
						$dbAccess->update('api_sessions', $data); 	
						
						if($dbAccess->affected_rows() > 0) { 
							$success = true;
						}
						
			return $success;
		}
		

	//Current Time
			function getcurrentdatetime(){
			//Set Current Date
			$date = new DateTime(null, new DateTimeZone('Asia/Manila'));
			return $date = $date->format('Y-m-d H:i:sP');
		}
			
//Checks the existence of $appcode && $livetoken ..Returns TRUE if exists
			function validatesession($appcode=false,$livetoken=false){
				$exists = false;
				
				$dbAccess = $this->load->database('default',true);
				
				$dbAccess->select("api_session_id");
				$dbAccess->where("api_apppcode", $appcode);
				$dbAccess->where("api_livetoken",  $livetoken);
				$query = $dbAccess->get('api_sessions');

					if ($query->num_rows() > 0){
					$exists = True;
					}
					
				return $exists;
			}

				//Returns TRUE if date format = YYYY-MM-DD
			//sample..	2011-02-14
			function isValidDate($date){
				if(preg_match("/^(\d{4})-(\d{2})-(\d{2})$/", $date, $matches))
				{
					if(checkdate($matches[2], $matches[3], $matches[1]))
					{
						return true;
					}
				}
			}
			
						
			//checks mobile number if already exist
			function check_mobile($mobileNumber=false){
			$exist = false;
			$dbAccess = $this->load->database('default',true);
			$dbAccess->where("api_customer_mobile", $mobileNumber);
			$query = $dbAccess->get('api_party_customers');
				
			if ($query->num_rows() > 0)
				{
				$exist = true;
				}
			return $exist;
			}

	
	
}



