<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
include('accesstemplate.php');

// class Transaction extends CI_Controller {
class Ipay88 extends AccessTemplate{


	
	public function __construct()
	{
		parent::__construct();
		$this->load->model('api_transaction_model', 'transaction');
		$this->load->model('api_sections_model', 'sections');
		$this->load->model('api_payment_types_model', 'payment_types');
		$this->load->model('api_payments_model', 'payments');
		$this->load->model('api_branches_model', 'branches');
		$this->load->model('api_bcode_model', 'bcode');
		$this->load->model('api_tickets_model', 'tickets');
		$this->load->model('api_prices_model', 'prices');
		$this->load->model('api_events_model', 'events');
		$this->load->model('api_mobilenum_model', 'mobilenum');
		$this->load->model('api_ip_model', 'ip');
		$this->load->model('api_authentication_model', 'authentication');
		$this->load->model('api_customers_model', 'customers');
		$this->load->model('admin_model', 'admin');

		$this->load->database('default',true);
		// $this->db->query('set transaction isolation level read uncommitted');
	}	
	
	function index(){
		echo "IPAY88 - SMTICKETS API";
		die();
	}
	
	function prep_signature($merchant_key, $merchant_code, $payment_id, $ref_no, $total_amount, $currency, $status)
	{
 		return base64_encode(sha1($merchant_key . $merchant_code . $payment_id . $ref_no . $total_amount . $currency . $status, true));
	}

	function backend_response($paycode = false, $merchant_key = false)
	{
	 
		$merchantcode = $this->input->post('MerchantCode');
		$payment_id = $this->input->post('PaymentId');
		$referenceNumber = $this->input->post('RefNo');
		$amount = $this->input->post('Amount');
		$currency = $this->input->post('Currency');
		$remark = $this->input->post('Remark');
		$transid = $this->input->post('TransId');
		$authcode = $this->input->post('AuthCode');
		$status = $this->input->post('Status');
		$errdesc = $this->input->post('ErrDesc');
		$signature = $this->input->post('Signature');
		$ThreeDFlag = $this->input->post('ThreeDFlag');

	
		// echo 'merchantcode: ' . $merchantcode . '<br>';
		// echo 'payment_id: ' . $payment_id . '<br>';
		// echo 'refno: ' . $refno . '<br>';
		// echo 'amount: ' . $amount . '<br>';
		// echo 'currency: ' . $currency . '<br>';
		// echo 'remark: ' . $remark . '<br>';
		// echo 'transid: ' . $transid . '<br>';
		// echo 'authcode: ' . $authcode . '<br>';
		// echo 'status: ' . $status . '<br>';
		// echo 'errdesc: ' . $errdesc . '<br>';
		// echo 'signature: ' . $signature . '<br>';
		
		// echo '<pre>';
		// print_r($_POST);
		// echo '</pre>';
		// die();
		
		 
		if(!$merchant_key ) die();
		
		$amount = str_replace(",","",$this->input->post('Amount'));
 		$amount_ = number_format($amount, 2, '', '');
		$sig = $this->prep_signature($merchant_key, $merchantcode, $payment_id, $referenceNumber, $amount_, $currency, $status);
		 
		 
		//check signature
	  	if($sig != $signature){ 
 			// redirect('transactions/failed'); 
			die();
			
 		}else{
			

			// bdo (success)
			if ($status == 1)
			{ 
				 
				//finalize transaction  
				$cardNumber =  'xxxxxxxxxxxxxxx'; 
				$expiration =  'x'; 
				// $card_type =  'xx';
				$others =  'xxx'; 
		
		
		
		
				// $content = http_build_query (array (
				// 'referencenumber' => $referenceNumber,
				// 'amount' =>$amount_,
				// 'paycode' =>$paycode,
				// 'cardnumber' =>$cardNumber,
				// 'expiration' =>$expiration,
				// 'card_type' =>$ThreeDFlag,
				// 'others' =>$others,
				
				// ));

				// $context = stream_context_create (array (
					// 'http' => array (	 
					// 'method' => 'POST',
					// 'header' => "Connection: close\r\n".
					// "Content-Type: application/x-www-form-urlencoded\r\n",
					// 'content' => $content,
					// )
				// ));
				
				// $url_base = $this->config->item('url_base');
				// $xml = file_get_contents("$url_base/transaction/payment_done3A", null, $context);
				
				$this->payment_done3A_br($referenceNumber,$amount_,$paycode,$cardNumber,$expiration,$ThreeDFlag,$others);
			
			}else{ 
				die();
				// redirect('failed');
			
			}
			 
		}
		 
		
	}

	function payment_done3A_br($referenceNumber,$amount,$paycode,$cardNumber,$expiration,$card_type,$others)
	{ 

		//order details
		// $referenceNumber =  $this->input->post("referencenumber"); 
		// $amount =  $this->input->post("amount"); 
		// $paycode =  $this->input->post("paycode"); 
		// $cardNumber =  $this->input->post("cardnumber"); 
		// $expiration =  $this->input->post("expiration"); 
		// $card_type =  $this->input->post("card_type"); 
		// $others =  $this->input->post("others"); 
 		 
		
		// echo '<pre>';
		// print_r($_POST);
		// echo '</pre>';
		// die();
		
		 
			if(!$cardNumber){
			
				$cardNumber = 'xxxxxxxxxxxxxxxx';
			}
			// elseif(!$cardNumber){
			// $this->promptError('ER:06:09');
		// }
		 
		  
		 
				// $app_result = $this->transaction->verify_app_token($appCode, $liveToken);
				
				// if($app_result == 'expired'){ 
				// $this->promptError('ER:03:01');
				// }elseif($app_result == 'inactive'){ 
					// $this->promptError('ER:02:13');
				// }elseif($app_result == 'invalid'){ 
					// $this->promptError('ER:02:11'); 
				// }else{
				
				 
					$ref = explode("-", $referenceNumber);  
					if($ref[0] != 99){
						$this->promptError('ER:06:04'); 
					}else{
					 
						$transaction_id = $ref[1];	 
						$this->log_details("payment_done3A_br","" ,$transaction_id, "","");
						// default value
						$pid = 0;
						$eid = 0;
						
						//check if the ticket is reserved or selected
						$status = $this->transaction->get_ticket_status($transaction_id);
						
						
						if($status == 'reserved'){
							$selected_tickets = $this->tickets->get_reserved_tickets($transaction_id);
						}elseif($status == 'selected'){
							$selected_tickets = $this->tickets->get_selected_tickets($transaction_id);
						}else{
							die("RECEIVEOK");
						}
						
						// identify tickets and the price_id/event_id just in case user opened events with new tab
						
						// echo '<pre>';
						// print_r($selected_tickets);
						// echo '</pre>';
						// die();
						foreach ($selected_tickets as $ticket) {
							$pid = $ticket->ticket_price_id;
							$eid = $ticket->ticket_event_id;
						}

						// check if valid access
						if (($pid > 0) && ($eid > 0)) { 
							// transaction tickets has valid event_id and price_id info
						 

							// identify price id from tickets
							$data['price'] =  $this->prices->get($pid);
							
							// identify event id from tickets
							$data['event'] = $this->events->get($eid);
							
							// get total amount
							$ticket_count = count($selected_tickets); 
							// $total_amount = $ticket_count * $data['price']->price_price;
							
							//korewa
							// if ($selected_tickets[0]->ticket_type_discount_type == 'Amount'): 
							// $price = ceil($selected_tickets[0]->price_price - $selected_tickets[0]->ticket_type_discount);  
							// elseif ($selected_tickets[0]->ticket_type_discount_type == 'Percentage'): 
							// $price = ceil($selected_tickets[0]->price_price - (($selected_tickets[0]->price_price * $selected_tickets[0]->ticket_type_discount)/100)); 
							// endif; 
							
							
							// echo '<pre>';
							// print_r($selected_tickets);
							// echo '</pre>';
							// die();
							
							
							
							
							// $total_amount = $ticket_count * $price;
							
							
							$total_amount = 0;
							foreach($selected_tickets as $x){
							
							if ($x->ticket_type_discount_type == 'Amount'): 
							
								$price = ceil($x->price_price - $x->ticket_type_discount);  
								$total_amount = $total_amount + $price;
							elseif ($x->ticket_type_discount_type == 'Percentage'): 
							
								$price = ceil($x->price_price - (($x->price_price * $x->ticket_type_discount)/100)); 
								$total_amount = $total_amount + $price;
							endif; 
							 
							}
							
							
							
							
							$orig_amount_raw = $total_amount + ($data['event']->event_internet_sales_charge * $ticket_count);
							$orig_amount = number_format($orig_amount_raw, 2, '', '');
							if ($orig_amount != $amount)
							{
								//error message
								//Amount paid did not match the transaction amount
								echo $orig_amount . ' ' . $amount;
								$this->promptError('ER:06:06'); 
								
							}
							else
							{
								$payment_type = $this->payment_types->get_by_code($paycode);
								if(!$payment_type){
								//invalid paycode
								$this->promptError('ER:06:13');
								}else{ 
									$this->transaction->paid_online2($transaction_id,$status); // mark the transaction as paid_online
									
									$barcode = strtoupper(hash("crc32", $transaction_id));
									
									$this->transaction->add_barcode($transaction_id,$barcode); //Add Barcode
									
									$this->payments->add($transaction_id, $payment_type->payment_type_id, $orig_amount_raw); // add total payment
									// $card_num = $this->input->get("CardNum");
									$this->payments->add_cardnum($transaction_id,$cardNumber,$expiration, $card_type);
									
									$charge_amount = ($data['event']->event_internet_sales_charge * $ticket_count);
									if ($charge_amount > 0) {
										$this->payments->add_convenience_charge_details($transaction_id, $ticket_count, $charge_amount); // add convenience charge details
									}
									$this->payments->add_totalpay($transaction_id, $payment_type->payment_type_id, $orig_amount_raw, 'total'); // add total amount
									$data['payment_type'] = $payment_type->payment_type_code; // payment type
									
									// add receipt numbers
									$or_number = 0;
									$transaction = $this->transaction->get_for_bcode($transaction_id);
									if($transaction){ 
										// OR number  &&  $transaction->customer_id != 82476
										$event_internet_sales_charge = $data['event']->event_internet_sales_charge;
										if (is_numeric($event_internet_sales_charge) && ($event_internet_sales_charge > 0))
										{
											$or_number = $this->branches->get_last_or_number($transaction->transaction_branch_id);
											$this->transaction->update_receipt_number($transaction_id, $or_number);
										}
										else 
										{
											$or_number = 0;
										}
										
															
										foreach ($selected_tickets as $ticket)
										{
											// AR number
											$ar_number = $this->branches->get_last_receipt_number($transaction->transaction_branch_id);
											$this->tickets->update_acknowledgment_receipt($ticket->ticket_id, $ar_number);
											
											
										}
										
									
										//check events_config if bcode is active
										$useBCODE = $this->bcode->isActive($eid);
							
										if ($useBCODE) {
											$d_or_number = sprintf("%06d", $or_number);
											$msg = "OR No: $d_or_number RefNum: $transaction_id Thank you for buying through SM Tickets Online.";
											
											$arrMobileNum = $this->mobilenum->lookup($transaction->customer_mobile);
											if ($arrMobileNum['isLocal']) {
												$carrier = $arrMobileNum['bCODE'];
												$localmobilenum = $arrMobileNum['CountryCode'].$arrMobileNum['MobileNum'];
											} 
											else {
												$localmobilenum = $arrMobileNum['MobileNum'];
											}
											// $sendSMS = $this->session->userdata('sendSMS');
											$sendSMS = '';
											
											if (empty($sendSMS)) {
												$carrier = '';
												$msg = '';
											}
											
											$querydata = array(
												'user' => $this->config->item('bcode_user'),
												'password' => $this->config->item('bcode_pass'),
												'application' => $this->config->item('bcode_app'),
												'mobile' => $localmobilenum,
												'carrier' => $carrier,
												'message' => $msg,
											);
											
											
								
											$xmlResult = $this->extension->__getbcode($querydata);
											if (is_array($xmlResult)) {
												if (isset($xmlResult['Result']) && ($xmlResult['Result'] == 0)) {
													$insertdata = array(
														'bcode_transaction_id' => $transaction_id,
														'bcode_value' => $xmlResult['bCODE'],
														'bcode_sendSMS' => $localmobilenum,
														'bcode_carrier' => $carrier,
													);
													$write = $this->load->database('live',true);
													$write->insert('bcode', $insertdata); 
												}
											}
										}
 
									
									}	
									// $postrequest = @$this->extension->post2mci($this->session->userdata('tid'));
									// $postrequest = @$this->extension->post2mci($transaction_id);
									// $this->session->unset_userdata('sendSMS');
									// redirect("transaction/payment_receipt/$transaction_id/$hash/$pid/$eid");
									
									// get data
									$data['charge_amount'] = $charge_amount; 
									$data['transaction_id'] = $transaction_id; 
									$data['or_receipt'] = $this->transaction->get_or($transaction_id); 
									$data['trans_date'] = date("Y-m-d H:i:s");
									$data['amount'] = $amount;
									$data['tickets'] = $this->tickets->get_paid_online_tickets($transaction_id);
									
									//$this->tag_blink($transaction_id);
									$this->tag_as_used($transaction_id);
									
									$this->add_to_historical($transaction_id);
									
									$this->log_details("done",$eid ,$transaction_id, ($amount/100), print_r($data['tickets'], true));
									
									// $this->load->view("result_xml", $data);
									//$this->customers->send_payment_notification($appCode,$liveToken,$accessCode,$dynaToken,$transaction_id);
									
									echo "RECEIVEOK";
								}
							}
							 
						} else {
							//Invalid transaction information.'
							$this->promptError('ER:06:07'); 
						}	
					}
				// }	
	}

	function tag_as_used($refno){

		$result = false;
		$dbAccess = $this->load->database('default',true);
			
			$data = array(
			'qr_status' => "used",
			'qr_datetime' =>  date("Y-m-d H:i:s"),
			);

			$dbAccess->where('qr_status', 'pending');
			$dbAccess->where('qr_transaction_id', $refno);
			
			$dbAccess->update('qrcode', $data); 			
			$ticket_count = $dbAccess->affected_rows();
	

		// header ("Content-Type:text/xml");
		// echo "<root>";
		// if($ticket_count > 0){
			// echo "<result>success</result>";
		// }else{
			// echo "<result>failed</result>";
		// }		
		// echo "</root>";
			
	}
	
	
	function tag_blink($ref = false){
		$dbAccess = $this->load->database('pincode',true);
		if($ref){
	
		$sql = "update pin_codes p set p.pin_status = 'used', p.pin_refno =?
			where p.pin_status = '0'
			and p.pin_set = 'blink'
			limit 1";  
		$dbAccess->query($sql, array($ref));
		}
	
	}
	
	function log_details($type = false,$event_id = false, $transID = false, $totalAmount = false, $description = false){
		$now = date("Y-m-d H:i:s");
 		$dbAccess = $this->load->database('pincode',true);
		$sql = "INSERT INTO `logs` (`log_type`, `log_event_id`, `log_transaction_id`, `log_total_amount`, `log_description`, `log_datetime`) VALUES ('$type', '$event_id','$transID','$totalAmount', '$description', '$now' );";  
		$dbAccess->query($sql);		
	}
	
	function add_to_historical($transaction_id = false){
		
		if(!$transaction_id) die('Unknown Error Encountered');
		
		//insert into historical table 
		$this->admin->copy_tickets($transaction_id, 'paid_online');
		$this->admin->copy_transactions($transaction_id,'paid_online');
		$this->admin->copy_payments($transaction_id);
		$this->admin->copy_charges($transaction_id);
		
		
	}
	
}