<?php 

/* 
 -- =============================================
-- Author:			<Emmanuel Gabion>
-- Create date: 	<11/5/2013>
-- Last Modified: 	<11/5/2013>
-- Description:		< Additional generic Functions Requested for optimal database usage>
-- =============================================
  */
 
if ( ! defined('BASEPATH')) exit('No direct script access allowed');
include('accesstemplate.php');

// class Generic_mod extends CI_Controller {
class Generic_mod extends AccessTemplate {
	
	public function __construct(){
		parent::__construct();
		$this->load->model('api_seatplans_model', 'seatplans');
		$this->load->model('api_events_model', 'events');
		$this->load->model('api_sections_model', 'sections');
		$this->load->model('api_transaction_model', 'transaction');
		$this->load->model('api_events_model', 'events');
		$this->load->model('api_prices_model', 'prices');
		$this->load->model('api_tickets_model', 'tickets');
		$this->load->model('api_payments_model', 'payments');
		$this->load->model('api_ticket_types_model', 'ticket_types');
		$this->load->model('api_ip_model', 'ip');
		$this->load->model('api_ticket_layouts_model', 'ticket_layouts');
		$this->load->model('api_bcode_model', 'bcode');
		$this->load->model('api_promo_codes_model', 'promo');
		$this->load->model('api_authentication_model', 'authentication');
		$this->load->database('default',true); 
	}
	
	function template() {
			
		// the date today
		$today = date("Y-m-d");
		$today = '2013-02-11';
		
		
		
		$dbAccess->select("
				evt.event_code
				, evt.event_title
				, evt.event_long_title
				, evt.event_date_time
			");
			
		$dbAccess->where("evt.event_date_time > '$today 00:00:00'");
		$dbAccess->where("evt.event_date_time < '$today 23:59:59'");
		$dbAccess->where("evt.event_active", 1);
		$query = $dbAccess->get('events evt');
	
	
		$this->load->dbutil();
		
		$config = array (
			  'root'    => 'root',
			  'element' => 'sections', 
			  'newline' => "\n", 
			  'tab'    => "\t"
			);

			
		$xmloutput = $this->dbutil->xml_from_result($query, $config);
		echo $xmloutput;

	}
	

	var $errorMessage = array (
		'ER:00' => 'Incomplete/Invalid Parameters.',
		'ER:01' => 'Invalid access.',
		'ER:02' => 'Inactive KEY',
		'ER:04' => 'In',
		'ER:05' => 'Relay problem and error encountered while storing data. Please contact MGI.',
		'ER:06' => 'Relay problem and error encountered while storing data. Please contact MGI.',
		);
	
	//============================== D A T A S Y N C  M O D E  =======================================
	//======= P a r t y L i n e   A u t h e n t i c a t i o n   P r o t o c o l =======
	 			 

		/* 	GetActiveEventsFullMarket_NoDesc()||CREATE DATE: <11/5/2013>||LAST MODIFIED: <11/5/2013>
			Description: List of full details of Active events from 'market' database minus the event description */
	
	// Get_Active_Events_Full_Market_NoDesc() 	
	function GetActiveEventsFullMarket_NoDesc(){
		
		$appcode = $this->input->get_post('appcode');
		$livetoken = $this->input->get_post('livetoken');
		$event_id = $this->input->get_post('eventid');
		$event = $this->input->get_post('event');
		
		if(!$appcode){
			$this->promptError('ER:01:03');
		}elseif(!$livetoken){
			$this->promptError('ER:01:04');
		}else{
			
					$sessionStatus = $this->checkTokenStatus($appcode,$livetoken);
					
					if($sessionStatus == "nonexistent"){
					$this->promptError('ER:02:02');
					}elseif($sessionStatus == "expired"){
					$this->promptError('ER:03:01');
					}else{	

					$dbAccess = $this->load->database('default',true);

					$dbAccess->select('evt.event_id,	
					evt.event_code,
					evt.event_title,
					evt.event_long_title,
					evt.event_date_time,
					evt.event_description,
					evt.event_image,
					evt.event_image_1,
					evt.event_seatplan_id,
					evt.event_recommended,
					s.seatplan_image,
					evt.event_venue_id,
					evt.event_internet_sales_charge as convenience_charge,
					evt.event_type,
					ec.events_config_ekbarcode_active,
					evt.event_active,
					evt.event_ticket_types,
					evt.event_hotel,
					evt.event_always_show,
					evt.event_online_registration');
						
				
					$dbAccess->where("evt.event_active",'1');
					$dbAccess->where("evt.event_date_time >= now()");

					$dbAccess->join('events_config ec', 'ec.events_config_eventid = evt.event_id', 'left' );

					$dbAccess->join('seatplans s', 's.seatplan_id = evt.event_seatplan_id', 'left' );

					if($event_id){
						$dbAccess->where("evt.event_id", $event_id);
					}

					if($event){
					$dbAccess->like('evt.event_long_title', $event);
					}

					$query = $dbAccess->get('events evt');

				
					$data['eventDetails'] = $query->result();
			
				//display the page
				$this->load->view('event_details_xml_NoDesc', $data);
			 }
		 }

		}
		/* End of GetActiveEventsFullMarket_NoDesc() */
		
		
		
		/* 	GetActiveEventsbyType()||CREATE DATE: <11/5/2013>||LAST MODIFIED: <11/5/2013>
		Description: List of basic details of Active events from 'market' database BY EVENT TYPE and minus event description */
		
		// Get_Active_Events_by_Type()
		function GetActiveEventsbyType(){
		
			$appcode = $this->input->get_post('appcode');
			$livetoken = $this->input->get_post('livetoken');
			$event_type = $this->input->get_post('type');
			
			if(!$appcode){
				$this->promptError('ER:01:03');
			}elseif(!$livetoken){
				$this->promptError('ER:01:04');			
			}elseif(!$event_type){
				$this->promptError('ER:05:18');
			}else{
				
					$sessionStatus = $this->checkTokenStatus($appcode,$livetoken);
					
					if($sessionStatus == "nonexistent"){
					$this->promptError('ER:02:02');
					}elseif($sessionStatus == "expired"){
					$this->promptError('ER:03:01');
					}else{	

						$dbAccess = $this->load->database('market',true);


						$queryString = "SELECT 
								evt.event_id
								,evt.event_code
								, evt.event_title
								, evt.event_long_title
								, evt.event_date_time
								, evt.event_internet_sales_charge as convenience_charge
								, ec.events_config_ekbarcode_active
								FROM (`events` evt) 
								LEFT JOIN `events_config` ec ON `ec`.`events_config_eventid` = `evt`.`event_id` 
								LEFT JOIN `seatplans` s ON `s`.`seatplan_id` = `evt`.`event_seatplan_id` 
								WHERE `evt`.`event_active` = 1 and event_date_time >= now() and `evt`.event_type = '$event_type'";
										
								$query = $dbAccess->query($queryString);
								$data['eventDetails'] = $query->result();

						//display the page
						$this->load->view('active_events_xml', $data);
						
					}
			}
		}
		/* End of GetActiveEventsbyType() */
		

		/* 	GetSchedbyEventID()||CREATE DATE: <11/5/2013>||LAST MODIFIED: <11/5/2013>
			Description: List of event id and their event date from 'market' database BY event id*/
		
		// Get_Sched_by_EventID()
		function GetSchedbyEventID(){
	
		$appcode = $this->input->get_post('appcode');
		$livetoken = $this->input->get_post('livetoken');
		$event_id = $this->input->get_post('eventid');
		
		if(!$appcode){
			$this->promptError('ER:01:03');
		}elseif(!$livetoken){
			$this->promptError('ER:01:04');			
		}elseif(!$event_id){
			$this->promptError('ER:05:03');
		}else{
			
					$sessionStatus = $this->checkTokenStatus($appcode,$livetoken);
					
					if($sessionStatus == "nonexistent"){
					$this->promptError('ER:02:02');
					}elseif($sessionStatus == "expired"){
					$this->promptError('ER:03:01');
					}else{	

					$dbAccess = $this->load->database('market',true);


					$queryString = "SELECT 
							evt.event_id
							, evt.event_date_time
							FROM (`events` evt) 
							LEFT JOIN `events_config` ec ON `ec`.`events_config_eventid` = `evt`.`event_id` 
							LEFT JOIN `seatplans` s ON `s`.`seatplan_id` = `evt`.`event_seatplan_id` 
							WHERE `evt`.`event_active` = 1 and event_date_time >= now()  and `evt`.`event_id` =  '$event_id' ";
				
							$query = $dbAccess->query($queryString);
							$data['eventDetails'] = $query->result();

					//display the page
					$this->load->view('active_events_sched', $data);
					
				}
		}
	}
		/* End of GetSchedbyEventID() */
	
	
		/* 	GetPriceSectionbyID()||CREATE DATE: <11/5/2013>||LAST MODIFIED: <11/5/2013>
			Description: List of Prices and their Sections by Price ID */
		// Get_Price_Section_by_ID()
		function GetPriceSectionbyID(){
			
				$price_id = $this->input->get_post('priceid');
				$appcode = $this->input->get_post('appcode');
				$livetoken = $this->input->get_post('livetoken');
				
				if(!$appcode){
					$this->promptError('ER:01:03');
				}elseif(!$livetoken){
					$this->promptError('ER:01:04');
				}elseif(!$price_id){
					$this->promptError('ER:05:07');
				}else{
				
					$sessionStatus = $this->checkTokenStatus($appcode,$livetoken);
					
					if($sessionStatus == "nonexistent"){
					$this->promptError('ER:02:02');
					}elseif($sessionStatus == "expired"){
					$this->promptError('ER:03:01');
					}else{	
					
				
						$data['price'] = $this->prices->get($price_id);
							$this->load->view('price_xml', $data);
							
					}
				}

			}
		/* End of GetPriceSectionbyID() */
	
		/* 	GetSectionByID()||CREATE DATE: <11/5/2013>||LAST MODIFIED: <11/5/2013>
			Description: List of Sections and their Seats by Section ID */
		// Get_Section_By_ID()
		function GetSectionByID(){

			$appcode = $this->input->get_post('appcode');
			$livetoken = $this->input->get_post('livetoken');
			$section_id = $this->input->get_post('id');
			
			if(!$appcode){
				$this->promptError('ER:01:03');
			}elseif(!$livetoken){
				$this->promptError('ER:01:04');
			}elseif(!$section_id){
				$this->promptError('ER:05:05');
			}else{

				$sessionStatus = $this->checkTokenStatus($appcode,$livetoken);
					
					if($sessionStatus == "nonexistent"){
					$this->promptError('ER:02:02');
					}elseif($sessionStatus == "expired"){
					$this->promptError('ER:03:01');
					}else{	

						$data['section'] = $this->sections->get($section_id);

						//display the page
						$this->load->view('section_info', $data);
				}
			
			}

		}
		/* End of GetSectionByID() */ 

			

			
			

		function nt_GetActiveEventsbyType($event_type=false){
		

			$dbAccess = $this->load->database('market',true);

			$dbAccess->select("
			evt.event_id
			, evt.event_code
			, evt.event_title
			, evt.event_long_title
			, evt.event_date_time
			, evt.event_internet_sales_charge as convenience_charge
			, evt.event_max_ticket
			, ec.events_config_ekbarcode_active
			");	

			$dbAccess->join('events_config ec', 'ec.events_config_eventid = evt.event_id', 'left' );
			$dbAccess->join('seatplans s', 's.seatplan_id = evt.event_seatplan_id', 'left' );
			$dbAccess->where("evt.event_active",1);
			$dbAccess->where("evt.event_date_time >= now()");
			$dbAccess->where("evt.event_type",$event_type);
			$query = $dbAccess->get("events evt")->result();
			
			$data['eventDetails'] = $query;

			//display the page
			$this->load->view('active_events_xml', $data);
	
		}

		function nt_GetActiveEventsFullMarket_NoDesc(){

			$event_id = $this->input->get_post('eventid');
			$event = $this->input->get_post('event');
			$event_type = $this->input->get_post('eventtype');

				$dbAccess = $this->load->database('default',true);
				$dbAccess->select('evt.event_id,	
				evt.event_code,
				evt.event_title,
				evt.event_long_title,
				evt.event_date_time,
				evt.event_description,
				evt.event_image,
				evt.event_image_1,
				evt.event_seatplan_id,
				evt.event_recommended,
				s.seatplan_image,
				evt.event_venue_id,
				v.venue_name,
				evt.event_internet_sales_charge as convenience_charge,
				evt.event_type,
				ec.events_config_ekbarcode_active,
				evt.event_active,
				evt.event_ticket_types,
				evt.event_hotel,
				evt.event_always_show,
				evt.event_online_registration');

				$dbAccess->where("evt.event_active",'1');
				$dbAccess->where("evt.event_date_time >= now()");
				$dbAccess->join('events_config ec', 'ec.events_config_eventid = evt.event_id', 'left' );
				$dbAccess->join('seatplans s', 's.seatplan_id = evt.event_seatplan_id', 'left' );
				$dbAccess->join('venues v', 'v.venue_id = evt.event_venue_id', 'left' );

				if($event_id){
					$dbAccess->where("evt.event_id", $event_id);
				}
				if($event){
				$dbAccess->like('evt.event_long_title', $event);
				}
				
				if($event_type){
				$dbAccess->where("evt.event_type",$event_type);
				}

				$query = $dbAccess->get('events evt');

			
				$data['eventDetails'] = $query->result();
		
			//display the page
			$this->load->view('event_details_xml_NoDesc', $data);
		 }
		
						
	function nt_getHotEvents($limit=false){

	/* // $limit = 6;
	$dbAccess = $this->load->database('default',true);
	$date = date( 'Y-m-d H:i:s',strtotime("-720 minutes"));

	$queryString = "SELECT COUNT(e.event_title) AS COUNT ,
		e.event_id, e.event_title, e.event_code, 
		e.event_long_title, 
		e.event_date_time, 
		e.event_description, 
		e.event_image, 
		e.event_image_1, 
		e.event_seatplan_id, 
		e.event_recommended,
		 s.seatplan_image, 
		 e.event_venue_id, 
		 v.venue_name, 
		 e.event_internet_sales_charge AS convenience_charge, 
		 e.event_type, 
		 ec.events_config_ekbarcode_active, 
		 e.event_active, 
		 e.event_ticket_types, 
		 e.event_hotel, 
		 e.event_always_show,
		 e.event_online_registration
		FROM (tickets)
		JOIN prices ON prices.price_id = tickets.ticket_price_id
		JOIN `events` e ON e.event_id = prices.price_event_id
		 JOIN events_config ec ON ec.events_config_eventid = e.event_id
		 JOIN seatplans s ON s.seatplan_id = e.event_seatplan_id
		 JOIN venues v ON v.venue_id = e.event_venue_id
		WHERE ticket_date_entered >= '$date' and e.event_active = '1'
		GROUP BY e.event_title
		ORDER BY COUNT DESC";
	if($limit){
		$queryString = $queryString . " LIMIT $limit";
	}
	
	$query = $dbAccess->query($queryString);
	
	$data['eventDetails'] = $query->result();

	$queryString =  "SELECT  e.event_id, e.event_title, e.event_code, e.event_long_title, e.event_date_time, e.event_description, e.event_image, e.event_image_1, e.event_seatplan_id, e.event_recommended, s.seatplan_image, e.event_venue_id, v.venue_name, e.event_internet_sales_charge AS convenience_charge, e.event_type, ec.events_config_ekbarcode_active, e.event_active, e.event_ticket_types, e.event_hotel, e.event_always_show, e.event_online_registration
					FROM (events e)
					JOIN events_config ec ON ec.events_config_eventid = e.event_id
					JOIN seatplans s ON s.seatplan_id = e.event_seatplan_id
					JOIN venues v ON v.venue_id = e.event_venue_id
					WHERE e.event_active = '1' AND `e`.`event_date_time` >= now() and e.event_id IN ('4166' , '4156','4174')
					GROUP BY e.event_long_title";
	
	$query = $dbAccess->query($queryString);
	
	$data['eventDetails'] = array_merge(	$query->result(), $data['eventDetails']);
	 */

	 
	 
	 	$dbAccess = $this->load->database('market',true);

	$dbAccess->select('e.event_id,	
				e.event_code,
				e.event_title,
				e.event_long_title,
				e.event_date_time,
				e.event_description,
				e.event_image,
				e.event_image_1,
				e.event_seatplan_id,
				e.event_recommended,
				s.seatplan_image,
				e.event_venue_id,
				v.venue_name,
				e.event_internet_sales_charge as convenience_charge,
				e.event_type,
				ec.events_config_ekbarcode_active,
				e.event_active,
				e.event_ticket_types,
				e.event_hotel,
				e.event_always_show,
				e.event_online_registration');
	

	$dbAccess->where("e.event_active",1);
	$dbAccess->where("e.event_date_time >= now()");
	$dbAccess->join('events_config ec', 'ec.events_config_eventid = e.event_id', 'left' );
	$dbAccess->join('seatplans s', 's.seatplan_id = e.event_seatplan_id', 'left' );
	$dbAccess->join('venues v', 'v.venue_id = e.event_venue_id', 'left' );
	
	if($limit)
	$dbAccess->limit($limit);
	
	
	$dbAccess->order_by('event_id', 'ASC');
	$query = $dbAccess->get('events e');

	$data['eventDetails'] = $query->result();
	 
	 
	 
	 
	 
	 
	//display the page
	$this->load->view('event_details_xml_NoDesc', $data);
	
	}	
				
	function nt_getHotEvents_2($limit=false){

	$dbAccess = $this->load->database('default',true);
	$date = date( 'Y-m-d H:i:s',strtotime("-10000 minutes"));

	$queryString = "SELECT count(e.event_title) as count
					,e.event_id
					,e.event_title
					FROM (tickets)
					JOIN prices ON prices.price_id = tickets.ticket_price_id
					JOIN events e ON e.event_id = prices.price_event_id
					WHERE e.event_active = '1' and ticket_date_entered >= '$date'
					group by e.event_title, e.event_long_title
					order by count desc";
					


	if($limit){
		$queryString = $queryString . " LIMIT $limit";
	}

	// echo $queryString;
	// die();
	
	$query = $dbAccess->query($queryString);

	$most_ticket_selected = $query->result();


	
	
	
	// echo "<pre>";
	// print_r($most_ticket_selected);
	// echo "</pre>";
	// die();
	
	

	header ("Content-Type:text/xml");
	echo "<root>";

	foreach($most_ticket_selected as $most_selected){
		echo "<event_info>" ;

			echo "<selection_count>" . $most_selected->count . "</selection_count>";
			echo "<event_id>" . htmlentities($most_selected->event_id) . "</event_id>";

		echo "</event_info>";
	}

	echo "</root>";
	
	
	}
		
		
	function nt_getActiveEventsForCalendar(){

				$date = $this->input->get_post('date');	
				
				//$date = "1483142400";
				
				$c_event_date = date('Y-m-d 00:00:00',$date);
				$p_event_date = date('Y-m-d 23:59:59',$date);
				
				
				
				
				$json = $this->input->get_post('json');
	
				$dbAccess = $this->load->database('market',true);
				$dbAccess->select('	e.event_id
									,e.event_active
									,e.event_title
									,e.event_long_title
									,e.event_image
									,e.event_image_1
									,e.event_date_time
									,e.event_announcement_date
									,e.event_tags
									,e.event_category
									,e.event_type
									,e.event_parent
									,e.date_modified as event_date_modified
									,v.venue_id,
									,v.venue_name,
									');

				$dbAccess->where("e.event_active",'1');
				
				$dbAccess->where("e.event_date_time >=", $c_event_date);
				$dbAccess->where("e.event_date_time <", $p_event_date);

				
				$dbAccess->join('venues v', 'v.venue_id = e.event_venue_id', 'left' );

				
				$dbAccess->order_by('e.event_title',"asc");
				
				$query = $dbAccess->get('events e');
				
				
				// echo $dbAccess->last_query();
				// die();
				
				$data['events'] = $query->result();
	
				 if(!$json){
					//display the page
					$this->load->view('events_listing_xml', $data);
				}else{
					echo json_encode($query->result());				
					die();
				} 
				
				
		 }	
		
	function nt_getActiveDates(){

				// $date = $this->input->get_post('date');	
				
				
				$json = $this->input->get_post('json');
	
				$dbAccess = $this->load->database('market',true);
				
				
				$dbAccess->select('	e.event_active, e.event_date_time, e.event_long_title ');
				
				$dbAccess->where("e.event_active",'1');
				
		
				$dbAccess->where("e.event_date_time >= now()");

				
				$dbAccess->order_by('e.event_date_time',"asc");
				
				$dbAccess->distinct();
				$query = $dbAccess->get('events e');
				
				
				// echo $dbAccess->last_query();
				// die();
				
				$data['events'] = $query->result();
				
				// echo "<pre>";
				// print_r($data['events']);
				// echo "</pre>";
				// die();
	
				 if(!$json){
					//display the page
					$this->load->view('active_events_date_xml', $data);
				}else{
					echo json_encode($query->result());				
					die();
				} 
				
				
		 }	
	
		
		
	/* 	
		function nt_getActiveEventsForListing(){

			
			$event_id = $this->input->get_post('id');
			$event_match = $this->input->get_post('match');
			$event_category = $this->input->get_post('category');
			$long_title = $this->input->get_post('title');
			$venue = $this->input->get_post('venue');

			$json = $this->input->get_post('json');

				$dbAccess = $this->load->database('market',true);
				$dbAccess->select('	e.event_id
									,e.event_active
									,e.event_title
									,e.event_long_title
									,e.event_image_1
									,e.event_date_time
									,e.event_announcement_date
									,e.event_tags
									,e.event_category
									,e.event_type
									,e.event_parent
									,e.date_modified as event_date_modified
									,v.venue_id,
									,v.venue_name,
									');

				$dbAccess->where("e.event_active",'1');
				
				$dbAccess->where("e.event_date_time >= now()");
				$dbAccess->join('venues v', 'v.venue_id = e.event_venue_id', 'left' );

				if($event_id){
					$dbAccess->where("e.event_id", $event_id);
				}
				
				if($event_match){
				$dbAccess->like('e.event_tags',$event_match);
				}
				
				if($event_category){
				$dbAccess->like('e.event_category',$event_category);
				}
				
				if($venue){
				$dbAccess->where("e.event_venue_id",$venue);
				}

				if($long_title){
				$dbAccess->where("e.event_long_title",$long_title);
				}else{
				// $dbAccess->where("e.event_parent",0);
				}
				
				$dbAccess->order_by('e.event_title',"asc");
				
				$query = $dbAccess->get('events e');
				
				$data['events'] = $query->result();
	
	
				// echo $dbAccess->last_query();
				// die();
				
				
					// echo "<pre>";
					// print_r($query->result());
					// echo "</pre>";
				
				
	
				 if(!$json){
					//display the page
					$this->load->view('events_listing_xml', $data);
				}else{
					// $this->output->set_content_type('application/json');
					
					echo json_encode($query->result());
					
					// echo "<pre>";
					// print_r($query->result());
					// echo "</pre>";
					
					
					die();
				} 
				
				
		 }
		 */ 
		
		function nt_getActiveEventsForListing(){

			$event_id = $this->input->get_post('id');
			$event_match = $this->input->get_post('match');
			
			$event_categories = explode( ' or ',  $this->input->get_post('category') );
				
			// echo $this->input->get_post('category');
			
			
			
			// echo "<pre>";
			// print_r(	$event_categories	);
			// echo "</pre>";
			
			// die();
							
			$long_title = $this->input->get_post('title');
			$venue = $this->input->get_post('venue');

			$json = $this->input->get_post('json');

				$dbAccess = $this->load->database('market',true);
				$dbAccess->select('	e.event_id
									,e.event_active
									,e.event_title
									,e.event_long_title
									,e.event_image
									,e.event_image_1
									,e.event_date_time
									,e.event_announcement_date
									,e.event_tags
									,e.event_category
									,e.event_type
									,e.event_parent
									,e.date_modified as event_date_modified
									,v.venue_id,
									,v.venue_name,
									,ec.other_event_date_time,
									');

				$dbAccess->where("e.event_active",'1');
				
				//Hidden Pages
				// $dbAccess->where("e.event_id !=", 5279);
				$dbAccess->where("e.event_id !=", 5280);
				$dbAccess->where("e.event_id !=", 5359);
				$dbAccess->where("e.event_id !=", 5360);
				// $dbAccess->where("e.event_id !=", 5788);
				// $dbAccess->where("e.event_id !=", 5577);
				// $dbAccess->where("e.event_id !=", 5157);
				// $dbAccess->where("e.event_id !=", 5645);
				$dbAccess->where("e.event_id !=", 5861);
				//
				
				$dbAccess->where("e.event_date_time >= now()");
				$dbAccess->join('venues v', 'v.venue_id = e.event_venue_id', 'left' );
				$dbAccess->join('events_config ec', 'ec.events_config_eventid = e.event_id', 'left' );
				
				if($event_id){
					$dbAccess->where("e.event_id", $event_id);
				}
				
				if($event_match){
					$dbAccess->like('e.event_title',$event_match,'both');
					$dbAccess->or_like('e.event_tags',$event_match,'both');	
				}
				
				if($event_categories){
					foreach(	$event_categories as $event_category	){
						if($event_category){
							
						$dbAccess->or_like('e.event_category',$event_category);
						}
					}
				}
				
				if($venue){
				$dbAccess->where("e.event_venue_id",$venue);
				}

				if($long_title){
				$dbAccess->where("e.event_long_title",$long_title);
				}else{
				}
				
				// $dbAccess->order_by('e.event_title',"asc");
				$dbAccess->order_by('e.event_date_time',"asc");
				
				$query = $dbAccess->get('events e');
				
				
				// echo $dbAccess->last_query();
				// die();
				
				$data['events'] = $query->result();
	
				 if(!$json){
					//display the page
					$this->load->view('events_listing_xml', $data);
				}else{
					echo json_encode($query->result());				
					die();
				} 
				
				
		 }
		 	  
		 
		 /* ACCOUNT */
		 

	// Get_Sections_For_All_ActiveEvents()
	function nt_GetSectionsforAllActiveEvents(){

		$event_id = $this->input->get_post('eventid');
		$data['sections'] = $this->sections->getSectionsWithEventID($event_id);

		if(!$data['sections']){
		$this->load->view('blank', $data);
		}else{
		//display the page
		$this->load->view('seatplans_active_events_xml', $data);
		}

	}
	
		// Get_Venues_For_All_Active_Events()
	function nt_GetVenueListForAllActiveEvents(){
		
		$venue_id = $this->input->get_post('venueid');
		$dbAccess = $this->load->database('default',true);
		
		$dbAccess->select("	v.venue_id
							,v.venue_type
							, v.venue_name
							, v.venue_address1");
			
		$dbAccess->distinct();
		$dbAccess->join('events e','e.event_venue_id = v.venue_id');
		$dbAccess->where("e.event_date_time >= now()");
		$dbAccess->where('e.event_active',1);
		
		if($venue_id){
		$dbAccess->where('v.venue_id',$venue_id);
		}

		$query = $dbAccess->get('venues v');
		$content = $query->result();
		$data['Venues'] = $content;
		$this->load->view('venues_xml', $data);
	}
	
	
	
		// Get_Active_Events_Full_Market()
		function GetActiveEventsFullMarket_new(){
		
			$event_id = $this->input->get_post('eventid');
			$dbAccess = $this->load->database('default',true);
	
			$dbAccess->select('evt.event_id,	
			evt.event_code,
			evt.event_title,
			evt.event_long_title,
			evt.event_date_time,
			evt.event_description,
			evt.event_image,
			evt.event_image_1,
			evt.event_seatplan_id,
			evt.event_recommended,
			evt.event_description,
			s.seatplan_image,
			evt.event_venue_id,
			v.venue_name,
			evt.event_internet_sales_charge as convenience_charge,
			evt.event_type,
			ec.events_config_ekbarcode_active,
			evt.event_enable_online_selling,
			evt.event_ticket_types,
			evt.event_hotel,
			evt.event_always_show,
			evt.event_online_registration,
			evt.event_parent,
			evt.event_max_ticket,
			evt.event_scripts,
			evt.event_active,
			ec.event_display_venue_online,
			ec.events_date_validity,
			ec.events_valid_dates,
			ec.event_display_date_online');
				
			$dbAccess->where("evt.event_active",'1');
			$dbAccess->where("evt.event_date_time >= now()");
			$dbAccess->join('events_config ec', 'ec.events_config_eventid = evt.event_id', 'left' );
			$dbAccess->join('venues v', 'v.venue_id = evt.event_venue_id', 'left' );
			$dbAccess->join('seatplans s', 's.seatplan_id = evt.event_seatplan_id', 'left' );

			if($event_id){
				$dbAccess->where("evt.event_id", $event_id);
			}

			$query = $dbAccess->get('events evt');
			
			$data['eventDetails'] = $query->result();
		
			//display the page
			$this->load->view('event_details_xml_new', $data);
		}
		 
		
		//no tokens for ticket master
		
			// Get_Transaction_Details()
 	
	// Get_Customer_Transactions()
	function nt_GetCustomerTransactions(){

 		$customerid = $this->input->get_post('customerid');
	 
		$data['transactions'] = $this->transaction->get_customer_transactions($customerid);
		 
		if(empty($data['transactions'])){
		$this->promptError('ER:04:22');
		}else{
		//display the page
		$this->load->view('customer_transactions_xml', $data);
		}
	}
	
	//di ko na ginamit -korewa
	function nt_GetCustomerDetails(){

 		$customerid = $this->input->get_post('customerid');
	 
		$data['customer'] = $this->transaction->get_customer_details($customerid);
		 
		if(empty($data['customer'])){
		// $this->promptError('ER:04:22');
		}else{
		//display the page
		$this->load->view('customer_details_xml', $data);
		}
			 
	 
	}	
	
	// View_API_User_by_Username()
	function nt_ViewAPIuserbyUsername(){
		$username = $this->input->get_post('username');
			
		if(!$username){
			$this->promptError('ER:04:12');
		}else{
				
					$dbAccess = $this->load->database('default',true);
					// $dbAccess->cache_on();
					$dbAccess->query('set transaction isolation level read uncommitted');
					$dbAccess->select("
							c.customer_id
							,c.customer_username 
							, c.customer_firstname
							, c.customer_middlename
							, c.customer_lastname
							, c.customer_birthdate
							, c.customer_mobile
							, c.customer_email
							, c.customer_partycode
							, c.customer_address1
							, c.customer_address2
							, c.customer_city
							, c.customer_gender
							, c.customer_marital_status
							");
							

						$dbAccess->where("c.customer_username", $username);
						$query = $dbAccess->get('customers c');	

						$data['user'] = $query->row();
								
						if($query->num_rows() < 1){
									$this->promptError('ER:04:15');
								}else{
								//display the page
								$this->load->view('user_xml', $data);
								}
						// $dbAccess->cache_off();
				
				
			}
			
	}
	
	
		// Register_party_user
	function nt_Register_party_user(){

 			$this->load->helper('email');
			$appcode = $this->input->post('appcode');
			$customer_username = $this->input->post('username');
			$customer_firstname = $this->input->post('fname');
			$customer_middlename = $this->input->post('mname');
			$customer_lastname = $this->input->post('lname');
			$customer_birthdate = $this->input->post('bdate');
			$customer_mobile = $this->input->post('mobile');
			$customer_email = $this->input->post('email');
			$customer_password = $this->input->post('password');
			$address = $this->input->post('address');
			$city = $this->input->post('city');
			$gender = $this->input->post('gender');
			$civil_status = $this->input->post('civil_status');
			
			$read = $this->load->database('default',true);
			$write = $this->load->database('live',true);  
			
				//Check username
				if(!trim($customer_username))
					{ 
					$this->promptError('ER:04:12');
					}	
				elseif($this->check_username(trim($customer_username)))
				{ 
					$this->promptError('ER:04:13');
				}					
				elseif(!$customer_password)
					{ 
					// $customer_password = 'ERROR: No Password Provided';
					$this->promptError('ER:04:03');
					}
				
				//Check FirstName
				elseif(!trim($customer_firstname))
					{
					// $customer_firstname = 'ERROR: No First Name Provided';
					$this->promptError('ER:04:04');
					}
					
					//Check LastName
				elseif(!trim($customer_lastname))
					{ 
					// $customer_lastname = 'ERROR: No Last Name Provided';
					$this->promptError('ER:04:05');
					}	
					
					
				//Check Date..Date should be in YYYY-MM-DD
				elseif (!$customer_birthdate)
						{
						// $customer_birthdate = 'ERROR: No Birth Date Provided';
						$this->promptError('ER:04:06');
						}
						
				//Returns TRUE if date format = YYYY-MM-DD
				elseif(!$this->isValidDate($customer_birthdate))
					{
					// $customer_birthdate = 'ERROR: Invalid date format';
					$this->promptError('ER:04:07');
					} 
					
				//Check mobile
				elseif(!trim($customer_mobile))
					{ 
					// $customer_mobile = 'ERROR: No Mobile Number Provided';
					$this->promptError('ER:04:08');
					} 	
					
				/* elseif(!$this->validate_phonenumbers(trim($customer_mobile)))
					{ 
					// $customer_mobile = 'ERROR:Invalid Mobile Format';
					$this->promptError('ER:04:11');
					}
					 */
			//Check existing mobile number		
			 	elseif($this->check_mobile(trim($customer_mobile)))
					{ 
					// $customer_mobile = 'ER:04:02' => 'Mobile Number Already Used',
					$this->promptError('ER:04:02');
					} 
				 
				 
				//Check if ther is a provided email
				elseif(!trim($customer_email))
					{ 
						// $customer_email = 'ERROR: No Email Provided';
						$this->promptError('ER:04:10');
					}
					
				//Check if email Adress string is valid
				elseif(!valid_email(trim($customer_email)))
					{ 
						// $customer_email = 'ERROR: Invalid Email Format';
						$this->promptError('ER:04:09');
					}
					
				//Check existing email
				/* elseif($this->check_email(trim($customer_email)))
					{ 
						// $customer_email = 'ERROR: No Email Provided';
						$this->promptError('ER:04:01');
					} */
					
				else{		
						$data = array(
					   'customer_firstname' => $customer_firstname,
					   'customer_middlename' => $customer_middlename,
					   'customer_lastname' => $customer_lastname,
					   'customer_birthdate' => $customer_birthdate,
					   'customer_mobile' => $customer_mobile,
					   'customer_email' => $customer_email,
					   'customer_username' => $customer_username,
					   'customer_active' => '1',
					   'customer_password' => $this->prep_password($customer_password),
					   // 'customer_partycode' => $customer_partycode,
					   'customer_address1' => $address,
					   'customer_city' => $city,
					   'customer_gender' => $gender,
					   'customer_marital_status' => $civil_status
						);
				 
						// I N S E R T		T O		D A T A B A S E
						$write->insert('customers', $data); 	
						
						$xml = '<result>Registration Succesful</result><id>'. $this->db->insert_id() . '</id>';
						foreach ($data as $key=>$value) 
						{
							if(substr($key, 9) !== 'password')
							{
								$xml = $xml . '<' .  substr($key, 9)  .'>' . $value . '</' . substr($key, 9). '>';
							}
						}	
						$data['content'] = $xml;
						$this->load->view("register_party_user_xml", $data);
			
					}
				 
			
			
			}
	  
	function nt_Reset_password(){

		$username = $this->input->get_post('user');
		$customer_birthdate = $this->input->post('bdate');
		$customer_email = $this->input->post('email');
		
		$read = $this->load->database('default',true);
		$write = $this->load->database('live',true);
						
			if(!trim($username)){
			$this->promptError('ER:04:12');
			}
			// elseif(!$customer_birthdate){
				// $this->promptError('ER:04:06');	// $customer_birthdate = 'ERROR: No Birth Date Provided';
			// }elseif(!$this->isValidDate($customer_birthdate)){	//Returns TRUE if date format = YYYY-MM-DD
				// $this->promptError('ER:04:07');	// $customer_birthdate = 'ERROR: Invalid date format';
			// }
			elseif(!trim($customer_email)){ 				
				$this->promptError('ER:04:10');	// $customer_email = 'ERROR: No Email Provided';
			}else{
					
					$read->select("customer_id");
					$read->where("customer_username", $username);
					// $read->where("customer_birthdate",  $customer_birthdate);
					$read->where("customer_email",  $customer_email);
					$query = $read->get('customers');
		
						if ($query->num_rows() < 1){
						$this->promptError('ER:02:11');
						}else{
						//Generate a reg key
						// $reg_key = $this->encrypt->sha1($username.'MGI'.$customer_birthdate.'MGI'. $customer_email . 'MGI' . $this->getcurrentdatetime());
						$reg_key = $this->encrypt->sha1($username.'MGI'. $customer_email . 'MGI' . $this->getcurrentdatetime());
						
						//Save reset into api_sessions
						$data = array(
							'customer_registration_code' => $reg_key,
						);
						$write->where("customer_username",  $username);
						$write->update('customers', $data); 		
						$xml = 	'<reset_key>'. $reg_key.'</reset_key>';
						
						$data['content'] = $xml;	
						$this->load->view("reset_xml", $data);

					}
			}

	}
	
	function nt_getNewEvents($limit=false){

	// $limit = 6;
	$dbAccess = $this->load->database('market',true);

	$dbAccess->select('e.event_id,	
				e.event_code,
				e.event_title,
				e.event_long_title,
				e.event_date_time,
				e.event_description,
				e.event_image,
				e.event_image_1,
				e.event_seatplan_id,
				e.event_recommended,
				s.seatplan_image,
				e.event_venue_id,
				v.venue_name,
				e.event_internet_sales_charge as convenience_charge,
				e.event_type,
				ec.events_config_ekbarcode_active,
				e.event_active,
				e.event_ticket_types,
				e.event_hotel,
				e.event_always_show,
				e.event_online_registration');
	

	$dbAccess->where("e.event_active",1);
	$dbAccess->where("e.event_date_time >= now()");
	$dbAccess->join('events_config ec', 'ec.events_config_eventid = e.event_id', 'left' );
	$dbAccess->join('seatplans s', 's.seatplan_id = e.event_seatplan_id', 'left' );
	$dbAccess->join('venues v', 'v.venue_id = e.event_venue_id', 'left' );
	
	if($limit)
	$dbAccess->limit($limit);
	
	
	$dbAccess->order_by('event_id', 'ASC');
	$query = $dbAccess->get('events e');

	$data['eventDetails'] = $query->result();

	//display the page
	$this->load->view('event_details_xml_NoDesc', $data);
	
	}
	
		 
	function nt_getVenueCountByEvent($limit=false){
		// die('test');
		// $limit = 6;
		$dbAccess = $this->load->database('market',true);

		$dbAccess->select('v.venue_name,
						v.venue_id,
						count(e.event_venue_id) as event_count');
			

		$dbAccess->where("e.event_active",1);
		$dbAccess->where("e.event_date_time >= now()");
		$dbAccess->join('events_config ec', 'ec.events_config_eventid = e.event_id', 'left' );
		$dbAccess->join('venues v', 'v.venue_id = e.event_venue_id', 'left' );
		if($limit)
		$dbAccess->limit($limit);
		$dbAccess->order_by('count(e.event_venue_id)', 'DESC');
		$dbAccess->group_by('e.event_venue_id');
		$query = $dbAccess->get('events e');

		// echo $dbAccess->last_query();
		 // die();
		
		$this->load->dbutil(); 
		$config = array (
						  'root'    => 'root',
						  'element' => 'element', 
						  'newline' => "\n", 
						  'tab'    => "\t"
						);

						
		echo $this->dbutil->xml_from_result($query, $config);
			 
	}
	
	function nt_GetAds(){

		// $dbAccess = $this->load->database('default',true);
		$dbAccess = $this->load->database('market',true);

		$queryString = "SELECT 
				a.ad_id
				,a.ad_path
				,a.ad_title
				,a.ad_type 
				,a.ad_filename
				,a.ad_link
				FROM (`ads` a)  
				WHERE `a`.`ad_active` = 'yes'";

		$query = $dbAccess->query($queryString);
		$data['adDetails'] = $query->result();
		
		// echo "<pre>";
		// print_r($data['adDetails']);
		// echo "</pre>";
		// die(); 
		
		//display the page
		$this->load->view('ads_xml', $data);
					
	}

	function get_barcode_for_ticket_printing($transaction_id = false, $accesscode = false) {


		$barcode = hash("crc32", $transaction_id);
		$barcode_hashed = strtoupper($barcode);

		$this->load->database('default',true);

		$this->db->select('apis.api_customer_id, cu.customer_email, cu.customer_id');
		$this->db->join('api_sessions apis', 'api_customer_id=cu.customer_id');
		$this->db->where('customer_active', 1);	
		$this->db->where('apis.api_accesscode', $accesscode);	
		$this->db->where('apis.api_active', 1);	
		$query_accesscode = $this->db->get('customers cu');
		$result_accesscode = $query_accesscode->result();

		if (json_encode($result_accesscode)) {

			$this->db->select('t.*, count(tix.ticket_id) as ticket_count, max(tix.ticket_event_id) as ticket_event_id , cu.customer_block as blocked, card_number_value as card_num, card_number_expiration as expiration, cu.customer_email');
			
			$this->db->join('tickets tix', 't.transaction_id = tix.ticket_transaction_id', 'LEFT');
			$this->db->join('customers cu', 'cu.customer_id = t.transaction_customer_id', 'LEFT');
			$this->db->join('card_numbers cn', 'cn.card_number_transaction_id = t.transaction_id', 'LEFT');
			$this->db->where('t.transaction_barcode', $barcode_hashed);
			$this->db->where('t.transaction_status', 'paid_online');	
			$this->db->where('tix.ticket_status', 'paid_online');	
			$this->db->where('cu.customer_block !=', 1);
			$this->db->group_by('t.transaction_id');
			$query = $this->db->get('transactions t');
			// $result = $query->result_array();
			$result = $query->result();

			if (($result) && ($result[0]->transaction_status !='done') && ($result_accesscode[0]->customer_id == $result[0]->transaction_customer_id)) {

				//xml response
				$this->load->view('ticket_by_barcode', array('info'=>$result));
				
				//json response
				// echo json_encode($result);

			}

			else {

				header ("Content-Type:text/xml");
				echo "<root>";
				echo "<message>Failed</message>";
				echo "</root>";

			}

		}

		else {

			header ("Content-Type:text/xml");
			echo "<root>";
			echo "<message>Access Code Failed</message>";
			echo "</root>";

		}

	}

	function get_password_for_ticket_printing() {

		$barcode = $this->input->post('barcode');
		$transaction_customer_id = $this->input->post('transaction_customer_id');
		$password = $this->input->post('password');
		$accesscode = $this->input->post('accesscode');

		// $barcode = "F776C6AB";
		// $transaction_customer_id = "612517";
		// $accesscode = "8dc3c86991bbeaccc73ad84deb674bb7ba6e96e4";
		// $username = "alinan.alfed";
		// $password = "alfedalinan";

		$hashed_password = sha1($this->config->item('encryption_key').$password);

		$this->load->database('default',true);
		
		$this->db->select('*');
		$this->db->join('tickets tix', 't.transaction_id = tix.ticket_transaction_id', 'LEFT');
		$this->db->join('customers cu', 'cu.customer_id = t.transaction_customer_id', 'LEFT');
		$this->db->join('api_sessions apis', 'apis.api_customer_id = t.transaction_customer_id', 'LEFT');
		$this->db->join('card_numbers cn', 'cn.card_number_transaction_id = t.transaction_id', 'LEFT');
		$this->db->where('t.transaction_barcode', $barcode);
		$this->db->where('t.transaction_customer_id', $transaction_customer_id);
		$this->db->where('cu.customer_password', $hashed_password);
		$this->db->where('apis.api_accesscode', $accesscode);
		$this->db->where('t.transaction_status', 'paid_online');	
		$this->db->where('tix.ticket_status', 'paid_online');	
		$this->db->where('cu.customer_block !=', 1);
		$this->db->where('apis.api_active', 1);
		$this->db->where('cu.customer_active', 1);
		$this->db->group_by('t.transaction_id');
		$query = $this->db->get('transactions t');
		$result = $query->result();
		$num_rows = $query->num_rows();

		// echo "<pre>";
		// print_r($num_rows);
		// echo "</pre>";
		// die();

		if (($num_rows==1) && ($result[0]->transaction_status!="done")) {

			header ("Content-Type:text/xml");
			echo "<root>";
			echo "<message>Success</message>";
			echo "</root>";

		}

		else {

			header ("Content-Type:text/xml");
			echo "<root>";
			echo "<message>Failed</message>";
			echo "</root>";

		}

	}	 	 
			
		function test(){
			echo "kamote";
			die();
		}
		
		function countTicketsByUsername(){
			$username = $this->input->get_post("username");
			$event_id = $this->input->get_post("eventid"); 
			header ("Content-Type:text/xml");
			echo "<root>";
			echo "<result>" . 	$this->transaction->countTicketsByUsername($username,$event_id) . "</result>" ;
			echo "</root>";
		// die();
		}

		
		function nt_computePricebyticketType(){
			
			$price_id = $this->input->get_post("priceid");
			$ticket_type = $this->input->get_post("ticket_type"); 
			
			$dbAccess = $this->load->database('default',true);
			$dbAccess->where("ticket_type_id", $ticket_type);
			$query = $dbAccess->get("ticket_types"); 
			$ticket_type_array = $query->row();
			
			$discount_type = $ticket_type_array->ticket_type_discount_type;
			$discount = $ticket_type_array->ticket_type_discount;
		
			$dbAccess = $this->load->database('default',true);
			$dbAccess->where("price_id", $price_id);
			$query = $dbAccess->get("prices"); 
			$ticket_price = $query->row()->price_price;			
		
			$discounted_price = false;			
			if($discount_type == "Amount"){
				$discounted_price = $ticket_price - $discount;
			}else if($discount_type == "Percentage"){
				$discounted_price = $ticket_price - ( $ticket_price * ($discount/100) );
			}
			
			$discounted_price = ceil($discounted_price);
			header ("Content-Type:text/xml");
			echo "<root>";
			echo "<price_id>$price_id</price_id>" ;
			echo "<price_amount>$discounted_price</price_amount>" ;
			echo "</root>";
		}
		
			
		function get_ticket_type_detail(){
			
			$ticket_type_id = $this->input->get_post("ticket_type_id"); 
			
			$dbAccess = $this->load->database('default',true);
			$dbAccess->where("ticket_type_id", $ticket_type_id);
			$query = $dbAccess->get("ticket_types"); 
			$ticket_type_array = $query->row();
			
			$discount_type = $ticket_type_array->ticket_type_discount_type;
			$discount_amount = $ticket_type_array->ticket_type_discount;	
		
			header ("Content-Type:text/xml");
			echo "<root>";
			echo "<ticket_type_id>$ticket_type_id</ticket_type_id>" ;
			echo "<discount_type>$discount_type</discount_type>" ;
			echo "<discount_amount>$discount_amount</discount_amount>" ;
			echo "</root>";
		}
		
	function getseo(){
			
			$event_id = $this->input->get_post("eventid"); 
			
			$dbAccess = $this->load->database('default',true);
			
			$dbAccess->where("event_id", $event_id);
			$dbAccess->select('evt.meta_description_content,evt.meta_keywords_content,evt.link_rel_canonical');
			$query = $dbAccess->get("events_seo evt"); 
			$e = $query->row();
		
			header ("Content-Type:text/xml");
			
			if(!empty($e)){
				echo "<root>";
				echo "<event_info>";
				echo "<meta_description_content>$e->meta_description_content</meta_description_content>" ;
				echo "<meta_keywords_content>$e->meta_keywords_content</meta_keywords_content>" ;
				echo "<link_rel_canonical>$e->link_rel_canonical</link_rel_canonical>" ;
				echo "</event_info>";
				echo "</root>";
			}else{
				echo "<root>";
				echo "<event_info>";
				echo "<meta_description_content>Reserve the latest event tickets in Manila today. The latest concerts, parks, tourist destinations, zoos, and hotels, you can purchase it with SM Tickets.</meta_description_content>" ;
				echo "<meta_keywords_content>tickets, schedule events, concerts, madonna, rebel, edm, music, live, MMI, arena, araneta, how much, theater</meta_keywords_content>" ;
				echo "<link_rel_canonical>https://www.smtickets.com</link_rel_canonical>" ;
				echo "</event_info>";
				echo "</root>";
			}
		}
	/* 		
		function getEventIDs(){

			$json = $this->input->get_post('json');

				$dbAccess = $this->load->database('market',true);
				$dbAccess->select('	e.event_id');

				$dbAccess->where("e.event_active",'1');
				$dbAccess->where("e.event_date_time >= now()");
				$dbAccess->group_by("e.event_long_title");
				$dbAccess->order_by("e.event_id","desc");
				

		
				$query = $dbAccess->get('events e');
				
				$data['events'] = $query->result();

				 if(!$json){
					//display the page
					$this->load->view('event_ids_xml', $data);
				}else{
					
					echo json_encode($query->result());

					die();
				} 
				
				
		 
		}
		
		 */		
		
		function getEventIDs(){

				$dbAccess = $this->load->database('default',true);
				$dbAccess->select('event_listing_name,event_ids');
				$query = $dbAccess->get('events_listing');
				$result = $query->result();
				
				
				$json = $this->input->get_post('json');
				if(	$json ){
					$ids = array();
					foreach($result as $r){
						$ids[$r->event_listing_name] = $r->event_ids;
					}
					
					echo json_encode($ids);
					die();
					
				}else{
				header ("Content-Type:text/xml");
				
					echo "<root>";

					foreach($result as $r){	
							echo "<listing>";
							echo "<name>" . $r->event_listing_name . "</name>";
							echo "<IDs>" . $r->event_ids . "</IDs>";
							echo "</listing>";
					}

					echo "</root>"; 
				
				
					
					
				}
		}
		
		// Get_Customer_Transactions()
		function nt_get_reservations(){

			$reservation_code = $this->input->get_post('pcode');
			
			if(	count( 	explode( "-" ,$reservation_code)	)	== 3	){
				
				$data['transactions'] = $this->transaction->get_reservations($reservation_code);
				
				if(empty($data['transactions'])){
					echo "<root></root>";
				}else{
					$this->load->view('customer_transactions_xml', $data);
				}
			}else{
				echo "<root></root>";
			}
			
			
		}
		
		function nt_get_reservations_v2($reservation_code,$pin_code=false){

			// $reservation_code = $this->input->get_post('pcode');
			// $pin_code = $this->input->get_post('ppin');

			if(!$pin_code){
				$pin_code = '';	
			}
			
			if(	count( 	explode( "-" ,$reservation_code)	)	== 3	){
				
				$data['transactions'] = $this->transaction->get_reservations($reservation_code,$pin_code);	

				if(!isset($data['transactions']) || empty($data['transactions'])){
					echo "<root></root>";
				}else{
					$payCode = $data['transactions'][0]->transaction_branch_id . "-" . $data['transactions'][0]->transaction_id . "-"  . date("md",strtotime($data['transactions'][0]->transaction_date));
					if($payCode != $reservation_code){	
						echo "<root></root>";
					}else{
						$this->load->view('customer_transactions_xml', $data);
					}
					
				}
			}else{
				echo "<root></root>";
			}
			
			
		}

		// Get_Reserved_Tickets()
		function nt_get_reserved_tickets(){

			$transaction_code = $this->input->get_post('t_id');
			
			$trans = $this->transaction->get_reserved_tickets($transaction_code);
			
			//print_r($trans);
			//die();
			
			if(isset($trans[0])){
			
			$data["transactions"] = $trans;
			}else{
			 
			$trans2[0] = $trans; 
			$data["transactions"] = $trans2;
			}
			
			
			if(empty($data['transactions'])){
				echo "<root></root>";
			}else{
				$this->load->view('ticket_transactions_xml', $data);
			}
			
			
		}
		
				
			
	function getLastDateModified(){
		
		// $this->getLastDateModified_v2();
		
		$dbAccess = $this->load->database('market',true);
		$dbAccess->select('e.date_modified as event_date_modified');
		// $dbAccess->limit(1);
		$dbAccess->order_by('e.date_modified',"desc");
		$dbAccess->where("e.event_date_time >= now()");
		$dbAccess->where("e.event_active",'1');
		$query = $dbAccess->get('events e');
		
		header ("Content-Type:text/xml");
		echo "<root>";
		echo "<date_modified>" . $query->row()->event_date_modified . "</date_modified>";
		echo "</root>";
		die();

		if(!$json){
		//display the page
		die($events);
		$this->load->view('events_listing_xml', $data);
		}else{
		echo json_encode($query->result());
		die();
		} 
	}
	
	function getRemainingSeat($section_id,$date=false){
		
		$dbAccess1 = $this->load->database('live',true);
		$dbAccess1->query('set transaction isolation level read uncommitted');
		// $dbAccess1->select('s.section_type,s.section_capacity');
		$dbAccess1->where("s.section_id",$section_id);
		$query = $dbAccess1->get('sections s')->row();
		$capacity = $query->section_capacity;
		$type = $query->section_type;
		// echo $dbAccess1->last_query(); die();
		
		// print_r($query); die();
		
		if($type != 'Reserved'){
			$dbAccess = $this->load->database('default',true);
			$dbAccess->query('set transaction isolation level read uncommitted');	
			$dbAccess->select('count(tix.ticket_id) as ticket_used');
			if($date){
				$dbAccess->join('transactions tr', 'tix.ticket_transaction_id = tr.transaction_id');
				$dbAccess->where('tr.transaction_date_validity', $date);
			}
			$dbAccess->where("tix.ticket_section_id",$section_id);
			$dbAccess->where_in("tix.ticket_status",array("done","paid","paid_online","reserved","selected"));
			$query1 = $dbAccess->get('tickets tix')->row();
			$used = $query1->ticket_used;
		
			
			header ("Content-Type:text/xml");
			echo "<root>";
			echo "<seat_available>" . ($capacity - $used) . "</seat_available>";
			echo "</root>";
			die();
		}else{
			header ("Content-Type:text/xml");
			echo "<root>";
			echo "<seat_available>RESERVED</seat_available>";
			echo "</root>";
			die();
		}
		
		

	}
	
	function GetActiveEventsFM_sp(){
		
			$event_id = $this->input->get_post('eventid');
			$dbAccess = $this->load->database('default',true);
	
			$dbAccess->select('evt.event_id,	
			evt.event_code,
			evt.event_title,
			evt.event_long_title,
			evt.event_date_time,
			evt.event_description,
			evt.event_image,
			evt.event_image_1,
			evt.event_seatplan_id,
			evt.event_recommended,
			evt.event_description,
			s.seatplan_image,
			evt.event_venue_id,
			v.venue_name,
			evt.event_internet_sales_charge as convenience_charge,
			evt.event_type,
			ec.events_config_ekbarcode_active,
			evt.event_enable_online_selling,
			evt.event_active,
			evt.event_scripts,
			evt.event_ticket_types,
			evt.event_hotel,
			evt.event_always_show,
			evt.event_online_registration,
			evt.event_parent,
			evt.event_max_ticket,
			evt.event_active,
			ec.event_display_venue_online,
			ec.event_display_date_online');
				
			// $dbAccess->where("evt.event_active",'1');
			$dbAccess->where("evt.event_date_time >= now()");
			$dbAccess->join('events_config ec', 'ec.events_config_eventid = evt.event_id', 'left' );
			$dbAccess->join('venues v', 'v.venue_id = evt.event_venue_id', 'left' );
			$dbAccess->join('seatplans s', 's.seatplan_id = evt.event_seatplan_id', 'left' );

			if($event_id){
				$dbAccess->where("evt.event_id", $event_id);
			}

			$query = $dbAccess->get('events evt');
			
			$data['eventDetails'] = $query->result();
		
			//display the page
			$this->load->view('event_details_xml_new', $data);
	}
	
	function get_price_dates()
	{
		$this->db->cache_on();
		$event_id = $this->input->get_post('eventid');
		$event_date = $this->input->get_post('eventdate');
		$this->db->query('set transaction isolation level read uncommitted');
		if ($event_id)
		{
			$this->db->where('ped.price_event_date_event_id', $event_id);
		}
		if($event_date){
			$this->db->like('ped.price_event_date_dates',$event_date);
			$this->db->where('ped.price_event_date_status',1);
		}
		// $this->db->join($this->events, 'ped.price_event_date_event_id = e.event_id', 'left');
		$this->db->order_by('ped.price_event_date_name', 'asc'); 
		$query = $this->db->get('price_event_dates ped');
		
		$this->db->cache_off();
		if($query->num_rows() == 1){
			$result = $query->row();
		}else{
			$result = FALSE;
		}
		
		
		
		if($result){
			header ("Content-Type:text/xml");
			echo "<root>";
			echo "<price_event_date_id>" . $result->price_event_date_id . "</price_event_date_id>";
			echo "<price_event_date_event_id>" . $result->price_event_date_event_id . "</price_event_date_event_id>";
			echo "<price_event_date_name>" . $result->price_event_date_name . "</price_event_date_name>";
			echo "<price_event_date_price_id>" . $result->price_event_date_price_id . "</price_event_date_price_id>";
			echo "<price_event_date_dates>" . $result->price_event_date_dates . "</price_event_date_dates>";
			echo "</root>";
			die();
		}
		
		

	}
	
	function delete_db_cache(){
		$dbAccess = $this->load->database('market',true);
		$dbAccess->cache_delete_all();
		
		echo "DB Cache Deleted!";
		die();
	}
	
	function selected_seat_status(){
		
		$used_tickets = array();
		
		// print_r($this->input->post());
		
		foreach($this->input->post() as $item){

            $event_id = $item['event_id'];
            $section_id = $item['section_id'];
            $ticket_type = $item['ticket_type'];
            $system_row = $item['sys_row'];
            $system_col = $item['sys_col'];
            $row = $item['row'];
            $seat = $item['seat'];
            $priceid = $item['price_id'];
            $session = $item['session_id'];
			
			$ticket_id = $this->tickets->nt_select_ticket($event_id, $section_id, $ticket_type, $system_row, $system_col, $row, $seat,$priceid,$session);
			
			
			if(strpos( $ticket_id,"|") !== false ){
				
				$used_tickets[] = array('row'=>$row,'seat'=>$seat);
			
			}else{
				
				$count = $this->seat_status_x($section_id,$row,$seat,$ticket_id);
					
				if($count == 1){
					$used_tickets[] = array('row'=>$row,'seat'=>$seat);
				}
			}
				
	
			
				
		}

		if(!$used_tickets){
			echo "OK";
		}else{
			echo json_encode($used_tickets);
		}
		
		
	}
	
	function seat_status_x($section_id,$row,$seat,$ticket_id){
		
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->select('ticket_id, ticket_status');
		$this->db->where('ticket_section_id', $section_id);
		$this->db->where('ticket_row', $row);
		$this->db->where('ticket_seat', $seat);
		$query = $this->db->get('tickets');
		
		$status = array('done','selected','paid','paid_online','reserved');
		
		$result = 0;
		
		if($query->num_rows() > 0){
			$res = $query->result();
			foreach($res as $r){
				if(in_array($r->ticket_status,$status) && $r->ticket_id < $ticket_id){
					$result = 1;
				}
			}
		}
		
		if($result == 1){
			$this->db->set('ticket_status', 'unselected');
			$this->db->where('ticket_id', $ticket_id);
			$this->db->update('tickets');
		}
		
		return $result;
	}
	
	function nt_GetCustomerTransactions_lite(){

 		$customerid = $this->input->get_post('customerid');
	 
		$data['transactions'] = $this->transaction->get_customer_transactions_lite($customerid);
		 
		if(empty($data['transactions'])){
		$this->promptError('ER:04:22');
		}else{
		//display the page
		$this->load->view('customer_transactions_lite_xml', $data);
		}
	}
	
	function insert_exo($value,$ticket_id){
		$this->db->query('set transaction isolation level read uncommitted');
		$this->db->where("exo_ticket_id",$ticket_id);
		$query = $this->db->get("exo");
		
		$return = FALSE;
		
		if($query->num_rows() > 0){
			$this->db->set("exo_design",$value);
			$this->db->where("exo_ticket_id",$ticket_id);
			$this->db->update("exo");	
		}else{
			$this->db->set('exo_design', $value);
			$this->db->set('exo_ticket_id', $ticket_id);
			$this->db->insert('exo');
		}
		
		if($this->db->affected_rows()){
			$return = TRUE;
		}
		
		echo $return;
	}
	
	function insert_customer_tracking($customer_id = false)
	{
		
		if(!$customer_id) return false;
		$this->db->query('set transaction isolation level read uncommitted');
	  
		$this->db->set('tracking_customer_id', $customer_id);
		$this->db->insert('customers_tracking'); 
		
		
	}
	
}
/* End of file generic_mod.php */
/* Location: ./application/controllers/generic_mod.php */