<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');
include('accesstemplate.php');

class Promos extends AccessTemplate{


	
	public function __construct()
	{
		parent::__construct();
		$this->load->database('default',true);
	}	
	
		
	function view_pincode(){
		$this->tag_as_unsellected(); // auto unsellect all expired
		$pincode = $this->input->get_post("pin");
		$pin_set = $this->input->get_post("set");
		$price_id = $this->input->get_post("priceid");
		
		$result = false;		
		
		if(trim($pincode)){
			$dbAccess = $this->load->database('default',true);
			$dbAccess->where("qr_qrcode",$pincode);
			
			
			
			if($price_id && $pin_set!='ONEFAN' && $pin_set!='DISNEY15' && $pin_set!='DISNEY10' ){
				$dbAccess->where("qr_price_id",$price_id);	
			}
			
			if($price_id && $pin_set=='ONEFAN'){
				$price_id = array('28745', '28746', '28747','28750','25509' );
				$dbAccess->where_in("qr_price_id",$price_id);
			}
			
			
			if($pin_set){	
				if(	$pin_set == "wanderland" ){
					$pin_set = array('globe15_1', 'globe15_2', 'globe15_3','globe15_4','globe15_5','globeGosurf25','globeTattoo15' );
					$dbAccess->where_in('qr_set', $pin_set);
				}else{
					$dbAccess->where("qr_set",$pin_set);
				}
			}
			
			$query = $dbAccess->get('qrcode');
			
			
			// echo $dbAccess->last_query();
			// die();
			
			
			$row = $query->row();
			
			header ("Content-Type:text/xml");
			echo "<root>";
			
			if($row){
				$status = array("selected","unsellected","0","");
						if (	$row->qr_transaction_id  == "" && in_array($row->qr_status, $status)) {
							$this->tag_as_selected($pincode);
								if($pin_set){
									echo "<result>success</result>";
									echo "<ticket_type>". $row->qr_ticket_type_id	."</ticket_type>";
								}else{
									echo "<result>success</result>";
								}
						}else if($row->qr_transaction_id  == "" && $row->qr_status == "pending"){
							echo "<result>pending</result>";
						}else{
							echo "<result>invalid</result>";
						}	
			}else{
				echo "<result>invalid</result>";
			}
		}
		echo "</root>";
	}			
					
	function tag_as_selected($pincode){
		$dbAccess = $this->load->database('default',true);			
		$data = array(
		'qr_status' => "selected",
		'qr_datetime' =>  date("Y-m-d H:i:s"),
		);
		
		$dbAccess->where("qr_qrcode",$pincode);
		$dbAccess->where("qr_type",1);
		//$dbAccess->where("qr_status !=",'multiple');
		$status = array('used', 'pending');
		$dbAccess->where_not_in('qr_status', $status);
		$dbAccess->update('qrcode', $data); 		
	}			
					
	function tag_as_pending(){

		$pincode = $this->input->get_post("pin");
		$refno = $this->input->get_post("refno");
		
		// print_r($_GET);
		// die();

		$result = false;
		if(trim($pincode)){
			$dbAccess = $this->load->database('default',true);
			
			//tag pin 
 			$data2 = array(
			'trans_id' => $refno, 
			'promo_code' =>  $pincode,
			);
			$dbAccess->insert('qrcode_tracking', $data2); 	
			
			
				
			$data = array(
				'qr_status' => "pending",
				'qr_datetime' =>  date("Y-m-d H:i:s"),
				'qr_transaction_id' => $refno
			);

			$dbAccess->where("qr_qrcode",$pincode);
			$status = array('used', 'pending');
			// $dbAccess->where_not_in('qr_status', $status);
			// $dbAccess->where('qr_status !=', 'used');
			// $dbAccess->where('qr_status !=', 'pending');
			$dbAccess->where('qr_status', NULL);
			$dbAccess->where("qr_type",1);
			//$dbAccess->where("qr_status !=",'multiple');
			// $dbAccess->where_not_in('qr_usage', array("multiple"));
			$dbAccess->update('qrcode', $data); 			
			$ticket_count = $dbAccess->affected_rows();
		}

		header ("Content-Type:text/xml");
		echo "<root>";
		if($ticket_count > 0){
			echo "<result>success</result>";
		}else{
			echo "<result>failed</result>";
		}		
		echo "</root>";
		
		$dbAccess = $this->load->database('default',true);
		die();
					
			
	}
							
	function tag_as_used(){

		$pincode = $this->input->get_post("pin");
		$refno = $this->input->get_post("refno");

		$result = false;
		if(trim($pincode) != 'ONEFAN'){
			$dbAccess = $this->load->database('default',true);
			
			$data = array(
			'qr_status' => "used",
			'qr_datetime' =>  date("Y-m-d H:i:s"),
			);

			$dbAccess->where("qr_qrcode",$pincode);
			$dbAccess->where('qr_status', 'pending');
			$dbAccess->where("qr_type",1);
			//$dbAccess->where("qr_status !=",'multiple');
			$dbAccess->where('qr_transaction_id', $refno);
			
			$dbAccess->update('qrcode', $data); 			
			$ticket_count = $dbAccess->affected_rows();
		}

		header ("Content-Type:text/xml");
		echo "<root>";
		if($ticket_count > 0){
			echo "<result>success</result>";
		}else{
			echo "<result>failed</result>";
		}		
		echo "</root>";
		
		$dbAccess = $this->load->database('default',true);
		die();
					
			
	}
									
	function tag_as_unsellected(){

		$date = date("Y-m-d H:i:s", strtotime(date("Y-m-d H:i:s")) - (15 * 60)); // NOW() - 15 minutes();
		

	
		// $pincode = $this->input->get_post("pin");
	
		$result = false;
		// if(trim($pincode)){
			$dbAccess = $this->load->database('default',true);
			
				
			$data = array(
			'qr_status' => "unsellected",
			'qr_datetime' => date("Y-m-d H:i:s"),
			'qr_transaction_id' => ""
			);

			// $dbAccess->where("pin_codes",$pincode);
			$dbAccess->where('qr_status', 'pending');
			
			$dbAccess->where('qr_datetime <', $date );
			
			$dbAccess->where('qr_transaction_id <>', '0');
			
			$dbAccess->update('qrcode', $data); 			
			
			// echo $dbAccess->last_query();
			// die();
			
			$ticket_count = $dbAccess->affected_rows();
		// }

		// header ("Content-Type:text/xml");
		// echo "<root>";
	
			// echo "<result>$ticket_count tickets unsellected</result>";
		
		// echo "</root>";
		
		// $dbAccess = $this->load->database('default',true);
		// die();
					
			
	}
	
	function tag_as_unsellected_2(){

		$date = date("Y-m-d H:i:s", strtotime(date("Y-m-d H:i:s")) - (5 * 60)); // NOW() - 15 minutes();
		

	
		// $pincode = $this->input->get_post("pin");
	
		$result = false;
		// if(trim($pincode)){
			$dbAccess = $this->load->database('default',true);
			
				
			$data = array(
			'qr_status' => "unsellected",
			'qr_datetime' => date("Y-m-d H:i:s"),
			'qr_transaction_id' => ""
			);

			// $dbAccess->where("pin_codes",$pincode);
			$dbAccess->where('qr_status', 'pending');
			
			$dbAccess->where('qr_datetime <', $date );
			
			$dbAccess->where('qr_transaction_id <>', '0');
			
			$dbAccess->update('qrcode', $data); 			
			
			echo $dbAccess->last_query();
			die();
			
			$ticket_count = $dbAccess->affected_rows();
		// }

		// header ("Content-Type:text/xml");
		// echo "<root>";
	
			// echo "<result>$ticket_count tickets unsellected</result>";
		
		// echo "</root>";
		
		// $dbAccess = $this->load->database('default',true);
		// die();
					
			
	}
				
	function reset_pincode(){
		
		$pincode = $this->input->get_post("pin");
		$ip = $this->input->get_post("ip"); 

		$ticket_count = 0;
		if(trim($pincode)){
		$dbAccess = $this->load->database('pincode',true);
		
			$data = array(
			'pin_status' => "0"
			);
		
			$dbAccess->where("pin_status <>",'used');
			$dbAccess->where("pin_codes",$pincode);
			$dbAccess->update('pin_codes', $data); 
			
			$ticket_count = $dbAccess->affected_rows();
		}
			
			
			
			header ("Content-Type:text/xml");
			echo "<root>";
			if($ticket_count > 0){
				echo "<result>success</result>";
			}else{
				echo "<result>failed</result>";
			}		
			echo "</root>";
			
		$this->logResets($pincode,$ip);
			
				
		$dbAccess = $this->load->database('default',true);
		die();
	
	}
		
	function logResets($pincode = false,$ip = false){
		if(trim($pincode)){
		$dbAccess = $this->load->database('pincode',true);
			$data = array(
			'reset_pincode' => $pincode,
			'reset_dateTime' =>  date("Y-m-d H:i:s"),
			'reset_ip' =>  $ip,
			);
			$dbAccess->insert('resets', $data); 	
		return true;
		}
	}
	
	function view_pincode_2(){
		$this->tag_as_unsellected(); // auto unsellect all expired
		$pincode = $this->input->get_post("pin");
		$pin_set = $this->input->get_post("set");
		$price_id = $this->input->get_post("priceid");
		
		$result = false;		
		
		if(trim($pincode)){
			$dbAccess = $this->load->database('default',true);
			$dbAccess->query('set transaction isolation level read uncommitted');
			$dbAccess->where("qr_qrcode",$pincode);
			
			$dbAccess->where("qr_event_id",$pin_set);
			$query = $dbAccess->get('qrcode');
			
			
			// echo $dbAccess->last_query();
			// die();
			
			
			$row = $query->row();
			
			header ("Content-Type:text/xml");
			echo "<root>";
			
			if($row){
				$status = array("selected","unsellected","0","");
						if (	$row->qr_transaction_id  == "" && in_array($row->qr_status, $status)) {
							$this->tag_as_selected($pincode);
							echo "<result>success</result>";
						}else if($row->qr_transaction_id  == "" && $row->qr_status == "pending"){
							echo "<result>pending</result>";
						}else{
							echo "<result>invalid</result>";
						}	
			}else{
				echo "<result>invalid</result>";
			}
		}
		echo "</root>";
	}	

}