<?php include_once('header.php'); ?>

<div class="content">
	<h2>Edit Venue</h2>
    <div class="form_page">
        <?php echo (validation_errors()) ? '<div class="errors">Error!  Please review the information below.</div>' : ''; ?>
        
        <?php echo form_open('venues/edit/'.$venue->venue_id); ?>
		<input type='hidden' name='venue_id' value="<?php echo $venue->venue_id?>">
        <div class="half_page">
        	
            <h3>Venue Information</h3>
			
             <p>
                <label for="venue_type">Venue Type:</label> 
                <?php echo form_dropdown('venue_type', $this->config->item('venue_types'), set_value('venue_type', $venue->venue_type)); ?>
                <?php echo form_error('venue_type');?>
            </p>
						
            <p>
                <label for="venue_name">Name:</label> 
                <input type="text" name="venue_name" value="<?php echo set_value('venue_name', $venue->venue_name)?>" maxlength="100" />
                <?php echo form_error('venue_name');?>
            </p>
            
            <p>
                <label for="venue_address1">Address 1:</label> 
                <input type="text" name="venue_address1" value="<?php echo set_value('venue_address1', $venue->venue_address1)?>" maxlength="100" />
                <?php echo form_error('venue_address1');?>
            </p>
			
			<p>
                <label for="venue_address2">Address 2:</label> 
                <input type="text" name="venue_address2" value="<?php echo set_value('venue_address2', $venue->venue_address2)?>" maxlength="100" />
                <?php echo form_error('venue_address2');?>
            </p>
			
			<p>
                <label for="venue_city">City:</label> 
                <input type="text" name="venue_city" value="<?php echo set_value('venue_city', $venue->venue_city)?>" maxlength="100" />
                <?php echo form_error('venue_city');?>
            </p>
			
			<p>
                <label for="venue_zip">Zip Code:</label> 
                <input type="text" name="venue_zip" value="<?php echo set_value('venue_zip', $venue->venue_zip)?>" maxlength="100" />
                <?php echo form_error('venue_zip');?>
            </p>
			
			<p>
                <label for="venue_country">Country:</label> 
                <input type="text" name="venue_country" value="<?php echo set_value('venue_country', $venue->venue_country)?>" maxlength="100" />
                <?php echo form_error('venue_country');?>
            </p>
            
<!--            <p>
                <label for="venue_contact_id">Contact:</label> 
                <?php echo form_dropdown('venue_contact_id', $contacts, set_value('venue_contact_id', $venue->venue_contact_id)); ?>
                <?php echo form_error('venue_contact_id');?>
            </p>
-->
            <p>
                <label for="venue_website">Website:</label> 
                <input type="text" name="venue_website" value="<?php echo set_value('venue_website', $venue->venue_website)?>" maxlength="100"/>
                <?php echo form_error('venue_website');?>
            </p>
            
            <p>
                <label for="venue_direction">Direction:</label> 
                <input type="text" name="venue_direction" value="<?php echo set_value('venue_direction', $venue->venue_direction)?>" maxlength="100"/>
                <?php echo form_error('venue_direction');?>
            </p>
			
			<p>
                <label for="venue_active">Status:</label> 
                <input type="checkbox" name="venue_active" value="1"<?php echo set_checkbox('venue_active', '1', ($venue->venue_active == '1') ? TRUE : FALSE); ?> /> Active
                <?php echo form_error('venue_active');?>
            </p>
			
			<p>
                <label for="venue_type">Venue Category:</label> 
                <?php echo form_dropdown('venue_category', $this->config->item('venue_categories'), set_value('venue_category', $venue->venue_category)); ?>
                <?php echo form_error('venue_category');?>
            </p>
			
			


		</div> 
		
		<div class="half_page float_right">
			    <div class="listing">

					
        			<h3>Contacts</h3>
						<span class="listing_crud"><?php echo anchor('contacts/add/venue/'.$venue->venue_id, 'Add Contacts')?></span>
        					<table width="100%">
								<tr>
									<th>Name</th>
									<th>Work Phone Number</th>
									<th>Action</th>
								</tr>
							 <?php foreach($contacts as $contact): ?>
								<tr>
									<td><?php echo $contact->contact_firstname; ?><?php echo ' '?><?php echo $contact->contact_lastname; ?></td>
									<td><?php echo $contact->contact_phone; ?></td>
									<td><?php echo anchor('contacts/edit/'.$contact->contact_id.'/venues/'.$venue->venue_id, 'Edit'); ?> | <?php echo anchor('contacts/delete/'.$contact->contact_id.'/venue/'.$venue->venue_id, 'Delete', array('onclick'=>"return confirm('Are you sure you want to delete this Contact?');")); ?></td>
								</tr>
								<?php endforeach ?>
							</table>
					
					<h3>Login Info</h3>
					<p>
						<label for="venue_username">Username:</label> 
						<input type="text" name="venue_username" value="<?php echo $venue->venue_username?>" maxlength="100" />
						<?php echo form_error('venue_username');?>
					</p>
					
					<p>
						<label for="venue_password">Password:</label> 
						<input type="password" name="venue_password" value="" maxlength="100"/>
						<?php echo form_error('venue_password');?>
					</p>
					
					<p class="form_caption">
						<label for="caption">&nbsp;</label> 
						<small>Leave the password field blank if not changing</small>
					</p>
					
					<p class="submit_button">
						<label for="submit">&nbsp;</label> 
						<button type="submit">Save Changes</button> or <?php echo anchor('venues/listing', 'Cancel'); ?>
					</p>
    			</div>
		</div>       
        </form>
		
		<div class="clearfix"></div>
    </div>

</div> <!-- content -->

<?php include_once('footer.php'); ?>

