<?php include_once('header.php'); ?>

<div class="content">
	<h2>Add Venue</h2>
    <div class="form_page">
        <?php echo (validation_errors()) ? '<div class="errors">Error!  Please review the information below.</div>' : ''; ?>
        
        <?php echo form_open('venues/add/'); ?>

        <div class="half_page">
        	
            <h3>Venue Info</h3>
			<p>
                <label for="venue_type">Venue Type:</label> 
                <?php echo form_dropdown('venue_type', $this->config->item('venue_types'), set_value('venue_type')); ?>
                <?php echo form_error('venue_type');?>
            </p>

            <p>
                <label for="venue_name">Name:</label> 
                <input type="text" name="venue_name" value="<?php echo set_value('venue_name')?>" maxlength="100"/>
                <?php echo form_error('venue_name');?>
            </p>
            
            <p>
                <label for="venue_address1">Address 1:</label> 
                <input type="text" name="venue_address1" value="<?php echo set_value('venue_address1')?>" maxlength="100"/>
                <?php echo form_error('venue_address1');?>
            </p>

            <p>
                <label for="venue_address2">Address 2:</label> 
                <input type="text" name="venue_address2" value="<?php echo set_value('venue_address2')?>" maxlength="100"/>
                <?php echo form_error('venue_address2');?>
            </p>
			
            <p>
                <label for="venue_city">City:</label> 
                <input type="text" name="venue_city" value="<?php echo set_value('venue_city')?>" maxlength="100"/>
                <?php echo form_error('venue_city');?>
            </p>
			
			<p>
                <label for="venue_zip">Zip Code:</label> 
                <input type="text" name="venue_zip" value="<?php echo set_value('venue_zip')?>" maxlength="100"/>
                <?php echo form_error('venue_zip');?>
            </p>
			
			<p>
                <label for="venue_country">Country:</label> 
                <input type="text" name="venue_country" value="<?php echo set_value('venue_country')?>" maxlength="100"/>
                <?php echo form_error('venue_country');?>
            </p>						
            
            <p>
                <label for="venue_website">Website:</label> 
                <input type="text" name="venue_website" value="<?php echo set_value('venue_website')?>" maxlength="100"/>
                <?php echo form_error('venue_website');?>
            </p>
            
            <p>
                <label for="venue_direction">Direction:</label> 
                <input type="text" name="venue_direction" value="<?php echo set_value('venue_direction')?>" maxlength="100"/>
                <?php echo form_error('venue_direction');?>
            </p>
			<!--<p>
                <label for="venue_category">Venue Category:</label> 
                <?php echo form_dropdown('venue_category', $this->config->item('venue_categories'), set_value('venue_category')); ?>
                <?php echo form_error('venue_category');?>
            </p>-->
	 
		</div> 

		<div class="half_page float_right">
              
			<h3>Login Info</h3>
            <p>
                <label for="venue_username">Username:</label> 
                <input type="text" name="venue_username" value="" maxlength="100" />
                <?php echo form_error('venue_username');?>
            </p>
            
            <p>
                <label for="venue_password">Password:</label> 
                <input type="password" name="venue_password" value="" maxlength="100" />
                <?php echo form_error('venue_password');?>
            </p>
             
            <p class="submit_button">
            	<label for="submit">&nbsp;</label> 
                <button type="submit">Add Venue</button> or <?php echo anchor('venues/listing', 'Cancel'); ?>
            </p>
						
		</div>   		
        </form>
        <div class="clearfix"></div>
    </div>

</div> <!-- content -->

<?php include_once('footer.php'); ?>
