<?php include_once('header.php'); ?>

<div class="content">
	<h2>Add User</h2>
    <div class="form_page">
        <?php echo (validation_errors()) ? '<div class="errors">Error!  Please review the information below.</div>' : ''; ?>
        
        <?php echo form_open('users/add/'); ?>

        <div class="half_page">
        	<h3>User Info</h3>
            
            <p>
                <label for="username">Username:</label> 
                <input type="text" name="username" value="<?php echo set_value('username')?>" maxlength="100"/>
                <?php echo form_error('username');?>
            </p>
            
            <p>
                <label for="password">Password:</label> 
                <input type="password" name="password" value="<?php echo set_value('password')?>" maxlength="100"/>
                <?php echo form_error('password');?>
            </p>
            
            <p>
                <label for="email">Email:</label> 
                <input type="text" name="email" value="<?php echo set_value('email')?>" maxlength="100"/>
                <?php echo form_error('email');?>
            </p>

            <p>
                <label for="firstname">First Name:</label> 
                <input type="text" name="firstname" value="<?php echo set_value('firstname')?>" maxlength="100"/>
                <?php echo form_error('firstname');?>
            </p>
            
            <p>
                <label for="lastname">Last Name:</label> 
                <input type="text" name="lastname" value="<?php echo set_value('lastname')?>" maxlength="100"/>
                <?php echo form_error('lastname');?>
            </p>
            
            <p>
                <label for="user_type">User Type:</label>
                <?php echo form_dropdown('user_type', $this->config->item('user_types'), set_value('user_type')); ?>
                <?php echo form_error('user_type');?>
            </p>

            <p>
                <label for="branch_id">Branch:</label> 
                <?php echo form_dropdown('branch_id', $branches, set_value('branch_id')); ?>
                <?php echo form_error('branch_id');?>
            </p>
            
            <p>
                <label for="terminal_id">Terminal:</label> 
                <?php echo form_dropdown('terminal_id', $terminals, set_value('terminal_id')); ?>
                <?php echo form_error('terminal_id');?>
            </p>
                
            <p class="submit_button">
            	<label for="submit">&nbsp;</label> 
                <button type="submit">Add User</button> or <?php echo anchor('users/listing', 'Cancel'); ?>
            </p>
		</div>        
        </form>
        
        <div class="clearfix"></div>
    </div>

</div> <!-- content -->

<?php include_once('footer.php'); ?>