<?php include_once('header.php'); ?>
<script type="text/javascript"> 
	$(document).ready(function() {
		$('input.sum').bind('keyup', function() {
			$(this).val( $(this).val().replace(/[^0-9]/g,'') ); 
			$("#total_payment").val( $('input.sum').sumValues().toFixed(2) );
			var change = $('#total_payment').val() - $('#transaction_total_amount').val();
			$("#total_change").val( change.toFixed(2));
			$("#total_change_display").val( change.toFixed(2));
			
			if (change >= 0) {
				$('.submit_button').fadeIn();
			} else {
				$('.submit_button').fadeOut();
			}
		});
		$("#payment_option_box_1").show();
	});
	
	$.fn.sumValues = function() {
		var sum = 0; 
		this.each(function() {
			if ( $(this).is(':input') ) {
				var val = $(this).val();
			} else {
				var val = $(this).text();
			}
			sum += parseFloat( ('0' + val).replace(/[^0-9-\.\,]/g, ''), 10 );
		});
		return sum;
	};
	
	var timeout    = 500;
	var closetimer = 0;
	var ddmenuitem = 0;
	
	function jspdm_open()
	{  jspdm_canceltimer();
	   jspdm_close();
	   ddmenuitem = $(this).find('ul').css('visibility', 'visible');}
	
	function jspdm_close()
	{  if(ddmenuitem) ddmenuitem.css('visibility', 'hidden');}
	
	function jspdm_timer()
	{  closetimer = window.setTimeout(jspdm_close, timeout);}
	
	function jspdm_canceltimer()
	{  if(closetimer)
	   {  window.clearTimeout(closetimer);
		  closetimer = null;}}
	
	$(document).ready(function()
	{  $('#jspdm > li').bind('mouseover', jspdm_open)
	   $('#jspdm > li').bind('mouseout',  jspdm_timer)});
	
	document.onclick = jspdm_close;
</script>

<div class="content">
	<h2><?php echo $price->event_title ?></h2>
   
    <div class="form_page">
        <?php echo (validation_errors()) ? '<div class="errors">Error!  Please review the information below.</div>' : ''; ?>
       <!-- <?php $data['uri'] = ($claim == 'claim') ? 'claim/'.$transaction_id : ''; ?>-->
        <?php echo form_open('transactions/payment_reservation/'.$uri) ?>

        <div class="half_page">
        	<h3>Customer Info</h3>
            
            <ul class="details">
                <li class="clearfix">
                    <dl>
                        <dt>Customer:</dt>
                        <dd><?php echo $customer->customer_firstname ?> <?php echo $customer->customer_lastname ?></dd>
                    </dl>
                </li>
                <li class="clearfix">
                    <dl>
                        <dt>Mobile:</dt>
                        <dd><?php echo $customer->customer_mobile ?></dd>
                    </dl>
                </li>
            </ul>
            
             
		</div> 
        
        <div class="half_page float_right payment">
		
			<ul id="jspdm" style="float: right; margin-top: -5px;">
				<li><small><a href="javascript:;" id="other_payment_option">Add Other Tender Type</a></small>
					<ul>
						<?php foreach($payment_types as $payment_type): ?>
							<?php if ($payment_type->payment_type_name != 'Cash'): ?>
								<li><a href="javascript:;" id="payment_option_<?php echo $payment_type->payment_type_id; ?>"><?php echo $payment_type->payment_type_name; ?> (<?php echo $payment_type->payment_type_type; ?>)</a></li>
							<?php endif; ?>
						<?php endforeach; ?>
					</ul>
					<div class="clear"></div>
				</li>
			</ul>
        	<h3>Payment Info</h3>
            
            <p>
                <label for="transaction_total_amount">Amount Due:</label> 
                <input class="money_field disabled" type="text" name="transaction_total_amount" value="<?php echo set_value('transaction_total_amount')?>" id="transaction_total_amount" maxlength="100" />
            </p>
            
             <?php foreach($payment_types as $payment_type): ?>
            	<span id="payment_option_box_<?php echo $payment_type->payment_type_id; ?>" class="hide">
                <p>
                    <label for="transaction_cash_payment"><?php echo $payment_type->payment_type_name; ?>:</label> 
                    <input class="money_field sum" type="text" name="transaction_payment_<?php echo $payment_type->payment_type_id; ?>" value="<?php echo set_value('transaction_payment_'.$payment_type->payment_type_id)?>" id="transaction_payment_<?php echo $payment_type->payment_type_id; ?>" maxlength="100" />
                    <?php echo form_error('transaction_payment_'.$payment_type->payment_type_id);?>
                </p>
                </span>
            <?php endforeach; ?>

			<script>
			<?php foreach($payment_types as $payment_type): ?>
				$("#payment_option_<?php echo $payment_type->payment_type_id; ?>").click(function () {
					$("#payment_option_box_<?php echo $payment_type->payment_type_id; ?>").show();
				});
			<?php endforeach; ?>
            </script>
            
            <p>
                <label for="total_payment">Total Payment:</label> 
                <input class="money_field disabled" type="text" name="total_payment" value="<?php echo set_value('total_payment', '0.00')?>" id="total_payment" maxlength="100" />
                <?php echo form_error('total_payment');?>
            </p>
            
            <p>
                <label for="total_change_display">Change:</label> 
                <input class="money_field disabled" type="text" name="total_change_display" value="<?php echo set_value('total_change_display', '0.00')?>" id="total_change_display" maxlength="100" />
                <input type="hidden" name="total_change" value="<?php echo set_value('total_change')?>" id="total_change" />
                <?php echo form_error('total_change');?>
            </p>
            
            <p class="submit_button hide">
    	        <label for="submit">&nbsp;</label> 
        	    <button type="submit">Add Payment and Print Tickets</button>
       		</p>
            
		</div>   
        
	        
            
        </form>
        
        <div class="clearfix"></div>
    </div>
    &nbsp;
    <div class="listing form_page">
    	<h3>Summary</h3>
      		<table width="100%">
            <tr>
                <th>Section</th>
                <th>Row</th>
                <th>Seat</th>
                <th>Type</th>
                <th>Amount</th>
            </tr>
            <?php $total = 0; ?>
            <?php foreach($tickets as $ticket): ?>
            	<?php if ($ticket->ticket_type_discount_type == 'Amount'): ?>
                	<?php $amount = ceil($price->price_price - $ticket->ticket_type_discount); ?>
                <?php elseif ($ticket->ticket_type_discount_type == 'Percentage'): ?>
                	<?php $amount = ceil($ticket->price_price - (($ticket->price_price * $ticket->ticket_type_discount)/100)); ?>
                <?php endif; ?>
                <?php $total += $amount; ?>
            	<tr>
                	<td><?php echo $price->price_name; ?> - <?php echo $ticket->section_name; ?></td>
                    <td><?php echo $ticket->ticket_row; ?></td>
                    <td><?php echo $ticket->ticket_seat; ?></td>
                    <td><?php echo $ticket->ticket_type_name; ?></td>
                    <td><?php echo number_format($amount, 2); ?></td>
                </tr>
            <?php endforeach; ?>
            <tr>
                <th colspan="4">Total</th>
                <th><?php echo number_format($total, 2); ?></th>
            </tr>
            </table>
        <div class="clearfix"></div>
        <script>$("#transaction_total_amount").val('<?php echo number_format($total, 2, '.', '') ?>'); </script>

    </div>
	</form>
</div> <!-- content -->

<?php include_once('footer.php'); ?>
