<?php include_once('header.php'); ?>

<div class="content">
	<h2>Claim Tickets</h2>
    <div class="form_page">
		<?php echo validation_errors(); ?>

		<div class="half_page listing">
			<h3>By Transaction</h3>
			<p>Use this to print all tickets bought in a particular transaction</p>
			<?php echo form_open('claims/transaction/print'); ?>
			<span>
			  <label>Transaction ID: </label>
			  <input type="text" name="t_id" maxlength="100" />
			</span>
			<button type="submit" class="search-button">Search</button>
			<?php echo form_close();?>
			<?php if (isset($transactions)): ?>
			<h3>Ticket Details</h3>
				<?php  if (count($transactions) > 0 and count($transactions_tickets) <= 0): ?>
				
				<?php if($transactions->blocked ==1):?>
				<div class="errors">
				
				THIS TRANSACTION IS BEING VERIFIED WITH THE BANK. PLEASE GET THE NAME AND CONTACT NUMBER OF THE CUSTOMER AND WE WILL CONTACT THEM ONCE WE GET CONFIRMATION FROM THE BANK.
				THANK YOU FOR YOUR UNDERSTANDING. FOR ADDITIONAL ASSISTANCE, PLEASE CALL SM CUSTOMER CARE 470-2222.
 				</div>
				<?php else:?>
				
				<?php if($transactions->transaction_branch_id== 90 && $transactions->transaction_status == 'done'){?>
				
						<div class="errors">Tickets for this transaction were already claimed.</div>
				
				<?php }else{?>
				 
						<?php 
						$trans_date = strtotime($transactions->transaction_date);
						$april_fools = strtotime('2018-04-01 00:00:00');
						// echo $trans_date .'<br>' ;
						// echo $april_fools;
						
						if($trans_date < $april_fools || $transactions->transaction_branch_id == 90){ ?>
						
						
							<table width="100%">
								<tr>
									<th>Trans Date</th>
									<th>Trans ID</th>
									<th>Tickets</th>
									<th>Print</th>
								</tr>
								<tr>
									<td><?php echo date("m/d/y", strtotime($transactions->transaction_date)); ?></td>
									<td><?php echo $transactions->transaction_id; ?></td>
									<td><?php echo $ticket_count = $transactions->ticket_count; ?></td>
									<td><a href="<?php echo base_url() . "claims/print_tickets/".$transactions->ticket_event_id. "/".$transactions->transaction_id.'/'.strtoupper(hash("crc32", $transactions->transaction_id)). "/$ticket_count"; ?>">Print Tickets</a>
									
									</td>
								</tr>
									
							</table>
							
							 
						<?php }else{ ?>
						
						<div class="errors">Tickets for this transaction were already claimed.</div>
						
							<?php }?>
					<?php }?>
				<?php endif;?>
				
				<?php else: ?>
					<?php if (count($transactions_tickets) > 0) { ?>
					<div class="errors">Tickets for this transaction were already claimed.</div>
					<?php } else { ?>
					<div class="errors">Unable to find transaction.</div>
					<?php } ?>
				<?php endif; ?>
			
			<?php endif;?>
			<p><b>OPERATIONS:<br>Please carefully verify the transaction being claimed. Make sure that the customer knows the transaction details. Thank you.</b></p>
						
		</div>
		
		<div class="half_page listing float_right">
			<?php if (isset($transactions) and $transactions): ?>
			<div id="listing_detail" class="clearfix">
				<h3>Transaction Info</h3>
				<ul class="details">
					<li class="clearfix">
						<dl>
							<dt>Transaction Date:</dt>
							<dd><?php echo date("D M d, Y  H:i:s", strtotime($transactions->transaction_date)); ?></dd>
						</dl>
					</li>
                    <li class="clearfix">
						<dl>
							<dt>Terminal:</dt>
							<dd><?php echo $transactions->terminal_name; ?></dd>
						</dl>
					</li>
                    <li class="clearfix">
						<dl>
							<dt>Branch:</dt>
							<dd><?php echo $transactions->branch_name; ?></dd>
						</dl>
					</li>
                    <li class="clearfix">
						<dl>
							<dt>Seller:</dt>
							<dd><?php echo $transactions->user_firstname; ?> <?php echo $transactions->user_lastname?></dd>
						</dl>
					</li>	
                </ul>
                
				<h3>Customer Info</h3>
				<ul class="details">
					<li class="clearfix">
						<dl>
							<dt>Customer:</dt>
							<dd><?php echo $transactions->customer_firstname ?> <?php echo $transactions->customer_lastname ?></dd>
						</dl>
					</li>
					<li class="clearfix">
						<dl>
							<dt>Mobile:</dt>
							<dd><?php echo $transactions->customer_mobile ?></dd>
						</dl>
					</li>
				</ul>
				
				<?php if (count($transactions_tickets) > 0): ?>
				<h3>Claimed Info</h3>
				<ul class="details">
					<li class="clearfix">
						<dl>
							<dt>Claim Date:</dt>
							<dd><?php echo date("D M d, Y  H:i:s", strtotime($transactions_tickets[0]->claim_date_time)); ?></dd>
						</dl>
					</li>
                    <li class="clearfix">
						<dl>
							<dt>Terminal:</dt>
							<dd><?php echo $transactions_tickets[0]->terminal_name; ?></dd>
						</dl>
					</li>
                    <li class="clearfix">
						<dl>
							<dt>Branch:</dt>
							<dd><?php echo $transactions_tickets[0]->branch_name; ?></dd>
						</dl>
					</li>
                    <li class="clearfix">
						<dl>
							<dt>Seller:</dt>
							<dd><?php echo $transactions_tickets[0]->user_firstname; ?> <?php echo $transactions_tickets[0]->user_lastname?></dd>
						</dl>
					</li>	
                </ul>
				<?php endif; ?>
			</div>
				
			<?php endif;?>		
		</div>

		<div class="clearfix"></div>
    </div>

</div> <!-- content -->
<?php include_once('footer.php'); ?>

