<?php 
// include pdf libraries
require(APPPATH.'/libraries/lib_pdf/fpdf/fpdf.php');

class PDF extends FPDF
{
	var $width_col_r = 220;
	//Page header
	function Header()
	{
		//Logo
		$this->Image('resources/images/logo.jpg',20,15,140);
		
		// acknowledgement receipt
		$this->SetTextColor(64, 64, 64);
		$this->SetXY(370,20);
		$this->SetFont('Arial','',12);
		$this->Cell($this->width_col_r,20,'AAcknowledgement Receipt',0,0,'C');
		
		// company info
		$this->SetXY(370,42);
		$this->SetFont('Arial','',8);
		$this->Cell($this->width_col_r,0,'SM PRIME HOLDINGS, INC.',0,0,'C');

		$this->SetFont('Arial','',6);
		$this->SetXY(370,50);
		$this->Cell(220,0,'11F Mall Of Asia Arena Annex Building',0,0,'C');
		$this->SetXY(370,58);
		$this->Cell(220,0,'Coral Way corner J.W. Diokno Boulevard',0,0,'C');
		$this->SetXY(370,66);
		$this->Cell(220,0,'Mall Of Asia Complex, Brgy. 076 Zone 10, Pasay City',0,0,'C');
		$this->SetXY(370,74);
		$this->Cell(220,0,'TEL 4702222   FAX 4773510',0,0,'C');
		$this->SetXY(370,82);
		$this->Cell(220,0,'www.smtickets.com',0,0,'C');
		$this->SetXY(370,90);
		$this->Cell(220,0,'TIN 003-058-789-041 VAT',0,0,'C');

		/*$this->SetTextColor(54, 45, 128);
		$this->SetXY(110,34);
		$this->SetFont('Arial','B',24);
		$this->Cell(120,25,'470.22.22',0,0,'C');
		
		/*$this->SetXY(110,54);
		$this->SetFont('Arial','',6);
		$this->Cell(120,10,'Get them at any SM Cinema Ticketbooths',0,0,'C');
		
		$this->SetXY(110,64);
		$this->SetFont('Arial','',6);
		$this->Cell(120,10,'www.smtickets.com',0,0,'C');*/
		
		// voucher
		$this->SetTextColor(95, 95, 95);
		$this->SetXY(165,37);
		$this->SetFont('Arial','B',15);
		$this->Cell(300,20,'CLAIM TICKET VOUCHER',0,0,'L');

		$this->Line(25, 72, 354, 72);
		
		$this->Rect(370, 20, 220, 195);
		
		// company
		/*$this->SetXY(142,65);
		$this->SetFont('Arial','I',8);
		$this->Cell(450,10,'SM PRIME HOLDINGS, INC. / Mall Of Asia, Pasay City / TIN 003-058-789-041',0,0,'R');
		*/
		// note
		$this->SetFont('Arial','I',9);
		$this->SetXY(200,325);
		$this->MultiCell(390, 10, 'This is not yet your actual ticket to the venue. Please bring this CLAIM TICKET VOUCHER to any SM TICKETS outlets located in all SM CINEMA nationwide to redeem your actual ticket. It is your responsibility to protect your voucher. Redemption can only be done ONCE. Any succeeding attempt will not be accepted by the system. v/', 0, 'C', FALSE);

		//Line break
		$this->Ln(20);
	}
	
	//Page footer
	function Footer()
	{
		//Position at 1.5 cm from bottom
		$this->SetY(-15);
		//Arial italic 8
		$this->SetFont('Arial','I',8);
		//Page number
		$this->Cell(0,10,'Page '.$this->PageNo().'/{nb}',0,0,'C');
	}
}


//Instantiation of inherited class
$pdf=new PDF('P', 'pt', 'Letter');
$pdf->SetMargins(30, 30);
$pdf->AliasNbPages();
$pdf->SetDrawColor(183, 183, 183);
$pdf->SetFont('Times','',12);
$pdf->SetAutoPageBreak(true,0);
$in = 72; // inch
$right_panel_width = 440;
$left_panel_width = 180;
$line_text_margin = 0;
$logo_height = 25;
$logo_width = 0;
$logo_count = 0;
$logo_margin = 5;
$text_margin = 2;
$left_container_width = 88;
$left_text_margin = 1;
		


// transaction barcode
$barcode_hash = hash("crc32", $transaction->transaction_id);
$barcode_hash = strtoupper($barcode_hash);
$transaction_barcode = base_url().'resources/barcode/barcode.php?text='.$barcode_hash;
	
// add barcode to transactions table
$this->transactions->add_barcode($transaction->transaction_id, $barcode_hash);
	
foreach ($tickets as $ticket)
{
	$pdf->AddPage();
	
	//print_array($transaction);
	// customer name
	$pdf->SetXY(20,90);
	$pdf->SetFont('Arial','',10);
	$pdf->Write(10, 'Customer Name:');
	$pdf->SetX(110);
	$pdf->SetFont('Arial','B',10);
	$pdf->Write(10,  iconv("UTF-8", "ISO-8859-1", $transaction->customer_firstname . ' ' .  $transaction->customer_lastname));
	
	// customer address
	$pdf->SetXY(20,105);
	$pdf->SetFont('Arial','',10);
	$pdf->Write(10, 'Customer Address:');
	$pdf->SetX(110);
	$pdf->SetFont('Arial','B',10);
	$pdf->Write(10,  iconv("UTF-8", "ISO-8859-1", $transaction->customer_address1 . ' ' .  $transaction->customer_address2));
	$pdf->SetXY(110,115);
	$pdf->Write(10,  iconv("UTF-8", "ISO-8859-1", $transaction->customer_city . ' ' .  $transaction->customer_nationality));
	
	// customer email
	$pdf->SetXY(20,130);
	$pdf->SetFont('Arial','',10);
	$pdf->Write(10, 'Email Address:');
	$pdf->SetX(110);
	$pdf->SetFont('Arial','B',10);
	$pdf->Write(10, $transaction->customer_email);
	
	// customer mobile
	$pdf->SetXY(20,145);
	$pdf->SetFont('Arial','',10);
	$pdf->Write(10, 'Mobile Number:');
	$pdf->SetX(110);
	$pdf->SetFont('Arial','B',10);
	$pdf->Write(10, $transaction->customer_mobile);
	
	// payment type
	$pdf->SetXY(20,160);
	$pdf->SetFont('Arial','',10);
	$pdf->Write(10, 'Payment Type:');
	$pdf->SetX(110);
	$pdf->SetFont('Arial','B',10);
	$pdf->Write(10, $payment_type);
	
	// total amount
	$pdf->SetXY(20,175);
	$pdf->SetFont('Arial','',10);
	$pdf->Write(10, 'Amount Paid:');
	$pdf->SetX(110);
	$pdf->SetFont('Arial','B',10);
	$pdf->Write(10, 'Php ' . number_format($total_amount, 2));
	
	
	// -----------------------------
	
	
	$pdf->SetTextColor(64, 64, 64);
	$pdf->SetFont('Arial','',8);
	
	$pdf->SetXY(370,102);
	$pdf->Cell(220,0,$tickets[0]->section_name,0,0,'C');

	$pdf->SetXY(370,110);
	$pdf->Cell(220,0,'Qty    Ticket Price      Total Amount',0,0,'C');
	
	$ticket_count = count($tickets);
	$pdf->Cell(220,0,$ticket_count,0,0,'C');

	
	$pdf->SetXY(370,118);
	$items2 = $ticket_count . '      P ' . number_format($ticket->price_price, 2) . '       P ' . number_format($ticket->price_price * $ticket_count, 2);
	$pdf->Cell(220,0,$items2,0,0,'C');
	
	$pdf->SetXY(370,130);
	$acknowledgement_receipt = ($ticket->ticket_acknowledgment_receipt) ? sprintf("%06d", $ticket->ticket_acknowledgment_receipt) : 0;
	$pdf->Cell(220,0,'Acknowledgement Receipt No. '.$acknowledgement_receipt,0,0,'C');
	
	$pdf->SetXY(370,140);
	$pdf->Cell(220,0,'Transaction ID '.$transaction->transaction_id,0,0,'C');
	
	$pdf->SetXY(370,150);
	$pdf->Cell(220,0,mysqldatetime_to_date($transaction->transaction_date, $format = "m/d/Y h:ia"),0,0,'C');
	
	$pdf->SetXY(370,160);
	$pdf->Cell(220,0,'This serves as your proof of payment',0,0,'C');
	
	
	

	// transaction date
	/*$pdf->SetXY(440,120);
	$pdf->SetFont('Arial','',9);
	$pdf->Write(10, 'Transaction Date:');
	$pdf->SetFont('Arial','0',8);
	$pdf->SetXY(370,80);
	$pdf->Cell(220,6,mysqldatetime_to_date($transaction->transaction_date, $format = "m/d/Y h:ia"),0,0,'C');
	*/
	// transaction barcode
	
	$pdf->SetFont('Arial','',8);
	$pdf->SetXY(370,170);
	$pdf->Cell(220,6,'Transaction Code '.$barcode_hash,0,0,'C');
	
	if ($voucher_type == 'all')
	{
		//$pdf->SetXY(300,200);
		$pdf->Image($transaction_barcode, 416, 180, 0, 30, 'PNG');
	}
	
	
	
	// -----------------------------
	
	
	if ($voucher_type == 'one')
	{
		// row - seat
		$pdf->SetXY(20,210);
		$pdf->SetFont('Arial','',9);
		$pdf->Write(10, 'ROW - SEAT');
		
		$pdf->SetTextColor(95, 95, 95);
		$pdf->SetXY(22,220);
		$pdf->SetFont('Arial','B',20);
		$ticket_row = ($ticket->ticket_row) ? $ticket->ticket_row . ' - ': '';
		$pdf->Cell(170, 20, $ticket_row . $ticket->ticket_seat, 1, 0, 'C');
		
		// section
		$pdf->SetXY(20,245);
		$pdf->SetFont('Arial','',9);
		$pdf->Write(10, 'SECTION');
		
		$pdf->SetTextColor(95, 95, 95);
		$pdf->SetXY(22,255);
		$pdf->SetFont('Arial','B',10);
		$pdf->Cell(170, 16, $ticket->section_name, 1, 0, 'C');
		
		// amount
		$pdf->SetXY(20,280);
		$pdf->SetFont('Arial','',9);
		$pdf->Write(10, 'TICKET AMOUNT');
	
		$pdf->SetTextColor(95, 95, 95);
		$pdf->SetXY(22,290);
		$pdf->SetFont('Arial','B',12);
		$pdf->Cell(170, 15, 'P ' . number_format($ticket->price_price, 2), 1, 0, 'C');
	
		// ticket code	
		$barcode_hash = hash("crc32", $ticket->ticket_id);
		$barcode_hash = strtoupper($barcode_hash);
		$barcode = base_url().'resources/barcode/barcode.php?text='.$barcode_hash;
		
		$pdf->SetXY(20,320);
		$pdf->SetFont('Arial','',9);
		$pdf->Write(10, 'TICKET CODE: ' . $barcode_hash);
		
		// bar code image
		$pdf->Image($barcode, 25, 336, 0, 30, 'PNG');
		
		// add barcode to tickets table
		$this->tickets->add_barcode($ticket->ticket_id, $barcode_hash);
	}
	else
	{
		// tickets
		$pdf->SetXY(20,208);
		$pdf->SetFont('Arial','B',10);
		$pdf->Write(10, 'TICKETS (Section/Seat)');
		
		$pdf->Rect(20, 220, 175, 145);
		
		$i = 0;
		$pdf->SetFont('Arial','',8);
		foreach ($tickets as $ticket2)
		{
			$i += 14;
			$pdf->SetXY(22,208+$i);
			$ticket_row = ($ticket2->ticket_row) ? $ticket2->ticket_row . ' - ': '';
			$pdf->Cell(170, 14, $ticket2->section_name . ' / ' . $ticket_row . $ticket2->ticket_seat, 0, 0, '');
			//$pdf->Line(24, 222+$i, 190, 222+$i);
		}
	}
	
	// -----------------------------
	
	// sponsors 
	
	$pdf->Rect(200, 220, 390, 100);
	$y = 240;

	// event title
	$pdf->SetXY(200,$y);
	$pdf->SetFont('Arial','B',15);
	$pdf->Cell(390, 24, $event->event_title, 0, 0, 'C');
	$y += 15;
	
	// event venue
	$pdf->SetXY(200,$y);
	$pdf->SetFont('Arial','B',10);
	$pdf->Cell(390, 24, $event->venue_name, 0, 0, 'C');
	$y += 15;
	
	// event date
	$pdf->SetXY(200,$y);
	$pdf->SetFont('Arial','B',10);
	$pdf->Cell(390, 24, mysqldatetime_to_date($event->event_date_time, $format = "l, M d, Y h:ia"), 0, 0, 'C');
	
	
	

	// fold here	
	$pdf->SetY(386);
	$pdf->SetFont('Arial','',7);
	//$pdf->Cell(0,0,'- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -  FOLD IN HALF  - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -',0,1,'C');
	$pdf->Cell(0,0,'- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - ',0,1,'C');
	
	
	// poster
	if (empty($bcode)) {
		$pdf->Rect(20, 400, 270, 360);
		if (file_exists(base_url() . 'uploads/' . $event->event_image)) {
			$pdf->Image(base_url() . 'uploads/' . $event->event_image, 30, 410, 0, 315, 'JPG');
		}
	}
	else {
	$pdf->Rect(20, 400, 270, 100);
	/// $pdf->SetXY(0,410);
	$pdf->SetFont('Arial','B',12);
	// $pdf->Write(10, $bcode);
	$tmp = str_split($bcode,10);
	$bcode = '';
	foreach($tmp as $line) {
		$bcode = $bcode.'='.chunk_split($line,5,"=")."\n";
	}
	$pdf->MultiCell(250,14,"\n\nbCODE\n\n$bcode",0,'C');
	$pdf->Rect(20, 500, 270, 260);
	$pdf->Image(base_url() . 'uploads/' . $event->event_image, 30, 510, 250, 240, 'JPG');
	}
	// terms and conditions
//	$pdf->Rect(300, 400, 290, 180);
	$width_col_w_orig = 290;
	// $width_col_w_r = 220;
	$width_col_w_r = $width_col_w_orig;
	$width_col_x_orig = 300;
	$diff = $width_col_w_orig - $width_col_w_r;
	$pdf->Rect($width_col_x_orig + $diff, 400, $width_col_w_r, 215-15);
	$pdf->SetTextColor(64, 64, 64);
	$pdf->SetTextColor(255, 0, 0);
	$pdf->SetXY(305,410);
	$pdf->SetFont('Arial','B',8);
//	$pdf->Write(10, 'TERMS AND CONDITIONS');
	$pdf->Write(11, 'NOTICE TO ONLINE CUSTOMER');
	
	// $ticket_terms = file_get_contents(base_url() . '/resources/terms/notice.txt', true);
	// $ticket_terms = file_get_contents(base_url() . '/resources/terms/checklist.txt', true);
	$ticket_terms = file_get_contents(base_url() . '/resources/terms/opc-revised-new.txt', true);
	$pdf->SetXY(305,425);
	$pdf->SetFont('Arial','',4.4);
	$pdf->MultiCell(280, 8, $ticket_terms . "v/".$transaction->transaction_customer_id, 0, 'L', FALSE);
	
	
	
	if ($event->event_internet_sales_charge != '')
	{
		// official receipt
		$x = 300;
		$y = 620-20+5;
		$w = 290;
		$h = 140+15;
		
		$pdf->Rect($x, $y, $w, $h);
		$pdf->SetTextColor(64, 64, 64);

		$pdf->SetXY(300,$y);
		$pdf->SetFont('Arial','',12);
		$pdf->Cell(290,20,'Official Receipt',0,0,'C');

		// company info
		$y += 20;
		$pdf->SetFont('Arial','',8);
		$pdf->SetXY(300,$y);
		$pdf->Cell(290,0,'SM PRIME HOLDINGS, INC.',0,0,'C');


		$y += 8;
		$pdf->SetFont('Arial','',6);
		$pdf->SetXY(300,$y);
		$pdf->Cell(290,0,'11F Mall Of Asia Arena Annex Building',0,0,'C');
		$y += 8;
		$pdf->SetXY(300,$y);
		$pdf->Cell(290,0,'Coral Way corner J.W. Diokno Boulevard',0,0,'C');
		$y += 8;
		$pdf->SetXY(300,$y);
		$pdf->Cell(290,0,'Mall Of Asia Complex, Brgy. 076 Zone 10, Pasay City',0,0,'C');
		$y += 8;
		$pdf->SetXY(300,$y);
		$pdf->Cell(290,0,'TIN 003-058-789-041 VAT',0,0,'C');
		
		// items
		$cc_formatted = number_format($event->event_internet_sales_charge,2);
		$convenience_charge = $event->event_internet_sales_charge*$ticket_count;
		$vatable_sales = number_format($convenience_charge * (1/1.12), 2);
		$vat_amount = number_format($convenience_charge - $vatable_sales, 2);
		$convenience_charge = number_format($convenience_charge, 2);

		$y += 8;
		$pdf->SetXY(300,$y);
		$pdf->Cell(40,10,"Online Fee",0,0,'L');
		
		$y += 10;
		$x = 330;
		// $pdf->SetXY(330,660);
		$pdf->SetXY($x,$y);
		$pdf->SetFont('','BU');
		$pdf->Cell(60,10,'Quantity',0,0,'C');
		$pdf->Cell(10,10,"",0,0,'C');
		$pdf->Cell(60,10,'Unit Price',0,0,'C');
		
		$y += 10;
		$x = 330;
		// $pdf->SetXY(330,670);
		$pdf->SetXY($x,$y);
		$pdf->SetFont('');
		$pdf->Cell(60,10,"$ticket_count",0,0,'C');
		$pdf->Cell(10,10,"x",0,0,'C');
		$pdf->Cell(60,10,"Php $cc_formatted",0,0,'C');
		$y += 10;
		$x = 310;
		$pdf->SetXY(310,685);
		$pdf->SetXY($x,$y);
		$pdf->MultiCell(200,10,"VATable Sales\nVAT Amount",0,'L',FALSE);
		$y += -10;
		$x = 510;
		$pdf->SetXY(510,670);
		$pdf->SetXY($x,$y);
		$pdf->Cell(70,10,"Php $convenience_charge",0,0,'R');
		$y += 10;
		$x = 510;
		$pdf->SetXY(510,685);
		$pdf->SetXY($x,$y);
		$pdf->MultiCell(70,10, "Php $vatable_sales\nPhp $vat_amount",0,'R',FALSE);

		$y += 35;
		$x = 300;
		// $pdf->SetXY(300,710);
		$pdf->SetXY($x,$y);
		$pdf->SetFont('Arial','',6);
		$or_number = ($transaction->transaction_receipt_number) ? sprintf("%06d", $transaction->transaction_receipt_number) : 0;
		$dform = mysqldatetime_to_date($transaction->transaction_date, $format = "m/d/Y h:ia");
		$pdf->SetFont('Arial','',6);
		$pdf->MultiCell(290,6, "Official Receipt No. $or_number\nTransaction ID ".$transaction->transaction_id."\n$dform\nThis serves as your Official Receipt",0,'C',FALSE);
		/*
		$or_number = ($transaction->transaction_receipt_number) ? sprintf("%06d", $transaction->transaction_receipt_number) : 0;
		$pdf->Cell(290,0,'Official Receipt No. '.$or_number,0,0,'C');
		
		$pdf->SetXY(300,718);
		$pdf->Cell(290,0,'Transaction ID '.$transaction->transaction_id,0,0,'C');
		
		$pdf->SetXY(300,726);
		$pdf->Cell(290,0,mysqldatetime_to_date($transaction->transaction_date, $format = "m/d/Y h:ia"),0,0,'C');
		
		$pdf->SetXY(300,734);
		$pdf->Cell(290,0,'This serves as your proof of payment',0,0,'C');
		*/
	}
	
	if ($voucher_type == 'all') break;
}
$pdf->Output();
$pdf->Close();
